/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.mail.send;

import com.irdstudio.sdk.beans.mail.common.MailContentType;
import com.irdstudio.sdk.beans.mail.config.MailConfig;
import com.irdstudio.sdk.beans.mail.send.ConfigurableMailSender;
import java.util.Map;
import jodd.mail.Email;
import jodd.mail.EmailAttachment;
import jodd.mail.MailServer;
import jodd.mail.SendMailSession;
import jodd.mail.SmtpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmailSenderImpl
implements ConfigurableMailSender {
    Logger logger = LoggerFactory.getLogger(DefaultEmailSenderImpl.class);
    private MailConfig config;

    public DefaultEmailSenderImpl(MailConfig config) {
        this.config = config.copy();
    }

    @Override
    public boolean send(String content, String subject, String remoteAddr, MailContentType type) {
        return this.send(content, subject, remoteAddr, type, null);
    }

    @Override
    public boolean send(String content, String subject, String remoteAddr, MailContentType type, Map<String, byte[]> attachments) {
        Email email = (Email)((Email)((Email)Email.create().from(this.config.localAddress())).to(remoteAddr)).subject(subject);
        if (attachments != null) {
            for (Map.Entry<String, byte[]> entry : attachments.entrySet()) {
                email.attachment(EmailAttachment.with().name(entry.getKey()).content(entry.getValue()));
            }
        }
        switch (type) {
            case TEXT: {
                email = (Email)email.textMessage(content);
                break;
            }
            case HTML: {
                email = (Email)email.htmlMessage(content);
                break;
            }
            default: {
                this.logger.error("\u975e\u6cd5\u7684MailContentType");
                return false;
            }
        }
        return this.doSend(email);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSend(Email email) {
        MailConfig local = this.config;
        SmtpServer smtpServer = this.createServer(local);
        try (SendMailSession session = smtpServer.createSession();){
            session.open();
            session.sendMail(email);
            boolean bl = true;
            return bl;
        }
    }

    private SmtpServer createServer(MailConfig config) {
        MailServer.Builder builder = MailServer.create().host(config.serverAddress()).port(config.port().intValue());
        if (config.username() != null && config.password() != null) {
            builder = builder.auth(config.username(), config.password()).ssl(config.ssl().booleanValue());
        }
        return builder.buildSmtpMailServer();
    }

    @Override
    public void setConfig(MailConfig config) {
        this.config = config.copy();
    }
}

