/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.mq.client.consumer;

import com.irdstudio.sdk.beans.mq.handle.MQMessageProcessor;
import com.irdstudio.sdk.beans.mq.listener.MessageListenerForConcurrently;
import java.util.Map;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragelyByCircle;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQPushConsumerMessageClient {
    private DefaultMQPushConsumer consumer;
    private String namesrvAddr;
    private String consumerGroup;
    private String messageListener;
    private Map<String, MQMessageProcessor> handlermap;
    private static Logger logger = LoggerFactory.getLogger(MQPushConsumerMessageClient.class);

    protected void init() throws InterruptedException, MQClientException {
        logger.info("Consumer initialize!!" + this.consumerGroup + this.namesrvAddr);
        this.consumer = new DefaultMQPushConsumer(this.consumerGroup);
        this.consumer.setNamesrvAddr(this.namesrvAddr);
        this.consumer.setInstanceName(String.valueOf(System.currentTimeMillis()));
        this.subscribe();
        this.consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET);
        this.consumer.setMessageModel(MessageModel.CLUSTERING);
        this.consumer.setAllocateMessageQueueStrategy((AllocateMessageQueueStrategy)new AllocateMessageQueueAveragelyByCircle());
        if ("CONCURRENTLY".equals(this.messageListener)) {
            MessageListenerForConcurrently messageListener = new MessageListenerForConcurrently();
            messageListener.setHandlermap(this.handlermap);
            logger.info("\u8fd9\u662f\u4e00\u4e2a\u666e\u901aRocketMQ\u6d88\u8d39\uff01 type:" + this.messageListener);
            this.consumer.registerMessageListener((MessageListenerConcurrently)messageListener);
        }
        this.consumer.start();
        logger.info("Consumer start success!");
    }

    public void destroy() {
        this.consumer.shutdown();
    }

    public void subscribe() {
        for (String topic : this.handlermap.keySet()) {
            MQMessageProcessor handle = this.handlermap.get(topic);
            if (handle == null) continue;
            try {
                this.consumer.subscribe(topic, "*");
                logger.info("consume subscribe topic" + topic + "success", (Object)"*");
            }
            catch (MQClientException e) {
                logger.error("consume subscribe topic" + topic + "failed", (Throwable)e);
            }
        }
    }

    public DefaultMQPushConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(DefaultMQPushConsumer consumer) {
        this.consumer = consumer;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(String messageListener) {
        this.messageListener = messageListener;
    }

    public Map<String, MQMessageProcessor> getHandlermap() {
        return this.handlermap;
    }

    public void setHandlermap(Map<String, MQMessageProcessor> handlermap) {
        this.handlermap = handlermap;
    }
}

