/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.ssh.utils;

import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.client.ScpClientCreator;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.common.SftpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSSHClient {
    private static Logger logger = LoggerFactory.getLogger(RemoteSSHClient.class);
    private String host;
    private String username;
    private String password;
    private int port;
    private ClientSession session;

    public RemoteSSHClient(String host, String username, String password, int port) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.port = port;
    }

    public RemoteSSHClient(String host, String username, String password) {
        this(host, username, password, 22);
    }

    public boolean connect() {
        SshClient client = SshClient.setUpDefaultClient();
        try {
            client.start();
            this.session = (ClientSession)((ConnectFuture)client.connect(this.username, this.host, this.port).verify()).getSession();
            this.session.addPasswordIdentity(this.password);
            boolean loginSuccess = ((AuthFuture)this.session.auth().verify()).isSuccess();
            return loginSuccess;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String executeCommand(String command) {
        try {
            String output = this.session.executeRemoteCommand(command);
            logger.debug(output);
            return output;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(final String command, final SSHOutputPrinter printer) {
        final PipedInputStream in = new PipedInputStream();
        final PipedInputStream err = new PipedInputStream();
        final AtomicBoolean open = new AtomicBoolean(true);
        final AtomicInteger status = new AtomicInteger(0);
        try {
            final PipedOutputStream out = new PipedOutputStream(in);
            final PipedOutputStream errOut = new PipedOutputStream(err);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ChannelExec channel = null;
                    try {
                        channel = RemoteSSHClient.this.session.createExecChannel(command);
                        channel.setOut((OutputStream)out);
                        channel.setErr((OutputStream)errOut);
                        channel.open().await();
                        Set waitMask = channel.waitFor((Collection)ClientSession.REMOTE_COMMAND_WAIT_EVENTS, 0L);
                        if (waitMask.contains(ClientChannelEvent.TIMEOUT)) {
                            throw new SocketTimeoutException("Failed to retrieve command result in time: " + command);
                        }
                        Integer exitStatus = channel.getExitStatus();
                        exitStatus = exitStatus == null ? -1 : exitStatus;
                        status.getAndSet(exitStatus);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        open.getAndSet(false);
                    }
                }
            }).start();
            final AtomicBoolean run = new AtomicBoolean(true);
            final AtomicBoolean errRun = new AtomicBoolean(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "utf-8"));
                        do {
                            if ((line = reader.readLine()) == null) continue;
                            printer.print(line);
                        } while (open.get() || line != null);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        run.getAndSet(false);
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader errReader = new BufferedReader(new InputStreamReader((InputStream)err, "utf-8"));
                        do {
                            if ((line = errReader.readLine()) == null) continue;
                            printer.printError(line);
                        } while (open.get() || line != null);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        errRun.getAndSet(false);
                    }
                }
            }).start();
            while (run.get() || errRun.get()) {
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            status.getAndSet(-1);
        }
        finally {
            IoUtils.closeQuietly((Closeable)in);
            IoUtils.closeQuietly((Closeable)err);
        }
        return status.get();
    }

    public boolean fileExists(String path) {
        SftpClient sftp = null;
        try {
            sftp = SftpClientFactory.instance().createSftpClient(this.session);
            SftpClient.Attributes attr = sftp.lstat(path);
            boolean bl = attr != null;
            return bl;
        }
        catch (SftpException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException ie) {
            logger.error(ie.getMessage(), (Throwable)ie);
            throw new RuntimeException(ie);
        }
        finally {
            if (sftp != null) {
                IoUtils.closeQuietly((Closeable)sftp);
            }
        }
    }

    public void uploadQuietly(String local, String remote) {
        try {
            if (this.session.isClosed()) {
                this.connect();
            }
            ScpClient scpClient = ScpClientCreator.instance().createScpClient(this.session);
            scpClient.upload(local, remote, new ScpClient.Option[0]);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20  {} \u5230 {} \u5f02\u5e38 {}", new Object[]{local, remote, e.getMessage(), e});
        }
    }

    public void upload(String local, String remote) throws IOException {
        if (this.session.isClosed()) {
            this.connect();
        }
        ScpClient scpClient = ScpClientCreator.instance().createScpClient(this.session);
        scpClient.upload(local, remote, new ScpClient.Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String remoteFile, String local) throws IOException {
        ScpClient scpClient = ScpClientCreator.instance().createScpClient(this.session);
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(local);
            scpClient.download(remoteFile, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(output);
            throw throwable;
        }
        IoUtils.closeQuietly((Closeable)output);
    }

    public void download(String remoteFile, OutputStream output) throws IOException {
        ScpClient scpClient = ScpClientCreator.instance().createScpClient(this.session);
        scpClient.download(remoteFile, output);
    }
}

