(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.GroupDropdown = {
        props: {
            modelValue: Object,
            groupConfig: Array,
            disabled: Boolean,
            activeFirst: {
                type: Boolean,
                default: true
            }
        },
        emits: ['group'],
        data(){
            return {
                currentItem: undefined
            }
        },
        methods: {
            handlerCommand(param) {
                if (param.command == 'groupList') {
                    if (!param.item && this.value) {
                        // 取消分组
                        this.value.queryParams[this.value.key] = ''
                        this.value.change({})
                    }
                    this.value = param.item
                    this.$emit('group', param.item, param.initFlag)
                }
            }
        },
        computed:{
            displayLabel() {
                if (this.value) {
                    return (this.value.label || "")
                } else {
                    return "分组";
                }
            },
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
        },
        mounted() {
            if(this.activeFirst && this.groupConfig && this.groupConfig.length > 0 && !this.value) {
                this.handlerCommand({command: 'groupList', item: this.groupConfig[0], initFlag: true})
            }
        },
        unmounted() {

        },
        template: `
<el-dropdown trigger="click" @command="handlerCommand"  :disabled="disabled">
    <el-button class="button" text size="small" ><el-icon><i class="iconfont icon-ziyuan-fenzu"></i></el-icon> {{displayLabel}}</el-button>
    <template #dropdown>
      <el-dropdown-menu>
        <el-dropdown-item  :command="{ command: 'groupList', item: undefined }"> 取消分组 </el-dropdown-item>
        <el-dropdown-item v-for="(item, index) in groupConfig" :key="index" :divided="index == 0" :command="{ command: 'groupList', item: item}">
            {{item.label}}
            <span style="float: right; color: var(--el-text-color-secondary); display: inline-block; margin-left: 10px;" v-if="displayLabel == item.label"><el-icon><Select></Select></el-icon></span>
        </el-dropdown-item>
      </el-dropdown-menu>
    </template>
</el-dropdown>
        `
    }
}));
