/*!
 * @form-create/element-ui v3.2.1
 * (c) 2018-2024 xaboy
 * Github https://github.com/xaboy/form-create
 * Released under the MIT License.
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue')) :
  typeof define === 'function' && define.amd ? define(['exports', 'vue'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.formCreate = {}, global.Vue));
})(this, (function (exports, vue) { 'use strict';

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);

      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }

      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";

    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;

    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (typeof call === "object" || typeof call === "function")) {
      return call;
    } else if (call !== void 0) {
      throw new TypeError("Derived constructors may only return object or undefined");
    }

    return _assertThisInitialized(self);
  }

  function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();

    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived),
          result;

      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;

        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }

      return _possibleConstructorReturn(this, result);
    };
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function getSlot(slots, exclude) {
    return Object.keys(slots).reduce(function (lst, name) {
      if (!exclude || exclude.indexOf(name) === -1) {
        lst.push(slots[name]);
      }

      return lst;
    }, []);
  }

  function toArray(value) {
    return Array.isArray(value) ? value : [null, undefined, ''].indexOf(value) > -1 ? [] : [value];
  }

  var NAME$8 = 'fcCheckbox';
  var Checkbox = vue.defineComponent({
    name: NAME$8,
    inheritAttrs: false,
    props: {
      formCreateInject: Object,
      modelValue: {
        type: Array,
        "default": function _default() {
          return [];
        }
      },
      type: String,
      input: Boolean,
      inputValue: String
    },
    emits: ['update:modelValue', 'fc.el'],
    setup: function setup(props, _) {
      var options = vue.toRef(props.formCreateInject, 'options', []);
      var value = vue.toRef(props, 'modelValue');
      var inputValue = vue.toRef(props, 'inputValue', '');
      var customValue = vue.ref(inputValue.value);
      var input = vue.toRef(props, 'input', false);

      var updateCustomValue = function updateCustomValue(n) {
        var _value = _toConsumableArray(toArray(value.value));

        var idx = _value.indexOf(customValue.value);

        customValue.value = n;

        if (idx > -1) {
          _value.splice(idx, 1);

          _value.push(n);

          onInput(_value);
        }
      };

      vue.watch(inputValue, function (n) {
        if (!input.value) {
          customValue.value = n;
          return undefined;
        }

        updateCustomValue(n);
      });

      var _options = function _options() {
        return Array.isArray(options.value) ? options.value : [];
      };

      var onInput = function onInput(n) {
        _.emit('update:modelValue', n);
      };

      return {
        options: _options,
        value: value,
        onInput: onInput,
        updateCustomValue: updateCustomValue,
        makeInput: function makeInput(Type) {
          if (!input.value) {
            return undefined;
          }

          return vue.createVNode(Type, {
            "value": customValue.value,
            "label": customValue.value
          }, {
            "default": function _default() {
              return [vue.createVNode(vue.resolveComponent("ElInput"), {
                "modelValue": customValue.value,
                "onUpdate:modelValue": updateCustomValue
              }, null)];
            }
          });
        }
      };
    },
    render: function render() {
      var _this$$slots$default,
          _this$$slots,
          _this = this;

      var name = this.type === 'button' ? 'ElCheckboxButton' : 'ElCheckbox';
      var Type = vue.resolveComponent(name);
      return vue.createVNode(vue.resolveComponent("ElCheckboxGroup"), vue.mergeProps(this.$attrs, {
        "modelValue": this.value,
        "onUpdate:modelValue": this.onInput,
        "ref": "el"
      }), _objectSpread2({
        "default": function _default() {
          return [_this.options().map(function (opt, index) {
            var props = _objectSpread2({}, opt);

            var value = props.value;
            var label = props.label;
            delete props.value;
            delete props.label;
            return vue.createVNode(Type, vue.mergeProps(props, {
              "label": value,
              "value": value,
              "key": name + index + '-' + value
            }), {
              "default": function _default() {
                return [label || value || ''];
              }
            });
          }), (_this$$slots$default = (_this$$slots = _this.$slots)["default"]) === null || _this$$slots$default === void 0 ? void 0 : _this$$slots$default.call(_this$$slots), _this.makeInput(Type)];
        }
      }, getSlot(this.$slots, ['default'])));
    },
    mounted: function mounted() {
      this.$emit('fc.el', this.$refs.el);
    }
  });

  // https://github.com/developit/mitt
  function Mitt(all) {
    all = all || new Map();
    var mitt = {
      $on: function $on(type, handler) {
        var handlers = all.get(type);
        var added = handlers && handlers.push(handler);

        if (!added) {
          all.set(type, [handler]);
        }
      },
      $once: function $once(type, handler) {
        handler._once = true;
        mitt.$on(type, handler);
      },
      $off: function $off(type, handler) {
        var handlers = all.get(type);

        if (handlers) {
          handlers.splice(handlers.indexOf(handler) >>> 0, 1);
        }
      },
      $emit: function $emit(type) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        (all.get(type) || []).slice().map(function (handler) {
          if (handler._once) {
            mitt.$off(type, handler);
            delete handler._once;
          }

          handler.apply(void 0, args);
        });
        (all.get('*') || []).slice().map(function (handler) {
          handler(type, args);
        });
      }
    };
    return mitt;
  }

  function styleInject(css, ref) {
    if ( ref === void 0 ) ref = {};
    var insertAt = ref.insertAt;

    if (!css || typeof document === 'undefined') { return; }

    var head = document.head || document.getElementsByTagName('head')[0];
    var style = document.createElement('style');
    style.type = 'text/css';

    if (insertAt === 'top') {
      if (head.firstChild) {
        head.insertBefore(style, head.firstChild);
      } else {
        head.appendChild(style);
      }
    } else {
      head.appendChild(style);
    }

    if (style.styleSheet) {
      style.styleSheet.cssText = css;
    } else {
      style.appendChild(document.createTextNode(css));
    }
  }

  var css_248z$3 = "._fc-frame ._fc-files img{display:inline-block;height:100%;vertical-align:top;width:100%}._fc-frame ._fc-upload-btn{border:1px dashed #c0ccda;cursor:pointer}._fc-frame._fc-disabled ._fc-upload-btn,._fc-frame._fc-disabled .el-button{color:#999;cursor:not-allowed!important}._fc-frame ._fc-upload-cover{background:rgba(0,0,0,.6);bottom:0;left:0;opacity:0;position:absolute;right:0;top:0;-webkit-transition:opacity .3s;-o-transition:opacity .3s;transition:opacity .3s}._fc-frame ._fc-upload-cover i{color:#fff;cursor:pointer;font-size:20px;margin:0 2px}._fc-frame ._fc-files:hover ._fc-upload-cover{opacity:1}._fc-frame .el-upload{display:block}._fc-frame ._fc-upload-icon{cursor:pointer}._fc-files,._fc-frame ._fc-upload-btn{background:#fff;border:1px solid #c0ccda;border-radius:4px;-webkit-box-shadow:2px 2px 5px rgba(0,0,0,.1);box-shadow:2px 2px 5px rgba(0,0,0,.1);-webkit-box-sizing:border-box;box-sizing:border-box;display:inline-block;height:58px;line-height:58px;margin-right:4px;overflow:hidden;position:relative;text-align:center;width:58px}";
  styleInject(css_248z$3);

  var script$6 = {
    name: 'IconCircleClose'
  };

  var _hoisted_1$6 = {
    "class": "icon",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };

  var _hoisted_2$6 = /*#__PURE__*/vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M466.752 512l-90.496-90.496a32 32 0 0145.248-45.248L512 466.752l90.496-90.496a32 32 0 1145.248 45.248L557.248 512l90.496 90.496a32 32 0 11-45.248 45.248L512 557.248l-90.496 90.496a32 32 0 01-45.248-45.248L466.752 512z"
  }, null, -1);

  var _hoisted_3$6 = /*#__PURE__*/vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 896a384 384 0 100-768 384 384 0 000 768zm0 64a448 448 0 110-896 448 448 0 010 896z"
  }, null, -1);

  var _hoisted_4 = [_hoisted_2$6, _hoisted_3$6];
  function render$6(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$6, _hoisted_4);
  }

  script$6.render = render$6;

  var script$5 = {
    name: 'IconDocument'
  };

  var _hoisted_1$5 = {
    "class": "icon",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };

  var _hoisted_2$5 = /*#__PURE__*/vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M832 384H576V128H192v768h640V384zm-26.496-64L640 154.496V320h165.504zM160 64h480l256 256v608a32 32 0 01-32 32H160a32 32 0 01-32-32V96a32 32 0 0132-32zm160 448h384v64H320v-64zm0-192h160v64H320v-64zm0 384h384v64H320v-64z"
  }, null, -1);

  var _hoisted_3$5 = [_hoisted_2$5];
  function render$5(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$5, _hoisted_3$5);
  }

  script$5.render = render$5;

  var script$4 = {
    name: 'IconDelete'
  };

  var _hoisted_1$4 = {
    "class": "icon",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };

  var _hoisted_2$4 = /*#__PURE__*/vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M160 256H96a32 32 0 010-64h256V95.936a32 32 0 0132-32h256a32 32 0 0132 32V192h256a32 32 0 110 64h-64v672a32 32 0 01-32 32H192a32 32 0 01-32-32V256zm448-64v-64H416v64h192zM224 896h576V256H224v640zm192-128a32 32 0 01-32-32V416a32 32 0 0164 0v320a32 32 0 01-32 32zm192 0a32 32 0 01-32-32V416a32 32 0 0164 0v320a32 32 0 01-32 32z"
  }, null, -1);

  var _hoisted_3$4 = [_hoisted_2$4];
  function render$4(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$4, _hoisted_3$4);
  }

  script$4.render = render$4;

  var script$3 = {
    name: 'IconView'
  };

  var _hoisted_1$3 = {
    "class": "icon",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };

  var _hoisted_2$3 = /*#__PURE__*/vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 160c320 0 512 352 512 352S832 864 512 864 0 512 0 512s192-352 512-352zm0 64c-225.28 0-384.128 208.064-436.8 288 52.608 79.872 211.456 288 436.8 288 225.28 0 384.128-208.064 436.8-288-52.608-79.872-211.456-288-436.8-288zm0 64a224 224 0 110 448 224 224 0 010-448zm0 64a160.192 160.192 0 00-160 160c0 88.192 71.744 160 160 160s160-71.808 160-160-71.744-160-160-160z"
  }, null, -1);

  var _hoisted_3$3 = [_hoisted_2$3];
  function render$3(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$3, _hoisted_3$3);
  }

  script$3.render = render$3;

  var script$2 = {
    name: 'IconFolderOpened'
  };

  var _hoisted_1$2 = {
    "class": "icon",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };

  var _hoisted_2$2 = /*#__PURE__*/vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M878.08 448H241.92l-96 384h636.16l96-384zM832 384v-64H485.76L357.504 192H128v448l57.92-231.744A32 32 0 01216.96 384H832zm-24.96 512H96a32 32 0 01-32-32V160a32 32 0 0132-32h287.872l128.384 128H864a32 32 0 0132 32v96h23.04a32 32 0 0131.04 39.744l-112 448A32 32 0 01807.04 896z"
  }, null, -1);

  var _hoisted_3$2 = [_hoisted_2$2];
  function render$2(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$2, _hoisted_3$2);
  }

  script$2.render = render$2;

  function _isSlot(s) {
    return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !vue.isVNode(s);
  }

  var NAME$7 = 'fcFrame';
  var Frame = vue.defineComponent({
    name: NAME$7,
    props: {
      type: {
        type: String,
        "default": 'input'
      },
      field: String,
      helper: {
        type: Boolean,
        "default": true
      },
      disabled: {
        type: Boolean,
        "default": false
      },
      src: {
        type: String,
        required: true
      },
      icon: {
        type: String,
        "default": 'IconFolderOpened'
      },
      width: {
        type: String,
        "default": '500px'
      },
      height: {
        type: String,
        "default": '370px'
      },
      maxLength: {
        type: Number,
        "default": 0
      },
      okBtnText: {
        type: String,
        "default": '确定'
      },
      closeBtnText: {
        type: String,
        "default": '关闭'
      },
      modalTitle: String,
      handleIcon: {
        type: [String, Boolean],
        "default": undefined
      },
      title: String,
      allowRemove: {
        type: Boolean,
        "default": true
      },
      onOpen: {
        type: Function,
        "default": function _default() {}
      },
      onOk: {
        type: Function,
        "default": function _default() {}
      },
      onCancel: {
        type: Function,
        "default": function _default() {}
      },
      onLoad: {
        type: Function,
        "default": function _default() {}
      },
      onBeforeRemove: {
        type: Function,
        "default": function _default() {}
      },
      onRemove: {
        type: Function,
        "default": function _default() {}
      },
      onHandle: Function,
      modal: {
        type: Object,
        "default": function _default() {
          return {};
        }
      },
      srcKey: [String, Number],
      modelValue: [Array, String, Number, Object],
      previewMask: undefined,
      footer: {
        type: Boolean,
        "default": true
      },
      reload: {
        type: Boolean,
        "default": true
      },
      closeBtn: {
        type: Boolean,
        "default": true
      },
      okBtn: {
        type: Boolean,
        "default": true
      },
      formCreateInject: Object
    },
    emits: ['update:modelValue', 'change'],
    components: {
      IconFolderOpened: script$2,
      IconView: script$3
    },
    data: function data() {
      return {
        fileList: toArray(this.modelValue),
        previewVisible: false,
        frameVisible: false,
        previewImage: '',
        bus: new Mitt()
      };
    },
    watch: {
      modelValue: function modelValue(n) {
        this.fileList = toArray(n);
      }
    },
    methods: {
      close: function close() {
        this.closeModel(true);
      },
      closeModel: function closeModel(close) {
        this.bus.$emit(close ? '$close' : '$ok');

        if (this.reload) {
          this.bus.$off('$ok');
          this.bus.$off('$close');
        }

        this.frameVisible = false;
      },
      handleCancel: function handleCancel() {
        this.previewVisible = false;
      },
      showModel: function showModel() {
        if (this.disabled || false === this.onOpen()) {
          return;
        }

        this.frameVisible = true;
      },
      input: function input() {
        var n = this.fileList;
        var val = this.maxLength === 1 ? n[0] || '' : n;
        this.$emit('update:modelValue', val);
        this.$emit('change', val);
      },
      makeInput: function makeInput() {
        var _this = this;

        return vue.createVNode(vue.resolveComponent("ElInput"), vue.mergeProps({
          type: 'text',
          modelValue: this.fileList.map(function (v) {
            return _this.getSrc(v);
          }).toString(),
          readonly: true
        }, {
          "key": 1
        }), {
          append: function append() {
            return vue.createVNode(vue.resolveComponent("ElButton"), {
              "icon": vue.resolveComponent(_this.icon),
              "onClick": function onClick() {
                return _this.showModel();
              }
            }, null);
          },
          suffix: function suffix() {
            return _this.fileList.length && !_this.disabled ? vue.createVNode(vue.resolveComponent("ElIcon"), {
              "class": "el-input__icon _fc-upload-icon",
              "onClick": function onClick() {
                _this.fileList = [];

                _this.input();
              }
            }, {
              "default": function _default() {
                return [vue.createVNode(script$6, null, null)];
              }
            }) : null;
          }
        });
      },
      makeGroup: function makeGroup(children) {
        if (!this.maxLength || this.fileList.length < this.maxLength) {
          children.push(this.makeBtn());
        }

        return vue.createVNode("div", {
          "key": 2
        }, [children]);
      },
      makeItem: function makeItem(index, children) {
        return vue.createVNode("div", {
          "class": "_fc-files",
          "key": '3' + index
        }, [children]);
      },
      valid: function valid(f) {
        var field = this.formCreateInject.field || this.field;

        if (field && f !== field) {
          throw new Error('[frame]无效的字段值');
        }
      },
      makeIcons: function makeIcons(val, index) {
        if (this.handleIcon !== false || this.allowRemove === true) {
          var icons = [];

          if (this.type !== 'file' && this.handleIcon !== false || this.type === 'file' && this.handleIcon) {
            icons.push(this.makeHandleIcon(val, index));
          }

          if (this.allowRemove) {
            icons.push(this.makeRemoveIcon(val, index));
          }

          return vue.createVNode("div", {
            "class": "_fc-upload-cover",
            "key": 4
          }, [icons]);
        }
      },
      makeHandleIcon: function makeHandleIcon(val, index) {
        var _this2 = this;

        var Type = vue.resolveComponent(this.handleIcon === true || this.handleIcon === undefined ? 'icon-view' : this.handleIcon);
        return vue.createVNode(vue.resolveComponent("ElIcon"), {
          "onClick": function onClick() {
            return _this2.handleClick(val);
          },
          "key": '5' + index
        }, {
          "default": function _default() {
            return [vue.createVNode(Type, null, null)];
          }
        });
      },
      makeRemoveIcon: function makeRemoveIcon(val, index) {
        var _this3 = this;

        return vue.createVNode(vue.resolveComponent("ElIcon"), {
          "onClick": function onClick() {
            return _this3.handleRemove(val);
          },
          "key": '6' + index
        }, {
          "default": function _default() {
            return [vue.createVNode(script$4, null, null)];
          }
        });
      },
      makeFiles: function makeFiles() {
        var _this4 = this;

        return this.makeGroup(this.fileList.map(function (src, index) {
          return _this4.makeItem(index, [vue.createVNode(vue.resolveComponent("ElIcon"), {
            "onClick": function onClick() {
              return _this4.handleClick(src);
            }
          }, {
            "default": function _default() {
              return [vue.createVNode(script$5, null, null)];
            }
          }), _this4.makeIcons(src, index)]);
        }));
      },
      makeImages: function makeImages() {
        var _this5 = this;

        return this.makeGroup(this.fileList.map(function (src, index) {
          return _this5.makeItem(index, [vue.createVNode("img", {
            "src": _this5.getSrc(src)
          }, null), _this5.makeIcons(src, index)]);
        }));
      },
      makeBtn: function makeBtn() {
        var _this6 = this;

        var Type = vue.resolveComponent(this.icon);
        return vue.createVNode("div", {
          "class": "_fc-upload-btn",
          "onClick": function onClick() {
            return _this6.showModel();
          },
          "key": 7
        }, [vue.createVNode(vue.resolveComponent("ElIcon"), null, {
          "default": function _default() {
            return [vue.createVNode(Type, null, null)];
          }
        })]);
      },
      handleClick: function handleClick(src) {
        if (this.onHandle) {
          return this.onHandle(src);
        } else {
          this.previewImage = this.getSrc(src);
          this.previewVisible = true;
        }
      },
      handleRemove: function handleRemove(src) {
        if (this.disabled) {
          return;
        }

        if (false !== this.onBeforeRemove(src)) {
          this.fileList.splice(this.fileList.indexOf(src), 1);
          this.input();
          this.onRemove(src);
        }
      },
      getSrc: function getSrc(src) {
        return !this.srcKey ? src : src[this.srcKey];
      },
      frameLoad: function frameLoad(iframe) {
        var _this7 = this;

        this.onLoad(iframe);

        try {
          if (this.helper === true) {
            iframe['form_create_helper'] = {
              api: this.formCreateInject.api,
              close: function close(field) {
                _this7.valid(field);

                _this7.closeModel();
              },
              set: function set(field, value) {
                _this7.valid(field);

                !_this7.disabled && _this7.$emit('update:modelValue', value);
              },
              get: function get(field) {
                _this7.valid(field);

                return _this7.modelValue;
              },
              onOk: function onOk(fn) {
                return _this7.bus.$on('$ok', fn);
              },
              onClose: function onClose(fn) {
                return _this7.bus.$on('$close', fn);
              }
            };
          }
        } catch (e) {
          console.error(e);
        }
      },
      makeFooter: function makeFooter() {
        var _this8 = this;

        var _this$$props = this.$props,
            okBtnText = _this$$props.okBtnText,
            closeBtnText = _this$$props.closeBtnText,
            closeBtn = _this$$props.closeBtn,
            okBtn = _this$$props.okBtn,
            footer = _this$$props.footer;

        if (!footer) {
          return;
        }

        return vue.createVNode("div", null, [closeBtn ? vue.createVNode(vue.resolveComponent("ElButton"), {
          "onClick": function onClick() {
            return _this8.onCancel() !== false && (_this8.frameVisible = false);
          }
        }, _isSlot(closeBtnText) ? closeBtnText : {
          "default": function _default() {
            return [closeBtnText];
          }
        }) : null, okBtn ? vue.createVNode(vue.resolveComponent("ElButton"), {
          "type": "primary",
          "onClick": function onClick() {
            return _this8.onOk() !== false && _this8.closeModel();
          }
        }, _isSlot(okBtnText) ? okBtnText : {
          "default": function _default() {
            return [okBtnText];
          }
        }) : null]);
      }
    },
    render: function render() {
      var _this9 = this;

      var type = this.type;
      var node;

      if (type === 'input') {
        node = this.makeInput();
      } else if (type === 'image') {
        node = this.makeImages();
      } else {
        node = this.makeFiles();
      }

      var _this$$props2 = this.$props,
          _this$$props2$width = _this$$props2.width,
          width = _this$$props2$width === void 0 ? '30%' : _this$$props2$width,
          height = _this$$props2.height,
          src = _this$$props2.src,
          title = _this$$props2.title,
          modalTitle = _this$$props2.modalTitle;
      vue.nextTick(function () {
        if (_this9.$refs.frame) {
          _this9.frameLoad(_this9.$refs.frame.contentWindow || {});
        }
      });
      return vue.createVNode("div", {
        "class": {
          '_fc-frame': true,
          '_fc-disabled': this.disabled
        }
      }, [node, vue.createVNode(vue.resolveComponent("ElDialog"), {
        "appendToBody": true,
        "modal": this.previewMask,
        "title": modalTitle,
        "modelValue": this.previewVisible,
        "onClose": this.handleCancel
      }, {
        "default": function _default() {
          return [vue.createVNode("img", {
            "style": "width: 100%",
            "src": _this9.previewImage
          }, null)];
        }
      }), vue.createVNode(vue.resolveComponent("ElDialog"), vue.mergeProps({
        "appendToBody": true
      }, _objectSpread2({
        width: width,
        title: title
      }, this.modal), {
        "modelValue": this.frameVisible,
        "onClose": function onClose() {
          return _this9.closeModel(true);
        }
      }), {
        "default": function _default() {
          return [_this9.frameVisible || !_this9.reload ? vue.createVNode("iframe", {
            "ref": "frame",
            "src": src,
            "frameBorder": "0",
            "style": {
              height: height,
              'border': '0 none',
              'width': '100%'
            }
          }, null) : null];
        },
        footer: function footer() {
          return _this9.makeFooter();
        }
      })]);
    },
    beforeMount: function beforeMount() {
      var _this$formCreateInjec = this.formCreateInject,
          name = _this$formCreateInjec.name,
          field = _this$formCreateInjec.field,
          api = _this$formCreateInjec.api;
      name && api.on('fc:closeModal:' + name, this.close);
      field && api.on('fc:closeModal:' + field, this.close);
    },
    beforeUnmount: function beforeUnmount() {
      var _this$formCreateInjec2 = this.formCreateInject,
          name = _this$formCreateInjec2.name,
          field = _this$formCreateInjec2.field,
          api = _this$formCreateInjec2.api;
      name && api.off('fc:closeModal:' + name, this.close);
      field && api.off('fc:closeModal:' + field, this.close);
    }
  });

  var NAME$6 = 'fcRadio';
  var Radio = vue.defineComponent({
    name: NAME$6,
    inheritAttrs: false,
    props: {
      formCreateInject: Object,
      modelValue: {
        type: [String, Number, Boolean],
        "default": ''
      },
      type: String,
      input: Boolean,
      inputValue: String
    },
    emits: ['update:modelValue', 'fc.el'],
    setup: function setup(props, _) {
      var options = vue.toRef(props.formCreateInject, 'options', []);
      var value = vue.toRef(props, 'modelValue');
      var inputValue = vue.toRef(props, 'inputValue', '');
      var customValue = vue.ref(inputValue.value);
      var input = vue.toRef(props, 'input', false);

      var _options = function _options() {
        return Array.isArray(options.value) ? options.value : [];
      };

      vue.watch(inputValue, function (n) {
        if (!input.value) {
          customValue.value = n;
          return undefined;
        }

        updateCustomValue(n);
      });

      var onInput = function onInput(n) {
        _.emit('update:modelValue', n);
      };

      var updateCustomValue = function updateCustomValue(n) {
        var o = customValue.value;
        customValue.value = n;

        if (value.value === o) {
          onInput(n);
        }
      };

      return {
        options: _options,
        value: value,
        onInput: onInput,
        updateCustomValue: updateCustomValue,
        customValue: customValue,
        makeInput: function makeInput(Type) {
          if (!input.value) {
            return undefined;
          }

          return vue.createVNode(Type, {
            "value": customValue.value,
            "label": customValue.value
          }, {
            "default": function _default() {
              return [vue.createVNode(vue.resolveComponent("ElInput"), {
                "modelValue": customValue.value,
                "onUpdate:modelValue": updateCustomValue
              }, null)];
            }
          });
        }
      };
    },
    render: function render() {
      var _this$$slots$default,
          _this$$slots,
          _this = this;

      var name = this.type === 'button' ? 'ElRadioButton' : 'ElRadio';
      var Type = vue.resolveComponent(name);
      return vue.createVNode(vue.resolveComponent("ElRadioGroup"), vue.mergeProps(this.$attrs, {
        "modelValue": this.value,
        "onUpdate:modelValue": this.onInput,
        "ref": "el"
      }), _objectSpread2({
        "default": function _default() {
          return [_this.options().map(function (opt, index) {
            var props = _objectSpread2({}, opt);

            var value = props.value;
            var label = props.label;
            delete props.value;
            delete props.label;
            return vue.createVNode(Type, vue.mergeProps(props, {
              "label": value,
              "value": value,
              "key": name + index + '-' + value
            }), {
              "default": function _default() {
                return [label || value || ''];
              }
            });
          }), (_this$$slots$default = (_this$$slots = _this.$slots)["default"]) === null || _this$$slots$default === void 0 ? void 0 : _this$$slots$default.call(_this$$slots), _this.makeInput(Type)];
        }
      }, getSlot(this.$slots, ['default'])));
    },
    mounted: function mounted() {
      this.$emit('fc.el', this.$refs.el);
    }
  });

  var is = {
    type: function type(arg, _type) {
      return Object.prototype.toString.call(arg) === '[object ' + _type + ']';
    },
    Undef: function Undef(v) {
      return v === undefined || v === null;
    },
    Element: function Element(arg) {
      return _typeof(arg) === 'object' && arg !== null && arg.nodeType === 1 && !is.Object(arg);
    },
    trueArray: function trueArray(data) {
      return Array.isArray(data) && data.length > 0;
    },
    Function: function Function(v) {
      var type = this.getType(v);
      return type === 'Function' || type === 'AsyncFunction';
    },
    getType: function getType(v) {
      var str = Object.prototype.toString.call(v);
      return /^\[object (.*)\]$/.exec(str)[1];
    },
    empty: function empty(value) {
      if (value === undefined || value === null) {
        return true;
      }

      if (Array.isArray(value) && Array.isArray(value) && !value.length) {
        return true;
      }

      return typeof value === 'string' && !value;
    }
  };
  ['Date', 'Object', 'String', 'Boolean', 'Array', 'Number'].forEach(function (t) {
    is[t] = function (arg) {
      return is.type(arg, t);
    };
  });
  function hasProperty(rule, k) {
    return {}.hasOwnProperty.call(rule, k);
  }

  var NAME$5 = 'fcSelect';
  var Select = vue.defineComponent({
    name: NAME$5,
    inheritAttrs: false,
    props: {
      formCreateInject: Object,
      modelValue: {
        type: [Array, String, Number, Boolean, Object],
        "default": undefined
      },
      type: String
    },
    emits: ['update:modelValue', 'fc.el'],
    setup: function setup(props) {
      var options = vue.toRef(props.formCreateInject, 'options', []);
      var value = vue.toRef(props, 'modelValue');

      var _options = function _options() {
        return Array.isArray(options.value) ? options.value : [];
      };

      return {
        options: _options,
        value: value
      };
    },
    render: function render() {
      var _this = this,
          _this$$slots$default,
          _this$$slots;

      var makeOption = function makeOption(props, index) {
        return vue.createVNode(vue.resolveComponent("ElOption"), vue.mergeProps(props, {
          "key": '' + index + '-' + props.value
        }), null);
      };

      var makeOptionGroup = function makeOptionGroup(props, index) {
        return vue.createVNode(vue.resolveComponent("ElOptionGroup"), {
          "label": props.label,
          "key": '' + index + '-' + props.label
        }, {
          "default": function _default() {
            return [is.trueArray(props.options) && props.options.map(function (v, index) {
              return makeOption(v, index);
            })];
          }
        });
      };

      var options = this.options();
      return vue.createVNode(vue.resolveComponent("ElSelect"), vue.mergeProps(this.$attrs, {
        "modelValue": this.value,
        "onUpdate:modelValue": function onUpdateModelValue(v) {
          return _this.$emit('update:modelValue', v);
        },
        "ref": "el"
      }), _objectSpread2({
        "default": function _default() {
          return [options.map(function (props, index) {
            return hasProperty(props || '', 'options') ? makeOptionGroup(props, index) : makeOption(props, index);
          }), (_this$$slots$default = (_this$$slots = _this.$slots)["default"]) === null || _this$$slots$default === void 0 ? void 0 : _this$$slots$default.call(_this$$slots)];
        }
      }, getSlot(this.$slots, ['default'])));
    },
    mounted: function mounted() {
      this.$emit('fc.el', this.$refs.el);
    }
  });

  var NAME$4 = 'fcTree';
  var Tree = vue.defineComponent({
    name: NAME$4,
    inheritAttrs: false,
    formCreateParser: {
      mergeProp: function mergeProp(ctx) {
        var props = ctx.prop.props;
        if (!props.nodeKey) props.nodeKey = 'id';
        if (!props.props) props.props = {
          label: 'title'
        };
      }
    },
    props: {
      type: String,
      modelValue: {
        type: [Array, String, Number],
        "default": function _default() {
          return [];
        }
      }
    },
    emits: ['update:modelValue', 'fc.el'],
    watch: {
      modelValue: function modelValue() {
        this.setValue();
      }
    },
    methods: {
      updateValue: function updateValue() {
        if (!this.$refs.tree) return;
        var value;

        if (this.type === 'selected') {
          value = this.$refs.tree.getCurrentKey();
        } else {
          value = this.$refs.tree.getCheckedKeys();
        }

        this.$emit('update:modelValue', value);
      },
      setValue: function setValue() {
        if (!this.$refs.tree) return;
        var type = this.type;

        if (type === 'selected') {
          this.$refs.tree.setCurrentKey(this.modelValue);
        } else {
          this.$refs.tree.setCheckedKeys(toArray(this.modelValue));
        }
      }
    },
    render: function render() {
      return vue.createVNode(vue.resolveComponent("ElTree"), vue.mergeProps(this.$attrs, {
        "ref": "tree",
        "onCheck": this.updateValue,
        "onNode-click": this.updateValue
      }), this.$slots);
    },
    mounted: function mounted() {
      this.setValue();
      this.$emit('fc.el', this.$refs.tree);
    }
  });

  var css_248z$2 = "._fc-exceed .el-upload{display:none}.el-upload-list.is-disabled .el-upload{cursor:not-allowed!important}";
  styleInject(css_248z$2);

  var script$1 = {
    name: 'IconUpload'
  };

  var _hoisted_1$1 = {
    "class": "icon",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };

  var _hoisted_2$1 = /*#__PURE__*/vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M160 832h704a32 32 0 110 64H160a32 32 0 110-64zm384-578.304V704h-64V247.296L237.248 490.048 192 444.8 508.8 128l316.8 316.8-45.312 45.248L544 253.696z"
  }, null, -1);

  var _hoisted_3$1 = [_hoisted_2$1];
  function render$1(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1, _hoisted_3$1);
  }

  script$1.render = render$1;

  function parseFile(file, i) {
    return {
      url: file,
      name: getFileName(file),
      uid: i
    };
  }

  function getFileName(file) {
    return ('' + file).split('/').pop();
  }

  var NAME$3 = 'fcUpload';
  var Upload = vue.defineComponent({
    name: NAME$3,
    inheritAttrs: false,
    formCreateParser: {
      toFormValue: function toFormValue(value) {
        return toArray(value);
      },
      toValue: function toValue(formValue, ctx) {
        return ctx.prop.props.limit === 1 ? formValue[0] || '' : formValue;
      }
    },
    props: {
      previewMask: undefined,
      onPreview: Function,
      modalTitle: String,
      modelValue: [Array, String]
    },
    emits: ['update:modelValue', 'change', 'remove', 'fc.el'],
    data: function data() {
      return {
        previewVisible: false,
        previewImage: '',
        fileList: []
      };
    },
    created: function created() {
      this.fileList = toArray(this.modelValue).map(parseFile);
    },
    watch: {
      modelValue: function modelValue(n) {
        this.fileList = toArray(n).map(parseFile);
      }
    },
    methods: {
      handlePreview: function handlePreview(file) {
        if (this.onPreview) {
          this.onPreview.apply(this, arguments);
        } else {
          this.previewImage = file.url;
          this.previewVisible = true;
        }
      },
      update: function update(fileList) {
        var files = fileList.map(function (file) {
          return file.url;
        }).filter(function (url) {
          return url !== undefined;
        });
        this.$emit('update:modelValue', files);
      },
      handleCancel: function handleCancel() {
        this.previewVisible = false;
      },
      handleChange: function handleChange(file, fileList) {
        this.$emit.apply(this, ['change'].concat(Array.prototype.slice.call(arguments)));

        if (file.status === 'success') {
          this.update(fileList);
        }
      },
      handleRemove: function handleRemove(file, fileList) {
        this.$emit.apply(this, ['remove'].concat(Array.prototype.slice.call(arguments)));
        this.update(fileList);
      }
    },
    render: function render() {
      var _this$$slots$default,
          _this$$slots,
          _this = this;

      var len = toArray(this.modelValue).length;
      return vue.createVNode(vue.Fragment, null, [vue.createVNode(vue.resolveComponent("ElUpload"), vue.mergeProps({
        "key": len,
        "list-type": "picture-card"
      }, this.$attrs, {
        "class": {
          '_fc-exceed': this.$attrs.limit ? this.$attrs.limit <= len : false
        },
        "onPreview": this.handlePreview,
        "onChange": this.handleChange,
        "onRemove": this.handleRemove,
        "fileList": this.fileList,
        "ref": "upload"
      }), _objectSpread2({
        "default": function _default() {
          return [((_this$$slots$default = (_this$$slots = _this.$slots)["default"]) === null || _this$$slots$default === void 0 ? void 0 : _this$$slots$default.call(_this$$slots)) || vue.createVNode(vue.resolveComponent("ElIcon"), null, {
            "default": function _default() {
              return [vue.createVNode(script$1, null, null)];
            }
          })];
        }
      }, getSlot(this.$slots, ['default']))), vue.createVNode(vue.resolveComponent("ElDialog"), {
        "appendToBody": true,
        "modal": this.previewMask,
        "title": this.modalTitle,
        "modelValue": this.previewVisible,
        "onClose": this.handleCancel
      }, {
        "default": function _default() {
          return [vue.createVNode("img", {
            "style": "width: 100%",
            "src": _this.previewImage
          }, null)];
        }
      })]);
    },
    mounted: function mounted() {
      this.$emit('fc.el', this.$refs.upload);
    }
  });

  function $set(target, field, value) {
    target[field] = value;
  }
  function $del(target, field) {
    delete target[field];
  }

  function deepExtend(origin) {
    var target = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var mode = arguments.length > 2 ? arguments[2] : undefined;
    var isArr = false;

    for (var key in target) {
      if (Object.prototype.hasOwnProperty.call(target, key)) {
        var clone = target[key];

        if ((isArr = Array.isArray(clone)) || is.Object(clone)) {
          var nst = origin[key] === undefined;

          if (isArr) {
            isArr = false;
            nst && $set(origin, key, []);
          } else if (clone._clone && mode !== undefined) {
            if (mode) {
              clone = clone.getRule();
              nst && $set(origin, key, {});
            } else {
              $set(origin, key, clone._clone());
              continue;
            }
          } else {
            nst && $set(origin, key, {});
          }

          origin[key] = deepExtend(origin[key], clone, mode);
        } else {
          $set(origin, key, clone);

          if (!is.Undef(clone)) {
            if (!is.Undef(clone.__json)) {
              origin[key].__json = clone.__json;
            }

            if (!is.Undef(clone.__origin)) {
              origin[key].__origin = clone.__origin;
            }
          }
        }
      }
    }

    return mode !== undefined && Array.isArray(origin) ? origin.filter(function (v) {
      return !v || !v.__ctrl;
    }) : origin;
  }
  function deepCopy(value) {
    return deepExtend({}, {
      value: value
    }).value;
  }

  var _extends = Object.assign || function (a) {
    for (var b, c = 1; c < arguments.length; c++) {
      for (var d in b = arguments[c], b) {
        Object.prototype.hasOwnProperty.call(b, d) && $set(a, d, b[d]);
      }
    }

    return a;
  };

  function extend() {
    return _extends.apply(this, arguments);
  }
  function copy$1(obj) {
    if (_typeof(obj) !== 'object' || obj === null) return obj;
    return obj instanceof Array ? _toConsumableArray(obj) : _objectSpread2({}, obj);
  }

  var css_248z$1 = "._fc-group{display:flex;flex-direction:column;justify-content:center;min-height:38px;width:100%}._fc-group-disabled ._fc-group-add,._fc-group-disabled ._fc-group-btn{cursor:not-allowed}._fc-group-handle{background-color:#fff;border:1px dashed #d9d9d9;border-radius:15px;bottom:-15px;display:flex;flex-direction:row;padding:3px 8px;position:absolute;right:30px}._fc-group-btn{cursor:pointer}._fc-group-idx{align-items:center;background:#eee;border-radius:15px;bottom:-15px;display:flex;font-weight:700;height:30px;justify-content:center;left:10px;position:absolute;width:30px}._fc-group-handle ._fc-group-btn+._fc-group-btn{margin-left:7px}._fc-group-container{border:1px dashed #d9d9d9;border-radius:5px;display:flex;flex-direction:column;margin:5px 5px 25px;padding:20px 20px 25px;position:relative}._fc-group-arrow{height:20px;position:relative;width:20px}._fc-group-arrow:before{border-left:2px solid #999;border-top:2px solid #999;content:\"\";height:9px;left:5px;position:absolute;top:8px;transform:rotate(45deg);width:9px}._fc-group-arrow._fc-group-down{transform:rotate(180deg)}._fc-group-plus-minus{cursor:pointer;height:20px;position:relative;width:20px}._fc-group-plus-minus:after,._fc-group-plus-minus:before{background-color:#409eff;content:\"\";height:2px;left:50%;position:absolute;top:50%;transform:translate(-50%,-50%);width:60%}._fc-group-plus-minus:before{transform:translate(-50%,-50%) rotate(90deg)}._fc-group-plus-minus._fc-group-minus:before{display:none}._fc-group-plus-minus._fc-group-minus:after{background-color:#f56c6c}._fc-group-add{border:1px solid rgba(64,158,255,.5);border-radius:15px;cursor:pointer;height:25px;width:25px}._fc-group-add._fc-group-plus-minus:after,._fc-group-add._fc-group-plus-minus:before{width:50%}";
  styleInject(css_248z$1);

  var NAME$2 = 'fcGroup';
  var Group = vue.defineComponent({
    name: NAME$2,
    props: {
      field: String,
      rule: Array,
      expand: Number,
      options: Object,
      button: {
        type: Boolean,
        "default": true
      },
      max: {
        type: Number,
        "default": 0
      },
      min: {
        type: Number,
        "default": 0
      },
      modelValue: {
        type: Array,
        "default": function _default() {
          return [];
        }
      },
      defaultValue: Object,
      sortBtn: {
        type: Boolean,
        "default": true
      },
      disabled: {
        type: Boolean,
        "default": false
      },
      syncDisabled: {
        type: Boolean,
        "default": true
      },
      onBeforeRemove: {
        type: Function,
        "default": function _default() {}
      },
      onBeforeAdd: {
        type: Function,
        "default": function _default() {}
      },
      formCreateInject: Object,
      parse: Function
    },
    data: function data() {
      return {
        len: 0,
        cacheRule: {},
        cacheValue: {},
        sort: [],
        form: vue.markRaw(this.formCreateInject.form.$form())
      };
    },
    emits: ['update:modelValue', 'change', 'itemMounted', 'remove', 'add'],
    watch: {
      rule: {
        handler: function handler(n, o) {
          var _this = this;

          Object.keys(this.cacheRule).forEach(function (v) {
            var item = _this.cacheRule[v];

            if (item.$f) {
              var val = item.$f.formData();

              if (n === o) {
                item.$f.deferSyncValue(function () {
                  deepExtend(item.rule, n);
                  item.$f.setValue(val);
                }, true);
              } else {
                var _val = item.$f.formData();

                item.$f.once('reloading', function () {
                  item.$f.setValue(_val);
                });
                item.rule = deepCopy(n);
              }
            }
          });
        },
        deep: true
      },
      expand: function expand(n) {
        var d = n - this.modelValue.length;

        if (d > 0) {
          this.expandRule(d);
        }
      },
      modelValue: {
        handler: function handler(n) {
          var _this2 = this;

          n = n || [];
          var keys = Object.keys(this.sort),
              total = keys.length,
              len = total - n.length;

          if (len < 0) {
            for (var i = len; i < 0; i++) {
              this.addRule(n.length + i, true);
            }

            for (var _i = 0; _i < total; _i++) {
              this.setValue(keys[_i], n[_i]);
            }
          } else {
            if (len > 0) {
              for (var _i2 = 0; _i2 < len; _i2++) {
                this.removeRule(keys[total - _i2 - 1]);
              }
            }

            n.forEach(function (val, i) {
              _this2.setValue(keys[i], n[i]);
            });
          }
        },
        deep: true
      }
    },
    methods: {
      _value: function _value(v) {
        return v && hasProperty(v, this.field) ? v[this.field] : v;
      },
      cache: function cache(k, val) {
        this.cacheValue[k] = JSON.stringify(val);
      },
      input: function input(value) {
        this.$emit('update:modelValue', value);
        this.$emit('change', value);
      },
      formData: function formData(key, _formData) {
        var _this3 = this;

        var cacheRule = this.cacheRule;
        var keys = this.sort;

        if (keys.filter(function (k) {
          return cacheRule[k].$f;
        }).length !== keys.length) {
          return;
        }

        var value = keys.map(function (k) {
          var data = key === k ? _formData : _objectSpread2({}, _this3.cacheRule[k].$f.form);
          var value = _this3.field ? data[_this3.field] || null : data;

          _this3.cache(k, value);

          return value;
        });
        this.input(value);
      },
      setValue: function setValue(key, value) {
        var field = this.field;

        if (field) {
          value = _defineProperty({}, field, this._value(value));
        }

        if (this.cacheValue[key] === JSON.stringify(field ? value[field] : value)) {
          return;
        }

        this.cache(key, value);
      },
      addRule: function addRule(i, emit) {
        var _this4 = this;

        var rule = this.formCreateInject.form.copyRules(this.rule || []);
        var options = this.options ? _objectSpread2({}, this.options) : {
          submitBtn: false,
          resetBtn: false
        };

        if (this.defaultValue) {
          if (!options.formData) options.formData = {};
          var defVal = deepCopy(this.defaultValue);
          extend(options.formData, this.field ? _defineProperty({}, this.field, defVal) : defVal);
        }

        this.parse && this.parse({
          rule: rule,
          options: options,
          index: this.sort.length
        });
        this.cacheRule[++this.len] = {
          rule: rule,
          options: options
        };

        if (emit) {
          vue.nextTick(function () {
            return _this4.$emit('add', rule, Object.keys(_this4.cacheRule).length - 1);
          });
        }
      },
      add$f: function add$f(i, key, $f) {
        var _this5 = this;

        this.cacheRule[key].$f = $f;
        vue.nextTick(function () {
          _this5.$emit('itemMounted', $f, Object.keys(_this5.cacheRule).indexOf(key));
        });
      },
      removeRule: function removeRule(key, emit) {
        var _this6 = this;

        var index = Object.keys(this.cacheRule).indexOf(key);
        delete this.cacheRule[key];
        delete this.cacheValue[key];

        if (emit) {
          vue.nextTick(function () {
            return _this6.$emit('remove', index);
          });
        }
      },
      add: function add(i) {
        if (this.disabled || false === this.onBeforeAdd(this.modelValue)) {
          return;
        }

        var value = _toConsumableArray(this.modelValue);

        value.push(this.defaultValue ? deepCopy(this.defaultValue) : this.field ? null : {});
        this.input(value);
      },
      del: function del(index, key) {
        if (this.disabled || false === this.onBeforeRemove(this.modelValue, index)) {
          return;
        }

        this.removeRule(key, true);

        var value = _toConsumableArray(this.modelValue);

        value.splice(index, 1);
        this.input(value);
      },
      addIcon: function addIcon(key) {
        return vue.createVNode("div", {
          "class": "_fc-group-btn _fc-group-plus-minus",
          "onClick": this.add
        }, null);
      },
      delIcon: function delIcon(index, key) {
        var _this7 = this;

        return vue.createVNode("div", {
          "class": "_fc-group-btn _fc-group-plus-minus _fc-group-minus",
          "onClick": function onClick() {
            return _this7.del(index, key);
          }
        }, null);
      },
      sortUpIcon: function sortUpIcon(index) {
        var _this8 = this;

        return vue.createVNode("div", {
          "class": "_fc-group-btn _fc-group-arrow _fc-group-up",
          "onClick": function onClick() {
            return _this8.changeSort(index, -1);
          }
        }, null);
      },
      sortDownIcon: function sortDownIcon(index) {
        var _this9 = this;

        return vue.createVNode("div", {
          "class": "_fc-group-btn _fc-group-arrow _fc-group-down",
          "onClick": function onClick() {
            return _this9.changeSort(index, 1);
          }
        }, null);
      },
      changeSort: function changeSort(index, sort) {
        var a = this.sort[index];
        this.sort[index] = this.sort[index + sort];
        this.sort[index + sort] = a;
        this.formData(0);
      },
      makeIcon: function makeIcon(total, index, key) {
        var _this10 = this;

        if (this.$slots.button) {
          return this.$slots.button({
            total: total,
            index: index,
            vm: this,
            key: key,
            del: function del() {
              return _this10.del(index, key);
            },
            add: this.add
          });
        }

        var btn = [];

        if ((!this.max || total < this.max) && total === index + 1) {
          btn.push(this.addIcon(key));
        }

        if (total > this.min) {
          btn.push(this.delIcon(index, key));
        }

        if (this.sortBtn && index) {
          btn.push(this.sortUpIcon(index));
        }

        if (this.sortBtn && index !== total - 1) {
          btn.push(this.sortDownIcon(index));
        }

        return btn;
      },
      emitEvent: function emitEvent(name, args, index, key) {
        this.$emit.apply(this, [name].concat(_toConsumableArray(args), [this.cacheRule[key].$f, index]));
      },
      expandRule: function expandRule(n) {
        for (var i = 0; i < n; i++) {
          this.addRule(i);
        }
      }
    },
    created: function created() {
      var _this11 = this;

      vue.watch(function () {
        return _objectSpread2({}, _this11.cacheRule);
      }, function (n) {
        _this11.sort = Object.keys(n);
      }, {
        immediate: true
      });
      var d = (this.expand || 0) - this.modelValue.length;

      for (var i = 0; i < this.modelValue.length; i++) {
        this.addRule(i);
      }

      if (d > 0) {
        this.expandRule(d);
      }
    },
    render: function render() {
      var _this12 = this;

      var keys = this.sort;
      var button = this.button;
      var Type = this.form;
      var disabled = this.disabled;
      var children = keys.length === 0 ? this.$slots["default"] ? this.$slots["default"]({
        vm: this,
        add: this.add
      }) : vue.createVNode("div", {
        "key": 'a_def',
        "class": "_fc-group-plus-minus _fc-group-add fc-clock",
        "onClick": this.add
      }, null) : keys.map(function (key, index) {
        var _this12$cacheRule$key = _this12.cacheRule[key],
            rule = _this12$cacheRule$key.rule,
            options = _this12$cacheRule$key.options;
        var btn = button && !disabled ? _this12.makeIcon(keys.length, index, key) : [];
        return vue.createVNode("div", {
          "class": "_fc-group-container",
          "key": key
        }, [vue.createVNode(Type, vue.mergeProps({
          "key": key
        }, {
          disabled: disabled,
          'onUpdate:modelValue': function onUpdateModelValue(formData) {
            return _this12.formData(key, formData);
          },
          'onEmit-event': function onEmitEvent(name) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            return _this12.emitEvent(name, args, index, key);
          },
          'onUpdate:api': function onUpdateApi($f) {
            return _this12.add$f(index, key, $f);
          },
          inFor: true,
          modelValue: _this12.field ? _defineProperty({}, _this12.field, _this12._value(_this12.modelValue[index])) : _this12.modelValue[index],
          rule: rule,
          option: options,
          extendOption: true
        }), null), vue.createVNode("div", {
          "class": "_fc-group-idx"
        }, [index + 1]), btn.length ? vue.createVNode("div", {
          "class": "_fc-group-handle fc-clock"
        }, [btn]) : null]);
      });
      return vue.createVNode("div", {
        "key": 'con',
        "class": '_fc-group ' + (disabled ? '_fc-group-disabled' : '')
      }, [children]);
    }
  });

  var NAME$1 = 'fcSubForm';
  var Sub = vue.defineComponent({
    name: NAME$1,
    props: {
      rule: Array,
      options: {
        type: Object,
        "default": function _default() {
          return vue.reactive({
            submitBtn: false,
            resetBtn: false
          });
        }
      },
      modelValue: {
        type: Object,
        "default": function _default() {
          return {};
        }
      },
      disabled: {
        type: Boolean,
        "default": false
      },
      syncDisabled: {
        type: Boolean,
        "default": true
      },
      formCreateInject: Object
    },
    data: function data() {
      return {
        cacheValue: {},
        subApi: {},
        form: vue.markRaw(this.formCreateInject.form.$form())
      };
    },
    emits: ['fc:subform', 'update:modelValue', 'change', 'itemMounted'],
    watch: {
      modelValue: function modelValue(n) {
        this.setValue(n);
      }
    },
    methods: {
      formData: function formData(value) {
        this.cacheValue = JSON.stringify(value);
        this.$emit('update:modelValue', value);
        this.$emit('change', value);
      },
      setValue: function setValue(value) {
        var str = JSON.stringify(value);

        if (this.cacheValue === str) {
          return;
        }

        this.cacheValue = str;
        this.subApi.coverValue(value || {});
      },
      add$f: function add$f(api) {
        var _this = this;

        this.subApi = api;
        vue.nextTick(function () {
          _this.$emit('itemMounted', api);
        });
      }
    },
    render: function render() {
      var Type = this.form;
      return vue.createVNode(Type, {
        "disabled": this.disabled,
        "onUpdate:modelValue": this.formData,
        "modelValue": this.modelValue,
        "onEmit-event": this.$emit,
        "onUpdate:api": this.add$f,
        "rule": this.rule,
        "option": this.options,
        "extendOption": true
      }, null);
    }
  });

  var script = {
    name: 'IconWarning'
  };

  var _hoisted_1 = {
    "class": "icon",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };

  var _hoisted_2 = /*#__PURE__*/vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 64a448 448 0 110 896 448 448 0 010-896zm0 832a384 384 0 000-768 384 384 0 000 768zm48-176a48 48 0 11-96 0 48 48 0 0196 0zm-48-464a32 32 0 0132 32v288a32 32 0 01-64 0V288a32 32 0 0132-32z"
  }, null, -1);

  var _hoisted_3 = [_hoisted_2];
  function render(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1, _hoisted_3);
  }

  script.render = render;

  var components = [Checkbox, Frame, Radio, Select, Tree, Upload, Group, Sub, script];

  function debounce(fn, wait) {
    var timeout = null;
    return function () {
      var _this = this;

      for (var _len = arguments.length, arg = new Array(_len), _key = 0; _key < _len; _key++) {
        arg[_key] = arguments[_key];
      }

      if (timeout !== null) clearTimeout(timeout);
      timeout = setTimeout(function () {
        return fn.call.apply(fn, [_this].concat(arg));
      }, wait);
    };
  }

  function toLine(name) {
    var line = name.replace(/([A-Z])/g, '-$1').toLocaleLowerCase();
    if (line.indexOf('-') === 0) line = line.substr(1);
    return line;
  }
  function upper(str) {
    return str.replace(str[0], str[0].toLocaleUpperCase());
  }

  var getRuleInject = function getRuleInject(vm, parent) {
    if (!vm || vm === parent) {
      return;
    }

    if (vm.props.formCreateInject) {
      return vm.props.formCreateInject;
    }

    if (vm.parent) {
      return getRuleInject(vm.parent, parent);
    }
  };

  function $FormCreate(FormCreate, components, directives) {
    return vue.defineComponent({
      name: 'FormCreate' + (FormCreate.isMobile ? 'Mobile' : ''),
      components: components,
      directives: directives,
      props: {
        rule: {
          type: Array,
          required: true,
          "default": function _default() {
            return [];
          }
        },
        option: {
          type: Object,
          "default": function _default() {
            return {};
          }
        },
        extendOption: Boolean,
        modelValue: Object,
        disabled: {
          type: Boolean,
          "default": undefined
        },
        preview: {
          type: Boolean,
          "default": undefined
        },
        api: Object,
        name: String,
        subForm: {
          type: Boolean,
          "default": true
        },
        inFor: Boolean
      },
      emits: ['update:api', 'update:modelValue', 'mounted', 'submit', 'change', 'emit-event', 'control', 'remove-rule', 'remove-field', 'sync', 'reload', 'repeat-field', 'update', 'validate-field-fail', 'validate-fail', 'created'],
      render: function render() {
        return this.fc.render();
      },
      setup: function setup(props) {
        var vm = vue.getCurrentInstance();
        vue.provide('parentFC', vm);
        var parent = vue.inject('parentFC', null);

        var _toRefs = vue.toRefs(props),
            rule = _toRefs.rule,
            modelValue = _toRefs.modelValue,
            subForm = _toRefs.subForm,
            inFor = _toRefs.inFor;

        var data = vue.reactive({
          ctxInject: {},
          destroyed: false,
          isShow: true,
          unique: 1,
          renderRule: _toConsumableArray(rule.value || []),
          updateValue: JSON.stringify(modelValue.value || {})
        });
        var fc = new FormCreate(vm);
        var fapi = fc.api();
        var isMore = inFor.value;

        var addSubForm = function addSubForm() {
          if (parent) {
            var _inject = getRuleInject(vm, parent);

            if (_inject) {
              var sub;

              if (isMore) {
                sub = toArray(_inject.getSubForm());
                sub.push(fapi);
              } else {
                sub = fapi;
              }

              _inject.subForm(sub);
            }
          }
        };

        var rmSubForm = function rmSubForm() {
          var inject = getRuleInject(vm, parent);

          if (inject) {
            if (isMore) {
              var sub = toArray(inject.getSubForm());
              var idx = sub.indexOf(fapi);

              if (idx > -1) {
                sub.splice(idx, 1);
              }
            } else {
              inject.subForm();
            }
          }
        };

        var styleEl = null;
        vue.onBeforeMount(function () {
          var content = '';
          var globalClass = props.option && props.option.globalClass || {};
          Object.keys(globalClass).forEach(function (k) {
            var subCss = '';
            globalClass[k].style && Object.keys(globalClass[k].style).forEach(function (key) {
              subCss += toLine(key) + ':' + globalClass[k].style[key] + ';';
            });

            if (globalClass[k].content) {
              subCss += globalClass[k].content + ';';
            }

            if (subCss) {
              content += ".".concat(k, "{").concat(subCss, "}");
            }
          });

          if (props.option && props.option.style) {
            content += props.option.style;
          }

          if (content) {
            styleEl = document.createElement('style');
            styleEl.type = 'text/css';
            styleEl.innerHTML = content;
            document.head.appendChild(styleEl);
          }
        });
        var emit$topForm = debounce(function () {
          fc.bus.$emit('$loadData.$topForm');
        }, 100);
        var emit$form = debounce(function () {
          fc.bus.$emit('$loadData.$form');
        }, 100);
        vue.onMounted(function () {
          if (parent) {
            fapi.top.bus.$on('$loadData.$form', emit$topForm);
          }

          fc.mounted();
        });
        vue.onBeforeUnmount(function () {
          if (parent) {
            fapi.top.bus.$off('$loadData.$form', emit$topForm);
          }

          styleEl && document.head.removeChild(styleEl);
          rmSubForm();
          data.destroyed = true;
          fc.unmount();
        });
        vue.onUpdated(function () {
          fc.updated();
        });
        vue.watch(subForm, function (n) {
          n ? addSubForm() : rmSubForm();
        }, {
          immediate: true
        });
        vue.watch(function () {
          return _toConsumableArray(rule.value);
        }, function (n) {
          if (fc.$handle.isBreakWatch() || n.length === data.renderRule.length && n.every(function (v) {
            return data.renderRule.indexOf(v) > -1;
          })) return;
          fc.$handle.reloadRule(rule.value);
          vm.setupState.renderRule();
        });
        vue.watch(function () {
          return props.option;
        }, function () {
          fc.initOptions();
          fapi.refresh();
        }, {
          deep: true
        });
        vue.watch(function () {
          return [props.disabled, props.preview];
        }, function () {
          fapi.refresh();
        });
        vue.watch(modelValue, function (n) {
          if (JSON.stringify(n || {}) === data.updateValue) return;
          fapi.config.forceCoverValue ? fapi.coverValue(n || {}) : fapi.setValue(n || {});
        }, {
          deep: true
        });
        return _objectSpread2(_objectSpread2({
          fc: vue.markRaw(fc),
          parent: parent ? vue.markRaw(parent) : parent,
          fapi: vue.markRaw(fapi)
        }, vue.toRefs(data)), {}, {
          refresh: function refresh() {
            ++data.unique;
          },
          renderRule: function renderRule() {
            data.renderRule = _toConsumableArray(rule.value || []);
          },
          updateValue: function updateValue(value) {
            if (data.destroyed) return;
            var json = JSON.stringify(value);

            if (data.updateValue === json) {
              return;
            }

            data.updateValue = json;
            vm.emit('update:modelValue', value);
            vue.nextTick(function () {
              emit$form();

              if (!parent) {
                emit$topForm();
              }
            });
          }
        });
      },
      created: function created() {
        var vm = vue.getCurrentInstance();
        vm.emit('update:api', vm.setupState.fapi);
        vm.setupState.fc.init();
      }
    });
  }

  var normalMerge = ['props'];
  var toArrayMerge = ['class', 'style', 'directives'];
  var functionalMerge = ['on'];

  var mergeProps = function mergeProps(objects) {
    var initial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var opt = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    var _normalMerge = [].concat(normalMerge, _toConsumableArray(opt['normal'] || []));

    var _toArrayMerge = [].concat(toArrayMerge, _toConsumableArray(opt['array'] || []));

    var _functionalMerge = [].concat(functionalMerge, _toConsumableArray(opt['functional'] || []));

    var propsMerge = opt['props'] || [];
    return objects.reduce(function (a, b) {
      for (var key in b) {
        if (a[key]) {
          if (propsMerge.indexOf(key) > -1) {
            a[key] = mergeProps([b[key]], a[key]);
          } else if (_normalMerge.indexOf(key) > -1) {
            a[key] = _objectSpread2(_objectSpread2({}, a[key]), b[key]);
          } else if (_toArrayMerge.indexOf(key) > -1) {
            var arrA = a[key] instanceof Array ? a[key] : [a[key]];
            var arrB = b[key] instanceof Array ? b[key] : [b[key]];
            a[key] = [].concat(_toConsumableArray(arrA), _toConsumableArray(arrB));
          } else if (_functionalMerge.indexOf(key) > -1) {
            for (var event in b[key]) {
              if (a[key][event]) {
                var _arrA = a[key][event] instanceof Array ? a[key][event] : [a[key][event]];

                var _arrB = b[key][event] instanceof Array ? b[key][event] : [b[key][event]];

                a[key][event] = [].concat(_toConsumableArray(_arrA), _toConsumableArray(_arrB));
              } else {
                a[key][event] = b[key][event];
              }
            }
          } else if (key === 'hook') {
            for (var hook in b[key]) {
              if (a[key][hook]) {
                a[key][hook] = mergeFn(a[key][hook], b[key][hook]);
              } else {
                a[key][hook] = b[key][hook];
              }
            }
          } else {
            a[key] = b[key];
          }
        } else {
          if (_normalMerge.indexOf(key) > -1 || _functionalMerge.indexOf(key) > -1 || propsMerge.indexOf(key) > -1) {
            a[key] = _objectSpread2({}, b[key]);
          } else if (_toArrayMerge.indexOf(key) > -1) {
            a[key] = b[key] instanceof Array ? _toConsumableArray(b[key]) : _typeof(b[key]) === 'object' ? _objectSpread2({}, b[key]) : b[key];
          } else a[key] = b[key];
        }
      }

      return a;
    }, initial);
  };

  var mergeFn = function mergeFn(fn1, fn2) {
    return function () {
      fn1 && fn1.apply(this, arguments);
      fn2 && fn2.apply(this, arguments);
    };
  };

  var keyAttrs = ['type', 'slot', 'emitPrefix', 'value', 'name', 'native', 'hidden', 'display', 'inject', 'options', 'emit', 'link', 'prefix', 'suffix', 'update', 'sync', 'optionsTo', 'key', 'slotUpdate', 'computed', 'preview', 'component', 'cache', 'modelEmit'];
  var arrayAttrs = ['validate', 'children', 'control'];
  var normalAttrs = ['effect'];
  function attrs() {
    return [].concat(keyAttrs, _toConsumableArray(normalMerge), _toConsumableArray(toArrayMerge), _toConsumableArray(functionalMerge), arrayAttrs, normalAttrs);
  }

  function format(type, msg, rule) {
    return "[form-create ".concat(type, "]: ").concat(msg) + (rule ? '\n\nrule: ' + JSON.stringify(rule.getRule ? rule.getRule() : rule) : '');
  }
  function err(msg, rule) {
    console.error(format('err', msg, rule));
  }
  function logError(e) {
    err(e.toString());
    console.error(e);
  }

  var PREFIX = '[[FORM-CREATE-PREFIX-';
  var SUFFIX = '-FORM-CREATE-SUFFIX]]';
  var $T = '$FN:';
  var $TX = '$FNX:';
  var $ON = '$GLOBAL:';
  var FUNCTION = 'function';
  function toJson(obj, space) {
    return JSON.stringify(deepExtend(Array.isArray(obj) ? [] : {}, obj, true), function (key, val) {
      if (val && val._isVue === true) return undefined;

      if (_typeof(val) !== FUNCTION) {
        return val;
      }

      if (val.__json) {
        return val.__json;
      }

      if (val.__origin) val = val.__origin;
      if (val.__emit) return undefined;
      return PREFIX + val + SUFFIX;
    }, space);
  }

  function makeFn(fn) {
    return new Function('return ' + fn)();
  }

  function parseFn(fn, mode) {
    if (fn && is.String(fn) && fn.length > 4) {
      var v = fn.trim();
      var flag = false;

      try {
        if (v.indexOf(SUFFIX) > 0 && v.indexOf(PREFIX) === 0) {
          v = v.replace(SUFFIX, '').replace(PREFIX, '');
          flag = true;
        } else if (v.indexOf($T) === 0) {
          v = v.replace($T, '');
          flag = true;
        } else if (v.indexOf($ON) === 0) {
          var name = v.replace($ON, '');

          v = function v() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            var callback = args[0].api.getGlobalEvent(name);

            if (callback) {
              return callback.call.apply(callback, [this].concat(args));
            }

            return undefined;
          };

          v.__json = fn;
          v.__inject = true;
          return v;
        } else if (v.indexOf($TX) === 0) {
          v = makeFn('function($inject){' + v.replace($TX, '') + '}');
          v.__json = fn;
          v.__inject = true;
          return v;
        } else if (!mode && v.indexOf(FUNCTION) === 0 && v !== FUNCTION) {
          flag = true;
        }

        if (!flag) return fn;
        var val = makeFn(v.indexOf(FUNCTION) === -1 && v.indexOf('(') !== 0 ? FUNCTION + ' ' + v : v);
        val.__json = fn;
        return val;
      } catch (e) {
        err("\u89E3\u6790\u5931\u8D25:".concat(v, "\n\nerr: ").concat(e));
        return undefined;
      }
    }

    return fn;
  }
  function parseJson(json, mode) {
    return JSON.parse(json, function (k, v) {
      if (is.Undef(v) || !v.indexOf) return v;
      return parseFn(v, mode);
    });
  }

  function enumerable(value, writable) {
    return {
      value: value,
      enumerable: false,
      configurable: false,
      writable: !!writable
    };
  } //todo 优化位置

  function copyRule(rule, mode) {
    return copyRules([rule], mode || false)[0];
  }
  function copyRules(rules, mode) {
    return deepExtend([], _toConsumableArray(rules), mode || false);
  }
  function mergeRule(rule, merge) {
    mergeProps(Array.isArray(merge) ? merge : [merge], rule, {
      array: arrayAttrs,
      normal: normalAttrs
    });
    return rule;
  }
  function getRule(rule) {
    var r = is.Function(rule.getRule) ? rule.getRule() : rule;

    if (!r.type) {
      r.type = 'input';
    }

    return r;
  }
  function mergeGlobal(target, merge) {
    if (!target) return merge;
    Object.keys(merge || {}).forEach(function (k) {
      if (merge[k]) {
        target[k] = mergeRule(target[k] || {}, merge[k]);
      }
    });
    return target;
  }
  function funcProxy(that, proxy) {
    Object.defineProperties(that, Object.keys(proxy).reduce(function (initial, k) {
      initial[k] = {
        get: function get() {
          return proxy[k]();
        }
      };
      return initial;
    }, {}));
  }
  function byCtx(rule) {
    return rule.__fc__ || (rule.__origin__ ? rule.__origin__.__fc__ : null);
  }
  function invoke(fn, def) {
    try {
      def = fn();
    } catch (e) {
      logError(e);
    }

    return def;
  }
  function makeSlotBag() {
    var slotBag = {};

    var slotName = function slotName(n) {
      return n || 'default';
    };

    return {
      setSlot: function setSlot(slot, vnFn) {
        slot = slotName(slot);
        if (!vnFn || Array.isArray(vnFn) && vnFn.length) return;
        if (!slotBag[slot]) slotBag[slot] = [];
        slotBag[slot].push(vnFn);
      },
      getSlot: function getSlot(slot, val) {
        slot = slotName(slot);
        var children = [];
        (slotBag[slot] || []).forEach(function (fn) {
          if (Array.isArray(fn)) {
            children.push.apply(children, _toConsumableArray(fn));
          } else if (is.Function(fn)) {
            var res = fn.apply(void 0, _toConsumableArray(val || []));

            if (Array.isArray(res)) {
              children.push.apply(children, _toConsumableArray(res));
            } else {
              children.push(res);
            }
          } else if (!is.Undef(fn)) {
            children.push(fn);
          }
        });
        return children;
      },
      getSlots: function getSlots() {
        var _this = this;

        var slots = {};
        Object.keys(slotBag).forEach(function (k) {
          slots[k] = function () {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            return _this.getSlot(k, args);
          };
        });
        return slots;
      },
      slotLen: function slotLen(slot) {
        slot = slotName(slot);
        return slotBag[slot] ? slotBag[slot].length : 0;
      },
      mergeBag: function mergeBag(bag) {
        var _this2 = this;

        if (!bag) return this;
        var slots = is.Function(bag.getSlots) ? bag.getSlots() : bag;

        if (Array.isArray(bag) || vue.isVNode(bag)) {
          this.setSlot(undefined, function () {
            return bag;
          });
        } else {
          Object.keys(slots).forEach(function (k) {
            _this2.setSlot(k, slots[k]);
          });
        }

        return this;
      }
    };
  }
  function toProps(rule) {
    var prop = _objectSpread2({}, rule.props || {});

    Object.keys(rule.on || {}).forEach(function (k) {
      var name = "on".concat(upper(k));

      if (Array.isArray(prop[name])) {
        prop[name] = [].concat(_toConsumableArray(prop[name]), [rule.on[k]]);
      } else if (prop[name]) {
        prop[name] = [prop[name], rule.on[k]];
      } else {
        prop[name] = rule.on[k];
      }
    });
    prop.key = rule.key;
    prop.ref = rule.ref;
    prop["class"] = rule["class"];
    prop.style = rule.style;
    if (prop.slot) delete prop.slot;
    return prop;
  }
  function setPrototypeOf(o, proto) {
    Object.setPrototypeOf(o, proto);
    return o;
  }

  var changeType = function changeType(a, b) {
    if (typeof a === 'string') {
      return String(b);
    } else if (typeof a === 'number') {
      return Number(b);
    }

    return b;
  };

  var condition = {
    '==': function _(a, b) {
      return JSON.stringify(a) === JSON.stringify(changeType(a, b));
    },
    '!=': function _(a, b) {
      return !condition['=='](a, b);
    },
    '>': function _(a, b) {
      return a > b;
    },
    '>=': function _(a, b) {
      return a >= b;
    },
    '<': function _(a, b) {
      return a < b;
    },
    '<=': function _(a, b) {
      return a <= b;
    },
    on: function on(a, b) {
      return a && a.indexOf && a.indexOf(changeType(a[0], b)) > -1;
    },
    notOn: function notOn(a, b) {
      return !condition.on(a, b);
    },
    "in": function _in(a, b) {
      return b && b.indexOf && b.indexOf(a) > -1;
    },
    notIn: function notIn(a, b) {
      return !condition["in"](a, b);
    },
    between: function between(a, b) {
      return a > b[0] && a < b[1];
    },
    notBetween: function notBetween(a, b) {
      return a < b[0] || a > b[1];
    },
    empty: function empty(a) {
      return is.empty(a);
    },
    notEmpty: function notEmpty(a) {
      return !is.empty(a);
    },
    pattern: function pattern(a, b) {
      return new RegExp(b, 'g').test(a);
    }
  };
  function deepGet(val, split) {
    (Array.isArray(split) ? split : (split || '').split('.')).forEach(function (k) {
      if (val != null) {
        val = val[k];
      }
    });
    return val;
  }
  function extractVar(str) {
    var regex = /{{\s*(.*?)\s*}}/g;
    var match;
    var matches = {};

    while ((match = regex.exec(str)) !== null) {
      if (match[1]) {
        matches[match[1]] = true;
      }
    }

    return Object.keys(matches);
  }

  function baseRule() {
    return {
      props: {},
      on: {},
      options: [],
      children: [],
      hidden: false,
      display: true,
      value: undefined
    };
  }
  function creatorFactory(name, init) {
    return function (title, field, value) {
      var props = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var maker = new Creator(name, title, field, value, props);

      if (init) {
        if (is.Function(init)) init(maker);else maker.props(init);
      }

      return maker;
    };
  }
  function Creator(type, title, field, value, props) {
    this._data = extend(baseRule(), {
      type: type,
      title: title,
      field: field,
      value: value,
      props: props || {}
    });
    this.event = this.on;
  }
  extend(Creator.prototype, {
    getRule: function getRule() {
      return this._data;
    },
    setProp: function setProp(key, value) {
      $set(this._data, key, value);
      return this;
    },
    modelField: function modelField(field) {
      this._data.modelField = field;
      return this;
    },
    _clone: function _clone() {
      var clone = new this.constructor();
      clone._data = copyRule(this._data);
      return clone;
    }
  });
  function appendProto(attrs) {
    attrs.forEach(function (name) {
      Creator.prototype[name] = function (key) {
        mergeRule(this._data, _defineProperty({}, name, arguments.length < 2 ? key : _defineProperty({}, key, arguments[1])));
        return this;
      };
    });
  }
  appendProto(attrs());

  var commonMaker = creatorFactory('');
  function create(type, field, title) {
    var make = commonMaker('', field);
    make._data.type = type;
    make._data.title = title;
    return make;
  }
  function makerFactory() {
    return {
      create: create,
      factory: creatorFactory
    };
  }

  function getError(action, option, xhr) {
    var msg = "fail to ".concat(action, " ").concat(xhr.status, "'");
    var err = new Error(msg);
    err.status = xhr.status;
    err.url = action;
    return err;
  }

  function getBody(xhr) {
    var text = xhr.responseText || xhr.response;

    if (!text) {
      return text;
    }

    try {
      return JSON.parse(text);
    } catch (e) {
      return text;
    }
  }

  function fetch$1(option) {
    if (typeof XMLHttpRequest === 'undefined') {
      return;
    }

    var xhr = new XMLHttpRequest();
    var action = option.action;

    xhr.onerror = function error(e) {
      option.onError(e);
    };

    xhr.onload = function onload() {
      if (xhr.status < 200 || xhr.status >= 300) {
        return option.onError(getError(action, option, xhr), getBody(xhr));
      }

      option.onSuccess(getBody(xhr));
    };

    xhr.open(option.method || 'get', action, true);
    var formData;

    if (option.data) {
      if ((option.dataType || '').toLowerCase() !== 'json') {
        formData = new FormData();
        Object.keys(option.data).map(function (key) {
          formData.append(key, option.data[key]);
        });
      } else {
        formData = JSON.stringify(option.data);
        xhr.setRequestHeader('content-type', 'application/json');
      }
    }

    if (option.withCredentials && 'withCredentials' in xhr) {
      xhr.withCredentials = true;
    }

    var headers = option.headers || {};
    Object.keys(headers).forEach(function (item) {
      if (headers[item] != null) {
        xhr.setRequestHeader(item, headers[item]);
      }
    });
    xhr.send(formData);
  }
  function asyncFetch(config) {
    return new Promise(function (resolve, reject) {
      fetch$1(_objectSpread2(_objectSpread2({}, config), {}, {
        onSuccess: function onSuccess(res) {
          var fn = function fn(v) {
            return v;
          };

          var parse = parseFn(config.parse);

          if (is.Function(parse)) {
            fn = parse;
          } else if (parse && is.String(parse)) {
            fn = function fn(v) {
              return deepGet(v, parse);
            };
          }

          resolve(fn(res));
        },
        onError: function onError(err) {
          reject(err);
        }
      }));
    });
  }

  function copy(value) {
    return deepCopy(value);
  }

  function Api(h) {
    function tidyFields(fields) {
      if (is.Undef(fields)) fields = h.fields();else if (!Array.isArray(fields)) fields = [fields];
      return fields;
    }

    function props(fields, key, val) {
      tidyFields(fields).forEach(function (field) {
        h.getCtxs(field).forEach(function (ctx) {
          $set(ctx.rule, key, val);
          h.$render.clearCache(ctx);
        });
      });
    }

    function allSubForm() {
      var subs = h.subForm;
      return Object.keys(subs).reduce(function (initial, k) {
        var sub = subs[k];
        if (!sub) return initial;
        if (Array.isArray(sub)) initial.push.apply(initial, _toConsumableArray(sub));else initial.push(sub);
        return initial;
      }, []);
    }

    var api = {
      get config() {
        return h.options;
      },

      set config(val) {
        h.fc.options.value = val;
      },

      get options() {
        return h.options;
      },

      set options(val) {
        h.fc.options.value = val;
      },

      get form() {
        return h.form;
      },

      get rule() {
        return h.rules;
      },

      get parent() {
        return h.vm.setupState.parent && h.vm.setupState.parent.setupState.fapi;
      },

      get top() {
        if (api.parent) {
          return api.parent.top;
        }

        return api;
      },

      get children() {
        return allSubForm();
      },

      formData: function formData(fields) {
        return tidyFields(fields).reduce(function (initial, id) {
          var ctx = h.getFieldCtx(id);
          if (!ctx) return initial;
          initial[ctx.field] = copy(ctx.rule.value);
          return initial;
        }, h.options.appendValue !== false ? copy(h.appendData) : {});
      },
      getValue: function getValue(field) {
        var ctx = h.getFieldCtx(field);
        if (!ctx) return;
        return copy(ctx.rule.value);
      },
      coverValue: function coverValue(formData) {
        var data = _objectSpread2({}, formData || {});

        h.deferSyncValue(function () {
          api.fields().forEach(function (key) {
            var ctxs = h.fieldCtx[key];

            if (ctxs) {
              var flag = hasProperty(formData, key);
              ctxs.forEach(function (ctx) {
                ctx.rule.value = flag ? formData[key] : undefined;
              });
              delete data[key];
            }
          });
          extend(h.appendData, data);
        });
      },
      setValue: function setValue(field) {
        var formData = field;
        if (arguments.length >= 2) formData = _defineProperty({}, field, arguments[1]);
        h.deferSyncValue(function () {
          Object.keys(formData).forEach(function (key) {
            var ctxs = h.fieldCtx[key];
            if (!ctxs) return h.appendData[key] = formData[key];
            ctxs.forEach(function (ctx) {
              ctx.rule.value = formData[key];
            });
          });
        });
      },
      removeField: function removeField(field) {
        var ctx = h.getCtx(field);
        h.deferSyncValue(function () {
          h.getCtxs(field).forEach(function (ctx) {
            ctx.rm();
          });
        }, true);
        return ctx ? ctx.origin : undefined;
      },
      removeRule: function removeRule(rule) {
        var ctx = rule && byCtx(rule);
        if (!ctx) return;
        ctx.rm();
        return ctx.origin;
      },
      fields: function fields() {
        return h.fields();
      },
      append: function append(rule, after, child) {
        var index = h.sort.length - 1,
            rules;
        var ctx = h.getCtx(after);

        if (ctx) {
          if (child) {
            rules = ctx.getPending('children', ctx.rule.children);
            if (!Array.isArray(rules)) return;
            index = ctx.rule.children.length - 1;
          } else {
            index = ctx.root.indexOf(ctx.origin);
            rules = ctx.root;
          }
        } else rules = h.rules;

        rules.splice(index + 1, 0, rule);
      },
      prepend: function prepend(rule, after, child) {
        var index = 0,
            rules;
        var ctx = h.getCtx(after);

        if (ctx) {
          if (child) {
            rules = ctx.getPending('children', ctx.rule.children);
            if (!Array.isArray(rules)) return;
          } else {
            index = ctx.root.indexOf(ctx.origin);
            rules = ctx.root;
          }
        } else rules = h.rules;

        rules.splice(index, 0, rule);
      },
      hidden: function hidden(state, fields) {
        props(fields, 'hidden', !!state);
        h.refresh();
      },
      hiddenStatus: function hiddenStatus(id) {
        var ctx = h.getCtx(id);
        if (!ctx) return;
        return !!ctx.rule.hidden;
      },
      display: function display(state, fields) {
        props(fields, 'display', !!state);
        h.refresh();
      },
      displayStatus: function displayStatus(id) {
        var ctx = h.getCtx(id);
        if (!ctx) return;
        return !!ctx.rule.display;
      },
      disabled: function disabled(_disabled, fields) {
        tidyFields(fields).forEach(function (field) {
          h.getCtxs(field).forEach(function (ctx) {
            $set(ctx.rule.props, 'disabled', !!_disabled);
          });
        });
        h.refresh();
      },
      all: function all(origin) {
        return Object.keys(h.ctxs).map(function (k) {
          var ctx = h.ctxs[k];
          return origin ? ctx.origin : ctx.rule;
        });
      },
      model: function model(origin) {
        return h.fields().reduce(function (initial, key) {
          var ctx = h.fieldCtx[key][0];
          initial[key] = origin ? ctx.origin : ctx.rule;
          return initial;
        }, {});
      },
      component: function component(origin) {
        return Object.keys(h.nameCtx).reduce(function (initial, key) {
          var ctx = h.nameCtx[key].map(function (ctx) {
            return origin ? ctx.origin : ctx.rule;
          });
          initial[key] = ctx.length === 1 ? ctx[0] : ctx;
          return initial;
        }, {});
      },
      bind: function bind() {
        return api.form;
      },
      reload: function reload(rules) {
        h.reloadRule(rules);
      },
      updateOptions: function updateOptions(options) {
        h.fc.updateOptions(options);
        api.refresh();
      },
      onSubmit: function onSubmit(fn) {
        api.updateOptions({
          onSubmit: fn
        });
      },
      sync: function sync(field) {
        if (Array.isArray(field)) {
          field.forEach(function (v) {
            return api.sync(v);
          });
          return;
        }

        var ctxs = is.Object(field) ? byCtx(field) : h.getCtxs(field);

        if (!ctxs) {
          return;
        }

        ctxs = Array.isArray(ctxs) ? ctxs : [ctxs];
        ctxs.forEach(function (ctx) {
          if (!ctx.deleted) {
            var subForm = h.subForm[ctx.id];

            if (subForm) {
              if (Array.isArray(subForm)) {
                subForm.forEach(function (form) {
                  form.refresh();
                });
              } else if (subForm) {
                subForm.refresh();
              }
            } //ctx.updateKey(true);


            h.$render.clearCache(ctx);
          }
        });
        h.refresh();
      },
      refresh: function refresh() {
        allSubForm().forEach(function (sub) {
          sub.refresh();
        });
        h.$render.clearCacheAll();
        h.refresh();
      },
      refreshOptions: function refreshOptions() {
        h.$manager.updateOptions(h.options);
        api.refresh();
      },
      hideForm: function hideForm(hide) {
        h.vm.setupState.isShow = !hide;
      },
      changeStatus: function changeStatus() {
        return h.changeStatus;
      },
      clearChangeStatus: function clearChangeStatus() {
        h.changeStatus = false;
      },
      updateRule: function updateRule(id, rule) {
        h.getCtxs(id).forEach(function (ctx) {
          extend(ctx.rule, rule);
        });
      },
      updateRules: function updateRules(rules) {
        Object.keys(rules).forEach(function (id) {
          api.updateRule(id, rules[id]);
        });
      },
      mergeRule: function mergeRule$1(id, rule) {
        h.getCtxs(id).forEach(function (ctx) {
          mergeRule(ctx.rule, rule);
        });
      },
      mergeRules: function mergeRules(rules) {
        Object.keys(rules).forEach(function (id) {
          api.mergeRule(id, rules[id]);
        });
      },
      getRule: function getRule(id, origin) {
        var ctx = h.getCtx(id);

        if (ctx) {
          return origin ? ctx.origin : ctx.rule;
        }
      },
      getRenderRule: function getRenderRule(id) {
        var ctx = h.getCtx(id);

        if (ctx) {
          return ctx.prop;
        }
      },
      getRefRule: function getRefRule(id) {
        var ctxs = h.getCtxs(id);

        if (ctxs) {
          var rules = ctxs.map(function (ctx) {
            return ctx.rule;
          });
          return rules.length === 1 ? rules[0] : rules;
        }
      },
      setEffect: function setEffect(id, attr, value) {
        var ctx = h.getCtx(id);

        if (ctx && attr) {
          if (attr[0] === '$') {
            attr = attr.substr(1);
          }

          if (hasProperty(ctx.rule, '$' + attr)) {
            $set(ctx.rule, '$' + attr, value);
          }

          if (!hasProperty(ctx.rule, 'effect')) {
            ctx.rule.effect = {};
          }

          $set(ctx.rule.effect, attr, value);
        }
      },
      clearEffectData: function clearEffectData(id, attr) {
        var ctx = h.getCtx(id);

        if (ctx) {
          if (attr && attr[0] === '$') {
            attr = attr.substr(1);
          }

          ctx.clearEffectData(attr);
          api.sync(id);
        }
      },
      updateValidate: function updateValidate(id, validate, merge) {
        if (merge) {
          api.mergeRule(id, {
            validate: validate
          });
        } else {
          props(id, 'validate', validate);
        }
      },
      updateValidates: function updateValidates(validates, merge) {
        Object.keys(validates).forEach(function (id) {
          api.updateValidate(id, validates[id], merge);
        });
      },
      refreshValidate: function refreshValidate() {
        api.refresh();
      },
      resetFields: function resetFields(fields) {
        tidyFields(fields).forEach(function (field) {
          h.getCtxs(field).forEach(function (ctx) {
            h.$render.clearCache(ctx);
            ctx.rule.value = copy(ctx.defaultValue);
          });
        });
      },
      method: function method(id, name) {
        var el = api.el(id);
        if (!el || !el[name]) throw new Error(format('err', "".concat(name, "\u65B9\u6CD5\u4E0D\u5B58\u5728")));
        return function () {
          return el[name].apply(el, arguments);
        };
      },
      exec: function exec(id, name) {
        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        return invoke(function () {
          return api.method(id, name).apply(void 0, args);
        });
      },
      toJson: function toJson$1(space) {
        return toJson(api.rule, space);
      },
      trigger: function trigger(id, event) {
        var el = api.el(id);

        for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
          args[_key2 - 2] = arguments[_key2];
        }

        el && el.$emit.apply(el, [event].concat(args));
      },
      el: function el(id) {
        var ctx = h.getCtx(id);
        if (ctx) return ctx.el || h.vm.refs[ctx.ref];
      },
      closeModal: function closeModal(id) {
        h.bus.$emit('fc:closeModal:' + id);
      },
      getSubForm: function getSubForm(field) {
        var ctx = h.getCtx(field);
        return ctx ? h.subForm[ctx.id] : undefined;
      },
      getChildrenRuleList: function getChildrenRuleList(id) {
        var flag = _typeof(id) === 'object';
        var ctx = flag ? byCtx(id) : h.getCtx(id);
        var rule = ctx ? ctx.rule : flag ? id : api.getRule(id);

        if (!rule) {
          return [];
        }

        var rules = [];

        var findRules = function findRules(children) {
          children && children.forEach(function (item) {
            if (_typeof(item) !== 'object') {
              return;
            }

            if (item.field) {
              rules.push(item);
            }

            rules.push.apply(rules, _toConsumableArray(api.getChildrenRuleList(item)));
          });
        };

        findRules(ctx ? ctx.loadChildrenPending() : rule.children);
        return rules;
      },
      getParentSubRule: function getParentSubRule(id) {
        var flag = _typeof(id) === 'object';
        var ctx = flag ? byCtx(id) : h.getCtx(id);

        if (ctx) {
          var group = ctx.getParentGroup();

          if (group) {
            return group.rule;
          }
        }
      },
      getChildrenFormData: function getChildrenFormData(id) {
        var rules = api.getChildrenRuleList(id);
        return rules.reduce(function (formData, rule) {
          formData[rule.field] = copy(rule.value);
          return formData;
        }, {});
      },
      setChildrenFormData: function setChildrenFormData(id, formData, cover) {
        var rules = api.getChildrenRuleList(id);
        h.deferSyncValue(function () {
          rules.forEach(function (rule) {
            if (hasProperty(formData, rule.field)) {
              rule.value = formData[rule.field];
            } else if (cover) {
              rule.value = undefined;
            }
          });
        });
      },
      getGlobalEvent: function getGlobalEvent(name) {
        var event = api.options.globalEvent[name];

        if (event) {
          if (_typeof(event) === 'object') {
            event = event.handle;
          }

          return parseFn(event);
        }

        return undefined;
      },
      getGlobalData: function getGlobalData(name) {
        return new Promise(function (resolve, inject) {
          var config = api.options.globalData[name];

          if (!config) {
            resolve(h.fc.loadData[name]);
          }

          if (config.type === 'fetch') {
            api.fetch(config).then(function (res) {
              resolve(res);
            })["catch"](inject);
          } else {
            resolve(config.data);
          }
        });
      },
      nextTick: function nextTick(fn) {
        h.bus.$once('next-tick', fn);
        h.refresh();
      },
      nextRefresh: function nextRefresh(fn) {
        h.nextRefresh();
        fn && invoke(fn);
      },
      deferSyncValue: function deferSyncValue(fn, sync) {
        h.deferSyncValue(fn, sync);
      },
      emit: function emit(name) {
        var _h$vm;

        for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
          args[_key3 - 1] = arguments[_key3];
        }

        (_h$vm = h.vm).emit.apply(_h$vm, [name].concat(args));
      },
      bus: h.bus,
      fetch: function fetch(opt) {
        return new Promise(function (resolve, reject) {
          h.beforeFetch(opt).then(function () {
            return asyncFetch(opt).then(resolve)["catch"](reject);
          });
        });
      },
      getData: function getData(id, def) {
        return h.fc.getLoadData(id, def);
      },
      setData: function setData(id, data) {
        return h.fc.setData(id, data);
      },
      helper: {
        tidyFields: tidyFields,
        props: props
      }
    };
    ['on', 'once', 'off'].forEach(function (n) {
      api[n] = function () {
        var _h$bus;

        (_h$bus = h.bus)["$".concat(n)].apply(_h$bus, arguments);
      };
    });
    api.changeValue = api.changeField = api.setValue;
    return api;
  }

  function useCache(Render) {
    extend(Render.prototype, {
      initCache: function initCache() {
        this.clearCacheAll();
      },
      clearCache: function clearCache(ctx) {
        if (ctx.rule.cache) {
          return;
        }

        if (!this.cache[ctx.id]) {
          if (ctx.parent) {
            this.clearCache(ctx.parent);
          }

          return;
        }

        if (this.cache[ctx.id].use === true || this.cache[ctx.id].parent) {
          this.$handle.refresh();
        }

        if (this.cache[ctx.id].parent) {
          this.clearCache(this.cache[ctx.id].parent);
        }

        this.cache[ctx.id] = null;
      },
      clearCacheAll: function clearCacheAll() {
        this.cache = {};
      },
      setCache: function setCache(ctx, vnode, parent) {
        this.cache[ctx.id] = {
          vnode: vnode,
          use: false,
          parent: parent,
          slot: ctx.rule.slot
        };
      },
      getCache: function getCache(ctx) {
        var cache = this.cache[ctx.id];

        if (cache) {
          cache.use = true;
          return cache.vnode;
        }

        return undefined;
      }
    });
  }

  function toCase(str) {
    var to = str.replace(/(-[a-z])/g, function (v) {
      return v.replace('-', '').toLocaleUpperCase();
    });
    return lower(to);
  }
  function lower(str) {
    return str.replace(str[0], str[0].toLowerCase());
  }

  function toString(val) {
    return val == null ? '' : _typeof(val) === 'object' ? JSON.stringify(val, null, 2) : String(val);
  }

  var id$2 = 0;
  function uniqueId() {
    var num = 370 + ++id$2;
    return 'F' + Math.random().toString(36).substr(3, 3) + Number("".concat(Date.now())).toString(36) + num.toString(36) + 'c';
  }

  function deepSet(data, idx, val) {
    var _data = data,
        to;
    (idx || '').split('.').forEach(function (v) {
      if (to) {
        if (!_data[to] || _typeof(_data[to]) != 'object') {
          _data[to] = {};
        }

        _data = _data[to];
      }

      to = v;
    });
    _data[to] = val;
    return _data;
  }

  function useRender$1(Render) {
    extend(Render.prototype, {
      initRender: function initRender() {
        this.cacheConfig = {};
      },
      getTypeSlot: function getTypeSlot(ctx) {
        var _fn = function _fn(vm) {
          if (vm) {
            var slot = undefined;

            if (ctx.rule.field) {
              slot = vm.slots['field-' + toLine(ctx.rule.field)] || vm.slots['field-' + ctx.rule.field];
            }

            if (!slot) {
              slot = vm.slots['type-' + toLine(ctx.type)] || vm.slots['type-' + ctx.type];
            }

            if (slot) {
              return slot;
            }

            return _fn(vm.setupState.parent);
          }
        };

        return _fn(this.vm);
      },
      render: function render() {
        var _this = this;

        // console.warn('renderrrrr', this.id);
        if (!this.vm.setupState.isShow) {
          return;
        }

        this.$manager.beforeRender();
        var slotBag = makeSlotBag();
        this.sort.forEach(function (k) {
          _this.renderSlot(slotBag, _this.$handle.ctxs[k]);
        });
        return this.$manager.render(slotBag);
      },
      renderSlot: function renderSlot(slotBag, ctx, parent) {
        if (this.isFragment(ctx)) {
          ctx.initProp();
          this.mergeGlobal(ctx);
          ctx.initNone();
          var slots = this.renderChildren(ctx.loadChildrenPending(), ctx);
          var def = slots["default"];
          def && slotBag.setSlot(ctx.rule.slot, function () {
            return def();
          });
          delete slots["default"];
          slotBag.mergeBag(slots);
        } else {
          slotBag.setSlot(ctx.rule.slot, this.renderCtx(ctx, parent));
        }
      },
      mergeGlobal: function mergeGlobal(ctx) {
        var _this2 = this;

        var g = this.$handle.options.global;
        if (!g) return;

        if (!this.cacheConfig[ctx.trueType]) {
          this.cacheConfig[ctx.trueType] = vue.computed(function () {
            var g = _this2.$handle.options.global;
            return mergeRule({}, [g['*'], g[ctx.originType] || g[ctx.type] || g[ctx.type] || {}]);
          });
        }

        ctx.prop = mergeRule({}, [this.cacheConfig[ctx.trueType].value, ctx.prop]);
      },
      setOptions: function setOptions(ctx) {
        var opt = ctx.loadPending({
          key: 'options',
          origin: ctx.prop.options,
          def: []
        });
        ctx.prop.options = opt;

        if (ctx.prop.optionsTo && opt) {
          deepSet(ctx.prop, ctx.prop.optionsTo, opt);
        }
      },
      deepSet: function deepSet$1(ctx) {
        var deep = ctx.rule.deep;
        deep && Object.keys(deep).sort(function (a, b) {
          return a.length < b.length ? -1 : 1;
        }).forEach(function (str) {
          deepSet(ctx.prop, str, deep[str]);
        });
      },
      parseSide: function parseSide(side, ctx) {
        return is.Object(side) ? mergeRule({
          props: {
            formCreateInject: ctx.prop.props.formCreateInject
          }
        }, side) : side;
      },
      renderSides: function renderSides(vn, ctx, temp) {
        var prop = ctx[temp ? 'rule' : 'prop'];
        return [this.renderRule(this.parseSide(prop.prefix, ctx)), vn, this.renderRule(this.parseSide(prop.suffix, ctx))];
      },
      renderId: function renderId(name, type) {
        var _this3 = this;

        var ctxs = this.$handle[type === 'field' ? 'fieldCtx' : 'nameCtx'][name];
        return ctxs ? ctxs.map(function (ctx) {
          return _this3.renderCtx(ctx, ctx.parent);
        }) : undefined;
      },
      renderCtx: function renderCtx(ctx, parent) {
        var _this4 = this;

        try {
          if (ctx.type === 'hidden') return;
          var rule = ctx.rule;

          if (!this.cache[ctx.id] || this.cache[ctx.id].slot !== rule.slot) {
            var vn;
            ctx.initProp();
            this.mergeGlobal(ctx);
            ctx.initNone();
            this.$manager.tidyRule(ctx);
            this.deepSet(ctx);
            this.setOptions(ctx);
            this.ctxProp(ctx);
            var prop = ctx.prop;
            prop.preview = !!(prop.preview != null ? prop.preview : this.vm.props.preview !== undefined ? this.vm.props.preview : this.options.preview || false);
            prop.props.formCreateInject = this.injectProp(ctx);
            var cacheFlag = prop.cache !== false;
            var preview = prop.preview;

            if (prop.hidden) {
              this.setCache(ctx, undefined, parent);
              return;
            }

            vn = function vn() {
              for (var _len = arguments.length, slotValue = new Array(_len), _key = 0; _key < _len; _key++) {
                slotValue[_key] = arguments[_key];
              }

              var inject = {
                rule: rule,
                prop: prop,
                preview: preview,
                api: _this4.$handle.api,
                model: prop.model || {},
                slotValue: slotValue
              };

              if (slotValue.length && rule.slotUpdate) {
                invoke(function () {
                  return rule.slotUpdate(inject);
                });
              }

              var children = {};

              var _load = ctx.loadChildrenPending();

              if (ctx.parser.renderChildren) {
                children = ctx.parser.renderChildren(_load, ctx);
              } else if (ctx.parser.loadChildren !== false) {
                children = _this4.renderChildren(_load, ctx);
              }

              var slot = _this4.getTypeSlot(ctx);

              var _vn;

              if (slot) {
                inject.children = children;
                _vn = slot(inject);
              } else {
                _vn = preview ? ctx.parser.preview(copy$1(children), ctx) : ctx.parser.render(copy$1(children), ctx);
              }

              _vn = _this4.renderSides(_vn, ctx);

              if (!(!ctx.input && is.Undef(prop["native"])) && prop["native"] !== true) {
                _vn = _this4.$manager.makeWrap(ctx, _vn);
              }

              if (ctx.none) {
                if (Array.isArray(_vn)) {
                  _vn = _vn.map(function (v) {
                    if (!v || !v.__v_isVNode) {
                      return v;
                    }

                    return _this4.none(v);
                  });
                } else {
                  _vn = _this4.none(_vn);
                }
              }

              cacheFlag && _this4.setCache(ctx, function () {
                return _this4.stable(_vn);
              }, parent);
              return _vn;
            };

            this.setCache(ctx, vn, parent);
          }

          return function () {
            var cache = _this4.getCache(ctx);

            if (cache) {
              return cache.apply(void 0, arguments);
            } else if (_this4.cache[ctx.id]) {
              return;
            }

            var _vn = _this4.renderCtx(ctx, ctx.parent);

            if (_vn) {
              return _vn();
            }
          };
        } catch (e) {
          console.error(e);
          return;
        }
      },
      none: function none(vn) {
        if (vn) {
          if (Array.isArray(vn.props["class"])) {
            vn.props["class"].push('fc-none');
          } else {
            vn.props["class"] = vn.props["class"] ? [vn.props["class"], 'fc-none'] : 'fc-none';
          }

          return vn;
        }
      },
      stable: function stable(vn) {
        var _this5 = this;

        var list = Array.isArray(vn) ? vn : [vn];
        list.forEach(function (v) {
          if (v && v.__v_isVNode && v.children && _typeof(v.children) === 'object') {
            v.children.$stable = true;

            _this5.stable(v.children);
          }
        });
        return vn;
      },
      getModelField: function getModelField(ctx) {
        return ctx.rule.modelField || ctx.parser.modelField || this.fc.modelFields[this.vNode.aliasMap[ctx.type]] || this.fc.modelFields[ctx.type] || this.fc.modelFields[ctx.originType] || 'modelValue';
      },
      isFragment: function isFragment(ctx) {
        return ctx.type === 'fragment' || ctx.type === 'template';
      },
      injectProp: function injectProp(ctx) {
        var _this6 = this;

        var state = this.vm.setupState;

        if (!state.ctxInject[ctx.id]) {
          state.ctxInject[ctx.id] = {
            api: this.$handle.api,
            form: this.fc.create,
            subForm: function subForm(_subForm) {
              _this6.$handle.addSubForm(ctx, _subForm);
            },
            getSubForm: function getSubForm() {
              return _this6.$handle.subForm[ctx.id];
            },
            options: [],
            children: [],
            preview: false,
            id: ctx.id,
            field: ctx.field,
            rule: ctx.rule,
            input: ctx.input
          };
        }

        var inject = state.ctxInject[ctx.id];
        extend(inject, {
          preview: ctx.prop.preview,
          options: ctx.prop.options,
          children: ctx.loadChildrenPending()
        });
        return inject;
      },
      ctxProp: function ctxProp(ctx) {
        var _this7 = this;

        var ref = ctx.ref,
            key = ctx.key,
            rule = ctx.rule;
        this.$manager.mergeProp(ctx);
        ctx.parser.mergeProp(ctx);
        var props = [{
          ref: ref,
          key: rule.key || "".concat(key, "fc"),
          slot: undefined,
          on: {
            vnodeMounted: function vnodeMounted(vn) {
              vn.el.__rule__ = ctx.rule;

              _this7.onMounted(ctx, vn.el);
            },
            'fc.updateValue': function fcUpdateValue(data) {
              _this7.$handle.onUpdateValue(ctx, data);
            },
            'fc.el': function fcEl(el) {
              ctx.exportEl = el;

              if (el) {
                (el.$el || el).__rule__ = ctx.rule;
              }
            }
          }
        }];

        if (ctx.input) {
          if (this.vm.props.disabled === true) {
            ctx.prop.props.disabled = true;
          }

          var field = this.getModelField(ctx);
          var model = {
            callback: function callback(value) {
              _this7.onInput(ctx, value);
            },
            value: this.$handle.getFormData(ctx)
          };
          props.push({
            on: _objectSpread2(_defineProperty({}, "update:".concat(field), model.callback), ctx.prop.modelEmit ? _defineProperty({}, ctx.prop.modelEmit, function () {
              return _this7.onEmitInput(ctx);
            }) : {}),
            props: _defineProperty({}, field, model.value)
          });
          ctx.prop.model = model;
        }

        mergeProps(props, ctx.prop);
        return ctx.prop;
      },
      onMounted: function onMounted(ctx, el) {
        ctx.el = this.vm.refs[ctx.ref] || el;
        ctx.parser.mounted(ctx);
        this.$handle.effect(ctx, 'mounted');
      },
      onInput: function onInput(ctx, value) {
        if (ctx.prop.modelEmit) {
          this.$handle.onBaseInput(ctx, value);
          return;
        }

        this.$handle.onInput(ctx, value);
      },
      onEmitInput: function onEmitInput(ctx) {
        this.$handle.setValue(ctx, ctx.parser.toValue(ctx.modelValue, ctx), ctx.modelValue);
      },
      renderChildren: function renderChildren(children, ctx) {
        var _this8 = this;

        if (!is.trueArray(children)) return {};
        var slotBag = makeSlotBag();
        children.map(function (child) {
          if (!child) return;
          if (is.String(child)) return slotBag.setSlot(null, child);

          if (child.__fc__) {
            return _this8.renderSlot(slotBag, child.__fc__, ctx);
          }

          if (child.type) {
            vue.nextTick(function () {
              _this8.$handle.loadChildren(children, ctx);

              _this8.$handle.refresh();
            });
          }
        });
        return slotBag.getSlots();
      },
      defaultRender: function defaultRender(ctx, children) {
        var prop = ctx.prop;
        if (prop.component) return this.vNode.makeComponent(prop.component, prop, children);
        if (this.vNode[ctx.type]) return this.vNode[ctx.type](prop, children);
        if (this.vNode[ctx.originType]) return this.vNode[ctx.originType](prop, children);
        return this.vNode.make(lower(ctx.originType), prop, children);
      },
      renderRule: function renderRule(rule, children, origin) {
        var _this9 = this;

        if (!rule) return undefined;
        if (is.String(rule)) return rule;
        var type;

        if (origin) {
          type = rule.type;
        } else {
          type = rule.is;

          if (rule.type) {
            type = toCase(rule.type);
            var alias = this.vNode.aliasMap[type];
            if (alias) type = toCase(alias);
          }
        }

        if (!type) return undefined;
        var slotBag = makeSlotBag();

        if (is.trueArray(rule.children)) {
          rule.children.forEach(function (v) {
            v && slotBag.setSlot(v === null || v === void 0 ? void 0 : v.slot, function () {
              return _this9.renderRule(v);
            });
          });
        }

        var props = _objectSpread2({}, rule);

        delete props.type;
        delete props.is;
        return this.vNode.make(type, props, slotBag.mergeBag(children).getSlots());
      }
    });
  }

  var id$1 = 1;
  function Render(handle) {
    extend(this, {
      $handle: handle,
      fc: handle.fc,
      vm: handle.vm,
      $manager: handle.$manager,
      vNode: new handle.fc.CreateNode(handle.vm),
      id: id$1++
    });
    funcProxy(this, {
      options: function options() {
        return handle.options;
      },
      sort: function sort() {
        return handle.sort;
      }
    });
    this.initCache();
    this.initRender();
  }
  useCache(Render);
  useRender$1(Render);

  function useInject(Handler) {
    extend(Handler.prototype, {
      parseInjectEvent: function parseInjectEvent(rule, on) {
        var inject = rule.inject || this.options.injectEvent;
        return this.parseEventLst(rule, on, inject);
      },
      parseEventLst: function parseEventLst(rule, data, inject, deep) {
        var _this = this;

        Object.keys(data).forEach(function (k) {
          var fn = _this.parseEvent(rule, data[k], inject, deep);

          if (fn) {
            data[k] = fn;
          }
        });
        return data;
      },
      parseEvent: function parseEvent(rule, fn, inject, deep) {
        if (is.Function(fn) && (inject !== false && !is.Undef(inject) || fn.__inject)) {
          return this.inject(rule, fn, inject);
        } else if (!deep && Array.isArray(fn) && fn[0] && (is.String(fn[0]) || is.Function(fn[0]))) {
          return this.parseEventLst(rule, fn, inject, true);
        } else if (is.String(fn)) {
          var val = parseFn(fn);

          if (val && fn !== val) {
            return val.__inject ? this.parseEvent(rule, val, inject, true) : val;
          }
        }
      },
      parseEmit: function parseEmit(ctx) {
        var _this2 = this;

        var event = {},
            rule = ctx.rule,
            emitPrefix = rule.emitPrefix,
            field = rule.field,
            name = rule.name,
            inject = rule.inject;
        var emit = rule.emit || [];

        if (is.trueArray(emit)) {
          emit.forEach(function (eventName) {
            if (!eventName) return;
            var eventInject;
            var emitKey = emitPrefix || field || name;

            if (is.Object(eventName)) {
              eventInject = eventName.inject;
              eventName = eventName.name;
              emitKey = eventName.prefix || emitKey;
            }

            if (emitKey) {
              var fieldKey = toLine("".concat(emitKey, "-").concat(eventName));

              var fn = function fn() {
                var _this2$vm, _this2$vm2, _this2$bus;

                if (_this2.vm.emitsOptions) {
                  _this2.vm.emitsOptions[fieldKey] = null;
                }

                for (var _len = arguments.length, arg = new Array(_len), _key = 0; _key < _len; _key++) {
                  arg[_key] = arguments[_key];
                }

                (_this2$vm = _this2.vm).emit.apply(_this2$vm, [fieldKey].concat(arg));

                (_this2$vm2 = _this2.vm).emit.apply(_this2$vm2, ['emit-event', fieldKey].concat(arg));

                (_this2$bus = _this2.bus).$emit.apply(_this2$bus, [fieldKey].concat(arg));
              };

              fn.__emit = true;

              if (!eventInject && inject === false) {
                event[eventName] = fn;
              } else {
                var _inject = eventInject || inject || _this2.options.injectEvent;

                event[eventName] = is.Undef(_inject) ? fn : _this2.inject(rule, fn, _inject);
              }
            }
          });
        }

        ctx.computed.on = event;
        return event;
      },
      getInjectData: function getInjectData(self, inject) {
        var _this$vm$props = this.vm.props,
            option = _this$vm$props.option,
            rule = _this$vm$props.rule;
        return {
          $f: this.api,
          api: this.api,
          rule: rule,
          self: self.__origin__,
          option: option,
          inject: inject
        };
      },
      inject: function inject(self, _fn, _inject2) {
        if (_fn.__origin) {
          if (this.watching && !this.loading) return _fn;
          _fn = _fn.__origin;
        }

        var h = this;

        var fn = function fn() {
          var data = h.getInjectData(self, _inject2);

          for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
          }

          data.args = [].concat(args);
          args.unshift(data);
          return _fn.apply(this, args);
        };

        fn.__origin = _fn;
        fn.__json = _fn.__json;
        return fn;
      },
      loadStrVar: function loadStrVar(str, get) {
        var _this3 = this;

        if (str && typeof str === 'string' && str.indexOf('{{') > -1 && str.indexOf('}}') > -1) {
          var vars = extractVar(str);
          vars.forEach(function (v) {
            var split = v.split('||');
            var field = split[0].trim();

            if (field) {
              var def = (split[1] || '').trim();
              var val = get ? get(field, def) : _this3.fc.getLoadData(field, def);
              str = str.replaceAll("{{".concat(v, "}}"), val == null ? '' : val);
            }
          });
        }

        return str;
      },
      loadFetchVar: function loadFetchVar(options, get) {
        var _this4 = this;

        var loadVal = function loadVal(str) {
          return _this4.loadStrVar(str, get);
        };

        options.action = loadVal(options.action);

        if (options.headers) {
          var _headers = {};
          Object.keys(options.headers).forEach(function (k) {
            _headers[loadVal(k)] = loadVal(options.headers[k]);
          });
          options.headers = _headers;
        }

        if (options.data) {
          var _data = {};
          Object.keys(options.data).forEach(function (k) {
            _data[loadVal(k)] = loadVal(options.data[k]);
          });
          options.data = _data;
        }

        return options;
      }
    });
  }

  var EVENT = ['hook:updated', 'hook:mounted'];
  function usePage(Handler) {
    extend(Handler.prototype, {
      usePage: function usePage() {
        var _this = this;

        var page = this.options.page;
        if (!page) return;
        var first = 25;
        var limit = getLimit(this.rules);

        if (is.Object(page)) {
          if (page.first) first = parseInt(page.first, 10) || first;
          if (page.limit) limit = parseInt(page.limit, 10) || limit;
        }

        extend(this, {
          first: first,
          limit: limit,
          pageEnd: this.rules.length <= first
        });
        this.bus.$on('page-end', function () {
          return _this.vm.emit('page-end', _this.api);
        });
        this.pageLoad();
      },
      pageLoad: function pageLoad() {
        var _this2 = this;

        var pageFn = function pageFn() {
          if (_this2.pageEnd) {
            _this2.bus.$off(EVENT, pageFn);

            _this2.bus.$emit('page-end');
          } else {
            _this2.first += _this2.limit;
            _this2.pageEnd = _this2.rules.length <= _this2.first;

            _this2.loadRule();

            _this2.refresh();
          }
        };

        this.bus.$on(EVENT, pageFn);
      }
    });
  }

  function getLimit(rules) {
    return rules.length < 31 ? 31 : Math.ceil(rules.length / 3);
  }

  function useRender(Handler) {
    extend(Handler.prototype, {
      clearNextTick: function clearNextTick() {
        this.nextTick && clearTimeout(this.nextTick);
        this.nextTick = null;
      },
      bindNextTick: function bindNextTick(fn) {
        var _this = this;

        this.clearNextTick();
        this.nextTick = setTimeout(function () {
          fn();
          _this.nextTick = null;
        }, 10);
      },
      render: function render() {
        // console.warn('%c render', 'color:green');
        ++this.loadedId;
        if (this.vm.setupState.unique > 0) return this.$render.render();else {
          this.vm.setupState.unique = 1;
          return [];
        }
      }
    });
  }

  function bind(ctx) {
    Object.defineProperties(ctx.origin, {
      __fc__: enumerable(vue.markRaw(ctx), true)
    });
  }

  function RuleContext(handle, rule, defaultValue) {
    var id = uniqueId();
    var isInput = !!rule.field;
    extend(this, {
      id: id,
      ref: id,
      wrapRef: id + 'fi',
      rule: rule,
      origin: rule.__origin__ || rule,
      name: rule.name,
      pending: {},
      none: false,
      watch: [],
      linkOn: [],
      root: [],
      ctrlRule: [],
      children: [],
      parent: null,
      group: rule.subRule ? this : null,
      cacheConfig: null,
      prop: _objectSpread2({}, rule),
      computed: {},
      payload: {},
      refRule: {},
      input: isInput,
      el: undefined,
      exportEl: undefined,
      defaultValue: isInput ? deepCopy(defaultValue) : undefined,
      field: rule.field || undefined
    });
    this.updateKey();
    bind(this);
    this.update(handle, true);
  }
  extend(RuleContext.prototype, {
    getParentGroup: function getParentGroup() {
      var ctx = this.parent;

      while (ctx) {
        if (ctx.group) {
          return ctx;
        }

        ctx = ctx.parent;
      }
    },
    loadChildrenPending: function loadChildrenPending() {
      var _this = this;

      var children = this.rule.children || [];
      if (Array.isArray(children)) return children;
      return this.loadPending({
        key: 'children',
        origin: children,
        def: [],
        onLoad: function onLoad(data) {
          _this.$handle && _this.$handle.loadChildren(data, _this);
        },
        onUpdate: function onUpdate(value, oldValue) {
          if (_this.$handle) {
            value === oldValue ? _this.$handle.loadChildren(value, _this) : _this.$handle.updateChildren(_this, value, oldValue);
          }
        },
        onReload: function onReload(value) {
          if (_this.$handle) {
            _this.$handle.updateChildren(_this, [], value);
          } else {
            delete _this.pending.children;
          }
        }
      });
    },
    loadPending: function loadPending(config) {
      var _this2 = this;

      var key = config.key,
          origin = config.origin,
          def = config.def,
          onLoad = config.onLoad,
          onReload = config.onReload,
          onUpdate = config.onUpdate;

      if (this.pending[key] && this.pending[key].origin === origin) {
        return this.getPending(key, def);
      }

      delete this.pending[key];
      var value = origin;

      if (is.Function(origin)) {
        var source = invoke(function () {
          return origin({
            rule: _this2.rule,
            api: _this2.$api,
            update: function update(data) {
              var value = data || def;

              var oldValue = _this2.getPending(key, def);

              _this2.setPending(key, origin, value);

              onUpdate && onUpdate(value, oldValue);
            },
            reload: function reload() {
              var oldValue = _this2.getPending(key, def);

              delete _this2.pending[key];
              onReload && onReload(oldValue);
              _this2.$api && _this2.$api.sync(_this2.rule);
            }
          });
        });

        if (source && is.Function(source.then)) {
          source.then(function (data) {
            var value = data || def;

            _this2.setPending(key, origin, value);

            onLoad && onLoad(value);
            _this2.$api && _this2.$api.sync(_this2.rule);
          })["catch"](function (e) {
            console.error(e);
          });
          value = def;
          this.setPending(key, origin, value);
        } else {
          value = source || def;
          this.setPending(key, origin, value);
          onLoad && onLoad(value);
        }
      }

      return value;
    },
    getPending: function getPending(key, def) {
      return this.pending[key] && this.pending[key].value || def;
    },
    setPending: function setPending(key, origin, value) {
      this.pending[key] = {
        origin: origin,
        value: vue.reactive(value)
      };
    },
    effectData: function effectData(name) {
      if (!this.payload[name]) {
        this.payload[name] = {};
      }

      return this.payload[name];
    },
    clearEffectData: function clearEffectData(name) {
      if (name === undefined) {
        this.payload = {};
      } else {
        delete this.payload[name];
      }
    },
    updateKey: function updateKey(flag) {
      this.key = uniqueId();
      flag && this.parent && this.parent.updateKey(flag);
    },
    updateType: function updateType() {
      this.originType = this.rule.type;
      this.type = toCase(this.rule.type);
      this.trueType = this.$handle.getType(this.originType);
    },
    setParser: function setParser(parser) {
      this.parser = parser;
      parser.init(this);
    },
    initProp: function initProp() {
      var _this3 = this;

      var rule = _objectSpread2({}, this.rule);

      delete rule.children;
      this.prop = mergeRule({}, [rule].concat(_toConsumableArray(Object.keys(this.payload).map(function (k) {
        return _this3.payload[k];
      })), [this.computed]));
    },
    initNone: function initNone() {
      this.none = !(is.Undef(this.prop.display) || !!this.prop.display);
    },
    injectValidate: function injectValidate() {
      var _this4 = this;

      return toArray(this.prop.validate).map(function (item) {
        if (is.Function(item.validator)) {
          var temp = _objectSpread2({}, item);

          var that = _this4;

          temp.validator = function () {
            var _item$validator;

            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            return (_item$validator = item.validator).call.apply(_item$validator, [{
              that: this,
              id: that.id,
              field: that.field,
              rule: that.rule,
              api: that.$handle.api
            }].concat(args));
          };

          return temp;
        }

        return item;
      });
    },
    check: function check(handle) {
      return this.vm === handle.vm;
    },
    unwatch: function unwatch() {
      this.watch.forEach(function (un) {
        return un();
      });
      this.watch = [];
      this.refRule = {};
    },
    unlink: function unlink() {
      this.linkOn.forEach(function (un) {
        return un();
      });
      this.linkOn = [];
    },
    link: function link() {
      this.unlink();
      this.$handle.appendLink(this);
    },
    watchTo: function watchTo() {
      this.$handle.watchCtx(this);
    },
    "delete": function _delete() {
      var undef = void 0;
      this.unwatch();
      this.unlink();
      this.rmCtrl();

      if (this.parent) {
        this.parent.children.splice(this.parent.children.indexOf(this) >>> 0, 1);
      }

      extend(this, {
        deleted: true,
        prop: _objectSpread2({}, this.rule),
        computed: {},
        el: undef,
        $handle: undef,
        $api: undef,
        vm: undef,
        vNode: undef,
        parent: null,
        children: [],
        cacheConfig: null,
        none: false
      });
    },
    rmCtrl: function rmCtrl() {
      this.ctrlRule.forEach(function (ctrl) {
        return ctrl.__fc__ && ctrl.__fc__.rm();
      });
      this.ctrlRule = [];
    },
    rm: function rm() {
      var _this5 = this;

      var _rm = function _rm() {
        var index = _this5.root.indexOf(_this5.origin);

        if (index > -1) {
          _this5.root.splice(index, 1);

          _this5.$handle && _this5.$handle.refresh();
        }
      };

      if (this.deleted) {
        _rm();

        return;
      }

      this.$handle.noWatch(function () {
        _this5.$handle.deferSyncValue(function () {
          _this5.rmCtrl();

          _rm();

          _this5.$handle.rmCtx(_this5);

          extend(_this5, {
            root: []
          });
        }, _this5.input);
      });
    },
    update: function update(handle, init) {
      extend(this, {
        deleted: false,
        $handle: handle,
        $render: handle.$render,
        $api: handle.api,
        vm: handle.vm,
        vNode: handle.$render.vNode,
        updated: false,
        cacheValue: this.rule.value
      });
      !init && this.unwatch();
      this.watchTo();
      this.link();
      this.updateType();
    }
  });

  function useLoader(Handler) {
    extend(Handler.prototype, {
      nextRefresh: function nextRefresh(fn) {
        var _this = this;

        var id = this.loadedId;
        vue.nextTick(function () {
          id === _this.loadedId && (fn ? fn() : _this.refresh());
        });
      },
      parseRule: function parseRule(_rule) {
        var _this2 = this;

        var rule = getRule(_rule);
        Object.defineProperties(rule, {
          __origin__: enumerable(_rule, true)
        });
        fullRule(rule);
        this.appendValue(rule);
        [rule, rule['prefix'], rule['suffix']].forEach(function (item) {
          if (!item) {
            return;
          }

          _this2.loadFn(item, rule);
        });
        this.loadCtrl(rule);

        if (rule.update) {
          rule.update = parseFn(rule.update);
        }

        return rule;
      },
      loadFn: function loadFn(item, rule) {
        var _this3 = this;

        ['on', 'props', 'deep'].forEach(function (k) {
          item[k] && _this3.parseInjectEvent(rule, item[k]);
        });
      },
      loadCtrl: function loadCtrl(rule) {
        rule.control && rule.control.forEach(function (ctrl) {
          if (ctrl.handle) {
            ctrl.handle = parseFn(ctrl.handle);
          }
        });
      },
      syncProp: function syncProp(ctx) {
        var _this4 = this;

        var rule = ctx.rule;
        is.trueArray(rule.sync) && mergeProps([{
          on: rule.sync.reduce(function (pre, prop) {
            pre["update:".concat(prop)] = function (val) {
              rule.props[prop] = val;

              _this4.vm.emit('sync', prop, val, rule, _this4.fapi);
            };

            return pre;
          }, {})
        }], ctx.computed);
      },
      loadRule: function loadRule() {
        var _this5 = this;

        // console.warn('%c load', 'color:blue');
        this.cycleLoad = false;
        this.loading = true;

        if (this.pageEnd) {
          this.bus.$emit('load-start');
        }

        this.deferSyncValue(function () {
          _this5._loadRule(_this5.rules);

          _this5.loading = false;

          if (_this5.cycleLoad && _this5.pageEnd) {
            return _this5.loadRule();
          }

          _this5.syncForm();

          if (_this5.pageEnd) {
            _this5.bus.$emit('load-end');
          }

          _this5.vm.setupState.renderRule();
        });
      },
      loadChildren: function loadChildren(children, parent) {
        this.cycleLoad = false;
        this.loading = true;
        this.bus.$emit('load-start');

        this._loadRule(children, parent);

        this.loading = false;

        if (this.cycleLoad) {
          return this.loadRule();
        } else {
          this.syncForm();
          this.bus.$emit('load-end');
        }

        this.$render.clearCache(parent);
      },
      _loadRule: function _loadRule(rules, parent) {
        var _this6 = this;

        var preIndex = function preIndex(i) {
          var pre = rules[i - 1];

          if (!pre || !pre.__fc__) {
            return i > 0 ? preIndex(i - 1) : -1;
          }

          var index = _this6.sort.indexOf(pre.__fc__.id);

          return index > -1 ? index : preIndex(i - 1);
        };

        var loadChildren = function loadChildren(children, parent) {
          if (is.trueArray(children)) {
            _this6._loadRule(children, parent);
          }
        };

        var ctxs = rules.map(function (_rule, index) {
          if (parent && !is.Object(_rule)) return;
          if (!_this6.pageEnd && !parent && index >= _this6.first) return;

          if (_rule.__fc__ && _rule.__fc__.root === rules && _this6.ctxs[_rule.__fc__.id]) {
            loadChildren(_rule.__fc__.loadChildrenPending(), _rule.__fc__);
            return _rule.__fc__;
          }

          var rule = getRule(_rule);

          var isRepeat = function isRepeat() {
            return !!(rule.field && _this6.fieldCtx[rule.field] && _this6.fieldCtx[rule.field][0] !== _rule.__fc__);
          };

          _this6.ruleEffect(rule, 'init', {
            repeat: isRepeat()
          });

          if (isRepeat()) {
            _this6.vm.emit('repeat-field', _rule, _this6.api);
          }

          var ctx;
          var isCopy = false;
          var isInit = !!_rule.__fc__;
          var defaultValue = rule.value;

          if (isInit) {
            ctx = _rule.__fc__;
            defaultValue = ctx.defaultValue;
            var check = !ctx.check(_this6);

            if (ctx.deleted) {
              if (check) {
                if (isCtrl(ctx)) {
                  return;
                }

                ctx.update(_this6);
              }
            } else {
              if (check) {
                if (isCtrl(ctx)) {
                  return;
                }

                rules[index] = _rule = _rule._clone ? _rule._clone() : copyRule(_rule);
                ctx = null;
                isCopy = true;
              }
            }
          }

          if (!ctx) {
            var _rule2 = _this6.parseRule(_rule);

            ctx = new RuleContext(_this6, _rule2, defaultValue);

            _this6.bindParser(ctx);
          } else {
            if (ctx.originType !== ctx.rule.type) {
              ctx.updateType();

              _this6.bindParser(ctx);
            }

            _this6.appendValue(ctx.rule);

            if (ctx.parent && ctx.parent !== parent) {
              _this6.rmSubRuleData(ctx);
            }
          }

          _this6.parseEmit(ctx);

          _this6.syncProp(ctx);

          ctx.parent = parent || null;
          ctx.root = rules;

          _this6.setCtx(ctx);

          !isCopy && !isInit && _this6.effect(ctx, 'load');

          _this6.effect(ctx, 'created');

          var _load = ctx.loadChildrenPending();

          ctx.parser.loadChildren === false || loadChildren(_load, ctx);

          if (!parent) {
            var _preIndex = preIndex(index);

            if (_preIndex > -1 || !index) {
              _this6.sort.splice(_preIndex + 1, 0, ctx.id);
            } else {
              _this6.sort.push(ctx.id);
            }
          }

          var r = ctx.rule;

          if (!ctx.updated) {
            ctx.updated = true;

            if (is.Function(r.update)) {
              _this6.bus.$once('load-end', function () {
                _this6.refreshUpdate(ctx, r.value, 'init');
              });
            }

            _this6.effect(ctx, 'loaded');
          } // if (ctx.input)
          //     Object.defineProperty(r, 'value', this.valueHandle(ctx));


          if (_this6.refreshControl(ctx)) _this6.cycleLoad = true;
          return ctx;
        }).filter(function (v) {
          return !!v;
        });

        if (parent) {
          parent.children = ctxs;
        }
      },
      refreshControl: function refreshControl(ctx) {
        return ctx.input && ctx.rule.control && this.useCtrl(ctx);
      },
      useCtrl: function useCtrl(ctx) {
        var _this7 = this;

        var controls = getCtrl(ctx),
            validate = [],
            api = this.api;
        if (!controls.length) return false;

        var _loop = function _loop(i) {
          var control = controls[i],
              handleFn = control.handle || function (val) {
            return (condition[control.condition || '=='] || condition['=='])(val, control.value);
          };

          if (!is.trueArray(control.rule)) return "continue";

          var data = _objectSpread2(_objectSpread2({}, control), {}, {
            valid: invoke(function () {
              return handleFn(ctx.rule.value, api);
            }),
            ctrl: findCtrl(ctx, control.rule),
            isHidden: is.String(control.rule[0])
          });

          if (data.valid && data.ctrl || !data.valid && !data.ctrl && !data.isHidden) return "continue";
          validate.push(data);
        };

        for (var i = 0; i < controls.length; i++) {
          var _ret = _loop(i);

          if (_ret === "continue") continue;
        }

        if (!validate.length) return false;
        var hideLst = [];
        var flag = false;
        this.deferSyncValue(function () {
          validate.reverse().forEach(function (_ref) {
            var isHidden = _ref.isHidden,
                valid = _ref.valid,
                rule = _ref.rule,
                prepend = _ref.prepend,
                append = _ref.append,
                child = _ref.child,
                ctrl = _ref.ctrl,
                method = _ref.method;

            if (isHidden) {
              valid ? ctx.ctrlRule.push({
                __ctrl: true,
                children: rule,
                valid: valid
              }) : ctx.ctrlRule.splice(ctx.ctrlRule.indexOf(ctrl), 1);
              hideLst[valid ? 'push' : 'unshift'](function () {
                if (method === 'disabled') {
                  _this7.api.disabled(!valid, rule);
                } else if (method === 'display') {
                  _this7.api.display(valid, rule);
                } else if (method === 'required') {
                  rule.forEach(function (item) {
                    _this7.api.setEffect(item, 'required', valid);
                  });

                  if (!valid) {
                    _this7.api.clearValidateState(rule);
                  }
                } else {
                  _this7.api.hidden(!valid, rule);
                }
              });
              return;
            }

            if (valid) {
              flag = true;
              var ruleCon = {
                type: 'fragment',
                "native": true,
                __ctrl: true,
                children: rule
              };
              ctx.ctrlRule.push(ruleCon);

              _this7.bus.$once('load-start', function () {
                // this.cycleLoad = true;
                if (prepend) {
                  api.prepend(ruleCon, prepend, child);
                } else if (append || child) {
                  api.append(ruleCon, append || ctx.id, child);
                } else {
                  ctx.root.splice(ctx.root.indexOf(ctx.origin) + 1, 0, ruleCon);
                }
              });
            } else {
              ctx.ctrlRule.splice(ctx.ctrlRule.indexOf(ctrl), 1);
              var ctrlCtx = byCtx(ctrl);
              ctrlCtx && ctrlCtx.rm();
            }
          });
        });
        hideLst.length && vue.nextTick(function () {
          hideLst.forEach(function (v) {
            return v();
          });
        });
        this.vm.emit('control', ctx.origin, this.api);
        this.effect(ctx, 'control');
        return flag;
      },
      reloadRule: function reloadRule(rules) {
        return this._reloadRule(rules);
      },
      _reloadRule: function _reloadRule(rules) {
        var _this8 = this;

        // console.warn('%c reload', 'color:red');
        if (!rules) rules = this.rules;

        var ctxs = _objectSpread2({}, this.ctxs);

        this.clearNextTick();
        this.initData(rules);
        this.fc.rules = rules;
        this.deferSyncValue(function () {
          _this8.bus.$once('load-end', function () {
            Object.keys(ctxs).filter(function (id) {
              return _this8.ctxs[id] === undefined;
            }).forEach(function (id) {
              return _this8.rmCtx(ctxs[id]);
            });

            _this8.$render.clearCacheAll();
          });

          _this8.reloading = true;

          _this8.loadRule();

          _this8.reloading = false;

          _this8.refresh();

          _this8.bus.$emit('reloading', _this8.api);
        });
        this.bus.$off('next-tick', this.nextReload);
        this.bus.$once('next-tick', this.nextReload);
        this.bus.$emit('update', this.api);
      },
      //todo 组件生成全部通过 alias
      refresh: function refresh() {
        this.vm.setupState.refresh();
      }
    });
  }

  function fullRule(rule) {
    var def = baseRule();
    Object.keys(def).forEach(function (k) {
      if (!hasProperty(rule, k)) rule[k] = def[k];
    });
    return rule;
  }

  function getCtrl(ctx) {
    var control = ctx.rule.control || [];
    if (is.Object(control)) return [control];else return control;
  }

  function findCtrl(ctx, rule) {
    for (var i = 0; i < ctx.ctrlRule.length; i++) {
      var ctrl = ctx.ctrlRule[i];
      if (ctrl.children === rule) return ctrl;
    }
  }

  function isCtrl(ctx) {
    return !!ctx.rule.__ctrl;
  }

  function useInput(Handler) {
    extend(Handler.prototype, {
      setValue: function setValue(ctx, value, formValue, setFlag) {
        if (ctx.deleted) return;
        ctx.rule.value = value;
        this.changeStatus = true;
        this.nextRefresh();
        this.$render.clearCache(ctx);
        this.setFormData(ctx, formValue);
        this.syncValue();
        this.valueChange(ctx, value);
        this.vm.emit('change', ctx.field, value, ctx.origin, this.api, setFlag || false);
        this.effect(ctx, 'value');
        this.emitEvent('change', ctx.field, value, {
          rule: ctx.origin,
          api: this.api,
          setFlag: setFlag || false
        });
      },
      onInput: function onInput(ctx, value) {
        var val;

        if (ctx.input && (this.isQuote(ctx, val = ctx.parser.toValue(value, ctx)) || this.isChange(ctx, value))) {
          this.setValue(ctx, val, value);
        }
      },
      onUpdateValue: function onUpdateValue(ctx, data) {
        var _this = this;

        this.deferSyncValue(function () {
          var group = ctx.getParentGroup();
          var subForm = group ? _this.subRuleData[group.id] : null;
          var subData = {};
          Object.keys(data || {}).forEach(function (k) {
            if (subForm && hasProperty(subForm, k)) {
              subData[k] = data[k];
            } else if (hasProperty(_this.api.form, k)) {
              _this.api.form[k] = data[k];
            } else if (_this.api.top !== _this.api && hasProperty(_this.api.top.form, k)) {
              _this.api.top.form[k] = data[k];
            }
          });

          if (Object.keys(subData).length) {
            _this.api.setChildrenFormData(group.rule, subData);
          }
        });
      },
      onBaseInput: function onBaseInput(ctx, value) {
        this.setFormData(ctx, value);
        ctx.modelValue = value;
        this.nextRefresh();
        this.$render.clearCache(ctx);
      },
      setFormData: function setFormData(ctx, value) {
        ctx.modelValue = value;
        var group = ctx.getParentGroup();

        if (group) {
          if (!this.subRuleData[group.id]) {
            this.subRuleData[group.id] = {};
          }

          this.subRuleData[group.id][ctx.field] = ctx.rule.value;
        }

        $set(this.formData, ctx.id, value);
      },
      rmSubRuleData: function rmSubRuleData(ctx) {
        var group = ctx.getParentGroup();

        if (group && this.subRuleData[group.id]) {
          delete this.subRuleData[group.id][ctx.field];
        }
      },
      getFormData: function getFormData(ctx) {
        return this.formData[ctx.id];
      },
      syncForm: function syncForm() {
        var _this2 = this;

        var data = vue.reactive({});
        this.fields().reduce(function (initial, field) {
          var ctx = _this2.getCtx(field);

          initial[field] = vue.toRef(ctx.rule, 'value');
          return initial;
        }, data);
        this.form = data;
        this.syncValue();
      },
      appendValue: function appendValue(rule) {
        if (!rule.field || !hasProperty(this.appendData, rule.field)) return;
        rule.value = this.appendData[rule.field];
        delete this.appendData[rule.field];
      },
      addSubForm: function addSubForm(ctx, subForm) {
        this.subForm[ctx.id] = subForm;
      },
      deferSyncValue: function deferSyncValue(fn, sync) {
        if (!this.deferSyncFn) {
          this.deferSyncFn = fn;
        }

        if (!this.deferSyncFn.sync) {
          this.deferSyncFn.sync = sync;
        }

        invoke(fn);

        if (this.deferSyncFn === fn) {
          this.deferSyncFn = null;

          if (fn.sync) {
            this.syncValue();
          }
        }
      },
      syncValue: function syncValue() {
        if (this.deferSyncFn) {
          return this.deferSyncFn.sync = true;
        }

        this.vm.setupState.updateValue(_objectSpread2(_objectSpread2({}, this.options.appendValue !== false ? this.appendData : {}), this.form));
      },
      isChange: function isChange(ctx, value) {
        return JSON.stringify(this.getFormData(ctx), strFn) !== JSON.stringify(value, strFn);
      },
      isQuote: function isQuote(ctx, value) {
        return (is.Object(value) || Array.isArray(value)) && value === ctx.rule.value;
      },
      refreshUpdate: function refreshUpdate(ctx, val, origin, field) {
        var _this3 = this;

        if (is.Function(ctx.rule.update)) {
          var state = invoke(function () {
            return ctx.rule.update(val, ctx.origin, _this3.api, {
              origin: origin || 'change',
              linkField: field
            });
          });
          if (state === undefined) return;
          ctx.rule.hidden = state === true;
        }
      },
      valueChange: function valueChange(ctx, val) {
        this.refreshRule(ctx, val);
        this.bus.$emit('change-' + ctx.field, val);
      },
      refreshRule: function refreshRule(ctx, val, origin, field) {
        if (this.refreshControl(ctx)) {
          this.$render.clearCacheAll();
          this.loadRule();
          this.bus.$emit('update', this.api);
          this.refresh();
        }

        this.refreshUpdate(ctx, val, origin, field);
      },
      appendLink: function appendLink(ctx) {
        var _this4 = this;

        var link = ctx.rule.link;
        is.trueArray(link) && link.forEach(function (field) {
          var fn = function fn() {
            return _this4.refreshRule(ctx, ctx.rule.value, 'link', field);
          };

          _this4.bus.$on('change-' + field, fn);

          ctx.linkOn.push(function () {
            return _this4.bus.$off('change-' + field, fn);
          });
        });
      },
      fields: function fields() {
        return Object.keys(this.fieldCtx);
      }
    });
  }

  function strFn(key, val) {
    return typeof val === 'function' ? '' + val : val;
  }

  var BaseParser = {
    init: function init(ctx) {},
    toFormValue: function toFormValue(value, ctx) {
      return value;
    },
    toValue: function toValue(formValue, ctx) {
      return formValue;
    },
    mounted: function mounted(ctx) {},
    render: function render(children, ctx) {
      return ctx.$render.defaultRender(ctx, children);
    },
    preview: function preview(children, ctx) {
      return this.render(children, ctx);
    },
    mergeProp: function mergeProp(ctx) {}
  };

  var noneKey = ['field', 'value', 'vm', 'template', 'name', 'config', 'control', 'inject', 'sync', 'payload', 'optionsTo', 'update', 'slotUpdate', 'computed', 'component', 'cache'];
  function useContext(Handler) {
    extend(Handler.prototype, {
      getCtx: function getCtx(id) {
        return this.getFieldCtx(id) || this.getNameCtx(id)[0] || this.ctxs[id];
      },
      getCtxs: function getCtxs(id) {
        return this.fieldCtx[id] || this.nameCtx[id] || (this.ctxs[id] ? [this.ctxs[id]] : []);
      },
      setIdCtx: function setIdCtx(ctx, key, type) {
        var field = "".concat(type, "Ctx");

        if (!this[field][key]) {
          this[field][key] = [ctx];
        } else {
          this[field][key].push(ctx);
        }
      },
      rmIdCtx: function rmIdCtx(ctx, key, type) {
        var field = "".concat(type, "Ctx");
        var lst = this[field][key];
        if (!lst) return false;
        var flag = lst.splice(lst.indexOf(ctx) >>> 0, 1).length > 0;

        if (!lst.length) {
          delete this[field][key];
        }

        return flag;
      },
      getFieldCtx: function getFieldCtx(field) {
        return (this.fieldCtx[field] || [])[0];
      },
      getNameCtx: function getNameCtx(name) {
        return this.nameCtx[name] || [];
      },
      setCtx: function setCtx(ctx) {
        var id = ctx.id,
            field = ctx.field,
            name = ctx.name,
            rule = ctx.rule;
        this.ctxs[id] = ctx;
        name && this.setIdCtx(ctx, name, 'name');
        if (!ctx.input) return;
        this.setIdCtx(ctx, field, 'field');
        this.setFormData(ctx, ctx.parser.toFormValue(rule.value, ctx));

        if (this.isMounted && !this.reloading) {
          this.vm.emit('change', ctx.field, rule.value, ctx.origin, this.api);
        }
      },
      getParser: function getParser(ctx) {
        var list = this.fc.parsers;
        return list[ctx.originType] || list[toCase(ctx.type)] || list[ctx.trueType] || BaseParser;
      },
      bindParser: function bindParser(ctx) {
        ctx.setParser(this.getParser(ctx));
      },
      getType: function getType(alias) {
        var map = this.fc.CreateNode.aliasMap;
        var type = map[alias] || map[toCase(alias)] || alias;
        return toCase(type);
      },
      noWatch: function noWatch(fn) {
        if (!this.noWatchFn) {
          this.noWatchFn = fn;
        }

        invoke(fn);

        if (this.noWatchFn === fn) {
          this.noWatchFn = null;
        }
      },
      watchCtx: function watchCtx(ctx) {
        var _this = this;

        var all = attrs();
        all.filter(function (k) {
          return k[0] !== '_' && k[0] !== '$' && noneKey.indexOf(k) === -1;
        }).forEach(function (key) {
          var ref = vue.toRef(ctx.rule, key);
          var flag = key === 'children';
          ctx.refRule[key] = ref;
          ctx.watch.push(vue.watch(flag ? function () {
            return is.Function(ref.value) ? ref.value : _toConsumableArray(ref.value || []);
          } : function () {
            return ref.value;
          }, function (_, o) {
            var n = ref.value;
            if (_this.isBreakWatch()) return;

            if (flag && ctx.parser.loadChildren === false) {
              _this.$render.clearCache(ctx);

              _this.nextRefresh();

              return;
            }

            _this.watching = true;

            if (key === 'link') {
              ctx.link();
              return;
            } else if (['props', 'on', 'deep'].indexOf(key) > -1) {
              _this.parseInjectEvent(ctx.rule, n || {});

              if (key === 'props' && ctx.input) {
                _this.setFormData(ctx, ctx.parser.toFormValue(ctx.rule.value, ctx));
              }
            } else if (key === 'emit') {
              _this.parseEmit(ctx);
            } else if (key === 'hidden' && Boolean(n) !== Boolean(o)) {
              _this.$render.clearCacheAll();
            } else if (['prefix', 'suffix'].indexOf(key) > -1) n && _this.loadFn(n, ctx.rule);else if (key === 'type') {
              ctx.updateType();

              _this.bindParser(ctx);
            } else if (flag) {
              if (is.Function(o)) {
                o = ctx.getPending('children', []);
              }

              if (is.Function(n)) {
                n = ctx.loadChildrenPending();
              }

              _this.updateChildren(ctx, n, o);
            }

            _this.$render.clearCache(ctx);

            _this.refresh();

            _this.watching = false;
          }, {
            deep: !flag,
            sync: flag
          }));
        });

        if (ctx.input) {
          var val = vue.toRef(ctx.rule, 'value');
          ctx.watch.push(vue.watch(function () {
            return val.value;
          }, function () {
            var formValue = ctx.parser.toFormValue(val.value, ctx);

            if (_this.isChange(ctx, formValue)) {
              _this.setValue(ctx, val.value, formValue, true);
            }
          }));
        }

        this.bus.$once('load-end', function () {
          var computed = ctx.rule.computed;

          if (!computed) {
            return;
          }

          if (_typeof(computed) !== 'object') {
            computed = {
              value: computed
            };
          }

          Object.keys(computed).forEach(function (k) {
            ctx.watch.push(vue.watch(function () {
              var item = computed[k];
              if (!item) return undefined;
              var fn;

              if (_typeof(item) === 'object') {
                var group = ctx.getParentGroup();

                var checkCondition = function checkCondition(item) {
                  item = Array.isArray(item) ? {
                    mode: 'AND',
                    group: item
                  } : item;

                  if (!is.trueArray(item.group)) {
                    return true;
                  }

                  var or = item.mode === 'OR';
                  var valid = true;

                  for (var i = 0; i < item.group.length; i++) {
                    var one = item.group[i];
                    var flag = void 0;

                    if (one.mode) {
                      flag = checkCondition(one);
                    } else if (!condition[one.condition]) {
                      flag = false;
                    } else {
                      flag = new Function('_$', '_$val', 'top', 'group', "with(top){with(this){with(group){ return _$['".concat(one.condition, "'](").concat(one.field, ", ").concat(one.compare ? one.compare : '_$val', "); }}}")).call(_this.api.form, condition, one.value, _this.api.top.form, group ? _this.subRuleData[group.id] || {} : {});
                    }

                    if (or && flag) {
                      return true;
                    }

                    if (!or) {
                      valid = valid && flag;
                    }
                  }

                  return or ? false : valid;
                };

                return checkCondition(item);
              } else if (is.Function(item)) {
                fn = function fn() {
                  return item(_this.api.form, _this.api);
                };
              } else {
                var _group = ctx.getParentGroup();

                fn = function fn() {
                  return new Function('formulas', 'top', 'group', '$rule', '$api', "with(top){with(this){with(group){with(formulas){ return ".concat(item, " }}}}")).call(_this.api.form, _this.fc.formulas, _this.api.top.form, _group ? _this.subRuleData[_group.id] || {} : {}, ctx.rule, _this.api);
                };
              }

              return invoke(fn, undefined);
            }, function (n) {
              setTimeout(function () {
                if (k === 'value') {
                  _this.onInput(ctx, n);
                } else if (k[0] === '$') {
                  _this.api.setEffect(ctx.id, k, n);
                } else {
                  deepSet(ctx.rule, k, n);
                }
              });
            }, {
              immediate: true
            }));
          });
        });
        this.watchEffect(ctx);
      },
      updateChildren: function updateChildren(ctx, n, o) {
        var _this2 = this;

        this.deferSyncValue(function () {
          o && o.forEach(function (child) {
            if ((n || []).indexOf(child) === -1 && child && !is.String(child) && child.__fc__ && child.__fc__.parent === ctx && child.__fc__.root !== n) {
              _this2.rmCtx(child.__fc__);
            }
          });

          if (is.trueArray(n)) {
            _this2.loadChildren(n, ctx);

            _this2.bus.$emit('update', _this2.api);
          }
        });
      },
      rmSub: function rmSub(sub) {
        var _this3 = this;

        is.trueArray(sub) && sub.forEach(function (r) {
          r && r.__fc__ && _this3.rmCtx(r.__fc__);
        });
      },
      rmCtx: function rmCtx(ctx) {
        var _this4 = this;

        if (ctx.deleted) return;
        var id = ctx.id,
            field = ctx.field,
            input = ctx.input,
            name = ctx.name;
        $del(this.ctxs, id);
        $del(this.formData, id);
        $del(this.subForm, id);
        $del(this.vm.setupState.ctxInject, id);
        var group = ctx.getParentGroup();

        if (group && this.subRuleData[group.id]) {
          $del(this.subRuleData[group.id], field);
        }

        if (ctx.group) {
          $del(this.subRuleData, id);
        }

        input && this.rmIdCtx(ctx, field, 'field');
        name && this.rmIdCtx(ctx, name, 'name');

        if (input && !hasProperty(this.fieldCtx, field)) {
          $del(this.form, field);
        }

        this.deferSyncValue(function () {
          if (!_this4.reloading) {
            if (ctx.parser.loadChildren !== false) {
              var children = ctx.getPending('children', ctx.rule.children);

              if (is.trueArray(children)) {
                children.forEach(function (h) {
                  return h.__fc__ && _this4.rmCtx(h.__fc__);
                });
              }
            }

            if (ctx.root === _this4.rules) {
              _this4.vm.setupState.renderRule();
            }
          }
        }, input);
        var index = this.sort.indexOf(id);

        if (index > -1) {
          this.sort.splice(index, 1);
        }

        this.$render.clearCache(ctx);
        ctx["delete"]();
        this.effect(ctx, 'deleted');
        input && !this.fieldCtx[field] && this.vm.emit('remove-field', field, ctx.rule, this.api);
        ctx.rule.__ctrl || this.vm.emit('remove-rule', ctx.rule, this.api);
        return ctx;
      }
    });
  }

  function useLifecycle(Handler) {
    extend(Handler.prototype, {
      mounted: function mounted() {
        var _this = this;

        var _mounted = function _mounted() {
          _this.isMounted = true;

          _this.lifecycle('mounted');
        };

        if (this.pageEnd) {
          _mounted();
        } else {
          this.bus.$once('page-end', _mounted);
        }
      },
      lifecycle: function lifecycle(name) {
        this.vm.emit(name, this.api);
        this.emitEvent(name, this.api);
      },
      emitEvent: function emitEvent(name) {
        var _this$bus;

        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        var _fn = this.options[name] || this.options[toCase('on-' + name)];

        if (_fn) {
          var fn = parseFn(_fn);
          is.Function(fn) && invoke(function () {
            return fn.apply(void 0, args);
          });
        }

        (_this$bus = this.bus).$emit.apply(_this$bus, [name].concat(args));
      }
    });
  }

  function useEffect(Handler) {
    extend(Handler.prototype, {
      useProvider: function useProvider() {
        var _this = this;

        var ps = this.fc.providers;
        Object.keys(ps).forEach(function (k) {
          var prop = ps[k];

          if (is.Function(prop)) {
            prop = prop(_this.fc);
          }

          prop._c = getComponent(prop);

          _this.onEffect(prop);

          _this.providers[k] = prop;
        });
      },
      onEffect: function onEffect(provider) {
        var _this2 = this;

        var used = [];
        (provider._c || ['*']).forEach(function (name) {
          var type = name === '*' ? '*' : _this2.getType(name);
          if (used.indexOf(type) > -1) return;
          used.push(type);

          _this2.bus.$on("p:".concat(provider.name, ":").concat(type, ":").concat(provider.input ? 1 : 0), function (event, args) {
            provider[event] && provider[event].apply(provider, _toConsumableArray(args));
          });
        });
        provider._used = used;
      },
      watchEffect: function watchEffect(ctx) {
        var _this3 = this;

        var effect = {
          required: function required() {
            var _ctx$rule, _ctx$rule$effect;

            return (hasProperty(ctx.rule, '$required') ? ctx.rule['$required'] : (_ctx$rule = ctx.rule) === null || _ctx$rule === void 0 ? void 0 : (_ctx$rule$effect = _ctx$rule.effect) === null || _ctx$rule$effect === void 0 ? void 0 : _ctx$rule$effect.required) || false;
          }
        };
        Object.keys(ctx.rule.effect || {}).forEach(function (k) {
          effect[k] = function () {
            return ctx.rule.effect[k];
          };
        });
        Object.keys(ctx.rule).forEach(function (k) {
          if (k[0] === '$') {
            effect[k.substr(1)] = function () {
              return ctx.rule[k];
            };
          }
        });
        Object.keys(effect).forEach(function (k) {
          ctx.watch.push(vue.watch(effect[k], function (n) {
            _this3.effect(ctx, 'watch', _defineProperty({}, k, n));
          }, {
            deep: true
          }));
        });
      },
      ruleEffect: function ruleEffect(rule, event, append) {
        this.emitEffect({
          rule: rule,
          input: !!rule.field,
          type: this.getType(rule.type)
        }, event, append);
      },
      effect: function effect(ctx, event, custom) {
        this.emitEffect({
          rule: ctx.rule,
          input: ctx.input,
          type: ctx.trueType,
          ctx: ctx,
          custom: custom
        }, event);
      },
      getEffect: function getEffect(rule, name) {
        if (hasProperty(rule, '$' + name)) {
          return rule['$' + name];
        }

        if (hasProperty(rule, 'effect') && hasProperty(rule.effect, name)) return rule.effect[name];
        return undefined;
      },
      emitEffect: function emitEffect(_ref, event, append) {
        var _this4 = this;

        var ctx = _ref.ctx,
            rule = _ref.rule,
            input = _ref.input,
            type = _ref.type,
            custom = _ref.custom;
        if (!type || ['fcFragment', 'fragment'].indexOf(type) > -1) return;
        var effect = custom ? custom : Object.keys(rule).reduce(function (i, k) {
          if (k[0] === '$') {
            i[k.substr(1)] = rule[k];
          }

          return i;
        }, _objectSpread2({}, rule.effect || {}));
        Object.keys(effect).forEach(function (attr) {
          var p = _this4.providers[attr];
          if (!p || p.input && !input) return;

          var _type;

          if (!p._c) {
            _type = '*';
          } else if (p._used.indexOf(type) > -1) {
            _type = type;
          } else {
            return;
          }

          var data = _objectSpread2({
            value: effect[attr],
            getValue: function getValue() {
              return _this4.getEffect(rule, attr);
            }
          }, append || {});

          if (ctx) {
            data.getProp = function () {
              return ctx.effectData(attr);
            };

            data.clearProp = function () {
              return ctx.clearEffectData(attr);
            };

            data.mergeProp = function (prop) {
              return mergeRule(data.getProp(), [prop]);
            };

            data.id = ctx.id;
          }

          _this4.bus.$emit("p:".concat(attr, ":").concat(_type, ":").concat(p.input ? 1 : 0), event, [data, rule, _this4.api]);
        });
      }
    });
  }

  function unique(arr) {
    return arr.filter(function (item, index, arr) {
      return arr.indexOf(item, 0) === index;
    });
  }

  function getComponent(p) {
    var c = p.components;

    if (Array.isArray(c)) {
      var arr = unique(c.filter(function (v) {
        return v !== '*';
      }));
      return arr.length ? arr : false;
    } else if (is.String(c)) return [c];else return false;
  }

  function Handler(fc) {
    var _this = this;

    funcProxy(this, {
      options: function options() {
        return fc.options.value || {};
      },
      bus: function bus() {
        return fc.bus;
      }
    });
    extend(this, {
      fc: fc,
      vm: fc.vm,
      watching: false,
      loading: false,
      reloading: false,
      noWatchFn: null,
      deferSyncFn: null,
      isMounted: false,
      formData: vue.reactive({}),
      subRuleData: vue.reactive({}),
      subForm: {},
      form: vue.reactive({}),
      appendData: {},
      providers: {},
      cycleLoad: null,
      loadedId: 1,
      nextTick: null,
      changeStatus: false,
      pageEnd: true,
      nextReload: function nextReload() {
        _this.lifecycle('reload');
      }
    });
    this.initData(fc.rules);
    this.$manager = new fc.manager(this);
    this.$render = new Render(this);
    this.api = fc.extendApiFn.reduce(function (api, fn) {
      extend(api, invoke(function () {
        return fn(api, _this);
      }, {}));
      return api;
    }, Api(this));
  }
  extend(Handler.prototype, {
    initData: function initData(rules) {
      extend(this, {
        ctxs: {},
        fieldCtx: {},
        nameCtx: {},
        sort: [],
        rules: rules
      });
    },
    init: function init() {
      this.appendData = _objectSpread2(_objectSpread2(_objectSpread2({}, this.options.formData || {}), this.fc.vm.props.modelValue || {}), this.appendData);
      this.useProvider();
      this.usePage();
      this.loadRule();

      this.$manager.__init();

      this.lifecycle('created');
    },
    isBreakWatch: function isBreakWatch() {
      return this.loading || this.noWatchFn || this.reloading;
    },
    beforeFetch: function beforeFetch(opt) {
      var _this2 = this;

      return new Promise(function (resolve) {
        var source = _this2.options.beforeFetch && invoke(function () {
          return _this2.options.beforeFetch(opt, {
            api: _this2.api
          });
        });

        if (source && is.Function(source.then)) {
          source.then(resolve);
        } else {
          resolve();
        }
      });
    }
  });
  useInject(Handler);
  usePage(Handler);
  useRender(Handler);
  useLoader(Handler);
  useInput(Handler);
  useContext(Handler);
  useLifecycle(Handler);
  useEffect(Handler);

  var NAME = 'fcFragment';
  var fragment = vue.defineComponent({
    name: NAME,
    inheritAttrs: false,
    props: ['vnode'],
    render: function render() {
      return this.vnode;
    }
  });

  function tidyDirectives(directives) {
    return Object.keys(directives).map(function (n) {
      var data = directives[n];
      var directive = vue.resolveDirective(n);
      if (!directive) return;
      return [directive, data.value, data.arg, data.modifiers];
    }).filter(function (v) {
      return !!v;
    });
  }

  function makeDirective(data, vn) {
    var directives = data.directives;
    if (!directives) return vn;

    if (!Array.isArray(directives)) {
      directives = [directives];
    }

    return vue.withDirectives(vn, directives.reduce(function (lst, v) {
      return lst.concat(tidyDirectives(v));
    }, []));
  }

  function CreateNodeFactory() {
    var aliasMap = {};

    function CreateNode() {}

    extend(CreateNode.prototype, {
      make: function make(tag, data, children) {
        return makeDirective(data, this.h(tag, toProps(data), children));
      },
      makeComponent: function makeComponent(type, data, children) {
        try {
          return makeDirective(data, vue.createVNode(type, toProps(data), children));
        } catch (e) {
          console.error(e);
          return vue.createVNode('');
        }
      },
      h: function h(tag, data, children) {
        var isNativeTag = vue.getCurrentInstance().appContext.config.isNativeTag(tag);

        if (isNativeTag) {
          delete data.formCreateInject;
        }

        try {
          return vue.createVNode(isNativeTag ? tag : vue.resolveComponent(tag), data, children);
        } catch (e) {
          console.error(e);
          return vue.createVNode('');
        }
      },
      aliasMap: aliasMap
    });
    extend(CreateNode, {
      aliasMap: aliasMap,
      alias: function alias(_alias, name) {
        aliasMap[_alias] = name;
      },
      use: function use(nodes) {
        Object.keys(nodes).forEach(function (k) {
          var line = toLine(k);
          var lower = toString(k).toLocaleLowerCase();
          var v = nodes[k];
          [k, line, lower].forEach(function (n) {
            CreateNode.alias(k, v);

            CreateNode.prototype[n] = function (data, children) {
              return this.make(v, data, children);
            };
          });
        });
      }
    });
    return CreateNode;
  }

  function createManager(proto) {
    var CustomManager = /*#__PURE__*/function (_Manager) {
      _inherits(CustomManager, _Manager);

      var _super = _createSuper(CustomManager);

      function CustomManager() {
        _classCallCheck(this, CustomManager);

        return _super.apply(this, arguments);
      }

      return CustomManager;
    }(Manager);

    Object.assign(CustomManager.prototype, proto);
    return CustomManager;
  }
  function Manager(handler) {
    extend(this, {
      $handle: handler,
      vm: handler.vm,
      options: {},
      ref: 'fcForm',
      mergeOptionsRule: {
        normal: ['form', 'row', 'info', 'submitBtn', 'resetBtn']
      }
    });
    this.updateKey();
    this.init();
  }
  extend(Manager.prototype, {
    __init: function __init() {
      var _this = this;

      this.$render = this.$handle.$render;

      this.$r = function () {
        var _this$$render;

        return (_this$$render = _this.$render).renderRule.apply(_this$$render, arguments);
      };
    },
    updateKey: function updateKey() {
      this.key = uniqueId();
    },
    //TODO interface
    init: function init() {},
    update: function update() {},
    beforeRender: function beforeRender() {},
    form: function form() {
      return this.vm.refs[this.ref];
    },
    getSlot: function getSlot(name) {
      var _fn = function _fn(vm) {
        if (vm) {
          var slot = vm.slots[name];

          if (slot) {
            return slot;
          }

          return _fn(vm.setupState.parent);
        }

        return undefined;
      };

      return _fn(this.vm);
    },
    mergeOptions: function mergeOptions(args, opt) {
      var _this2 = this;

      return mergeProps(args.map(function (v) {
        return _this2.tidyOptions(v);
      }), opt, this.mergeOptionsRule);
    },
    updateOptions: function updateOptions(options) {
      this.options = this.mergeOptions([options], this.getDefaultOptions());
      this.update();
    },
    tidyOptions: function tidyOptions(options) {
      return options;
    },
    tidyRule: function tidyRule(ctx) {},
    mergeProp: function mergeProp(ctx) {},
    getDefaultOptions: function getDefaultOptions() {
      return {};
    },
    render: function render(children) {}
  });

  var loadData = function loadData(fc) {
    var loadData = {
      name: 'loadData',
      _fn: [],
      mounted: function mounted(inject, rule, api) {
        this.deleted(inject);
        var attrs = toArray(inject.getValue());
        var unwatchs = [];
        attrs.forEach(function (attr) {
          if (attr && (attr.attr || attr.template)) {
            var unwatch = fc.watchLoadData(debounce(function (get) {
              var value;

              if (attr.template) {
                value = fc.$handle.loadStrVar(attr.template, get);
              } else {
                value = get(attr.attr, attr["default"]);
              }

              if (attr.copy !== false) {
                value = deepCopy(value);
              }

              deepSet(inject.getProp(), attr.to || 'options', value);
              api.sync(rule);
            }, attr.wait || 300));

            if (attr.watch !== false) {
              unwatchs.push(unwatch);
            } else {
              unwatch();
            }
          }
        });
        this._fn[inject.id] = unwatchs;
      },
      deleted: function deleted(inject) {
        if (this._fn[inject.id]) {
          this._fn[inject.id].forEach(function (un) {
            un();
          });
        }

        inject.clearProp();
      }
    };
    loadData.watch = loadData.created;
    return loadData;
  };

  var componentValidate = {
    name: 'componentValidate',
    load: function load(attr, rule, api) {
      var method = attr.getValue();

      if (!method) {
        attr.clearProp();
        api.clearValidateState([rule.field]);
      } else {
        attr.getProp().validate = [{
          validator: function validator() {
            var ctx = byCtx(rule);

            if (ctx) {
              for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
              }

              return api.exec.apply(api, [ctx.id, method === true ? 'formCreateValidate' : method].concat(args, [{
                attr: attr,
                rule: rule,
                api: api
              }]));
            }
          }
        }];
      }
    },
    watch: function watch() {
      componentValidate.load.apply(componentValidate, arguments);
    }
  };

  var fetch = function fetch(fc) {
    function parseOpt(option) {
      if (is.String(option)) {
        option = {
          action: option,
          to: 'options'
        };
      }

      return option;
    }

    function run(inject, rule, api) {
      var option = inject.value;
      fetchAttr.deleted(inject);

      if (is.Function(option)) {
        option = option(rule, api);
      }

      option = parseOpt(option);

      var set = function set(val) {
        if (val === undefined) {
          inject.clearProp();
        } else {
          deepSet(inject.getProp(), option.to || 'options', val);
        }

        api.sync(rule);
      };

      if (!option || !option.action && !option.key) {
        set(undefined);
        return;
      }

      option = deepCopy(option);

      if (!option.to) {
        option.to = 'options';
      }

      if (option.key) {
        var item = fc.$handle.options.globalData[option.key];

        if (!item) {
          set(undefined);
          return;
        }

        if (item.type === 'static') {
          set(item.data);
          return;
        } else {
          option = _objectSpread2(_objectSpread2({}, option), item);
        }
      }

      var _onError = option.onError;

      var check = function check() {
        if (!inject.getValue()) {
          inject.clearProp();
          api.sync(rule);
          return true;
        }
      };

      fetchAttr._fn[inject.id] = fc.watchLoadData(debounce(function (get) {
        var _option = fc.$handle.loadFetchVar(deepCopy(option), get);

        var config = _objectSpread2(_objectSpread2({
          headers: {}
        }, _option), {}, {
          onSuccess: function onSuccess(body, flag) {
            if (check()) return;

            var fn = function fn(v) {
              return flag ? v : hasProperty(v, 'data') ? v.data : v;
            };

            var parse = parseFn(_option.parse);

            if (is.Function(parse)) {
              fn = parse;
            } else if (parse && is.String(parse)) {
              fn = function fn(v) {
                return deepGet(v, parse);
              };
            }

            set(fn(body, rule, api));
            api.sync(rule);
          },
          onError: function onError(e) {
            set(undefined);
            if (check()) return;

            (_onError || function (e) {
              return err(e.message || 'fetch fail ' + _option.action);
            })(e, rule, api);
          }
        });

        fc.$handle.beforeFetch(config, {
          rule: rule,
          api: api
        }).then(function () {
          if (is.Function(_option.action)) {
            _option.action(rule, api).then(function (val) {
              config.onSuccess(val, true);
            })["catch"](function (e) {
              config.onError(e);
            });

            return;
          }

          invoke(function () {
            return fc.create.fetch(config, {
              inject: inject,
              rule: rule,
              api: api
            });
          });
        });
      }, option.wait || 1000));
    }

    var fetchAttr = {
      name: 'fetch',
      _fn: [],
      mounted: function mounted() {
        run.apply(void 0, arguments);
      },
      watch: function watch() {
        run.apply(void 0, arguments);
      },
      deleted: function deleted(inject) {
        if (this._fn[inject.id]) {
          this._fn[inject.id]();
        }

        inject.clearProp();
      }
    };
    return fetchAttr;
  };

  var $provider = {
    fetch: fetch,
    loadData: loadData,
    componentValidate: componentValidate
  };

  var name$6 = 'html';
  var html = {
    name: name$6,
    loadChildren: false,
    render: function render(children, ctx) {
      ctx.prop.props.innerHTML = children["default"]();
      return ctx.vNode.make(ctx.prop.props.tag || 'div', ctx.prop);
    },
    renderChildren: function renderChildren(children) {
      return {
        "default": function _default() {
          return children.filter(function (v) {
            return is.String(v);
          }).join('');
        }
      };
    }
  };

  function getCookie(name) {
    name = name + '=';
    var decodedCookie = decodeURIComponent(document.cookie);
    var cookieArray = decodedCookie.split(';');

    for (var i = 0; i < cookieArray.length; i++) {
      var cookie = cookieArray[i];

      while (cookie.charAt(0) === ' ') {
        cookie = cookie.substring(1);
      }

      if (cookie.indexOf(name) === 0) {
        cookie = cookie.substring(name.length, cookie.length);

        try {
          return JSON.parse(cookie);
        } catch (e) {
          return cookie;
        }
      }
    }

    return null;
  }

  function getLocalStorage(name) {
    var value = localStorage.getItem(name);

    if (value) {
      try {
        return JSON.parse(value);
      } catch (e) {
        return value;
      }
    }

    return null;
  }

  function baseDriver(driver, name) {
    if (!name) {
      return null;
    }

    var split = name.split('.');
    var value = driver(split.shift());

    if (!split.length) {
      return value;
    }

    if (value == null) {
      return null;
    }

    return deepGet(value, split);
  }
  function cookieDriver(name) {
    return baseDriver(getCookie, name);
  }
  function localStorageDriver(name) {
    return baseDriver(getLocalStorage, name);
  }

  function parseProp(name, id) {
    var prop;

    if (arguments.length === 2) {
      prop = arguments[1];
      id = prop[name];
    } else {
      prop = arguments[2];
    }

    return {
      id: id,
      prop: prop
    };
  }

  function nameProp() {
    return parseProp.apply(void 0, ['name'].concat(Array.prototype.slice.call(arguments)));
  }

  function exportAttrs(attrs) {
    var key = attrs.key || [];
    var array = attrs.array || [];
    var normal = attrs.normal || [];
    keyAttrs.push.apply(keyAttrs, _toConsumableArray(key));
    arrayAttrs.push.apply(arrayAttrs, _toConsumableArray(array));
    normalAttrs.push.apply(normalAttrs, _toConsumableArray(normal));
    appendProto([].concat(_toConsumableArray(key), _toConsumableArray(array), _toConsumableArray(normal)));
  }

  var id = 1;
  var instance = {}; //todo 表单嵌套

  function FormCreateFactory(config) {
    var components = _defineProperty({}, fragment.name, fragment);

    var parsers = {};
    var directives = {};
    var modelFields = {};
    var useApps = [];
    var listener = [];
    var extendApiFn = [config.extendApi];

    var providers = _objectSpread2({}, $provider);

    var maker = makerFactory();
    var globalConfig = {
      global: {}
    };
    var loadData = vue.reactive({});
    var CreateNode = CreateNodeFactory();
    var formulas = {};
    var isMobile = config.isMobile === true;
    exportAttrs(config.attrs || {});

    function getApi(name) {
      var val = instance[name];

      if (Array.isArray(val)) {
        return val.map(function (v) {
          return v.api();
        });
      } else if (val) {
        return val.api();
      }
    }

    function useApp(fn) {
      useApps.push(fn);
    }

    function directive() {
      var data = nameProp.apply(void 0, arguments);
      if (data.id && data.prop) directives[data.id] = data.prop;
    }

    function register() {
      var data = nameProp.apply(void 0, arguments);
      if (data.id && data.prop) providers[data.id] = _objectSpread2(_objectSpread2({}, data.prop), {}, {
        name: data.id
      });
    }

    function componentAlias(alias) {
      CreateNode.use(alias);
    }

    function parser() {
      var data = nameProp.apply(void 0, arguments);
      if (!data.id || !data.prop) return BaseParser;
      var name = toCase(data.id);
      var parser = data.prop;
      var base = parser.merge === true ? parsers[name] : undefined;
      parsers[name] = setPrototypeOf(parser, base || BaseParser);
      maker[name] = creatorFactory(name);
      parser.maker && extend(maker, parser.maker);
    }

    function component(id, component) {
      var name;

      if (is.String(id)) {
        name = id;

        if (component === undefined) {
          return components[name];
        }
      } else {
        name = id.displayName || id.name;
        component = id;
      }

      if (!name || !component) return;
      var nameAlias = toCase(name);
      components[name] = component;
      components[nameAlias] = component;
      delete CreateNode.aliasMap[name];
      delete CreateNode.aliasMap[nameAlias];
      delete parsers[name];
      delete parsers[nameAlias];
      if (component.formCreateParser) parser(name, component.formCreateParser);
    }

    function $form() {
      return $FormCreate(FormCreate, components, directives);
    }

    function createFormApp(rule, option) {
      var Type = $form();
      return vue.createApp({
        data: function data() {
          return vue.reactive({
            rule: rule,
            option: option
          });
        },
        render: function render() {
          return vue.h(Type, _objectSpread2({
            ref: 'fc'
          }, this.$data));
        }
      });
    }

    function $vnode() {
      return fragment;
    } //todo 检查回调函数作用域


    function use(fn, opt) {
      if (is.Function(fn.install)) fn.install(create, opt);else if (is.Function(fn)) fn(create, opt);
      return this;
    }

    function create(rules, option) {
      var app = createFormApp(rules, option || {});
      useApps.forEach(function (v) {
        invoke(function () {
          return v(create, app);
        });
      });
      var div = document.createElement('div');
      ((option === null || option === void 0 ? void 0 : option.el) || document.body).appendChild(div);
      var vm = app.mount(div);
      return vm.$refs.fc.fapi;
    }

    function factory(inherit) {
      var _config = _objectSpread2({}, config);

      if (inherit) {
        _config.inherit = {
          components: components,
          parsers: parsers,
          directives: directives,
          modelFields: modelFields,
          providers: providers,
          useApps: useApps,
          maker: maker,
          formulas: formulas,
          loadData: loadData
        };
      } else {
        delete _config.inherit;
      }

      return FormCreateFactory(_config);
    }

    function setModelField(name, field) {
      modelFields[name] = field;
    }

    function setFormula(name, fn) {
      formulas[name] = fn;
    }

    function emitData(id) {
      Object.keys(instance).forEach(function (v) {
        var apis = Array.isArray(instance[v]) ? instance[v] : [instance[v]];
        apis.forEach(function (that) {
          that.bus.$emit('$loadData.' + id);
        });
      });
    }

    function setData(id, data) {
      loadData[id] = data;
      emitData(id);
    }

    function setDataDriver(id, data) {
      var callback = function callback() {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        return invoke(function () {
          return data.apply(void 0, args);
        });
      };

      callback._driver = true;
      setData(id, callback);
    }

    function getData(id, def) {
      var split = (id || '').split('.');
      id = split.shift();
      var field = split.join('.');

      if (hasProperty(loadData, id)) {
        var val = loadData[id];

        if (val && val._driver) {
          val = val(field);
        } else if (split.length) {
          val = deepGet(val, split);
        }

        return val == null || val === '' ? def : val;
      } else {
        return def;
      }
    }

    function extendApi(fn) {
      extendApiFn.push(fn);
    }

    function removeData(id) {
      delete loadData[id];
      emitData(id);
    }

    function on(name, callback) {
      listener.push({
        name: name,
        callback: callback
      });
    }

    function FormCreate(vm) {
      var _this = this;

      extend(this, {
        id: id++,
        create: create,
        vm: vm,
        manager: createManager(config.manager),
        parsers: parsers,
        providers: providers,
        modelFields: modelFields,
        formulas: formulas,
        isMobile: isMobile,
        rules: vm.props.rule,
        name: vm.props.name || uniqueId(),
        inFor: vm.props.inFor,
        prop: {
          components: components,
          directives: directives
        },
        setData: setData,
        getData: getData,
        emitData: emitData,
        loadData: loadData,
        CreateNode: CreateNode,
        bus: new Mitt(),
        unwatch: null,
        options: vue.ref({}),
        extendApiFn: extendApiFn,
        fetchCache: new WeakMap()
      });
      listener.forEach(function (item) {
        _this.bus.$on(item.name, item.callback);
      });
      vue.nextTick(function () {
        vue.watch(_this.options, function () {
          _this.$handle.$manager.updateOptions(_this.options.value);

          _this.api().refresh();
        }, {
          deep: true
        });
      });
      extend(vm.appContext.components, components);
      extend(vm.appContext.directives, directives);
      this.$handle = new Handler(this);

      if (this.name) {
        if (this.inFor) {
          if (!instance[this.name]) instance[this.name] = [];
          instance[this.name].push(this);
        } else {
          instance[this.name] = this;
        }
      }
    }

    FormCreate.isMobile = isMobile;
    extend(FormCreate.prototype, {
      init: function init() {
        var _this2 = this;

        if (this.isSub()) {
          this.unwatch = vue.watch(function () {
            return _this2.vm.setupState.parent.setupState.fc.options.value;
          }, function () {
            _this2.initOptions();

            _this2.$handle.api.refresh();
          }, {
            deep: true
          });
        }

        this.initOptions();
        this.$handle.init();
      },
      globalDataDriver: function globalDataDriver(id) {
        var _this3 = this;

        var split = id.split('.');
        var key = split.shift();
        var option = this.options.value.globalData && this.options.value.globalData[key];

        if (option) {
          if (option.type === 'static') {
            return deepGet(option.data, split);
          } else {
            var val;
            var res = this.fetchCache.get(option);

            if (res) {
              if (res.status) {
                val = deepGet(res.data, split);
              }

              if (!res.loading) {
                return val;
              }

              res.loading = false;
              this.fetchCache.set(option, res);
            } else {
              this.fetchCache.set(option, {
                status: false
              });
            }

            var reload = debounce(function () {
              unwatch();

              var res = _this3.fetchCache.get(option);

              if (_this3.options.value.globalData && Object.values(_this3.options.value.globalData).indexOf(option) !== -1) {
                if (res) {
                  res.loading = true;

                  _this3.fetchCache.set(option, res);
                }

                _this3.bus.$emit('$loadData.$globalData');
              } else {
                _this3.fetchCache["delete"](option);
              }
            }, option.wait || 1000);

            var callback = function callback(get, change) {
              if (change) {
                reload();
                return;
              }

              var options = _this3.$handle.loadFetchVar(copy$1(option), get);

              _this3.$handle.api.fetch(options).then(function (res) {
                _this3.fetchCache.set(option, {
                  status: true,
                  data: res
                });

                _this3.bus.$emit('$loadData.$globalData');
              });
            };

            var unwatch = this.watchLoadData(callback);
            return val;
          }
        }
      },
      getLoadData: function getLoadData(id, def) {
        var val = null;

        if (id != null) {
          var split = id.split('.');
          var key = split.shift();

          if (key === '$form') {
            val = this.$handle.api.top.formData();
          } else if (key === '$subForm') {
            val = this.$handle.api.formData();
          } else if (key === '$options') {
            val = this.options.value;
          } else if (key === '$globalData') {
            val = this.globalDataDriver(split.join('.'));
            split = [];
          } else {
            val = getData(id, def);
            split = [];
          }

          if (split.length) {
            val = deepGet(val, split);
          }
        }

        console.log(id, val);
        return val == null || val === '' ? def : val;
      },
      watchLoadData: function watchLoadData(fn) {
        var _this4 = this;

        var unwatch = {};

        var run = function run(flag) {
          invoke(function () {
            fn(get, flag);
          });
        };

        var get = function get(id, def) {
          if (unwatch[id]) {
            return unwatch[id].val;
          }

          var val = _this4.getLoadData(id, def);

          var key = id.split('.').shift();

          var callback = function callback() {
            if (key !== id) {
              var temp = _this4.getLoadData(id, def);

              if (JSON.stringify(temp) !== JSON.stringify(unwatch[id].val)) {
                unwatch[id].val = temp;
                run(true);
              }
            } else {
              run(true);
            }
          };

          _this4.bus.$on('$loadData.' + key, callback);

          unwatch[id] = {
            fn: function fn() {
              _this4.bus.$off('$loadData.' + key, callback);
            },
            val: val
          };
          return val;
        };

        run(false);
        return function () {
          Object.keys(unwatch).forEach(function (k) {
            return unwatch[k].fn();
          });
          unwatch = {};
        };
      },
      isSub: function isSub() {
        return this.vm.setupState.parent && this.vm.props.extendOption;
      },
      initOptions: function initOptions() {
        this.options.value = {};

        var options = _objectSpread2({
          formData: {},
          submitBtn: {},
          resetBtn: {},
          globalEvent: {},
          globalData: {}
        }, deepCopy(globalConfig));

        if (this.isSub()) {
          options = this.mergeOptions(options, this.vm.setupState.parent.setupState.fc.options.value || {}, true);
        }

        options = this.mergeOptions(options, this.vm.props.option);
        this.updateOptions(options);
      },
      mergeOptions: function mergeOptions(target, opt, parent) {
        opt = deepCopy(opt);
        parent && ['page', 'onSubmit', 'mounted', 'reload', 'formData', 'el', 'globalClass', 'style'].forEach(function (n) {
          delete opt[n];
        });

        if (opt.global) {
          target.global = mergeGlobal(target.global, opt.global);
          delete opt.global;
        }

        this.$handle.$manager.mergeOptions([opt], target);
        return target;
      },
      updateOptions: function updateOptions(options) {
        this.options.value = this.mergeOptions(this.options.value, options);
        this.$handle.$manager.updateOptions(this.options.value);
        this.bus.$emit('$loadData.$options');
      },
      api: function api() {
        return this.$handle.api;
      },
      render: function render() {
        return this.$handle.render();
      },
      mounted: function mounted() {
        this.$handle.mounted();
      },
      unmount: function unmount() {
        var _this5 = this;

        if (this.name) {
          if (this.inFor) {
            var idx = instance[this.name].indexOf(this);
            instance[this.name].splice(idx, 1);
          } else {
            delete instance[this.name];
          }
        }

        listener.forEach(function (item) {
          _this5.bus.$off(item.name, item.callback);
        });
        this.unwatch && this.unwatch();
        this.$handle.reloadRule([]);
      },
      updated: function updated() {
        var _this6 = this;

        this.$handle.bindNextTick(function () {
          return _this6.bus.$emit('next-tick', _this6.$handle.api);
        });
      }
    });

    function useAttr(formCreate) {
      extend(formCreate, {
        version: config.version,
        ui: config.ui,
        extendApi: extendApi,
        getData: getData,
        setDataDriver: setDataDriver,
        setData: setData,
        removeData: removeData,
        maker: maker,
        component: component,
        directive: directive,
        setModelField: setModelField,
        setFormula: setFormula,
        register: register,
        $vnode: $vnode,
        parser: parser,
        use: use,
        factory: factory,
        componentAlias: componentAlias,
        copyRule: copyRule,
        copyRules: copyRules,
        fetch: fetch$1,
        $form: $form,
        parseFn: parseFn,
        parseJson: parseJson,
        toJson: toJson,
        useApp: useApp,
        getApi: getApi,
        on: on
      });
    }

    function useStatic(formCreate) {
      extend(formCreate, {
        create: create,
        isMobile: isMobile,
        install: function install(app, options) {
          globalConfig = _objectSpread2(_objectSpread2({}, globalConfig), options || {});
          var key = '_installedFormCreate_' + config.ui;
          if (app[key] === true) return;
          app[key] = true;

          var $formCreate = function $formCreate(rules) {
            var opt = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
            return create(rules, opt);
          };

          useAttr($formCreate);
          app.config.globalProperties.$formCreate = $formCreate;
          var $component = $form();
          app.component($component.name, $component);
          useApps.forEach(function (v) {
            invoke(function () {
              return v(formCreate, app);
            });
          });
        }
      });
    }

    useAttr(create);
    useStatic(create);
    setDataDriver('$cookie', cookieDriver);
    setDataDriver('$localStorage', localStorageDriver);
    CreateNode.use({
      fragment: 'fcFragment'
    });
    config.install && create.use(config);
    useApp(function (_, app) {
      app.mixin({
        props: ['formCreateInject']
      });
    });
    parser(html);

    if (config.inherit) {
      var inherit = config.inherit;
      inherit.components && extend(components, inherit.components);
      inherit.parsers && extend(parsers, inherit.parsers);
      inherit.directives && extend(directives, inherit.directives);
      inherit.modelFields && extend(modelFields, inherit.modelFields);
      inherit.providers && extend(providers, inherit.providers);
      inherit.useApps && extend(useApps, inherit.useApps);
      inherit.maker && extend(maker, inherit.maker);
      inherit.loadData && extend(loadData, inherit.loadData);
      inherit.formulas && extend(formulas, inherit.formulas);
    }

    var FcComponent = $form();
    setPrototypeOf(FcComponent, create);
    FcComponent.util = create;
    return FcComponent;
  }

  var DEFAULT_FORMATS = {
    date: 'YYYY-MM-DD',
    month: 'YYYY-MM',
    datetime: 'YYYY-MM-DD HH:mm:ss',
    timerange: 'HH:mm:ss',
    daterange: 'YYYY-MM-DD',
    monthrange: 'YYYY-MM',
    datetimerange: 'YYYY-MM-DD HH:mm:ss',
    year: 'YYYY'
  };
  var name$5 = 'datePicker';
  var datePicker = {
    name: name$5,
    maker: function () {
      return ['year', 'month', 'date', 'dates', 'week', 'datetime', 'datetimeRange', 'dateRange', 'monthRange'].reduce(function (initial, type) {
        initial[type] = creatorFactory(name$5, {
          type: type.toLowerCase()
        });
        return initial;
      }, {});
    }(),
    mergeProp: function mergeProp(ctx) {
      var props = ctx.prop.props;

      if (!props.valueFormat) {
        props.valueFormat = DEFAULT_FORMATS[props.type] || DEFAULT_FORMATS['date'];
      }
    }
  };

  var name$4 = 'hidden';
  var hidden = {
    name: name$4,
    maker: _defineProperty({}, name$4, function (field, value) {
      return creatorFactory(name$4)('', field, value);
    }),
    render: function render() {
      return [];
    }
  };

  var name$3 = 'input';
  var input = {
    name: name$3,
    maker: function () {
      var maker = ['password', 'url', 'email', 'text', 'textarea'].reduce(function (maker, type) {
        maker[type] = creatorFactory(name$3, {
          type: type
        });
        return maker;
      }, {});
      maker.idate = creatorFactory(name$3, {
        type: 'date'
      });
      return maker;
    }(),
    mergeProp: function mergeProp(ctx) {
      var props = ctx.prop.props;

      if (props && props.autosize && props.autosize.minRows) {
        props.rows = props.autosize.minRows || 2;
      }
    }
  };

  var name$2 = 'slider';
  var slider = {
    name: name$2,
    maker: {
      sliderRange: creatorFactory(name$2, {
        range: true
      })
    },
    toFormValue: function toFormValue(value, ctx) {
      var isArr = Array.isArray(value),
          props = ctx.prop.props,
          min = props.min || 0,
          parseValue;

      if (props.range === true) {
        parseValue = isArr ? value : [min, parseFloat(value) || min];
      } else {
        parseValue = isArr ? parseFloat(value[0]) || min : parseFloat(value);
      }

      return parseValue;
    }
  };

  var name$1 = 'timePicker';
  var timePicker = {
    name: name$1,
    maker: {
      time: creatorFactory(name$1, function (m) {
        return m.props.isRange = false;
      }),
      timeRange: creatorFactory(name$1, function (m) {
        return m.props.isRange = true;
      })
    },
    mergeProp: function mergeProp(ctx) {
      var props = ctx.prop.props;

      if (!props.valueFormat) {
        props.valueFormat = 'HH:mm:ss';
      }
    }
  };

  var row = {
    name: 'FcRow',
    render: function render(_, ctx) {
      return ctx.vNode.col({
        props: {
          span: 24
        }
      }, {
        "default": function _default() {
          return [ctx.vNode.row(ctx.prop, _)];
        }
      });
    }
  };

  var name = 'select';
  var select = {
    name: name,
    toFormValue: function toFormValue(value, ctx) {
      if (ctx.prop.props.multiple && !Array.isArray(value)) {
        return toArray(value);
      } else {
        return value;
      }
    }
  };

  var parsers = [datePicker, hidden, input, slider, timePicker, row, select];

  var PRE = 'el';
  var alias = {
    button: PRE + '-button',
    icon: PRE + '-icon',
    slider: PRE + '-slider',
    rate: PRE + '-rate',
    upload: 'fc-upload',
    cascader: PRE + '-cascader',
    popover: PRE + '-popover',
    tooltip: PRE + '-tooltip',
    colorPicker: PRE + '-colorPicker',
    timePicker: PRE + '-time-picker',
    timeSelect: PRE + '-time-select',
    datePicker: PRE + '-date-picker',
    'switch': PRE + '-switch',
    select: 'fc-select',
    checkbox: 'fc-checkbox',
    radio: 'fc-radio',
    inputNumber: PRE + '-input-number',
    number: PRE + '-input-number',
    input: PRE + '-input',
    formItem: PRE + '-form-item',
    form: PRE + '-form',
    frame: 'fc-frame',
    col: PRE + '-col',
    row: PRE + '-row',
    tree: 'fc-tree',
    autoComplete: PRE + '-autocomplete',
    auto: PRE + '-autocomplete',
    group: 'fc-group',
    object: 'fc-sub-form',
    subForm: 'fc-sub-form'
  };

  function getConfig() {
    return {
      form: {
        inline: false,
        labelPosition: 'right',
        labelWidth: '125px',
        disabled: false,
        size: undefined
      },
      row: {
        show: true,
        gutter: 0
      },
      submitBtn: {
        type: 'primary',
        loading: false,
        disabled: false,
        innerText: '提交',
        show: true,
        col: undefined,
        click: undefined
      },
      resetBtn: {
        type: 'default',
        loading: false,
        disabled: false,
        innerText: '重置',
        show: false,
        col: undefined,
        click: undefined
      }
    };
  }

  function isTooltip(info) {
    return info.type === 'tooltip';
  }

  function tidy(props, name) {
    if (!hasProperty(props, name)) return;

    if (is.String(props[name])) {
      var _props$name;

      props[name] = (_props$name = {}, _defineProperty(_props$name, name, props[name]), _defineProperty(_props$name, "show", true), _props$name);
    }
  }

  function isFalse(val) {
    return val === false;
  }

  function tidyBool(opt, name) {
    if (hasProperty(opt, name) && !is.Object(opt[name])) {
      opt[name] = {
        show: !!opt[name]
      };
    }
  }

  function tidyRule(rule) {
    var _rule = _objectSpread2({}, rule);

    delete _rule.children;
    return _rule;
  }

  var manager = {
    validate: function validate() {
      var form = this.form();

      if (form) {
        return form.validate();
      } else {
        return new Promise(function (v) {
          return v();
        });
      }
    },
    validateField: function validateField(field) {
      var _this = this;

      return new Promise(function (resolve, reject) {
        var form = _this.form();

        if (form) {
          form.validateField(field, function (res, err) {
            err ? reject(err) : resolve(res);
          });
        } else {
          resolve();
        }
      });
    },
    clearValidateState: function clearValidateState(ctx) {
      var fItem = this.vm.refs[ctx.wrapRef];

      if (fItem) {
        fItem.clearValidate();
      }
    },
    tidyOptions: function tidyOptions(options) {
      ['submitBtn', 'resetBtn', 'row', 'info', 'wrap', 'col', 'title'].forEach(function (name) {
        tidyBool(options, name);
      });
      return options;
    },
    tidyRule: function tidyRule(_ref) {
      var prop = _ref.prop;
      tidy(prop, 'title');
      tidy(prop, 'info');
      return prop;
    },
    mergeProp: function mergeProp(ctx) {
      ctx.prop = mergeProps([{
        info: this.options.info || {},
        wrap: this.options.wrap || {},
        col: this.options.col || {},
        title: this.options.title || {}
      }, ctx.prop], {
        info: {
          trigger: 'hover',
          placement: 'top-start',
          icon: true
        },
        title: {},
        col: {
          span: 24
        },
        wrap: {}
      }, {
        normal: ['title', 'info', 'col', 'wrap']
      });
    },
    getDefaultOptions: function getDefaultOptions() {
      return getConfig();
    },
    update: function update() {
      var form = this.options.form;
      this.rule = {
        props: _objectSpread2({}, form),
        on: {
          submit: function submit(e) {
            e.preventDefault();
          }
        },
        "class": [form.className, form["class"], 'form-create', this.options.preview ? 'is-preview' : ''],
        style: form.style,
        type: 'form'
      };
    },
    beforeRender: function beforeRender() {
      var key = this.key,
          ref = this.ref,
          $handle = this.$handle;
      extend(this.rule, {
        key: key,
        ref: ref
      });
      extend(this.rule.props, {
        model: $handle.formData
      });
    },
    render: function render(children) {
      var _this2 = this;

      if (children.slotLen() && !this.options.preview) {
        children.setSlot(undefined, function () {
          return _this2.makeFormBtn();
        });
      }

      return this.$r(this.rule, isFalse(this.options.row.show) ? children.getSlots() : [this.makeRow(children)]);
    },
    makeWrap: function makeWrap(ctx, children) {
      var _this3 = this;

      var rule = ctx.prop;
      var uni = "".concat(this.key).concat(ctx.key);
      var col = rule.col;
      var isTitle = this.isTitle(rule);
      var labelWidth = !col.labelWidth && !isTitle ? 0 : col.labelWidth;
      var _this$rule$props = this.rule.props,
          inline = _this$rule$props.inline,
          _col = _this$rule$props.col;
      var item = isFalse(rule.wrap.show) ? children : this.$r(mergeProps([rule.wrap, {
        props: _objectSpread2(_objectSpread2({
          labelWidth: labelWidth === void 0 ? labelWidth : toString(labelWidth),
          label: isTitle ? rule.title.title : undefined
        }, tidyRule(rule.wrap || {})), {}, {
          prop: ctx.id,
          rules: ctx.injectValidate()
        }),
        "class": rule.className,
        key: "".concat(uni, "fi"),
        ref: ctx.wrapRef,
        type: 'formItem'
      }]), _objectSpread2({
        "default": function _default() {
          return children;
        }
      }, isTitle ? {
        label: function label() {
          return _this3.makeInfo(rule, uni, ctx);
        }
      } : {}));
      return inline === true || isFalse(_col) || isFalse(col.show) ? item : this.makeCol(rule, uni, [item]);
    },
    isTitle: function isTitle(rule) {
      if (this.options.form.title === false) return false;
      var title = rule.title;
      return !(!title.title && !title["native"] || isFalse(title.show));
    },
    makeInfo: function makeInfo(rule, uni, ctx) {
      var _this4 = this;

      var titleProp = _objectSpread2({}, rule.title);

      var infoProp = _objectSpread2({}, rule.info);

      var isTip = isTooltip(infoProp);
      var form = this.options.form;
      var titleSlot = this.getSlot('title');
      var children = [titleSlot ? titleSlot({
        title: titleProp.title || '',
        rule: ctx.rule,
        options: this.options
      }) : (titleProp.title || '') + (form.labelSuffix || form['label-suffix'] || '')];

      if (!isFalse(infoProp.show) && (infoProp.info || infoProp["native"]) && !isFalse(infoProp.icon)) {
        var prop = {
          type: infoProp.type || 'popover',
          props: tidyRule(infoProp),
          key: "".concat(uni, "pop")
        };
        delete prop.props.icon;
        delete prop.props.show;
        delete prop.props.info;
        delete prop.props.align;
        delete prop.props["native"];
        var field = 'content';

        if (infoProp.info && !hasProperty(prop.props, field)) {
          prop.props[field] = infoProp.info;
        }

        children[infoProp.align !== 'left' ? 'unshift' : 'push'](this.$r(mergeProps([infoProp, prop]), _defineProperty({}, titleProp.slot || (isTip ? 'default' : 'reference'), function () {
          return _this4.$r({
            type: 'ElIcon',
            style: 'top:2px',
            key: "".concat(uni, "i")
          }, {
            "default": function _default() {
              return _this4.$r({
                type: infoProp.icon === true ? 'icon-warning' : infoProp.icon
              });
            }
          }, true);
        })));
      }

      var _prop = mergeProps([titleProp, {
        props: tidyRule(titleProp),
        key: "".concat(uni, "tit"),
        type: titleProp.type || 'span'
      }]);

      delete _prop.props.show;
      delete _prop.props.title;
      delete _prop.props["native"];
      return this.$r(_prop, children);
    },
    makeCol: function makeCol(rule, uni, children) {
      var col = rule.col;
      return this.$r({
        "class": col["class"],
        type: 'col',
        props: col || {
          span: 24
        },
        key: "".concat(uni, "col")
      }, children);
    },
    makeRow: function makeRow(children) {
      var row = this.options.row || {};
      return this.$r({
        type: 'row',
        props: row,
        "class": row["class"],
        key: "".concat(this.key, "row")
      }, children);
    },
    makeFormBtn: function makeFormBtn() {
      var vn = [];

      if (!isFalse(this.options.submitBtn.show)) {
        vn.push(this.makeSubmitBtn());
      }

      if (!isFalse(this.options.resetBtn.show)) {
        vn.push(this.makeResetBtn());
      }

      if (!vn.length) {
        return;
      }

      var item = this.$r({
        type: 'formItem',
        key: "".concat(this.key, "fb")
      }, vn);
      return this.rule.props.inline === true ? item : this.$r({
        type: 'col',
        props: {
          span: 24
        },
        key: "".concat(this.key, "fc")
      }, [item]);
    },
    makeResetBtn: function makeResetBtn() {
      var _this5 = this;

      var resetBtn = _objectSpread2({}, this.options.resetBtn);

      var innerText = resetBtn.innerText;
      delete resetBtn.innerText;
      delete resetBtn.click;
      delete resetBtn.col;
      delete resetBtn.show;
      return this.$r({
        type: 'button',
        props: resetBtn,
        "class": '_fc-reset-btn',
        style: {
          width: resetBtn.width
        },
        on: {
          click: function click() {
            var fApi = _this5.$handle.api;
            _this5.options.resetBtn.click ? _this5.options.resetBtn.click(fApi) : fApi.resetFields();
          }
        },
        key: "".concat(this.key, "b2")
      }, [innerText]);
    },
    makeSubmitBtn: function makeSubmitBtn() {
      var _this6 = this;

      var submitBtn = _objectSpread2({}, this.options.submitBtn);

      var innerText = submitBtn.innerText;
      delete submitBtn.innerText;
      delete submitBtn.click;
      delete submitBtn.col;
      delete submitBtn.show;
      return this.$r({
        type: 'button',
        props: submitBtn,
        "class": '_fc-submit-btn',
        style: {
          width: submitBtn.width
        },
        on: {
          click: function click() {
            var fApi = _this6.$handle.api;
            _this6.options.submitBtn.click ? _this6.options.submitBtn.click(fApi) : fApi.submit()["catch"](function () {});
          }
        },
        key: "".concat(this.key, "b1")
      }, [innerText]);
    }
  };

  var maker$1 = {};
  useAlias(maker$1);
  useSelect(maker$1);
  useTree(maker$1);
  useUpload(maker$1);
  useFrame(maker$1);

  function useAlias(maker) {
    ['group', 'tree', 'switch', 'upload', 'autoComplete', 'checkbox', 'cascader', 'colorPicker', 'datePicker', 'frame', 'inputNumber', 'radio', 'rate'].forEach(function (name) {
      maker[name] = creatorFactory(name);
    });
    maker.auto = maker.autoComplete;
    maker.number = maker.inputNumber;
    maker.color = maker.colorPicker;
  }

  function useSelect(maker) {
    var select = 'select';
    var multiple = 'multiple';
    maker['selectMultiple'] = creatorFactory(select, _defineProperty({}, multiple, true));
    maker['selectOne'] = creatorFactory(select, _defineProperty({}, multiple, false));
  }

  function useTree(maker) {
    var name = 'tree';
    var types = {
      'treeSelected': 'selected',
      'treeChecked': 'checked'
    };
    Object.keys(types).reduce(function (m, key) {
      m[key] = creatorFactory(name, {
        type: types[key]
      });
      return m;
    }, maker);
  }

  function useUpload(maker) {
    var name = 'upload';
    var types = {
      image: ['image', 0],
      file: ['file', 0],
      uploadFileOne: ['file', 1],
      uploadImageOne: ['image', 1]
    };
    Object.keys(types).reduce(function (m, key) {
      m[key] = creatorFactory(name, function (m) {
        return m.props({
          uploadType: types[key][0],
          maxLength: types[key][1]
        });
      });
      return m;
    }, maker);
    maker.uploadImage = maker.image;
    maker.uploadFile = maker.file;
  }

  function useFrame(maker) {
    var types = {
      frameInputs: ['input', 0],
      frameFiles: ['file', 0],
      frameImages: ['image', 0],
      frameInputOne: ['input', 1],
      frameFileOne: ['file', 1],
      frameImageOne: ['image', 1]
    };
    Object.keys(types).reduce(function (maker, key) {
      maker[key] = creatorFactory('frame', function (m) {
        return m.props({
          type: types[key][0],
          maxLength: types[key][1]
        });
      });
      return maker;
    }, maker);
    maker.frameInput = maker.frameInputs;
    maker.frameFile = maker.frameFiles;
    maker.frameImage = maker.frameImages;
    return maker;
  }

  var css_248z = ".form-create .form-create .el-form-item{margin-bottom:22px}.form-create{width:100%}.form-create .fc-none,.form-create.is-preview .el-form-item.is-required>.el-form-item__label-wrap>.el-form-item__label:before,.form-create.is-preview .el-form-item.is-required>.el-form-item__label:before,.form-create.is-preview .fc-clock{display:none!important}.fc-wrap-left .el-form-item__label{justify-content:flex-start;justify-content:flex-end}.fc-wrap-top.el-form-item{display:block}.fc-wrap-top.el-form-item .el-form-item__label{display:block;height:auto;line-height:22px;margin-bottom:8px;text-align:left}.el-form--large .fc-wrap-top.el-form-item .el-form-item__label{line-height:22px;margin-bottom:12px}.el-form--default .fc-wrap-top.el-form-item .el-form-item__label{line-height:22px;margin-bottom:8px}.el-form--small .fc-wrap-top.el-form-item .el-form-item__label{line-height:20px;margin-bottom:4px}";
  styleInject(css_248z);

  function tidyBtnProp(btn, def) {
    if (is.Boolean(btn)) btn = {
      show: btn
    };else if (!is.Undef(btn) && !is.Object(btn)) btn = {
      show: def
    };
    return btn;
  }

  function extendApi(api, h) {
    return {
      formEl: function formEl() {
        return h.$manager.form();
      },
      wrapEl: function wrapEl(id) {
        var ctx = h.getFieldCtx(id);
        if (!ctx) return;
        return h.vm.refs[ctx.wrapRef];
      },
      validate: function validate(callback) {
        return new Promise(function (resolve, reject) {
          var forms = api.children;
          var all = [h.$manager.validate()];
          forms.forEach(function (v) {
            all.push(v.validate());
          });
          Promise.all(all).then(function () {
            resolve(true);
            callback && callback(true);
          })["catch"](function (e) {
            reject(e);
            callback && callback(e);
            h.vm.emit('validate-fail', e, {
              api: api
            });
          });
        });
      },
      validateField: function validateField(field, callback) {
        return new Promise(function (resolve, reject) {
          var ctx = h.getFieldCtx(field);
          if (!ctx) return;
          var sub = h.subForm[ctx.id];
          var all = [h.$manager.validateField(ctx.id)];
          toArray(sub).forEach(function (v) {
            all.push(v.validate());
          });
          Promise.all(all).then(function () {
            resolve(null);
            callback && callback(null);
          })["catch"](function (e) {
            reject(e);
            callback && callback(e);
            h.vm.emit('validate-field-fail', e, {
              field: field,
              api: api
            });
          });
        });
      },
      clearValidateState: function clearValidateState(fields) {
        var _this = this;

        var clearSub = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
        api.helper.tidyFields(fields).forEach(function (field) {
          if (clearSub) _this.clearSubValidateState(field);
          h.getCtxs(field).forEach(function (ctx) {
            h.$manager.clearValidateState(ctx);
          });
        });
      },
      clearSubValidateState: function clearSubValidateState(fields) {
        api.helper.tidyFields(fields).forEach(function (field) {
          h.getCtxs(field).forEach(function (ctx) {
            var subForm = h.subForm[ctx.id];
            if (!subForm) return;

            if (Array.isArray(subForm)) {
              subForm.forEach(function (form) {
                form.clearValidateState();
              });
            } else if (subForm) {
              subForm.clearValidateState();
            }
          });
        });
      },
      btn: {
        loading: function loading() {
          var _loading = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

          api.submitBtnProps({
            loading: !!_loading
          });
        },
        disabled: function disabled() {
          var _disabled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

          api.submitBtnProps({
            disabled: !!_disabled
          });
        },
        show: function show() {
          var isShow = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
          api.submitBtnProps({
            show: !!isShow
          });
        }
      },
      resetBtn: {
        loading: function loading() {
          var _loading2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

          api.resetBtnProps({
            loading: !!_loading2
          });
        },
        disabled: function disabled() {
          var _disabled2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

          api.resetBtnProps({
            disabled: !!_disabled2
          });
        },
        show: function show() {
          var isShow = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
          api.resetBtnProps({
            show: !!isShow
          });
        }
      },
      submitBtnProps: function submitBtnProps() {
        var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var btn = tidyBtnProp(h.options.submitBtn, true);
        extend(btn, props);
        h.options.submitBtn = btn;
        api.refreshOptions();
      },
      resetBtnProps: function resetBtnProps() {
        var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var btn = tidyBtnProp(h.options.resetBtn, false);
        extend(btn, props);
        h.options.resetBtn = btn;
        api.refreshOptions();
      },
      submit: function submit(successFn, failFn) {
        return new Promise(function (resolve, reject) {
          api.validate().then(function () {
            var formData = api.formData();
            is.Function(successFn) && invoke(function () {
              return successFn(formData, api);
            });
            is.Function(h.options.onSubmit) && invoke(function () {
              return h.options.onSubmit(formData, api);
            });
            h.vm.emit('submit', formData, api);
            resolve(formData);
          })["catch"](function () {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            is.Function(failFn) && invoke(function () {
              return failFn.apply(void 0, [api].concat(args));
            });
            reject.apply(void 0, args);
          });
        });
      }
    };
  }

  var required = {
    name: 'required',
    load: function load(inject, rule, api) {
      var val = parseVal(inject.getValue());

      if (val.required === false) {
        inject.clearProp();
        api.clearValidateState([rule.field]);
      } else {
        var validate = _objectSpread2({
          required: true,
          validator: function validator(_, v, call) {
            is.empty(v) ? call(validate.message) : call();
          }
        }, val);

        if (!validate.message) {
          var title = rule.title || '';
          validate.message = ((_typeof(title) === 'object' ? title.title : title) || '') + '不能为空';
        }

        inject.getProp().validate = [validate];
      }

      api.sync(rule);
    },
    watch: function watch() {
      required.load.apply(required, arguments);
    }
  };

  function parseVal(val) {
    if (is.Boolean(val)) {
      return {
        required: val
      };
    } else if (is.String(val)) {
      return {
        message: val
      };
    } else if (is.Undef(val)) {
      return {
        required: false
      };
    } else if (is.Function(val)) {
      return {
        validator: val
      };
    } else if (!is.Object(val)) {
      return {};
    } else {
      return val;
    }
  }

  function install(FormCreate) {
    FormCreate.componentAlias(alias);
    components.forEach(function (component) {
      FormCreate.component(component.name, component);
    });
    FormCreate.register(required);
    parsers.forEach(function (parser) {
      FormCreate.parser(parser);
    });
    Object.keys(maker$1).forEach(function (name) {
      FormCreate.maker[name] = maker$1[name];
    });

    if (typeof window !== 'undefined' && window.ElementPlus) {
      FormCreate.useApp(function (_, app) {
        app.use(window.ElementPlus);
      });
    }
  }

  function elmFormCreate() {
    return FormCreateFactory({
      ui: 'element-ui',
      version: '3.2.1',
      manager: manager,
      extendApi: extendApi,
      install: install,
      attrs: {
        normal: ['col', 'wrap'],
        array: ['className'],
        key: ['title', 'info']
      }
    });
  }

  var FormCreate = elmFormCreate();

  if (typeof window !== 'undefined') {
    window.formCreate = FormCreate;
  }

  var maker = FormCreate.maker;

  exports["default"] = FormCreate;
  exports.maker = maker;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
