(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    /**
     * paas组件选择
     */
    exports.PaasCbaSelect = {
        props: {
            modelValue: Array,
            placeholder: String,
            disabled: Boolean,
            readonly: Boolean,
        },
        emits: ['update:modelValue', 'change'],
        data(){
            return {
                cbaList: [],
                cbaGroupList: []
            }
        },
        methods: {
            handlerChange(val) {
                this.$emit('change', val)
            },
            queryData() {
                const self = this;

                $.restfulPostForm('/allinapaas/api/paas/cba/groups/list', { }, function(data){
                    let map = [], list = [], root =[];
                    data.rows.forEach(function(el){
                        map[el.cbaGroupCode] = el
                    })
                    data.rows.forEach(function(el){
                        let parent = map[el.cbaGroupAbv]
                        if (parent) {
                            if (!parent.children) {
                                parent.children = []
                            }
                            el.cbaGroupAbvName = parent.cbaGroupName
                            parent.children.push(el)
                        } else {
                            root.push(el)
                        }
                    })
                    self.cbaGroupList = root;
                }, function(e){}, true)

                $.restfulPostForm('/allinapaas/api/paas/cba/infos/list', { cbaType: '2' }, function(data){
                    self.cbaList = data.rows;
                }, function(e){}, true);
            }
        },
        computed:{
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            breadcrumb() {
                if (this.placeholder) {
                    return this.placeholder;
                } else {
                    return '工具组件'
                }
            },
            DIC() {
                return {

                }
            },
        },
        mounted() {
            this.queryData();
        },
        unmounted() {

        },
        template: `
<el-card class="box-card pure-theme" shadow="never" >
    <template #header>
        <page-header class="inner-title" :breadcrumb="breadcrumb" card-header></page-header>
    </template>
    <el-row>
        <el-col :span="24">
            <el-checkbox-group v-model="value" :disabled="disabled || readonly"  @change="handlerChange"
                style="display: flex; justify-content: space-between;flex-direction: column; flex-wrap: wrap;">
                <template v-for="(el, index) in cbaGroupList" >
                <div :key="index"  v-if="cbaList.filter(c=>c.cbaGroup == el.cbaGroupCode).length > 0"
                    style="flex: 0 0 20%; padding: 5px; display: inline-flex; flex-direction: column;">
                    <div style="font-weight: bold;line-height: 32px; font-size: 14px; margin-left: 5px; margin-right: 15px; max-width:200px;">{{el.cbaGroupName}}</div>
                    <template v-for="(cbaGroup, index) in el.children" >
                    <div :key="index" v-if="cbaList.filter(c=>c.cbaSubgroup == cbaGroup.cbaGroupCode).length > 0"
                        style="flex: 0 0 20%; padding: 5px; display: inline-flex;">
                        <div style="font-weight: normal; line-height: 32px; font-size: 14px;  margin-right: 15px; max-width:200px; text-align: right; flex: 0 0 5em;">{{cbaGroup.cbaGroupName}}</div>
                        <div style="display: inline-flex; flex-wrap: wrap; ">
                            <el-checkbox 
                                v-for="( cba, cIdx) in cbaList.filter(c=>c.cbaSubgroup == cbaGroup.cbaGroupCode)" 
                                :label="cba.cbaCode" 
                            >{{cba.cbaName}}</el-checkbox>
                        </div>
                    </div>
                    </template>
                </div>
                </template>
            </el-checkbox-group>
        </el-col>
    </el-row>
</el-card>
        `
    }
}));
