(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.UserCombobox = {
        props: {
            modelValue: String,
            placeholder: String,
            disabled: Boolean,
            readonly: Boolean,
            multiple: Boolean,
        },
        inject: ['DIC'],
        emits: ['update:modelValue', 'change', 'selectLabel'],
        data(){
            return {
                users:[],
            }
        },
        methods: {
            queryUsers() {
                const self = this ;
                $.restfulPostForm('/allincloud/api/s/users', { size: 100}, function(data) {
                    self.users = data.rows;
                }, function(e) {}, true)
            },
            handlerChange(val) {
                const item = this.users.find(function(el){ return val == el.actorno}) || {}
                this.$emit('change', val, item.actorname)
                this.$emit('selectLabel', item.actorname)
            },
            getUserName(val) {
                const item = this.users.find(function(el){ return val == el.actorno}) || {}
                return item.actorname
            }
        },
        computed:{
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            DIC(){
                return window[this.opType] || []
            },
            popperOptions() {
                return window.EL_POPPER_OPTIONS
            }
        },
        mounted() {
            this.queryUsers();
        },
        unmounted() {

        },
        template: `
<el-select v-model="value" class="m-2" :placeholder="placeholder" :popper-options="popperOptions" clearable filterable :multiple="multiple" :disabled="disabled || readonly" @change="handlerChange" >
    <el-option
            v-for="item in users"
            :key="item.actorno"
            :label="item.actorname"
            :value="item.actorno"
    />
</el-select>
        `
        , _designerRule: {
            //插入菜单位置
            menu: 'main',
            //图标
            icon: 'iconfont icon-yonghufill',
            //名称
            label: '用户选择',
            //id,唯一!
            name: 'UserCombobox',
            //是否可以操作, 除了容器类组件建议为true !
            mask: true,
            //支持组件验证, 值的类型
            validate: ['string'],
            //定义组件的事件
            event: ['change', 'visibleChange', 'selectLabel'],
            //定义组件的渲染规则
            rule({t}) {
                //组件的生成规则
                return {
                    type: 'UserCombobox',
                    //field不能重复!!!
                    field: JLUtil.uniqueId(),
                    title: '用户选择',
                    info: '',
                    $required: false,
                    props: {},
                };
            },
            //组件的属性配置
            props(_, {t}) {
                return [
                    {
                        type: 'switch',
                        title: '是否禁用',
                        field: 'disabled'
                    },
                    {
                        type: 'switch',
                        title: '是否可清除',
                        field: 'clearable'
                    },
                    {
                        type: 'switch',
                        title: '是否多选',
                        field: 'multiple'
                    },
                ];
            }
        }
    }
}));
