(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.InputButton = {
        props: {
            modelValue: String,
            placeholder: String,
            disabled: Boolean,
            readonly: Boolean,
            clearable: {
                type: Boolean,
                default: true
            },
            buttonText: String,
            buttonAction: Function
        },
        emits: ['update:modelValue', 'input', 'change', 'buttonClick'],
        data(){
            return {
                formItem: undefined
            }
        },
        methods: {
            handlerInput(val) {
                this.$emit('input', val)
                const { formItem } = this;
                formItem && formItem.validate();
            },
            handlerChange(val) {
                this.$emit('change', val)
                const { formItem } = this;
                formItem && formItem.validate();
            },
            handlerBtnClick(event) {
                if (this.buttonAction) {
                    this.buttonAction(this, event);
                } else {
                    this.$emit('buttonClick', this, event);
                }

            },
        },
        computed:{
            value: {
                get() {
                    return (this.modelValue || '') + ''
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },

        },
        mounted() {
            this.formItem = vue.inject(ElementPlus.formItemContextKey)
        },
        unmounted() {

        },
        template: `
<el-input v-model="value"  :placeholder="placeholder" :clearable="clearable" :disabled="disabled || readonly" class="m2"
     @input="handlerInput"
     @change="handlerChange"
     >
    <template #append>
        <el-button @click="handlerBtnClick">{{ buttonText }}</el-button>
    </template>
</el-input>
        `,
        _designerRule: {
            //插入菜单位置
            menu: 'main',
            //图标
            icon: 'icon-input',
            //名称
            label: '弹框输入框',
            //id,唯一!
            name: 'InputButton',
            //是否可以操作, 除了容器类组件建议为true !
            mask: true,
            //支持组件验证, 值的类型
            validate: ['string'],
            //定义组件的事件
            event: ['change', 'input', 'buttonClick'],
            //定义组件的渲染规则
            rule({t}) {
                //组件的生成规则
                return {
                    type: 'InputButton',
                    //field不能重复!!!
                    field: JLUtil.uniqueId(),
                    title: '弹框输入框',
                    info: '',
                    $required: false,
                    props: {},
                };
            },
            //组件的属性配置
            props(_, {t}) {
                return [
                    {
                        type: 'switch',
                        title: '是否禁用',
                        field: 'disabled'
                    },
                    {
                        type: 'switch',
                        title: '是否可清除',
                        field: 'clearable'
                    },
                    {
                        type: 'input',
                        title: '按钮文本',
                        field: 'buttonText',
                    },
                ];
            },
        }
    }
}));
