(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    /**
     *  头部logo
     */
    exports.HeaderSvgLogo = {
        props: {
            module: Object,
            drawerShow: Boolean,
            logoShow: {
                type: Boolean,
                default: true
            },
            suffixDesc: {
                type: String
            }
        },
        computed: {
            moduleTitle() {
                if (!this.module) return '';
                // return this.module.moduleShort;
                return this.module.moduleName;
            },
            moduleIcon() {
                if (!this.module) return '';
                return this.module.moduleIcon;
            }
        },
        template: `
<div style="display:flex;" :style="{ 'flex' : module ? '1' : drawerShow ? '0 0 95px' : '0 0 95px'}">
    <div style="overflow: hidden; padding-left: 5px; flex: 0 0 110px;" v-if="logoShow">
        <svg class="svg-canvas" viewBox="0 0 1200 600" width="40" height="30" :transform=" module || drawerShow  ? 'scale(2.7) translate(10 5)' : 'scale(2.2) translate(3 0)'" 
        preserveAspectRatio="none" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="background:#224a7d;">
        <!--滤镜-->
        <defs></defs>

        <!-- 背景 -->
        

        <!--元素-->
        
                <g id="shape_AjwXCJgVSQ" ref="shape_AjwXCJgVSQ" key="shape_AjwXCJgVSQ" mask="">
                  <g transform="translate(13.889102011314106,102.28875850305086) rotate(0,421.81443078986393,135.30067566274207) scale(1,1)" style="opacity: 1;mix-blend-mode: undefined;" filter="">
                    <!--普通元素-->
                    <svg version="1.1" id="图层_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="843.6288615797279" height="270.60135132548413" viewBox="10.189589500427246 43.904483795166016 179.6204071044922 112.19052124023438" enable-background="new 0 0 200 200" xml:space="preserve" preserveAspectRatio="none" class="style-removed" data-parent="shape_AjwXCJgVSQ">
<g>
\t<path fill="#246fdd" d="M106.321,89.494c0,0,21.712-23.689,49.111-19.623c20.564,3.052,29.926,14.137,34.378,20.14H176.37
\t\tc0,0-9.943-9.084-23.78-10.899C140.013,77.462,129.843,78.121,106.321,89.494z" stroke-width="0"></path>
\t<path fill="#246fdd" d="M147.161,71.716c0,0-5.801-22.574-33.028-27.054S61.92,55.92,43.31,82.687l22.517-4.021
\t\tc0,0,19.354-29.195,47.101-24.24c16.083,2.872,24.699,10.109,27.916,18.496L147.161,71.716z" stroke-width="0"></path>
\t<path fill="#24dd7f" d="M62.38,83.893c0,0-46.698,7.782-51.696,38.255c-4.136,25.216,18.611,33.947,33.43,33.947
\t\tc18.036,0,112.698,0,112.698,0l1.206-5.687c0,0-71.397,0.324-101.38,0c-15.968-0.172-28.147-4.996-28.147-22.574
\t\tc0-14.992,12.867-26.502,29.065-32.034L62.38,83.893z" stroke-width="0"></path>
</g>
</svg>
                  </g>
                </g>
                <g id="shape_KGTd7uuhMV" ref="shape_KGTd7uuhMV" key="shape_KGTd7uuhMV" mask="">
                  <g transform="translate(78.50902194006079,276.29665723120274) rotate(0,338.81741880387915,127.31741880387912) scale(1,1)" style="opacity: 1;mix-blend-mode: undefined;" filter="">
                    <!--普通元素-->
                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="677.6348376077583" height="254.63483760775824" viewBox="0 0 677.6348376077583 254.63483760775824" data-ligature="true" data-parent="shape_KGTd7uuhMV"><g data-role="text" data-width="357.8166015625" data-height="36" transform="translate(109.31741880387912, 109.31741880387912)"><path d="M12.22-4.20L1.78-4.20L1.78-29.61L12.22-29.61Q16.92-29.61 20.25-25.89L20.25-25.89Q23.56-22.17 23.56-16.90L23.56-16.90Q23.56-11.64 20.25-7.92L20.25-7.92Q16.92-4.20 12.22-4.20L12.22-4.20ZM12.22-26.89L4.50-26.89L4.50-6.92L12.22-6.92Q15.80-6.92 18.31-9.84L18.31-9.84Q20.84-12.76 20.84-16.90L20.84-16.90Q20.84-21.03 18.31-23.97L18.31-23.97Q15.80-26.89 12.22-26.89L12.22-26.89Z" transform="translate(0 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="24.62546875" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M4.50-4.20L4.50-21.44L1.78-21.44L1.78-4.20L4.50-4.20ZM3.13-30.07Q3.88-30.07 4.41-29.54L4.41-29.54Q4.95-29.00 4.95-28.26L4.95-28.26Q4.95-27.49 4.41-26.96L4.41-26.96Q3.88-26.42 3.13-26.42L3.13-26.42Q2.38-26.42 1.85-26.96L1.85-26.96Q1.32-27.49 1.32-28.26L1.32-28.26Q1.32-29.00 1.85-29.54L1.85-29.54Q2.38-30.07 3.13-30.07L3.13-30.07Z" transform="translate(24.62546875 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="6.28091796875" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M9.34-19.16Q6.89-19.16 5.16-17.31L5.16-17.31Q3.43-15.44 3.43-12.81L3.43-12.81Q3.43-10.18 5.16-8.33L5.16-8.33Q6.89-6.46 9.34-6.46L9.34-6.46Q11.78-6.46 13.50-8.33L13.50-8.33Q15.23-10.18 15.23-12.81L15.23-12.81Q15.23-15.44 13.50-17.31L13.50-17.31Q11.78-19.16 9.34-19.16L9.34-19.16ZM17.95-21.44L17.95-4.64Q17.95-0.89 15.30 1.78L15.30 1.78Q12.65 4.43 8.88 4.43L8.88 4.43Q6.41 4.43 4.29 3.18L4.29 3.18Q2.22 1.96 1.01-0.11L1.01-0.11L3.38-1.48Q4.22-0.02 5.66 0.84L5.66 0.84Q7.15 1.71 8.88 1.71L8.88 1.71Q11.51 1.71 13.38-0.16L13.38-0.16Q15.23-2.01 15.23-4.64L15.23-4.64L15.23-6.21Q12.78-3.74 9.34-3.74L9.34-3.74Q5.76-3.74 3.24-6.41L3.24-6.41Q0.71-9.06 0.71-12.81L0.71-12.81Q0.71-16.58 3.24-19.23L3.24-19.23Q5.76-21.89 9.34-21.89L9.34-21.89Q12.78-21.89 15.23-19.43L15.23-19.43L15.23-21.44L17.95-21.44Z" transform="translate(30.90638671875 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="19.198613281249997" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M4.50-4.20L4.50-21.44L1.78-21.44L1.78-4.20L4.50-4.20ZM3.13-30.07Q3.88-30.07 4.41-29.54L4.41-29.54Q4.95-29.00 4.95-28.26L4.95-28.26Q4.95-27.49 4.41-26.96L4.41-26.96Q3.88-26.42 3.13-26.42L3.13-26.42Q2.38-26.42 1.85-26.96L1.85-26.96Q1.32-27.49 1.32-28.26L1.32-28.26Q1.32-29.00 1.85-29.54L1.85-29.54Q2.38-30.07 3.13-30.07L3.13-30.07Z" transform="translate(50.105 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="6.28091796875" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M4.34-18.72L4.34-9.18Q4.34-7.12 5.80-5.66L5.80-5.66Q7.26-4.20 9.32-4.20L9.32-4.20L11.60-4.20L11.60-6.92L9.32-6.92Q8.40-6.92 7.72-7.58L7.72-7.58Q7.06-8.26 7.06-9.18L7.06-9.18L7.06-18.72L11.60-18.72L11.60-21.44L7.06-21.44L7.06-26.89L4.34-26.89L4.34-21.44L0.71-21.44L0.71-18.72L4.34-18.72Z" transform="translate(56.38591796874999 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="12.312734375" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M9.34-19.16Q6.89-19.16 5.16-17.31L5.16-17.31Q3.43-15.44 3.43-12.81L3.43-12.81Q3.43-10.18 5.16-8.33L5.16-8.33Q6.89-6.46 9.34-6.46L9.34-6.46Q11.78-6.46 13.50-8.33L13.50-8.33Q15.23-10.18 15.23-12.81L15.23-12.81Q15.23-15.44 13.50-17.31L13.50-17.31Q11.78-19.16 9.34-19.16L9.34-19.16ZM15.23-4.20L15.23-6.21Q12.78-3.74 9.34-3.74L9.34-3.74Q5.76-3.74 3.24-6.41L3.24-6.41Q0.71-9.06 0.71-12.81L0.71-12.81Q0.71-16.58 3.24-19.23L3.24-19.23Q5.76-21.89 9.34-21.89L9.34-21.89Q12.78-21.89 15.23-19.43L15.23-19.43L15.23-21.44L17.95-21.44L17.95-4.20L15.23-4.20Z" transform="translate(68.69865234375 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="19.198613281249997" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M3.97-4.20L3.97-29.61L1.25-29.61L1.25-4.20L3.97-4.20Z" transform="translate(87.89726562499999 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="5.21333984375" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M0,0Z" transform="translate(93.11060546875 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="9.038828125" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M11.51-27.33Q14.38-27.33 16.35-25.94L16.35-25.94Q18.31-24.55 18.31-22.58L18.31-22.58L21.03-22.58Q21.03-25.69 18.31-27.86L18.31-27.86Q15.55-30.07 11.51-30.07L11.51-30.07Q7.46-30.07 4.77-28.17L4.77-28.17Q1.98-26.19 1.98-23.02L1.98-23.02Q1.98-19.64 4.66-17.99L4.66-17.99Q6.48-16.89 10.60-16.17L10.60-16.17Q15.25-15.36 16.53-14.82L16.53-14.82Q19.22-13.72 19.22-11.23L19.22-11.23Q19.22-9.07 16.96-7.74L16.96-7.74Q14.80-6.46 11.51-6.46L11.51-6.46Q8.15-6.46 5.94-8.18L5.94-8.18Q3.79-9.88 3.79-12.37L3.79-12.37L1.07-12.37Q1.07-8.74 3.99-6.26L3.99-6.26Q6.97-3.74 11.51-3.74L11.51-3.74Q16.00-3.74 18.88-5.69L18.88-5.69Q21.94-7.76 21.94-11.23L21.94-11.23Q21.94-14.71 19.25-16.44L19.25-16.44Q17.40-17.63 13.33-18.36L13.33-18.36Q8.51-19.23 7.40-19.66L7.40-19.66Q4.70-20.71 4.70-23.02L4.70-23.02Q4.70-25.02 6.69-26.21L6.69-26.21Q8.59-27.33 11.51-27.33L11.51-27.33Z" transform="translate(102.14943359374999 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="23.00630859375" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M3.58-11.46L18.77-11.46Q18.86-12.13 18.86-12.81L18.86-12.81Q18.86-16.58 16.21-19.23L16.21-19.23Q13.56-21.89 9.79-21.89L9.79-21.89Q6.03-21.89 3.38-19.23L3.38-19.23Q0.71-16.58 0.71-12.81L0.71-12.81Q0.71-9.06 3.38-6.41L3.38-6.41Q6.03-3.74 9.79-3.74L9.79-3.74Q14.52-3.74 17.22-7.62L17.22-7.62L15.00-9.16Q13.10-6.46 9.79-6.46L9.79-6.46Q7.15-6.46 5.30-8.33L5.30-8.33Q3.93-9.68 3.58-11.46L3.58-11.46ZM3.58-14.18Q3.93-15.94 5.30-17.31L5.30-17.31Q7.15-19.16 9.79-19.16L9.79-19.16Q12.42-19.16 14.29-17.31L14.29-17.31Q15.64-15.94 16.00-14.18L16.00-14.18L3.58-14.18Z" transform="translate(125.15574218749998 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="19.572265625" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M1.25-4.20L1.25-21.44L3.97-21.44L3.97-19.80Q6.26-21.89 9.41-21.89L9.41-21.89Q10.11-21.89 10.78-21.78L10.78-21.78L10.78-19.00Q10.11-19.16 9.41-19.16L9.41-19.16Q7.17-19.16 5.57-17.58L5.57-17.58Q3.97-15.98 3.97-13.72L3.97-13.72L3.97-4.20L1.25-4.20Z" transform="translate(144.72800781249998 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="11.494257812499999" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M17.49-21.44L14.52-21.44L8.74-8.15L2.97-21.44L0-21.44L7.49-4.20L10.00-4.20L17.49-21.44Z" transform="translate(156.22226562499998 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="17.49048828125" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M4.50-4.20L4.50-21.44L1.78-21.44L1.78-4.20L4.50-4.20ZM3.13-30.07Q3.88-30.07 4.41-29.54L4.41-29.54Q4.95-29.00 4.95-28.26L4.95-28.26Q4.95-27.49 4.41-26.96L4.41-26.96Q3.88-26.42 3.13-26.42L3.13-26.42Q2.38-26.42 1.85-26.96L1.85-26.96Q1.32-27.49 1.32-28.26L1.32-28.26Q1.32-29.00 1.85-29.54L1.85-29.54Q2.38-30.07 3.13-30.07L3.13-30.07Z" transform="translate(173.71275390625 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="6.28091796875" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M9.79-21.89Q14.50-21.89 17.22-18.02L17.22-18.02L15.00-16.46Q13.10-19.16 9.79-19.16L9.79-19.16Q7.15-19.16 5.30-17.31L5.30-17.31Q3.43-15.44 3.43-12.81L3.43-12.81Q3.43-10.18 5.30-8.33L5.30-8.33Q7.15-6.46 9.79-6.46L9.79-6.46Q13.10-6.46 15.00-9.16L15.00-9.16L17.22-7.62Q14.50-3.74 9.79-3.74L9.79-3.74Q6.03-3.74 3.36-6.41L3.36-6.41Q0.71-9.06 0.71-12.81L0.71-12.81Q0.71-16.58 3.36-19.23L3.36-19.23Q6.03-21.89 9.79-21.89L9.79-21.89Z" transform="translate(179.993671875 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="17.9353125" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M3.58-11.46L18.77-11.46Q18.86-12.13 18.86-12.81L18.86-12.81Q18.86-16.58 16.21-19.23L16.21-19.23Q13.56-21.89 9.79-21.89L9.79-21.89Q6.03-21.89 3.38-19.23L3.38-19.23Q0.71-16.58 0.71-12.81L0.71-12.81Q0.71-9.06 3.38-6.41L3.38-6.41Q6.03-3.74 9.79-3.74L9.79-3.74Q14.52-3.74 17.22-7.62L17.22-7.62L15.00-9.16Q13.10-6.46 9.79-6.46L9.79-6.46Q7.15-6.46 5.30-8.33L5.30-8.33Q3.93-9.68 3.58-11.46L3.58-11.46ZM3.58-14.18Q3.93-15.94 5.30-17.31L5.30-17.31Q7.15-19.16 9.79-19.16L9.79-19.16Q12.42-19.16 14.29-17.31L14.29-17.31Q15.64-15.94 16.00-14.18L16.00-14.18L3.58-14.18Z" transform="translate(197.928984375 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="19.572265625" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M0,0Z" transform="translate(217.50125 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="9.038828125" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M12.22-29.61L1.78-29.61L1.78-4.20L4.50-4.20L4.50-13.27L12.22-13.27Q15.60-13.27 17.99-15.66L17.99-15.66Q20.39-18.06 20.39-21.44L20.39-21.44Q20.39-24.82 17.99-27.22L17.99-27.22Q15.60-29.61 12.22-29.61L12.22-29.61ZM4.50-26.89L12.22-26.89Q14.48-26.89 16.07-25.28L16.07-25.28Q17.67-23.70 17.67-21.44L17.67-21.44Q17.67-19.18 16.07-17.58L16.07-17.58Q14.48-16.00 12.22-16.00L12.22-16.00L4.50-16.00L4.50-26.89Z" transform="translate(226.540078125 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="21.4583203125" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M3.97-4.20L3.97-29.61L1.25-29.61L1.25-4.20L3.97-4.20Z" transform="translate(247.99839843750001 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="5.21333984375" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M9.34-19.16Q6.89-19.16 5.16-17.31L5.16-17.31Q3.43-15.44 3.43-12.81L3.43-12.81Q3.43-10.18 5.16-8.33L5.16-8.33Q6.89-6.46 9.34-6.46L9.34-6.46Q11.78-6.46 13.50-8.33L13.50-8.33Q15.23-10.18 15.23-12.81L15.23-12.81Q15.23-15.44 13.50-17.31L13.50-17.31Q11.78-19.16 9.34-19.16L9.34-19.16ZM15.23-4.20L15.23-6.21Q12.78-3.74 9.34-3.74L9.34-3.74Q5.76-3.74 3.24-6.41L3.24-6.41Q0.71-9.06 0.71-12.81L0.71-12.81Q0.71-16.58 3.24-19.23L3.24-19.23Q5.76-21.89 9.34-21.89L9.34-21.89Q12.78-21.89 15.23-19.43L15.23-19.43L15.23-21.44L17.95-21.44L17.95-4.20L15.23-4.20Z" transform="translate(253.21173828125 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="19.198613281249997" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M4.34-18.72L4.34-9.18Q4.34-7.12 5.80-5.66L5.80-5.66Q7.26-4.20 9.32-4.20L9.32-4.20L11.60-4.20L11.60-6.92L9.32-6.92Q8.40-6.92 7.72-7.58L7.72-7.58Q7.06-8.26 7.06-9.18L7.06-9.18L7.06-18.72L11.60-18.72L11.60-21.44L7.06-21.44L7.06-26.89L4.34-26.89L4.34-21.44L0.71-21.44L0.71-18.72L4.34-18.72Z" transform="translate(272.4103515625 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="12.312734375" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M4.80-21.44L4.80-24.61Q4.80-26.67 6.26-28.15L6.26-28.15Q7.72-29.61 9.79-29.61L9.79-29.61L13.42-29.61L13.42-26.89L9.79-26.89Q8.86-26.89 8.18-26.23L8.18-26.23Q7.53-25.55 7.53-24.61L7.53-24.61L7.53-21.44L13.42-21.44L13.42-18.72L7.53-18.72L7.53-4.20L4.80-4.20L4.80-18.72L0.71-18.72L0.71-21.44L4.80-21.44Z" transform="translate(284.7230859375 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="14.127617187499999" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M9.79-21.89Q13.54-21.89 16.21-19.23L16.21-19.23Q18.86-16.58 18.86-12.81L18.86-12.81Q18.86-9.06 16.21-6.41L16.21-6.41Q13.54-3.74 9.79-3.74L9.79-3.74Q6.03-3.74 3.36-6.41L3.36-6.41Q0.71-9.06 0.71-12.81L0.71-12.81Q0.71-16.58 3.36-19.23L3.36-19.23Q6.03-21.89 9.79-21.89L9.79-21.89ZM14.29-17.31Q12.42-19.16 9.79-19.16L9.79-19.16Q7.15-19.16 5.30-17.31L5.30-17.31Q3.43-15.44 3.43-12.81L3.43-12.81Q3.43-10.18 5.30-8.33L5.30-8.33Q7.15-6.46 9.79-6.46L9.79-6.46Q12.42-6.46 14.29-8.33L14.29-8.33Q16.14-10.18 16.14-12.81L16.14-12.81Q16.14-15.44 14.29-17.31L14.29-17.31Z" transform="translate(298.850703125 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="19.572265625" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M1.25-4.20L1.25-21.44L3.97-21.44L3.97-19.80Q6.26-21.89 9.41-21.89L9.41-21.89Q10.11-21.89 10.78-21.78L10.78-21.78L10.78-19.00Q10.11-19.16 9.41-19.16L9.41-19.16Q7.17-19.16 5.57-17.58L5.57-17.58Q3.97-15.98 3.97-13.72L3.97-13.72L3.97-4.20L1.25-4.20Z" transform="translate(318.42296875 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="11.494257812499999" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path><path d="M3.97-14.86L3.97-4.20L1.25-4.20L1.25-21.44L3.97-21.44L3.97-20.14Q5.87-21.89 8.51-21.89L8.51-21.89Q11.33-21.89 13.33-19.89L13.33-19.89Q13.70-19.52 14.02-19.11L14.02-19.11Q14.31-19.48 14.66-19.84L14.66-19.84Q16.71-21.89 19.63-21.89L19.63-21.89Q22.54-21.89 24.61-19.84L24.61-19.84Q26.65-17.78 26.65-14.86L26.65-14.86L26.65-4.20L23.93-4.20L23.93-14.86Q23.93-16.64 22.67-17.90L22.67-17.90Q21.40-19.16 19.63-19.16L19.63-19.16Q17.85-19.16 16.58-17.90L16.58-17.90Q15.32-16.64 15.32-14.86L15.32-14.86L15.32-4.20L12.60-4.20L12.60-14.86Q12.60-16.64 11.33-17.90L11.33-17.90Q10.07-19.16 8.27-19.16L8.27-19.16Q6.49-19.16 5.23-17.90L5.23-17.90Q3.97-16.64 3.97-14.86L3.97-14.86Z" transform="translate(329.9172265625 29) " fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.061" data-glyph-w="27.899375" data-glyph-h="37.970195312499996" data-glyph-ascender="30.532734374999997" data-glyph-descender="-7.437460937499999" data-kerning="0"></path></g></svg>
                  </g>
                </g>
                <g id="shape_W7YDZ35Q8m" ref="shape_W7YDZ35Q8m" key="shape_W7YDZ35Q8m" mask="">
                  <g transform="translate(-271.17355925606006,-249.21290527558523) rotate(0,959.6590909090909,535.5) scale(1,1)" style="opacity: 1;mix-blend-mode: undefined;" filter="">
                    <!--普通元素-->
                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="1919.3181818181818" height="1071" viewBox="0 0 1919.3181818181818 1071" data-ligature="true" data-parent="shape_W7YDZ35Q8m"><g data-role="text" data-width="985.3199999999999" data-height="153" transform="translate(459, 459)"><path d="M3.21-81.09L3.21-95.01L9.64-95.01L6.43-107.56L25.86-107.56L29.07-95.01L32.59-95.01L32.59-110.31L53.55-110.31L53.55-95.01L57.07-95.01L60.28-107.56L79.71-107.56L76.50-95.01L82.93-95.01L82.93-81.09L53.55-81.09L53.55-57.22L32.59-57.22L32.59-81.09L3.21-81.09ZM20.81-57.22L3.21-57.22L8.41-77.27L26.01-77.27L20.81-57.22ZM65.33-57.22L60.13-77.27L77.72-77.27L82.93-57.22L65.33-57.22ZM3.21 0L3.21-13.16Q9.33-13.92 16.37-14.99L16.37-14.99Q14.38-15.76 12.39-16.60Q10.40-17.44 8.26-18.36L8.26-18.36L8.26-31.67L8.26-34.73L3.21-34.73L3.21-48.65L8.26-48.65L8.26-53.40L26.77-53.40L26.77-48.65L59.36-48.65L59.36-53.40L77.88-53.40L77.88-48.65L82.93-48.65L82.93-34.73L77.88-34.73L77.88-31.67L77.88-18.36Q75.73-17.44 73.75-16.60Q71.76-15.76 69.77-14.99L69.77-14.99Q76.81-13.92 82.93-13.16L82.93-13.16L82.93 0Q71.30-0.92 62.04-2.22Q52.78-3.52 43.15-6.12L43.15-6.12Q33.35-3.52 24.10-2.22Q14.84-0.92 3.21 0L3.21 0ZM26.77-34.73L26.77-26.16Q30.91-24.48 35.04-23.26Q39.17-22.03 43.15-20.81L43.15-20.81Q47.12-22.03 51.18-23.26Q55.23-24.48 59.36-26.16L59.36-26.16L59.36-34.73L26.77-34.73ZM137.55-97.31L137.55-82.31Q137.55-67.93 133.80-56.53Q130.05-45.13 123.47-35.80L123.47-35.80Q126.68-32.74 130.20-29.76Q133.72-26.77 137.55-23.56L137.55-23.56L137.55-0.61Q130.51-5.51 123.85-10.71Q117.20-15.91 111.38-21.73L111.38-21.73Q105.57-15.91 98.99-10.71Q92.41-5.51 85.37-0.61L85.37-0.61L85.37-23.56Q89.20-26.77 92.72-29.76Q96.24-32.74 99.45-35.80L99.45-35.80Q93.64-44.37 89.96-54.47Q86.29-64.57 85.53-77.27L85.53-77.27L102.97-77.27Q103.58-68.24 105.80-61.58Q108.02-54.93 111.54-49.27L111.54-49.27Q115.82-55.69 118.19-63.57Q120.56-71.45 120.56-82.31L120.56-82.31L113.37-82.31L85.68-82.31L94.86-110.31L116.28-110.31L112.15-97.31L137.55-97.31Z" transform="translate(0 131) skewX(-14)" fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.255" data-glyph-w="140.76" data-glyph-h="153" data-glyph-ascender="131.427" data-glyph-descender="-21.573" data-kerning="0"></path><path d="M82.47-101.90L121.33-101.90Q124.85-101.90 127.91-100.60Q130.97-99.30 133.26-97.00Q135.56-94.71 136.86-91.65Q138.16-88.59 138.16-85.07L138.16-85.07L138.16-73.75L117.05-73.75L117.05-82.01Q117.05-84.00 115.67-85.37Q114.29-86.75 112.15-86.75L112.15-86.75L23.87-86.75L23.87-73.75L2.60-73.75L2.60-101.90L59.36-101.90L55.54-110.47L78.64-110.47L82.47-101.90ZM7.19-45.90L73.75-45.90L85.83-61.96L29.07-61.96L29.07-77.11L112.45-77.11L112.45-66.86L97.77-45.90L132.50-45.90L132.50-30.75L88.43-30.75L88.43-16.52Q88.43-13.00 87.13-9.95Q85.83-6.88 83.54-4.59Q81.24-2.29 78.18-0.99Q75.12 0.31 71.60 0.31L71.60 0.31L34.73 0.31L40.70-13.00L62.42-13.00Q64.41-13.00 65.79-14.38Q67.17-15.76 67.17-17.75L67.17-17.75L67.17-30.75L7.19-30.75L7.19-45.90Z" transform="translate(140.76 131) skewX(-14)" fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.255" data-glyph-w="140.76" data-glyph-h="153" data-glyph-ascender="131.427" data-glyph-descender="-21.573" data-kerning="0"></path><path d="M68.54-110.16L89.05-110.16L89.05-73.29L131.73-86.60L131.73-69.61L89.05-56.30L89.05-17.75Q89.05-16.37 90.04-15.38Q91.03-14.38 92.56-14.38L92.56-14.38L137.55-14.38L132.19-0.15L83.23-0.15Q77.11-0.15 72.83-4.44Q68.54-8.72 68.54-14.84L68.54-14.84L68.54-50.03L44.22-42.38L44.22-59.36L68.54-66.86L68.54-110.16ZM15.91-0.15L15.91-67.47L3.21-67.47L22.18-110.16L45.13-110.16L32.44-81.86L36.87-81.86L36.87-0.15L15.91-0.15Z" transform="translate(281.52 131) skewX(-14)" fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.255" data-glyph-w="140.76" data-glyph-h="153" data-glyph-ascender="131.427" data-glyph-descender="-21.573" data-kerning="0"></path><path d="M84.30-95.17L84.30-67.93L138.01-67.93L138.01-53.09Q138.01-44.83 134.64-37.10Q131.27-29.38 125.92-22.64L125.92-22.64Q128.52-21.27 131.50-20.12Q134.49-18.97 138.01-17.75L138.01-17.75L138.01 0.15Q123.47-2.45 112.15-10.25L112.15-10.25Q100.83-2.45 86.44 0.15L86.44 0.15L86.44-17.75Q89.96-18.97 92.95-20.12Q95.93-21.27 98.53-22.64L98.53-22.64Q93.79-28.46 90.81-35.19Q87.82-41.92 86.75-49.27L86.75-49.27L105.11-49.27Q107.56-40.24 112.15-33.81L112.15-33.81Q115.06-37.64 116.97-42.38Q118.88-47.12 120.26-53.09L120.26-53.09L84.30-53.09L84.30-16.22L79.25 0.15L57.99 0.15L63.04-16.83L63.04-95.17L63.04-103.89L63.04-110.31L137.85-110.31L137.85-88.59Q137.85-85.07 136.55-82.08Q135.25-79.10 132.96-76.81Q130.66-74.51 127.60-73.21Q124.54-71.91 121.02-71.91L121.02-71.91L94.55-71.91L97.31-85.22L111.84-85.22Q113.83-85.22 115.21-86.67Q116.59-88.13 116.59-90.12L116.59-90.12L116.59-95.17L84.30-95.17ZM38.56-110.31L45.90-110.31Q50.95-110.31 54.47-106.79Q57.99-103.27 57.99-98.23L57.99-98.23L57.99-12.24Q57.99-8.87 56.99-6.50Q56.00-4.13 54.47-2.68Q52.94-1.22 51.26-0.54Q49.57 0.15 48.04 0.15L48.04 0.15L29.84 0.15L34.27-10.10L36.72-10.10Q37.48-10.10 37.71-10.40Q37.94-10.71 38.25-11.02L38.25-11.02Q38.40-11.47 38.56-12.09L38.56-12.09L38.56-31.82L23.87-31.82L23.87-14.69L20.50 0.15L2.60 0.15L5.35-14.69L5.35-110.31L12.24-110.31L23.87-110.31L38.56-110.31ZM33.66-95.17L23.87-95.17L23.87-78.64L38.56-78.64L38.56-90.42Q38.56-92.41 37.18-93.79Q35.80-95.17 33.66-95.17L33.66-95.17ZM23.87-46.97L38.56-46.97L38.56-63.49L23.87-63.49L23.87-46.97Z" transform="translate(422.28 131) skewX(-14)" fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.255" data-glyph-w="140.76" data-glyph-h="153" data-glyph-ascender="131.427" data-glyph-descender="-21.573" data-kerning="0"></path><path d="M137.39-15.15L137.39-14.69Q137.39-11.63 136.25-9.03Q135.10-6.43 133.19-4.44Q131.27-2.45 128.60-1.30Q125.92-0.15 123.01-0.15L123.01-0.15L88.74-0.15L95.63-13.46L113.68-13.46Q115.67-13.46 117.05-14.84Q118.42-16.22 118.42-18.36L118.42-18.36L118.42-32.13L50.80-32.13L28.15 0L5.51 0L28.30-32.13L5.51-32.13L5.51-44.06L36.72-44.06L41.92-51.56L64.57-51.56L59.21-44.06L118.42-44.06L126.38-44.06L137.39-44.06L137.39-15.15ZM135.10-64.87L135.10-49.88Q120.41-50.49 103.35-52.10Q86.29-53.70 69.16-57.22L69.16-57.22Q52.17-53.70 35.11-52.10Q18.05-50.49 3.37-49.88L3.37-49.88L3.37-64.87Q12.09-65.48 19.89-66.10Q27.69-66.71 34.73-67.47L34.73-67.47Q26.01-70.99 18.74-75.43Q11.47-79.87 5.97-85.37L5.97-85.37L35.04-85.37Q43.45-81.09 51.71-78.11Q59.98-75.12 69.16-72.98L69.16-72.98Q79.87-75.58 89.43-79.25Q98.99-82.93 108.78-88.28L108.78-88.28L23.41-88.28L7.80-88.28L4.44-88.28L16.07-110.31L35.04-110.31L30.60-102.05L135.10-102.05L135.10-88.28Q129.44-81.70 121.41-76.58Q113.37-71.45 103.73-67.47L103.73-67.47Q110.77-66.71 118.58-66.10Q126.38-65.48 135.10-64.87L135.10-64.87Z" transform="translate(563.04 131) skewX(-14)" fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.255" data-glyph-w="140.76" data-glyph-h="153" data-glyph-ascender="131.427" data-glyph-descender="-21.573" data-kerning="0"></path><path d="M115.82-49.42L97.46-49.42L106.33-87.67L124.69-87.67L115.82-49.42ZM36.57-87.67L44.83-49.42L26.47-49.42L18.21-87.67L36.57-87.67ZM137.55-32.44L137.55-28.46L81.09-28.46L81.09-0.31L59.82-0.31L59.82-28.46L3.21-28.46L3.21-32.44L3.21-42.69L3.21-43.45L59.82-43.45L59.82-94.86L8.26-94.86L8.26-97.16L8.26-107.41L8.26-109.85L132.50-109.85L132.50-107.41L132.50-97.16L132.50-94.86L81.09-94.86L81.09-43.45L137.55-43.45L137.55-42.69L137.55-32.44Z" transform="translate(703.8 131) skewX(-14)" fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.255" data-glyph-w="140.76" data-glyph-h="153" data-glyph-ascender="131.427" data-glyph-descender="-21.573" data-kerning="0"></path><path d="M131.89-41.00L131.89-15.30Q131.89-12.24 130.74-9.64Q129.59-7.04 127.68-5.13Q125.77-3.21 123.09-2.07Q120.41-0.92 117.50-0.92L117.50-0.92L29.53-0.92L7.19-0.92L7.19-15.76L7.19-41.00L7.19-42.84L7.19-56.00L131.89-56.00L131.89-55.69L131.89-41.00ZM109.55-20.66L109.55-41.00L29.53-41.00L29.53-15.76L104.80-15.76Q106.79-15.76 108.17-17.14Q109.55-18.51 109.55-20.66L109.55-20.66ZM10.86-63.34L4.74-63.34L34.27-109.39L55.84-109.39L35.95-78.34L104.50-78.34L89.50-103.27L110.01-103.27L136.02-59.82L115.67-59.82L113.53-63.34L26.32-63.34L10.86-63.34Z" transform="translate(844.56 131) skewX(-14)" fill="rgb(255, 255, 255)" stroke="rgb(255, 255, 255)" stroke-width="0.255" data-glyph-w="140.76" data-glyph-h="153" data-glyph-ascender="131.427" data-glyph-descender="-21.573" data-kerning="0"></path></g></svg>
                  </g>
                </g>
      </svg>
    </div>

    <div style="line-height: var(--index-nav-line-height); display: inline-flex; justify-content: left; align-items: center;" v-if="!!module" class="nav-log-title"> 
        <i class="divider-i" v-if="logoShow"></i>
        <template v-if="moduleIcon.startsWith('#icon')">
            <svg class="icon svg-icon" style="color: #FFF; padding-right: 5px; font-size: 14px; " aria-hidden="true"><use :xlink:href="moduleIcon"></use></svg>   
        </template>
        <template v-else>
            <i class="iconfont" :class="[ moduleIcon ]" style="font-size: 18px;"></i>
        </template>
        {{ moduleTitle }}
        <template v-if="suffixDesc">
            <i class="divider-i" style="padding-left: 12px;"></i>
            {{ suffixDesc }}
        </template>
    </div>
    <div style="line-height: var(--index-nav-line-height); display: inline-flex; justify-content: left; align-items: center; flex: 0 0 5px;" v-else> 
       <i class="divider-i"></i>
    </div>
</div>
        `
    }
}));
