(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {

    exports.RichEditor = {
        props: {
            modelValue: String,
            disabled: Boolean,
            width: String,
            height: String,
        },
        inject: ['DIC'],
        emits: ['update:modelValue', 'change'],
        data(){
            return {
                editor: undefined,
            }
        },
        watch: {
            disabled(val) {
                if (this.editor) {
                    this.editor.readonly(val)
                }
            },
            modelValue(val, oldVal) {
                if (this.editor) {
                    const editorVal = this.editor.html();
                    if(val != editorVal) {
                        this.editor.html(val);
                    }
                }
            }
        },
        methods: {
            initEditor() {
                const self = this;
                const $el = self.$el;
                const KindEditor = window.KindEditor;
                KindEditor.ready(function(K) {
                    self.editor = K.create($el, Vue.unref(self.options));
                    setTimeout(function(){ self.editor.readonly(self.disabled) }, 50)
                });
                // 有时ready 回调不执行
                setTimeout(function() {
                    window.document.dispatchEvent(new Event("DOMContentLoaded", {
                        bubbles: true,
                        cancelable: true
                    }));
                }, 200) ;
            },
            change() {
                if (this.editor) {
                    const val = this.editor.html();
                    this.value = val;
                    this.$emit('change', val)
                }
            }
        },
        computed:{
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            docTools() {
                return [ 'formatblock', 'fontname', 'fontsize', 'lineheight', '|', 'forecolor', 'hilitecolor', '|', 'bold', 'italic','underline', 'strikethrough', '|',
                    'justifyleft', 'justifycenter', 'justifyright', 'justifyfull', '|',
                    'insertorderedlist', 'insertunorderedlist', '|',
                    'emoticons', 'image', 'hr', '|', 'link', '|',
                    'undo', 'redo', '|', 'selectall', 'cut', 'copy', 'paste', '|', 'plainpaste', 'wordpaste', '|', 'removeformat', 'clearhtml','quickformat', '|',
                    'indent', 'outdent', 'subscript', 'superscript', '|',
                    'table', 'code', 'pagebreak',
                    'source']
            },
            simpleTools() {
                return [ 'formatblock', 'fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold', 'italic','underline', '|',
                    'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist', 'insertunorderedlist', '|',
                    'emoticons', 'image', 'code', 'link', 'table', '|', 'removeformat','undo', 'redo', 'fullscreen', 'source', 'about']
            },
            options() {
                return {
                    basePath: '/allinapaas/static/kindeditor/',
                    pluginsPath: '/allinapaas/static/kindeditor/plugins/',
                    themesPath: '/allinapaas/static/kindeditor/themes/',
                    langPath: '/allinapaas/static/kindeditor/lang/',
                    width: this.width || '100%',
                    height: this.height || '200px',
                    filterMode: true,
                    bodyClass: 'article-content',
                    urlType: 'absolute',
                    langType: 'zh_CN',
                    cssData: 'html,body {background: none}.article-content{overflow:visible}.article-content, .article-content table td, .article-content table th {line-height: 1.3846153846; font-size: 13px;}.article-content .table-auto {width: auto!important; max-width: 100%;}',
                    placeholder: '',
                    placeholderStyle: {fontSize: '14px', color: '#888'},
                    // pasteImage: {postUrl: createLink('file', 'ajaxPasteImg', 'uid=' + kuid)},
                    syncType: 'form',
                    allowFileManager: false,
                    spellcheck: false,
                    afterChange: this.change,
                    items: this.simpleTools
                }
            }

        },
        mounted() {
            const self = this;
            if (window.KindEditor) {
                self.initEditor()
            } else {
                loadjs('/allinapaas/static/kindeditor/kindeditor-all.js', function(){
                    if (window.KindEditor) {
                        self.initEditor()
                    } else {
                        setTimeout(self.initEditor, 250)
                    }
                })
            }

        },
        unmounted() {

        },
        template: `
<textarea v-model="value"> </textarea>
        `
        , _designerRule: {
            //插入菜单位置
            menu: 'main',
            //图标
            icon: 'icon-editor',
            //名称
            label: '富文本',
            //id,唯一!
            name: 'RichEditor',
            //是否可以操作, 除了容器类组件建议为true !
            mask: true,
            //支持组件验证, 值的类型
            validate: ['string'],
            //定义组件的事件
            event: ['change'],
            //定义组件的渲染规则
            rule({t}) {
                //组件的生成规则
                return {
                    type: 'RichEditor',
                    //field不能重复!!!
                    field: JLUtil.uniqueId(),
                    title: '富文本',
                    info: '',
                    $required: false,
                    props: {},
                };
            },
            //组件的属性配置
            props(_, {t}) {
                return [
                    {
                        type: 'switch',
                        title: '是否禁用',
                        field: 'disabled'
                    },
                    {
                        type: 'input',
                        title: '代码语言',
                        field: 'language',
                    },
                    {
                        type: 'SizeInput',
                        title: '宽度',
                        field: 'width',
                        value: '100%'
                    },
                    {
                        type: 'SizeInput',
                        title: '高度',
                        field: 'height',
                        value: '450px'
                    },
                ];
            }
        }
    }
}));
