/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.web.feign;

import com.irdstudio.sdk.beans.web.feign.FeignClientAutoRequestMapping;
import feign.Contract;
import feign.Feign;
import feign.OwnFeignContract;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@ConditionalOnClass(value={Feign.class})
@Configuration
public class FeignConfiguration {
    @Value(value="${feign.readTimeout:7200}")
    private int readTimeout;
    @Value(value="${feign.connectTimeout:7200}")
    private int connectTimeout;

    @Bean
    public Request.Options options() {
        return new Request.Options((long)this.connectTimeout, TimeUnit.SECONDS, (long)this.readTimeout, TimeUnit.SECONDS, false);
    }

    @Bean
    public Contract feignContract() {
        return new OwnFeignContract();
    }

    @Bean
    public WebMvcRegistrations webMvcRegistrationsHandlerMapping() {
        return new WebMvcRegistrations(){

            public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
                return new FeignClientAutoRequestMapping();
            }
        };
    }

    @Bean
    public RequestInterceptor feignHeaderInterceptor() {
        return new RequestInterceptor(){

            public void apply(RequestTemplate template) {
                if (RequestContextHolder.getRequestAttributes() != null) {
                    String tgc = (String)RequestContextHolder.getRequestAttributes().getAttribute("TGC", 1);
                    template.header("Cookie", new String[]{String.format("%s=%s", "TGC", tgc)});
                }
            }
        };
    }
}

