/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.mybatis.iterceptor;

import com.irdstudio.sdk.beans.core.util.ReflectUtility;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.util.ReflectionTestUtils;

@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class}), @Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class SqlPageInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(SqlPageInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
            MetaObject metaObjectHandler = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
            MappedStatement mappedStatement = (MappedStatement)metaObjectHandler.getValue("delegate.mappedStatement");
            String mapId = mappedStatement.getId();
            String dbTypeName = null;
            try {
                dbTypeName = (String)metaObjectHandler.getValue("delegate.mappedStatement.configuration.environment.dataSource.dbTypeName");
            }
            catch (Exception e) {
                dbTypeName = (String)metaObjectHandler.getValue("delegate.mappedStatement.configuration.environment.dataSource.dbType");
            }
            if (mapId.matches(".+ByPage$")) {
                ParameterHandler parameterHandler = (ParameterHandler)metaObjectHandler.getValue("delegate.parameterHandler");
                Object parameter = parameterHandler.getParameterObject();
                Object pageInfo = this.findPageInfo(parameter);
                this.checkAndSetPageInfo(pageInfo);
                String sql = (String)metaObjectHandler.getValue("delegate.boundSql.sql");
                this.queryTotalRecord(pageInfo, parameter, mappedStatement, (Connection)invocation.getArgs()[0]);
                String limitSql = sql;
                limitSql = dbTypeName != null && dbTypeName.equalsIgnoreCase("oracle") ? this.buildOraclePageSql(pageInfo, sql) : this.buildPageSql(pageInfo, sql);
                logger.info("\u751f\u6210\u7684\u5206\u9875\u67e5\u8be2sql\u4e3a\uff1a" + limitSql);
                metaObjectHandler.setValue("delegate.boundSql.sql", (Object)limitSql);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object arg0) {
        return Plugin.wrap((Object)arg0, (Interceptor)this);
    }

    public void setProperties(Properties arg0) {
    }

    private Object findPageInfo(Object parameterObject) {
        if (parameterObject instanceof Map) {
            Map parameterMap = (Map)parameterObject;
            Object pageInfo = parameterMap.get("pageInfoVO");
            if (pageInfo != null && ReflectUtility.invokeGetter(pageInfo, (String)"page", (boolean)false) != null) {
                return pageInfo;
            }
            pageInfo = parameterMap.get("pageInfo");
            if (pageInfo != null && ReflectUtility.invokeGetter(pageInfo, (String)"page", (boolean)false) != null) {
                return pageInfo;
            }
            for (Object key : parameterMap.keySet()) {
                Object obj = parameterMap.get(key);
                Integer page = (Integer)ReflectUtility.invokeGetter(obj, (String)"page", (boolean)false);
                if (page == null) continue;
                return obj;
            }
            return parameterObject;
        }
        return parameterObject;
    }

    public void checkAndSetPageInfo(Object pageInfo) {
        Integer size = (Integer)ReflectUtility.invokeGetter((Object)pageInfo, (String)"size", (boolean)false);
        Integer page = (Integer)ReflectUtility.invokeGetter((Object)pageInfo, (String)"page", (boolean)false);
        Integer rows = (Integer)ReflectUtility.invokeGetter((Object)pageInfo, (String)"rows", (boolean)false);
        size = size <= 0 ? BaseInfo.DEFAULT_MIN_PAGE_SIZE : size;
        page = page < 1 ? BaseInfo.DEFAULT_MIN_PAGE_NO : page;
        rows = size;
        ReflectUtility.invokeSetter((Object)pageInfo, (String)"size", (Object)size, (boolean)false);
        ReflectUtility.invokeSetter((Object)pageInfo, (String)"page", (Object)page, (boolean)false);
        ReflectUtility.invokeSetter((Object)pageInfo, (String)"rows", (Object)rows, (boolean)false);
    }

    protected String buildPageSql(Object pageInfo, String sql) {
        int page = (Integer)ReflectUtility.invokeGetter((Object)pageInfo, (String)"page", (boolean)false);
        int size = (Integer)ReflectUtility.invokeGetter((Object)pageInfo, (String)"size", (boolean)false);
        int offset = (page - 1) * size;
        return sql + " limit " + offset + "," + size;
    }

    protected String buildOraclePageSql(Object pageInfo, String sql) {
        int offset;
        int page = (Integer)ReflectUtility.invokeGetter((Object)pageInfo, (String)"page", (boolean)false);
        int size = (Integer)ReflectUtility.invokeGetter((Object)pageInfo, (String)"size", (boolean)false);
        int startRow = offset = (page - 1) * size;
        int endRow = offset + size;
        StringBuilder sqlBuilder = new StringBuilder(sql.length() + 120);
        if (startRow > 0) {
            sqlBuilder.append("SELECT * FROM ( ");
        }
        if (endRow > 0) {
            sqlBuilder.append(" SELECT TMP_PAGE.*, ROWNUM ROW_ID FROM ( ");
        }
        sqlBuilder.append(sql);
        if (endRow > 0) {
            sqlBuilder.append(" ) TMP_PAGE WHERE ROWNUM <= ");
            sqlBuilder.append(endRow);
        }
        if (startRow > 0) {
            sqlBuilder.append(" ) WHERE ROW_ID > ");
            sqlBuilder.append(startRow);
        }
        return sqlBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryTotalRecord(Object page, Object parameterObject, MappedStatement mappedStatement, Connection connection) throws SQLException {
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
        String sql = boundSql.getSql();
        String countSql = this.buildCountSql(sql);
        logger.info("\u751f\u6210\u7684\u67e5\u8be2\u603b\u9875\u6570\u7684sql\u4e3a:" + countSql);
        List parameterMappings = boundSql.getParameterMappings();
        BoundSql countBoundSql = new BoundSql(mappedStatement.getConfiguration(), countSql, parameterMappings, parameterObject);
        DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, parameterObject, countBoundSql);
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            Map additionalParameters = (Map)ReflectionTestUtils.getField((Object)boundSql, (String)"additionalParameters");
            if (additionalParameters != null && additionalParameters.size() > 0) {
                for (Map.Entry entry : additionalParameters.entrySet()) {
                    countBoundSql.setAdditionalParameter((String)entry.getKey(), entry.getValue());
                }
            }
            pstmt = connection.prepareStatement(countSql);
            parameterHandler.setParameters((PreparedStatement)pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int totalRecord = rs.getInt(1);
                ReflectUtility.invokeSetter((Object)page, (String)"total", (Object)totalRecord, (boolean)false);
                logger.info("\u67e5\u8be2\u5230\u7684\u603b\u9875\u6570\u4e3a:" + totalRecord);
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u67e5\u8be2\u603b\u9875\u6570sql\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    logger.error("\u5173\u95edResultSet\u65f6\u5f02\u5e38.", (Throwable)e);
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    logger.error("\u5173\u95edPreparedStatement\u65f6\u5f02\u5e38.", (Throwable)e);
                }
            }
        }
    }

    protected String buildCountSql(String sql) {
        return "select count(1) from (" + sql + ") t";
    }
}

