/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.util;

import com.irdstudio.sdk.ssm.util.DateTool;
import java.util.Date;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static String Separate_FenHao = ";";
    public static String Separate_Split = "\\|";
    public static String Separate_MaoHao = ":";
    public static String Separate_DengHao = "=";
    public static String Separate_DouHao = ",";
    public static String Separate_Xiahuaxian = "_";

    public static boolean isEmpty(String source) {
        return StringUtils.isEmpty((CharSequence)source);
    }

    public static boolean isNullorBank(String source) {
        return null == source || "".equals(source.trim());
    }

    public static boolean isStrEmpty(String str) {
        return StringUtil.isEmpty(str) || "null".equals(str.trim());
    }

    public static boolean isNotEmpty(String source) {
        return !StringUtil.isEmpty(source);
    }

    public static boolean isStrNotEmpty(String str) {
        return !StringUtil.isStrEmpty(str);
    }

    public static String nullToEmpty(String source) {
        return StringUtil.isStrEmpty(source) ? "" : source;
    }

    public static String nullToZero(String str) {
        return StringUtil.isStrEmpty(str) ? "0" : str.trim();
    }

    public static Long String2Long(String inStr) {
        try {
            if (inStr == null || "".equals(inStr.trim()) || "0".equals(inStr.trim())) {
                return null;
            }
            return Long.parseLong(inStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String clearHTML(String strValue) {
        int end;
        int begin;
        if ("".equals(strValue)) {
            return "";
        }
        if (strValue.indexOf("<") == -1) {
            return strValue;
        }
        while (strValue.toUpperCase().indexOf("<SCRIPT") > -1) {
            begin = strValue.toUpperCase().indexOf("<SCRIPT");
            end = strValue.toUpperCase().indexOf("</SCRIPT>");
            strValue = strValue.substring(0, begin) + strValue.substring(end + 9);
        }
        while (strValue.toUpperCase().indexOf("<IFRAME") > -1) {
            begin = strValue.toUpperCase().indexOf("<IFRAME");
            end = strValue.toUpperCase().indexOf("</IFRAME>");
            strValue = strValue.substring(0, begin) + strValue.substring(end + 9);
        }
        while (strValue.toUpperCase().indexOf("<NOSCRIPT") > -1) {
            begin = strValue.toUpperCase().indexOf("<NOSCRIPT");
            end = strValue.toUpperCase().indexOf("</NOSCRIPT>");
            strValue = strValue.substring(0, begin) + strValue.substring(end + 11);
        }
        while (strValue.toUpperCase().indexOf("<!--") > -1) {
            begin = strValue.indexOf("<!--");
            end = strValue.indexOf("-->");
            strValue = strValue.substring(0, begin) + strValue.substring(end + 3);
        }
        return strValue;
    }

    public static byte[] getBytesFromStr(String inStr) throws Exception {
        byte[] retBytes = inStr.getBytes("unicode");
        return retBytes;
    }

    public static String getStrFromBytes(byte[] inBytes) throws Exception {
        String retStr = new String(inBytes, "unicode");
        return retStr;
    }

    public static final String subStr(String strAll, int strLen) {
        String strNew = StringUtil.nullToEmpty(strAll);
        String myStr = "";
        myStr = strNew.length() >= strLen ? strNew.substring(0, strLen) : strNew;
        return myStr;
    }

    public static String replace(String s, String s1, String s2) {
        if (s == null) {
            return null;
        }
        int i = 0;
        if ((i = s.indexOf(s1, i)) >= 0) {
            char[] ac = s.toCharArray();
            char[] ac1 = s2.toCharArray();
            int j = s1.length();
            StringBuffer stringbuffer = new StringBuffer(ac.length);
            stringbuffer.append(ac, 0, i).append(ac1);
            int k = i += j;
            while ((i = s.indexOf(s1, i)) > 0) {
                stringbuffer.append(ac, k, i - k).append(ac1);
                k = i += j;
            }
            stringbuffer.append(ac, k, ac.length - k);
            return stringbuffer.toString();
        }
        return s;
    }

    public static String[] split(String source, String seperate) {
        if (source == null) {
            String[] wordLists = new String[]{source};
            return wordLists;
        }
        StringTokenizer st = new StringTokenizer(source, seperate);
        int total = st.countTokens();
        String[] wordLists = new String[total];
        for (int i = 0; i < total; ++i) {
            wordLists[i] = st.nextToken();
        }
        return wordLists;
    }

    public static String[] split(String source, char delim) {
        return StringUtil.split(source, String.valueOf(delim));
    }

    public static String combineArray(String[] array, String delim) {
        if (array == null || array.length == 0) {
            return "";
        }
        int length = array.length - 1;
        if (delim == null) {
            delim = "";
        }
        StringBuffer result = new StringBuffer(length * 8);
        for (int i = 0; i < length; ++i) {
            result.append(array[i]);
            result.append(delim);
        }
        result.append(array[length]);
        return result.toString();
    }

    public static String fillString(char c, int length) {
        String ret = "";
        for (int i = 0; i < length; ++i) {
            ret = ret + c;
        }
        return ret;
    }

    public static boolean contains(String[] strings, String string, boolean caseSensitive) {
        for (int i = 0; i < strings.length; ++i) {
            if (!(caseSensitive ? strings[i].equals(string) : strings[i].equalsIgnoreCase(string))) continue;
            return true;
        }
        return false;
    }

    public static int getByteLength(String source) {
        int len = 0;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            int highByte = c >>> 8;
            len += highByte == 0 ? 1 : 2;
        }
        return len;
    }

    public static boolean isDoubleByte(char c) {
        return c >>> 8 != 0;
    }

    public static boolean matchString(String pattern, String string) {
        int stringLength = string.length();
        int stringIndex = 0;
        for (int patternIndex = 0; patternIndex < pattern.length(); ++patternIndex) {
            char c = pattern.charAt(patternIndex);
            if (c == '%') {
                while (stringIndex < stringLength) {
                    if (StringUtil.matchString(pattern.substring(patternIndex + 1), string.substring(stringIndex))) {
                        return true;
                    }
                    ++stringIndex;
                }
                continue;
            }
            if (stringIndex >= stringLength || c != string.charAt(stringIndex)) {
                return false;
            }
            ++stringIndex;
        }
        return stringIndex == stringLength;
    }

    public static String addtoTotalString(String destString, String sourceString, String seperator) {
        if (StringUtil.isEmpty(destString)) {
            return sourceString;
        }
        return destString + seperator + sourceString;
    }

    private static int getIndexOfTotalString(String destString, String remString, String separator) {
        if (destString == null) {
            return -1;
        }
        String tempTotalString = separator + destString + separator;
        int index = tempTotalString.indexOf(separator + remString + separator);
        if (index != 0 && index != -1) {
            --index;
        }
        return index;
    }

    public static String removeFromTotalString(String destString, String remString, String separator) {
        if (destString == null) {
            return "";
        }
        int index = StringUtil.getIndexOfTotalString(destString, remString, separator);
        if (index == -1) {
            return destString;
        }
        if (index == 0) {
            if (destString.equals(remString)) {
                return "";
            }
            return destString.substring(remString.length() + 1);
        }
        if (destString.length() == index + remString.length()) {
            return destString.substring(0, index - 1);
        }
        return destString.substring(0, index) + destString.substring(remString.length() + 1 + index);
    }

    public static String object2String(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Date) {
            return DateTool.getDateTimeStr((Date)obj);
        }
        return obj.toString();
    }

    public static boolean isChinese(String str) {
        Pattern pattern = Pattern.compile("[\u0391-\uffe5]+$");
        return pattern.matcher(str).matches();
    }

    public static String htmlencode(String str) {
        if (str == null) {
            return null;
        }
        return StringUtil.replace("\"", "&quot;", StringUtil.replace("<", "&lt;", str));
    }

    public static String htmldecode(String str) {
        if (str == null) {
            return null;
        }
        return StringUtil.replace("&quot;", "\"", StringUtil.replace("&lt;", "<", str));
    }

    public static String htmlshow(String str) {
        if (str == null) {
            return null;
        }
        str = StringUtil.replace("<", "&lt;", str);
        str = StringUtil.replace(" ", "&nbsp;", str);
        str = StringUtil.replace("\r\n", "<br/>", str);
        str = StringUtil.replace("\n", "<br/>", str);
        str = StringUtil.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;", str);
        return str;
    }

    public static String toLength(String str, int length) {
        if (str == null) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        try {
            if (str.getBytes("GBK").length <= length) {
                return str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer buff = new StringBuffer();
        int index = 0;
        length -= 3;
        while (length > 0) {
            char c = str.charAt(index);
            if (c < '\u0080') {
                --length;
            } else {
                --length;
                --length;
            }
            buff.append(c);
            ++index;
        }
        buff.append("...");
        return buff.toString();
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]+$");
        return pattern.matcher(str).matches();
    }

    public static boolean isDouble(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?\\d+\\.\\d+$");
        return pattern.matcher(str).matches();
    }

    public static boolean isLetter(String str) {
        if (str == null || str.length() < 0) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\w\\.-_]*");
        return pattern.matcher(str).matches();
    }

    public static String parse(String content) {
        String email = null;
        if (content == null || content.length() < 1) {
            return email;
        }
        String token = "@";
        String preHalf = "";
        String sufHalf = "";
        int beginPos = content.indexOf(token);
        if (beginPos > -1) {
            int i;
            String s = null;
            for (i = beginPos; i > 0 && StringUtil.isLetter(s = content.substring(i - 1, i)); --i) {
                preHalf = s + preHalf;
            }
            for (i = beginPos + 1; i < content.length() && StringUtil.isLetter(s = content.substring(i, i + 1)); ++i) {
                sufHalf = sufHalf + s;
            }
            email = preHalf + "@" + sufHalf;
            if (StringUtil.isEmail(email)) {
                return email;
            }
        }
        return null;
    }

    public static boolean isEmail(String email) {
        if (email == null || email.length() < 1 || email.length() > 256) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$");
        return pattern.matcher(email).matches();
    }

    public static String hangeToBig(String str) {
        double value;
        try {
            value = Double.parseDouble(str.trim());
        }
        catch (Exception e) {
            return null;
        }
        char[] hunit = new char[]{'\u62fe', '\u4f70', '\u4edf'};
        char[] vunit = new char[]{'\u4e07', '\u4ebf'};
        char[] digit = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
        long midVal = (long)(value * 100.0);
        String valStr = String.valueOf(midVal);
        String head = valStr.substring(0, valStr.length() - 2);
        String rail = valStr.substring(valStr.length() - 2);
        String prefix = "";
        String suffix = "";
        suffix = "00".equals(rail) ? "\u6574" : digit[rail.charAt(0) - 48] + "\u89d2" + digit[rail.charAt(1) - 48] + "\u5206";
        char[] chDig = head.toCharArray();
        int zero = 48;
        int zeroSerNum = 0;
        for (int i = 0; i < chDig.length; ++i) {
            int idx = (chDig.length - i - 1) % 4;
            int vidx = (chDig.length - i - 1) / 4;
            if (chDig[i] == '0') {
                zeroSerNum = (byte)(zeroSerNum + 1);
                if (zero == 48) {
                    zero = digit[0];
                    continue;
                }
                if (idx != 0 || vidx <= 0 || zeroSerNum >= 4) continue;
                prefix = prefix + vunit[vidx - 1];
                zero = 48;
                continue;
            }
            zeroSerNum = 0;
            if (zero != 48) {
                prefix = prefix + (char)zero;
                zero = 48;
            }
            prefix = prefix + digit[chDig[i] - 48];
            if (idx > 0) {
                prefix = prefix + hunit[idx - 1];
            }
            if (idx != 0 || vidx <= 0) continue;
            prefix = prefix + vunit[vidx - 1];
        }
        if (prefix.length() > 0) {
            prefix = prefix + '\u5706';
        }
        return prefix + suffix;
    }

    public static String encoding(String src) {
        if (src == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (src != null) {
            src = src.trim();
            block11: for (int pos = 0; pos < src.length(); ++pos) {
                switch (src.charAt(pos)) {
                    case '\"': {
                        result.append("&quot;");
                        continue block11;
                    }
                    case '<': {
                        result.append("&lt;");
                        continue block11;
                    }
                    case '>': {
                        result.append("&gt;");
                        continue block11;
                    }
                    case '\'': {
                        result.append("&apos;");
                        continue block11;
                    }
                    case '&': {
                        result.append("&amp;");
                        continue block11;
                    }
                    case '%': {
                        result.append("&pc;");
                        continue block11;
                    }
                    case '_': {
                        result.append("&ul;");
                        continue block11;
                    }
                    case '#': {
                        result.append("&shap;");
                        continue block11;
                    }
                    case '?': {
                        result.append("&ques;");
                        continue block11;
                    }
                    default: {
                        result.append(src.charAt(pos));
                    }
                }
            }
        }
        return result.toString();
    }

    public static String decoding(String src) {
        if (src == null) {
            return "";
        }
        String result = src;
        result = result.replace("&quot;", "\"").replace("&apos;", "'");
        result = result.replace("&lt;", "<").replace("&gt;", ">");
        result = result.replace("&amp;", "&");
        result = result.replace("&pc;", "%").replace("&ul", "_");
        result = result.replace("&shap;", "#").replace("&ques", "?");
        return result;
    }

    public static String uniteTwoStringBySemicolon(String targetString, String addString) {
        return StringUtil.uniteTwoStringBySemicolon(targetString, addString, ";");
    }

    public static String uniteTwoStringBySemicolon(String targetString, String addString, String separator) {
        return StringUtil.isEmpty(addString) ? targetString : (StringUtil.isEmpty(targetString) ? addString : targetString + (StringUtil.isEmpty(separator) ? ";" : separator) + addString);
    }

    public static String handleSpecilChar(String param) {
        return param.replaceAll("'", "\u2019").replaceAll("\"", "\u201d").replaceAll(">", "\ufe65").replaceAll("<", "\ufe64");
    }

    public static String removeEndStr(String str, String remove) {
        return StringUtil.isEmpty(str) || StringUtil.isEmpty(remove) ? str : str.substring(0, str.length() - remove.length());
    }

    public static String number2String(Number number) {
        return Objects.nonNull(number) ? String.valueOf(number) : null;
    }
}

