/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.api.rest;

import com.irdstudio.sdk.admin.service.facade.SRoleService;
import com.irdstudio.sdk.admin.service.facade.SRoleuserService;
import com.irdstudio.sdk.admin.service.vo.SRoleVO;
import com.irdstudio.sdk.admin.service.vo.SRoleuserVO;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SRoleController
extends AbstractController {
    @Autowired
    @Qualifier(value="sRoleServiceImpl")
    private SRoleService sRoleService;
    @Autowired
    @Qualifier(value="sRoleuserServiceImpl")
    private SRoleuserService sRoleuserService;

    @RequestMapping(value={"/s/roles"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRoleVO>> querySRoleAll(SRoleVO vo) {
        List<SRoleVO> outputVo = this.sRoleService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roles/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRoleVO>> queryAllByCondition(SRoleVO vo) {
        List<SRoleVO> outputVo = this.sRoleService.queryAllByCondition(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/role/{roleno}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SRoleVO> queryByPk(@PathVariable(value="roleno") String roleno) {
        SRoleVO inVo = new SRoleVO();
        inVo.setRoleno(new String(roleno));
        SRoleVO outputVo = this.sRoleService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/s/role"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SRoleVO inSRoleVo) {
        int outputVo = this.sRoleService.deleteByPk(inSRoleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/role"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SRoleVO inSRoleVo) {
        int outputVo = this.sRoleService.updateByPk(inSRoleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/role"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSRole(@RequestBody SRoleVO inSRoleVo) {
        int outputVo = this.sRoleService.insertSRole(inSRoleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roles/not/used"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRoleVO>> qryNotSelectSRoleAll(SRoleuserVO sRoleuserVO) {
        List<SRoleVO> outputVo = null;
        String actorNo = sRoleuserVO.getActorno();
        if (StringUtil.isNullorBank((String)actorNo)) {
            return this.getResponseData(null);
        }
        List<String> roleNos = this.getRoleNosByActorNo(actorNo);
        outputVo = Objects.nonNull(roleNos) && roleNos.size() > 0 ? this.sRoleService.queryAllFilterList(roleNos) : this.sRoleService.queryAllByCondition(new SRoleVO());
        return this.getResponseData(outputVo);
    }

    private List<String> getRoleNosByActorNo(String actorNo) {
        SRoleuserVO sRoleuserVO = new SRoleuserVO();
        sRoleuserVO.setActorno(actorNo);
        List<SRoleuserVO> sRoleUserVOS = this.sRoleuserService.queryAllByCondition(sRoleuserVO);
        if (Objects.isNull(sRoleUserVOS) && sRoleUserVOS.size() == 0) {
            return null;
        }
        return sRoleUserVOS.stream().map(SRoleuserVO::getRoleno).collect(Collectors.toList());
    }

    @RequestMapping(value={"/s/role/user/roles"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRoleVO>> queryUserRoleListByPage(SRoleVO vo) {
        List<SRoleVO> outputVo = this.sRoleService.queryUserRoleListByPage(vo);
        return this.getResponseData(outputVo);
    }
}

