/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.util;

import com.irdstudio.sdk.ssm.vo.ResponseVO;
import com.irdstudio.sdk.ssm.web.http.impl.DefRestfulHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class AgentApiUtil {
    protected static Logger logger = LoggerFactory.getLogger(AgentApiUtil.class);

    public static ResponseVO activeAgent(String agentUrl, String agentId) {
        ResponseVO response = null;
        try {
            DefRestfulHttpClient defaultClient = new DefRestfulHttpClient();
            response = (ResponseVO)defaultClient.httpCall(agentUrl + "/active?agentId={agentId}", HttpMethod.GET, null, ResponseVO.class, new Object[]{agentId});
        }
        catch (Exception e) {
            response = new ResponseVO();
            response.setFlag("fail");
            response.setMsg("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl);
            logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl, (Throwable)e);
        }
        return response;
    }

    public static ResponseVO stopAgent(String agentUrl, String agentId) {
        ResponseVO response = null;
        try {
            DefRestfulHttpClient defaultClient = new DefRestfulHttpClient();
            response = (ResponseVO)defaultClient.httpCall(agentUrl + "/stop?agentId={agentId}", HttpMethod.GET, null, ResponseVO.class, new Object[]{agentId});
        }
        catch (Exception e) {
            response = new ResponseVO();
            response.setFlag("fail");
            response.setMsg("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl);
            logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl, (Throwable)e);
        }
        return response;
    }

    public static ResponseVO actionBatch(String agentUrl, String batchSerialNo, String batchId, String batchAction) {
        ResponseVO response = null;
        try {
            DefRestfulHttpClient defaultClient = new DefRestfulHttpClient();
            response = (ResponseVO)defaultClient.httpCall(agentUrl + "/batch/start?batchSerialNo={batchSerialNo}&batchId={batchId}&batchAction={batchAction}", HttpMethod.GET, null, ResponseVO.class, new Object[]{batchSerialNo, batchId, batchAction});
        }
        catch (Exception e) {
            response = new ResponseVO();
            response.setFlag("fail");
            response.setMsg("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl);
            logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl, (Throwable)e);
        }
        return response;
    }

    public static ResponseVO actionBpmBatch(String agentUrl, String batchId, String batchSerialNo, String batchAction) {
        ResponseVO response = null;
        try {
            DefRestfulHttpClient defaultClient = new DefRestfulHttpClient();
            response = (ResponseVO)defaultClient.httpCall(agentUrl + "/bpm/start?batchId={batchId}&batchSerialNo={batchSerialNo}&batchAction={batchAction}", HttpMethod.GET, null, ResponseVO.class, new Object[]{batchId, batchSerialNo, batchAction});
        }
        catch (Exception e) {
            response = new ResponseVO();
            response.setFlag("fail");
            response.setMsg("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl);
            logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl, (Throwable)e);
        }
        return response;
    }

    public static String getBatchLogs(String agentUrl, String batchId) throws Exception {
        DefRestfulHttpClient defaultClient = new DefRestfulHttpClient();
        ResponseVO responseVO = (ResponseVO)defaultClient.httpCall(agentUrl + "/batch/log?batchId={batchId}", HttpMethod.GET, null, ResponseVO.class, new Object[]{batchId});
        if ("fail".equals(responseVO.getFlag())) {
            throw new Exception(responseVO.getMsg());
        }
        return responseVO.getMsg();
    }

    public static String getBatchLogs(String agentUrl, String batchId, String batchSerialNo) throws Exception {
        DefRestfulHttpClient defaultClient = new DefRestfulHttpClient();
        ResponseVO responseVO = (ResponseVO)defaultClient.httpCall(agentUrl + "/batch/log?batchId={batchId}&batchSerialNo={batchSerialNo}", HttpMethod.GET, null, ResponseVO.class, new Object[]{batchId, batchSerialNo});
        if ("fail".equals(responseVO.getFlag())) {
            throw new Exception(responseVO.getMsg());
        }
        return responseVO.getMsg();
    }
}

