/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.util;

import com.irdstudio.sdk.ssm.constant.Sex;
import com.irdstudio.sdk.ssm.util.StringUtil;
import com.irdstudio.sdk.ssm.util.TimeUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class ValidationUtils {
    public static final String EMAIL = "\\w+(\\.\\w+)*@\\w+(\\.\\w+)+";
    public static final String PHONE = "(^(\\d{2,4}[-_\uff0d\ufffd?\ufffd]?)?\\d{3,8}([-_\uff0d\ufffd?\ufffd]?\\d{3,8})?([-_\uff0d\ufffd?\ufffd]?\\d{1,7})?$)|(^0?1[35]\\d{9}$)";
    public static final String MOBILE = "^(13[0-9]|14[0-9]|15[0-9]|17[0-9]|18[0-9])\\d{8}$";
    public static final String INTEGER_NEGATIVE = "^[1-9]\\d*|0$|^[1-9]\\d*\\.0+?";
    public static final String INTEGER_POSITIVE = "^-[1-9]\\d*|0$";
    public static final String CODE = "[0-9]\\d{5}(?!\\d)";
    public static final String STR_SPECIAL = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\ufffd?%\u2026\ufffd??&*\uff08\uff09\u2014\ufffd??+|{}\u3010\ufffd?\ufffd\ufffd?\ufffd\uff1b\uff1a\ufffd?\ufffd\ufffd?\ufffd\ufffd?\ufffd\ufffd?\ufffd\uff0c\u3001\uff1f]";
    public static final String DATE_FORMAT1 = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)";
    public static final String URL = "^(http|www|ftp|)?(://)?(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*((:\\d+)?)(/(\\w+(-\\w+)*))*(\\.?(\\w)*)(\\?)?(((\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*(\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*)*(\\w*)*)$";
    public static final String ORG_CODE = "^[A-Z0-9]{8}-[A-Z0-9]$";
    public static final String STR_NUM = "^[0-9]+$";
    public static final String CURRENCY = "^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){1,2})?$";
    public static final String DECIMALS_NUM = "([1-9]\\d*\\.?\\d*)|(0\\.\\d*)";
    private static final String SUCCESS = "true";
    private static final String BAD_LENGTH = "\u94f6\u884c\u5361\u53f7\u957f\u5ea6\u5fc5\u987b\u572816\u523019\u4e4b\u95f4";
    private static final String NOT_NUMBER = "\u94f6\u884c\u5361\u5fc5\u987b\u5168\u90e8\u4e3a\u6570\u5b57";
    private static final String ILLEGAL_NUMBER = "\u94f6\u884c\u5361\u4e0d\u7b26\u5408\u89c4\u5219";
    private static final String strBin = "10,18,30,35,37,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,58,60,62,65,68,69,84,87,88,94,95,98,99,90";
    private static int[] wi = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static char[] ai = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    private static String regex = "^\\d{17}[0-9Xx]{1}$";

    public static boolean isDecimalsNum(String str) {
        return ValidationUtils.regular(str, DECIMALS_NUM);
    }

    public static String nulltoStr(String str, String defaut) {
        return StringUtils.isEmpty((Object)str) ? defaut : str;
    }

    public static boolean isEmail(String str) {
        return ValidationUtils.regular(str, EMAIL);
    }

    public static boolean isPhone(String str) {
        return ValidationUtils.regular(str, PHONE);
    }

    public static boolean isMobile(String str) {
        return ValidationUtils.regular(str, MOBILE);
    }

    public static boolean isUrl(String str) {
        return ValidationUtils.regular(str, URL);
    }

    public static boolean isINTEGER_NEGATIVE(String str) {
        return ValidationUtils.regular(str, INTEGER_NEGATIVE);
    }

    public static boolean isINTEGER_POSITIVE(String str) {
        return ValidationUtils.regular(str, INTEGER_POSITIVE);
    }

    public static boolean isDate1(String str) {
        return ValidationUtils.regular(str, DATE_FORMAT1);
    }

    public static boolean isLengOut(String str, int leng) {
        return StringUtils.isEmpty((Object)str) ? false : str.trim().length() > leng;
    }

    public static boolean isCode(String str) {
        return ValidationUtils.regular(str, CODE);
    }

    public static String filterStr(String str) {
        Pattern p = Pattern.compile(STR_SPECIAL);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static boolean isOrgCode(String str) {
        return ValidationUtils.regular(str, ORG_CODE);
    }

    public static boolean isStrNUM(String str) {
        return ValidationUtils.regular(str, STR_NUM);
    }

    public static boolean isCurrency(String str) {
        return ValidationUtils.regular(str, CURRENCY);
    }

    private static boolean regular(String str, String pattern) {
        if (null == str || str.trim().length() <= 0) {
            return false;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    private static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isDataFormat(String str) {
        boolean flag = false;
        String regxStr = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$";
        Pattern pattern1 = Pattern.compile(regxStr);
        Matcher isNo = pattern1.matcher(str);
        if (isNo.matches()) {
            flag = true;
        }
        return flag;
    }

    private static Hashtable getAreaCode() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("11", "\u5317\u4eac");
        hashtable.put("12", "\u5929\u6d25");
        hashtable.put("13", "\u6cb3\u5317");
        hashtable.put("14", "\u5c71\u897f");
        hashtable.put("15", "\u5185\u8499\u53e4");
        hashtable.put("21", "\u8fbd\u5b81");
        hashtable.put("22", "\u5409\u6797");
        hashtable.put("23", "\u9ed1\u9f99\u6c5f");
        hashtable.put("31", "\u4e0a\u6d77");
        hashtable.put("32", "\u6c5f\u82cf");
        hashtable.put("33", "\u6d59\u6c5f");
        hashtable.put("34", "\u5b89\u5fbd");
        hashtable.put("35", "\u798f\u5efa");
        hashtable.put("36", "\u6c5f\u897f");
        hashtable.put("37", "\u5c71\u4e1c");
        hashtable.put("41", "\u6cb3\u5357");
        hashtable.put("42", "\u6e56\u5317");
        hashtable.put("43", "\u6e56\u5357");
        hashtable.put("44", "\u5e7f\u4e1c");
        hashtable.put("45", "\u5e7f\u897f");
        hashtable.put("46", "\u6d77\u5357");
        hashtable.put("50", "\u91cd\u5e86");
        hashtable.put("51", "\u56db\u5ddd");
        hashtable.put("52", "\u8d35\u5dde");
        hashtable.put("53", "\u4e91\u5357");
        hashtable.put("54", "\u897f\u85cf");
        hashtable.put("61", "\u9655\u897f");
        hashtable.put("62", "\u7518\u8083");
        hashtable.put("63", "\u9752\u6d77");
        hashtable.put("64", "\u5b81\u590f");
        hashtable.put("65", "\u65b0\u7586");
        hashtable.put("71", "\u53f0\u6e7e");
        hashtable.put("81", "\u9999\u6e2f");
        hashtable.put("82", "\u6fb3\u95e8");
        hashtable.put("91", "\u56fd\u5916");
        return hashtable;
    }

    public static boolean idCardValidate(String IDStr) throws ParseException, NumberFormatException, ParseException {
        Hashtable h;
        IDStr = IDStr.trim().toUpperCase();
        String[] ValCodeArr = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
        String[] Wi = new String[]{"7", "9", "10", "5", "8", "4", "2", "1", "6", "3", "7", "9", "10", "5", "8", "4", "2"};
        String Ai = "";
        if (IDStr.length() != 15 && IDStr.length() != 18) {
            return false;
        }
        if (IDStr.length() == 18) {
            Ai = IDStr.substring(0, 17);
        } else if (IDStr.length() == 15) {
            Ai = IDStr.substring(0, 6) + "19" + IDStr.substring(6, 15);
        }
        if (!ValidationUtils.isNumeric(Ai)) {
            return false;
        }
        String strYear = Ai.substring(6, 10);
        String strMonth = Ai.substring(10, 12);
        String strDay = Ai.substring(12, 14);
        if (!ValidationUtils.isDataFormat(strYear + "-" + strMonth + "-" + strDay)) {
            return false;
        }
        GregorianCalendar gc = new GregorianCalendar();
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
        if (gc.get(1) - Integer.parseInt(strYear) > 150 || gc.getTime().getTime() - s.parse(strYear + "-" + strMonth + "-" + strDay).getTime() < 0L) {
            return false;
        }
        if (Integer.parseInt(strMonth) > 12 || Integer.parseInt(strMonth) == 0) {
            return false;
        }
        if (Integer.parseInt(strDay) > 31 || Integer.parseInt(strDay) == 0) {
            return false;
        }
        if ("02".equals(strMonth)) {
            if (Integer.parseInt(strYear) % 400 == 0 ? Integer.parseInt(strDay) > 30 || Integer.parseInt(strDay) == 0 : Integer.parseInt(strDay) > 29 || Integer.parseInt(strDay) == 0) {
                return false;
            }
            if (Integer.parseInt(strYear) % 4 == 0 && (Integer.parseInt(strYear) % 100 != 0 ? Integer.parseInt(strDay) > 30 || Integer.parseInt(strDay) == 0 : Integer.parseInt(strDay) > 29 || Integer.parseInt(strDay) == 0)) {
                return false;
            }
        }
        if ((h = ValidationUtils.getAreaCode()).get(Ai.substring(0, 2)) == null) {
            return false;
        }
        int TotalmulAiWi = 0;
        for (int i = 0; i < 17; ++i) {
            TotalmulAiWi += Integer.parseInt(String.valueOf(Ai.charAt(i))) * Integer.parseInt(Wi[i]);
        }
        int modValue = TotalmulAiWi % 11;
        String strVerifyCode = ValCodeArr[modValue];
        Ai = Ai + strVerifyCode;
        if (IDStr.length() == 18) {
            return Ai.equals(IDStr);
        }
        return true;
    }

    public static boolean validPhoneNum(String checkType, String phoneNum) {
        boolean flag = false;
        Pattern p1 = null;
        Pattern p2 = null;
        Matcher m = null;
        p1 = Pattern.compile("^(((13[0-9]{1})|(15[0-9]{1})|(18[0-9]{1})|(17[0-9]{1}))+\\d{8})?$");
        p2 = Pattern.compile("^(0[0-9]{2,3}\\-)?([1-9][0-9]{6,7})$");
        if ("0".equals(checkType)) {
            System.out.println(phoneNum.length());
            if (phoneNum.length() != 11) {
                return false;
            }
            m = p1.matcher(phoneNum);
            flag = m.matches();
        } else if ("1".equals(checkType)) {
            if (phoneNum.length() < 11 || phoneNum.length() >= 16) {
                return false;
            }
            m = p2.matcher(phoneNum);
            flag = m.matches();
        } else if ("2".equals(checkType)) {
            if (!(phoneNum.length() == 11 && p1.matcher(phoneNum).matches() || phoneNum.length() < 16 && p2.matcher(phoneNum).matches())) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    public static String luhmCheck(String bankno) {
        if (bankno.length() < 16 || bankno.length() > 19) {
            return BAD_LENGTH;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher match = pattern.matcher(bankno);
        if (!match.matches()) {
            return NOT_NUMBER;
        }
        if (strBin.indexOf(bankno.substring(0, 2)) == -1) {
            return "\u94f6\u884c\u5361\u53f7\u5f00\u59346\u4f4d\u4e0d\u7b26\u5408\u89c4\u8303";
        }
        int lastNum = Integer.parseInt(bankno.substring(bankno.length() - 1, bankno.length()));
        String first15Num = bankno.substring(0, bankno.length() - 1);
        char[] newArr = new char[first15Num.length()];
        char[] tempArr = first15Num.toCharArray();
        for (int i = 0; i < tempArr.length; ++i) {
            newArr[tempArr.length - 1 - i] = tempArr[i];
        }
        int[] arrSingleNum = new int[newArr.length];
        int[] arrSingleNum2 = new int[newArr.length];
        int[] arrDoubleNum = new int[newArr.length];
        for (int j = 0; j < newArr.length; ++j) {
            if ((j + 1) % 2 == 1) {
                if ((newArr[j] - 48) * 2 < 9) {
                    arrSingleNum[j] = (newArr[j] - 48) * 2;
                    continue;
                }
                arrSingleNum2[j] = (newArr[j] - 48) * 2;
                continue;
            }
            arrDoubleNum[j] = newArr[j] - 48;
        }
        int[] arrSingleNumChild = new int[newArr.length];
        int[] arrSingleNum2Child = new int[newArr.length];
        for (int h = 0; h < arrSingleNum2.length; ++h) {
            arrSingleNumChild[h] = arrSingleNum2[h] % 10;
            arrSingleNum2Child[h] = arrSingleNum2[h] / 10;
        }
        int sumSingleNum = 0;
        int sumDoubleNum = 0;
        int sumSingleNumChild = 0;
        int sumSingleNum2Child = 0;
        int sumTotal = 0;
        for (int m = 0; m < arrSingleNum.length; ++m) {
            sumSingleNum += arrSingleNum[m];
        }
        for (int n = 0; n < arrDoubleNum.length; ++n) {
            sumDoubleNum += arrDoubleNum[n];
        }
        for (int p = 0; p < arrSingleNumChild.length; ++p) {
            sumSingleNumChild += arrSingleNumChild[p];
            sumSingleNum2Child += arrSingleNum2Child[p];
        }
        sumTotal = sumSingleNum + sumDoubleNum + sumSingleNumChild + sumSingleNum2Child;
        int k = sumTotal % 10 == 0 ? 10 : sumTotal % 10;
        int luhm = 10 - k;
        if (lastNum == luhm) {
            return SUCCESS;
        }
        return ILLEGAL_NUMBER;
    }

    public static boolean verifyIdNumber(String id) {
        String last1_;
        boolean flag = false;
        if (StringUtil.isStrEmpty(id)) {
            return false;
        }
        if (id.length() != 18) {
            return false;
        }
        if (!id.toUpperCase().matches(regex)) {
            return false;
        }
        String pre17 = id.substring(0, 17);
        String last1 = id.substring(17, 18).toUpperCase();
        if (last1.equals(last1_ = ValidationUtils.getLastOne(pre17))) {
            flag = true;
        }
        return flag;
    }

    private static String getLastOne(String pre17) {
        int total = 0;
        for (int i = 0; i < pre17.length(); ++i) {
            int n = Integer.parseInt("" + pre17.charAt(i));
            total += n * wi[i];
        }
        int lastOne = total % 11;
        return String.valueOf(ai[lastOne]);
    }

    public static Sex getSexFromIdNumber(String id) {
        int last2 = Integer.parseInt(id.substring(16, 17));
        return last2 % 2 == 0 ? Sex.FEMALE : Sex.MALE;
    }

    public static boolean isMale(String id) {
        return Sex.MALE.equals((Object)ValidationUtils.getSexFromIdNumber(id));
    }

    public static boolean isFemale(String id) {
        return Sex.FEMALE.equals((Object)ValidationUtils.getSexFromIdNumber(id));
    }

    public static String getBirthdayFromIdNumber(String id) {
        return id.substring(6, 10) + "-" + id.substring(10, 12) + "-" + id.substring(12, 14);
    }

    public static String getLast4Numbers(String id) {
        return id.substring(14, 18);
    }

    public static int getAgeFromIdNumber(String id) {
        int age = 0;
        String birthday = ValidationUtils.getBirthdayFromIdNumber(id);
        String currDay = TimeUtil.getCurDate();
        int by = Integer.parseInt(birthday.substring(0, 4));
        int bm = Integer.parseInt(birthday.substring(5, 7));
        int bd = Integer.parseInt(birthday.substring(8, 10));
        int cy = Integer.parseInt(currDay.substring(0, 4));
        int cm = Integer.parseInt(currDay.substring(5, 7));
        int cd = Integer.parseInt(currDay.substring(8, 10));
        age = cy - by;
        if (cm < bm) {
            --age;
        } else if (cm == bm) {
            age = cd <= bd ? --age : age;
        }
        return age < 0 ? 0 : age;
    }
}

