/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans;

import com.irdstudio.sdk.beans.ssm.session.SessionManager;
import com.irdstudio.sdk.beans.ssm.web.filter.E4AFilter;
import javax.servlet.Filter;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="'${e4a.integer.type}'=='L'")
public class LocalE4AConfiguration {
    @Value(value="${e4a.sessionTimeOut:3600000}")
    private int sessionTimeOut;
    @Value(value="${e4a.allowUrl:/**/*}")
    private String allowUrl;

    @Bean
    @ConditionalOnExpression(value="'${e4a.integer.type}'=='L'")
    public SessionManager sessionManager() {
        SessionManager sessionManager = new SessionManager();
        sessionManager.setSessionTimeOut(this.sessionTimeOut);
        return sessionManager;
    }

    public Filter e4aFilter() {
        E4AFilter e4AFilter = new E4AFilter();
        return e4AFilter;
    }

    @Bean
    @ConditionalOnExpression(value="'${e4a.integer.type}'=='L'")
    public FilterRegistrationBean e4aFilterReg() {
        FilterRegistrationBean reg = new FilterRegistrationBean();
        reg.setFilter(this.e4aFilter());
        reg.addInitParameter("allowUrl", this.allowUrl);
        reg.addUrlPatterns(new String[]{"/*"});
        reg.setName("e4aFilter");
        reg.setOrder(2);
        return reg;
    }

    @Configuration(value="ScanAdminConfiguration")
    @ConditionalOnExpression(value="'${e4a.integer.type}'=='L'")
    @ComponentScan(value={"com.irdstudio.sdk.beans.admin"})
    @MapperScan(value={"com.irdstudio.sdk.beans.admin.dao"})
    public static class ScanAdminConfiguration {
    }
}

