/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans;

import com.irdstudio.sdk.beans.ssm.session.SessionManager;
import com.irdstudio.sdk.beans.ssm.web.filter.E4ACasFilter;
import javax.servlet.Filter;
import org.jasig.cas.client.boot.configuration.CasClientConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnExpression(value="'${e4a.integer.type}'=='U'")
public class UnityE4AConfiguration {
    @Value(value="${e4a.sessionTimeOut:3600000}")
    private int sessionTimeOut;
    @Value(value="${e4a.allowUrl:/**/*}")
    private String allowUrl;
    @Value(value="cas.server-url-prefix:}")
    private String casServerUrl;

    @Bean
    @ConditionalOnExpression(value="'${e4a.integer.type}'=='U'")
    public SessionManager sessionManager() {
        SessionManager sessionManager = new SessionManager();
        sessionManager.setSessionTimeOut(this.sessionTimeOut);
        return sessionManager;
    }

    public Filter e4aCasFilter() {
        E4ACasFilter e4AFilter = new E4ACasFilter();
        return e4AFilter;
    }

    @Bean
    @ConditionalOnExpression(value="'${e4a.integer.type}'=='U'")
    public FilterRegistrationBean e4aCasFilterReg() {
        FilterRegistrationBean reg = new FilterRegistrationBean();
        reg.setFilter(this.e4aCasFilter());
        reg.addInitParameter("casServerUrl", this.casServerUrl);
        reg.addUrlPatterns(new String[]{"/*"});
        reg.setName("e4aFilter");
        reg.setOrder(2);
        return reg;
    }

    @Configuration(value="EnableCas")
    @ConditionalOnExpression(value="'${e4a.integer.type}'=='U'")
    @Import(value={CasClientConfiguration.class})
    public static class EnableCas {
    }
}

