/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.admin.api.rest;

import com.auth0.jwt.interfaces.Claim;
import com.irdstudio.sdk.beans.admin.service.facade.E4AServiceSsm;
import com.irdstudio.sdk.beans.admin.service.vo.AuthInfoVO;
import com.irdstudio.sdk.beans.admin.service.vo.SMenuFuncOpUserVO;
import com.irdstudio.sdk.beans.admin.service.vo.SResourceTree;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.ssm.session.SessionManager;
import com.irdstudio.sdk.beans.ssm.util.CookiesUtil;
import com.irdstudio.sdk.beans.ssm.util.TreeNodeUtil;
import com.irdstudio.sdk.beans.ssm.web.filter.E4AJWTTokenFilter;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class E4AController
extends AbstractController {
    private static Logger logger = LoggerFactory.getLogger(E4AController.class);
    @Autowired
    private E4AServiceSsm e4aServiceC;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/oauth/token/jwt"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> authTokenByJWT(@RequestBody AuthInfoVO authInfoVO) {
        authInfoVO.setSessionId(this.httpRequest.getSession().getId());
        AuthInfoVO authInfo = this.e4aServiceC.login(authInfoVO);
        if (authInfo != null && Objects.nonNull(authInfo.getUserInfo())) {
            HashMap<String, Object> tokenPayload = new HashMap<String, Object>();
            tokenPayload.put("sessionId", authInfoVO.getSessionId());
            tokenPayload.put("signUserId", authInfo.getUsercode());
            tokenPayload.put("ssottp", String.valueOf(authInfo.getTimestamp()));
            tokenPayload.put("ssoclient", authInfo.getSessionId());
            tokenPayload.put("ssomd5", authInfo.getMd5());
            String token = E4AJWTTokenFilter.genJwtToken(tokenPayload);
            this.sessionManager.setLoginInfo(authInfo.getUserInfo(), this.httpRequest);
            return this.getResponseData(token);
        }
        ResponseData data = this.getResponseData(null);
        data.setMessage("\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\u6216\u7528\u6237\u5df2\u88ab\u6ce8\u9500");
        return data;
    }

    @RequestMapping(value={"/oauth/token/jwt/verify"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> verifyJwtToken(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((CharSequence)token)) {
            Map<String, Claim> tokenPayload = E4AJWTTokenFilter.verifyJwtToken(token);
            if (tokenPayload == null) {
                return this.getResponseData(false);
            }
            return this.getResponseData(true);
        }
        return this.getResponseData(false);
    }

    @RequestMapping(value={"/oauth/token"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> authToken(@RequestBody AuthInfoVO authInfoVO) {
        authInfoVO.setSessionId(this.httpRequest.getSession().getId());
        AuthInfoVO authInfo = this.e4aServiceC.login(authInfoVO);
        if (authInfo != null && Objects.nonNull(authInfo.getUserInfo())) {
            CookiesUtil.addCookie(this.httpResponse, "ssoclient", authInfo.getSessionId(), -1);
            CookiesUtil.addCookie(this.httpResponse, "ssottp", String.valueOf(authInfo.getTimestamp()), -1);
            CookiesUtil.addCookie(this.httpResponse, "ssomd5", authInfo.getMd5(), -1);
            CookiesUtil.addCookie(this.httpResponse, "signUserId", authInfo.getUsercode(), -1);
            this.sessionManager.setLoginInfo(authInfo.getUserInfo(), this.httpRequest);
            return this.getResponseData(true);
        }
        ResponseData data = this.getResponseData(false);
        data.setMessage("\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\u6216\u7528\u6237\u5df2\u88ab\u6ce8\u9500");
        return data;
    }

    @RequestMapping(value={"/session/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<UserInfo> getSessionInfo() {
        ResponseData data = null;
        try {
            UserInfo userInfo = this.getUserInfo();
            data = this.getResponseData(userInfo);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6session\u767b\u5f55\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
            this.httpResponse.setStatus(401);
        }
        return data;
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> logout() {
        ResponseData data = null;
        try {
            Cookie[] cookies;
            String sessionId = CookiesUtil.getCookieValue(this.httpRequest, "ssoclient");
            for (Cookie c : cookies = this.httpRequest.getCookies()) {
                if (!"ssoclient".equals(c.getName()) && !"ssottp".equals(c.getName()) && !"ssomd5".equals(c.getName())) continue;
                c.setMaxAge(0);
                this.httpResponse.addCookie(c);
            }
            this.sessionManager.removeSession(sessionId);
            logger.info("\u6e05\u7a7asession");
            data = this.getResponseData(true);
        }
        catch (Exception e) {
            logger.error("\u767b\u51fa\u5931\u8d25" + e.getMessage(), (Throwable)e);
            data = this.getResponseData(false);
            data.setMessage("\u767b\u51fa\u5931\u8d25!");
        }
        return data;
    }

    @RequestMapping(value={"/account/modifyUserPwd"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> changePasswrod(@RequestBody AuthInfoVO authInfoVO) {
        ResponseData data = null;
        UserInfo userInfo = this.getUserInfo();
        authInfoVO.setUsercode(userInfo.getUserId());
        AuthInfoVO resultInfo = this.e4aServiceC.modifyUserPassword(authInfoVO);
        if (resultInfo != null) {
            if (resultInfo.isChangeSuccess()) {
                data = this.getResponseData(true);
            } else {
                data = this.getResponseData(false);
                data.setMessage(resultInfo.getMessage());
            }
        } else {
            data = this.getResponseData(false);
        }
        return data;
    }

    @RequestMapping(value={"/admin/menus"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<SMenuFuncOpUserVO> menuAndFuncOp() {
        SMenuFuncOpUserVO output = null;
        try {
            UserInfo userInfo = this.getUserInfo();
            if (Objects.nonNull(userInfo)) {
                output = this.e4aServiceC.queryUserResourceInfo(userInfo.getUserId());
                output.setActorNo(userInfo.getUserId());
                output.setActorName(userInfo.getUserName());
                this.sessionManager.setUserResource(output, this.httpRequest);
            }
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u5b50\u7cfb\u7edf\u83dc\u5355\u8d44\u6e90\u53ca\u83dc\u5355\u64cd\u4f5c\u6743\u9650\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.getResponseData((Object)output);
    }

    @RequestMapping(value={"/s/menu/user/{resourceId}/{actorNo}/{subsId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SResourceTree> getSResourceTree(@PathVariable(value="resourceId") String resourceId, @PathVariable(value="actorNo") String actorNo, @PathVariable(value="subsId") String subsId) {
        ArrayList<SResourceTree> sResourceTreeList;
        ArrayList<SResourceTree> outputVo = new ArrayList<SResourceTree>();
        List menusUser = (List)this.httpRequest.getSession().getAttribute(actorNo);
        if (Objects.nonNull(menusUser) && menusUser.size() > 0 && Objects.nonNull(sResourceTreeList = TreeNodeUtil.getSResourceTree(menusUser, subsId)) && sResourceTreeList.size() > 0) {
            for (SResourceTree sResourceTree : sResourceTreeList) {
                if (!sResourceTree.getId().equals(resourceId)) continue;
                outputVo.add(sResourceTree);
            }
        }
        return outputVo;
    }
}

