/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.admin.api.rest;

import com.irdstudio.sdk.beans.admin.service.facade.SResourceactionService;
import com.irdstudio.sdk.beans.admin.service.vo.SResourceactionVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SResourceactionController
extends AbstractController {
    @Autowired
    @Qualifier(value="sResourceactionServiceImpl")
    private SResourceactionService sResourceactionService;

    @RequestMapping(value={"/s/resourceactions"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SResourceactionVO>> querySResourceactionAll(SResourceactionVO vo) {
        List<SResourceactionVO> outputVo = this.sResourceactionService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/resourceaction/{resourceid}/{actid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SResourceactionVO> queryByPk(@PathVariable(value="resourceid") String resourceid, @PathVariable(value="actid") String actid) {
        SResourceactionVO inVo = new SResourceactionVO();
        inVo.setResourceid(new String(resourceid));
        inVo.setActid(new String(actid));
        SResourceactionVO outputVo = this.sResourceactionService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/s/resourceaction"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SResourceactionVO inSResourceactionVo) {
        int outputVo = this.sResourceactionService.deleteByPk(inSResourceactionVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/resourceaction"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SResourceactionVO inSResourceactionVo) {
        int outputVo = this.sResourceactionService.updateByPk(inSResourceactionVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/resourceaction"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSResourceaction(@RequestBody SResourceactionVO inSResourceactionVo) {
        int outputVo = this.sResourceactionService.insertSResourceaction(inSResourceactionVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/resource/action/all"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SResourceactionVO>> qrySResourceAction(SResourceactionVO vo) {
        List<SResourceactionVO> outputVo = this.sResourceactionService.queryAllByCondition(vo);
        return this.getResponseData(outputVo);
    }
}

