/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.admin.api.rest;

import com.irdstudio.sdk.beans.admin.service.facade.SUserService;
import com.irdstudio.sdk.beans.admin.service.vo.SUserVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SUserController
extends AbstractController {
    @Autowired
    @Qualifier(value="sUserServiceImpl")
    private SUserService sUserService;

    @RequestMapping(value={"/s/users"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SUserVO>> querySUserAll(SUserVO vo) {
        List<SUserVO> outputVo = this.sUserService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/user/{actorno}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SUserVO> queryByPk(@PathVariable(value="actorno") String actorno) throws UnsupportedEncodingException {
        SUserVO inVo = new SUserVO();
        inVo.setActorno(new String(actorno));
        SUserVO outputVo = this.sUserService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/s/user"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SUserVO inSUserVo) {
        if (Objects.nonNull((Object)inSUserVo)) {
            inSUserVo.setState("0");
        }
        int outputVo = this.sUserService.updateByPk(inSUserVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/user"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SUserVO inSUserVo) {
        int outputVo = this.sUserService.updateByPk(inSUserVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/user"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSUser(@RequestBody SUserVO inSUserVo) {
        int outputVo = this.sUserService.insertSUser(inSUserVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/user/reset/pwd"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> userResetPwd(@RequestBody SUserVO vo) {
        int outputVo = this.sUserService.pwdByPk(vo);
        return this.getResponseData(outputVo);
    }
}

