/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.ssm.init;

import com.irdstudio.sdk.beans.admin.service.facade.SDicService;
import com.irdstudio.sdk.beans.admin.service.vo.SDicVO;
import com.irdstudio.sdk.beans.ssm.init.InitDictCondition;
import com.irdstudio.sdk.beans.ssm.util.PathUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={InitDictCondition.class})
@Component
public class InitForDict {
    private static Logger logger = LoggerFactory.getLogger(InitForDict.class);
    @Value(value="${sdk.initDict:true}")
    private boolean initDict = true;
    @Autowired
    @Qualifier(value="sDicService")
    private SDicService sDicService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void initMethod() {
        if (!this.initDict) {
            return;
        }
        String dictFileFullPath = PathUtil.getProjectRootPath() + "ffres/dict/all.js";
        logger.info("\u521d\u59cb\u5316\u5b57\u5178\u6570\u636e\u5230:" + dictFileFullPath);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(dictFileFullPath), "UTF-8");
            StringBuffer sb = new StringBuffer();
            List<SDicVO> list = this.sDicService.queryAllDict();
            list.forEach(dic -> {
                logger.info("\u521d\u59cb\u5316\u5b57\u5178\u9879" + dic.getOpttype() + "...");
                List<SDicVO> options = this.sDicService.queryDictOption(dic.getOpttype());
                sb.append("var ").append(dic.getOpttype().toUpperCase());
                sb.append("=[");
                options.forEach(option -> sb.append("{\"enname\":\"").append(option.getEnname()).append("\",\"cnname\":\"").append(option.getCnname()).append("\"},"));
                if (',' == sb.charAt(sb.length() - 1)) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append("];\r\n");
                sb.append("function formatter_").append(dic.getOpttype().toUpperCase()).append("(value, row, index){").append("return JLEUtil.formatter_dict(value,").append(dic.getOpttype().toUpperCase()).append(");").append("};\r\n");
            });
            osw.write(sb.toString());
        }
        catch (Exception e) {
            try {
                logger.error("\u6570\u636e\u5b57\u5178\u521d\u59cb\u5316\u51fa\u9519", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(osw);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)osw);
        }
        IOUtils.closeQuietly((Writer)osw);
        logger.info("\u5b57\u5178\u6570\u636e\u521d\u59cb\u5316\u5b8c\u6210!");
    }
}

