/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.ssm.init;

import com.irdstudio.sdk.beans.admin.service.facade.SDicService;
import com.irdstudio.sdk.beans.admin.service.vo.SDicVO;
import com.irdstudio.sdk.beans.ssm.init.InitDictCondition;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Conditional(value={InitDictCondition.class})
@Controller
public class SpringBootDictInitController
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(SpringBootDictInitController.class);
    private String dictJs = "";
    private String portalModules = "";
    @Autowired
    @Qualifier(value="sDicService")
    private SDicService sDicService;

    @GetMapping(value={"ffres/dict/all.js"})
    public void loadDict(HttpServletResponse resp) throws IOException {
        resp.setHeader("Content-Type", "application/javascript;charset=UTF-8");
        IOUtils.write((String)this.dictJs, (OutputStream)resp.getOutputStream(), (String)"UTF-8");
    }

    @GetMapping(value={"ffres/dict/modules.js"})
    public void loadModules(HttpServletResponse resp) throws IOException {
        resp.setHeader("Content-Type", "application/javascript;charset=UTF-8");
        IOUtils.write((String)this.portalModules, (OutputStream)resp.getOutputStream(), (String)"UTF-8");
    }

    public void initMethod() {
        try {
            StringBuffer sb = new StringBuffer();
            List<SDicVO> list = this.sDicService.queryAllDict();
            list.forEach(dic -> {
                logger.info("\u521d\u59cb\u5316\u5b57\u5178\u9879" + dic.getOpttype() + "...");
                List<SDicVO> options = this.sDicService.queryDictOption(dic.getOpttype());
                sb.append("var ").append(dic.getOpttype().toUpperCase());
                sb.append("=[");
                options.forEach(option -> sb.append("{\"enname\":\"").append(option.getEnname()).append("\",\"cnname\":\"").append(option.getCnname()).append("\"},"));
                if (',' == sb.charAt(sb.length() - 1)) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append("];\r\n");
                sb.append("function formatter_").append(dic.getOpttype().toUpperCase()).append("(value, row, index){").append("return JLEUtil.formatter_dict(value,").append(dic.getOpttype().toUpperCase()).append(");").append("};\r\n");
            });
            this.dictJs = sb.toString();
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5b57\u5178\u521d\u59cb\u5316\u51fa\u9519", (Throwable)e);
        }
        logger.info("\u5b57\u5178\u6570\u636e\u521d\u59cb\u5316\u5b8c\u6210!");
    }

    public void afterPropertiesSet() throws Exception {
        this.initMethod();
    }
}

