/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.ssm.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Date2LongTypeAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Pattern pattern = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
        String format = "yyyy-MM-dd";
        Matcher m = pattern.matcher(json.getAsJsonPrimitive().getAsString());
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        boolean dateFlag = m.matches();
        if (json.getAsJsonPrimitive().getAsString() == null) return null;
        if (!dateFlag) return new Date(json.getAsJsonPrimitive().getAsLong());
        try {
            return formatter.parse(json.getAsJsonPrimitive().getAsString());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)src.getTime());
    }
}

