/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.ssm.util;

import java.io.File;
import java.net.URL;

public final class PathUtil {
    public static final String getWorkDir() {
        return System.getProperty("user.dir");
    }

    public static final String getClassRootPath() {
        String path = PathUtil.class.getResource("/").getPath();
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.lastIndexOf("windows") != -1 && path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    public static final String getClassCurrentPath(Class<?> srcClass) {
        return srcClass.getResource("").getPath();
    }

    public static final URL getClassRootURL() {
        return Thread.currentThread().getContextClassLoader().getResource("");
    }

    public static final String getProjectRootPath() {
        String osName;
        String path = PathUtil.class.getProtectionDomain().getCodeSource().toString();
        if (path.indexOf("WEB-INF") >= 0) {
            path = path.substring(0, path.lastIndexOf("WEB-INF"));
        } else if (path.indexOf("bin") >= 0) {
            path = path.substring(0, path.lastIndexOf("bin"));
        }
        if (path.indexOf("file:/") >= 0) {
            path = path.substring(path.indexOf("file:/") + 5);
        }
        if ((osName = System.getProperty("os.name").toLowerCase()).lastIndexOf("windows") != -1 && path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    public static final boolean isAbsolutePath(String path) {
        if (path == null || "".equals(path)) {
            return false;
        }
        return path.startsWith("/") || path.startsWith(":", 1) || path.startsWith("file:/");
    }

    public static final String getFormatPath(String path) {
        if (PathUtil.isAbsolutePath(path)) {
            return path;
        }
        return PathUtil.getProjectRootPath() + path;
    }

    public static final void checkAndCreate(String filePath) {
        if ((filePath = filePath.replace('\\', '/')).startsWith("/")) {
            filePath = filePath.substring(1);
        }
        String[] dirs = filePath.split("/");
        String curPath = "";
        for (int i = 0; i < dirs.length; ++i) {
            File file = new File((curPath = curPath + dirs[i] + "/").substring(0, curPath.length() - 1));
            if (file.exists()) continue;
            file.mkdir();
        }
    }
}

