/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.ssm.util;

import com.irdstudio.sdk.beans.ssm.constant.TemplatePathConstant;
import com.irdstudio.sdk.beans.ssm.util.BeanUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.resource.ClasspathResourceLoader;

public final class TemplateUtils {
    private static GroupTemplate groupTemplate;
    private static Properties properties;

    private TemplateUtils() {
    }

    public static String getTemplate(TemplatePathConstant pathConstant, Object bean) {
        Map<String, Object> paramMap = null;
        if (bean != null) {
            paramMap = BeanUtility.bean2Map(bean);
        }
        return TemplateUtils.getTemplate(pathConstant, paramMap);
    }

    public static void getTemplate(TemplatePathConstant pathConstant, Object bean, Writer writer) {
        Map<String, Object> paramMap = null;
        if (bean != null) {
            paramMap = BeanUtility.bean2Map(bean);
        }
        TemplateUtils.getTemplate(pathConstant, paramMap, writer);
    }

    public static String getTemplateAll(TemplatePathConstant pathConstant, Object bean) {
        Map<String, Object> paramMap = null;
        if (bean != null) {
            paramMap = BeanUtility.bean2Map(bean);
        }
        return TemplateUtils.getTemplate(pathConstant, paramMap);
    }

    public static String getTemplate(TemplatePathConstant pathConstant, Map<String, Object> paramMap) {
        if (pathConstant == null) {
            throw new NullPointerException("MsgTemplatePathConstant\u4e3a\u7a7a\uff01");
        }
        long beginTime = System.currentTimeMillis();
        Template template = groupTemplate.getTemplate(pathConstant.getPath());
        template.binding(paramMap);
        List<String> listMapKeys = TemplateUtils.getMapKeys(paramMap);
        for (String key : listMapKeys) {
            if (!(paramMap.get(key) instanceof List)) continue;
            template.binding(key, paramMap.get(key));
        }
        String result = template.render();
        long endTime = System.currentTimeMillis();
        System.err.println("\u66ff\u6362\u6a21\u677f[" + pathConstant.getPath() + "]\u8017\u65f6\uff1a" + (endTime - beginTime) + "\u6beb\u79d2\uff01");
        return result;
    }

    public static void getTemplate(TemplatePathConstant pathConstant, Map<String, Object> paramMap, Writer writer) {
        if (pathConstant == null) {
            throw new NullPointerException("MsgTemplatePathConstant\u4e3a\u7a7a\uff01");
        }
        long beginTime = System.currentTimeMillis();
        Template template = groupTemplate.getTemplate(pathConstant.getPath());
        template.binding(paramMap);
        List<String> listMapKeys = TemplateUtils.getMapKeys(paramMap);
        for (String key : listMapKeys) {
            if (!(paramMap.get(key) instanceof List)) continue;
            template.binding(key, paramMap.get(key));
        }
        template.renderTo(writer);
        long endTime = System.currentTimeMillis();
        System.err.println("\u66ff\u6362\u6a21\u677f[" + pathConstant.getPath() + "]\u8017\u65f6\uff1a" + (endTime - beginTime) + "\u6beb\u79d2\uff01");
    }

    public static List<String> getMapKeys(Map<?, ?> map) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
        Map.Entry<?, ?> entry = null;
        while (it.hasNext()) {
            entry = it.next();
            list.add((String)entry.getKey());
        }
        return list;
    }

    public static Properties getProperties(String fileName) {
        Properties prop = new Properties();
        InputStream is = TemplateUtils.class.getClassLoader().getResourceAsStream("templateCfg.properties");
        try {
            prop.load(is);
            return prop;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        Configuration cfg;
        properties = TemplateUtils.getProperties("templateCfg.properties");
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader(properties.getProperty("templateFilePath"));
        try {
            cfg = Configuration.defaultConfiguration();
        }
        catch (IOException e) {
            throw new BeetlException(e.getMessage(), (Throwable)e);
        }
        groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
        groupTemplate.setSharedVars(new HashMap<Object, Object>(properties));
    }
}

