/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.ssm.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateFormatUtils;

public class TimeUtil {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public static int compareDates(String date1, String date2) throws Exception {
        int result = 0;
        try {
            long d1 = sdf.parse(date1).getTime();
            long d2 = sdf.parse(date2).getTime();
            if (d1 > d2) {
                result = 1;
            } else if (d1 == d2) {
                result = 0;
            } else if (d1 < d2) {
                result = -1;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return result;
    }

    public static int getDaysBetweenTwoDates(String date1, String date2) throws Exception {
        int result = 0;
        try {
            long d1 = sdf.parse(date1).getTime();
            long d2 = sdf.parse(date2).getTime();
            result = (int)((d2 - d1) / 1000L / 60L / 60L / 24L);
            result = result < 0 ? result * -1 : result;
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return result;
    }

    public static int getMonthsBetweenTwoDates(String date1, String date2) {
        int result = 0;
        try {
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c1.setTime(sdf.parse(date1));
            c2.setTime(sdf.parse(date2));
            result = (c2.get(1) - c1.get(1)) * 12 + c2.get(2) - c1.get(2);
            c1.add(2, result);
            result = c1.after(c2) ? result - 1 : result;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String addDay(String date, int n) throws Exception {
        return TimeUtil.addDate(5, date, n);
    }

    public static String addMonth(String date, int n) throws Exception {
        return TimeUtil.addDate(2, date, n);
    }

    public static String addYear(String date, int n) throws Exception {
        return TimeUtil.addDate(1, date, n);
    }

    private static String addDate(int addType, String date, int addNum) throws Exception {
        String result = "";
        try {
            sdf.parse(date);
            Calendar calendar = sdf.getCalendar();
            calendar.add(addType, addNum);
            int y = calendar.get(1);
            int m = calendar.get(2) + 1;
            int d = calendar.get(5);
            result = y + "-" + (m < 10 ? "0" + m : Integer.valueOf(m)) + "-" + (d < 10 ? "0" + d : Integer.valueOf(d));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return result;
    }

    public static boolean checkDateIsEndOfMonth(String date) throws Exception {
        boolean result = false;
        try {
            sdf.parse(date);
            Calendar calendar = sdf.getCalendar();
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int total = TimeUtil.getMonthsDays(year, month);
            String yearStartDate = year + "-01-01";
            int diffDays = TimeUtil.getDaysBetweenTwoDates(yearStartDate, date) + 1;
            if (total == diffDays) {
                result = true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return result;
    }

    private static int getMonthsDays(int year, int month) {
        int total = 0;
        switch (month) {
            case 1: {
                total = 31;
                break;
            }
            case 2: {
                total = 59;
                break;
            }
            case 3: {
                total = 90;
                break;
            }
            case 4: {
                total = 120;
                break;
            }
            case 5: {
                total = 151;
                break;
            }
            case 6: {
                total = 181;
                break;
            }
            case 7: {
                total = 212;
                break;
            }
            case 8: {
                total = 243;
                break;
            }
            case 9: {
                total = 273;
                break;
            }
            case 10: {
                total = 304;
                break;
            }
            case 11: {
                total = 334;
                break;
            }
            case 12: {
                total = 365;
            }
        }
        if (TimeUtil.leapYear(year) && month > 1) {
            ++total;
        }
        return total;
    }

    public static boolean leapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static String getCurDate() {
        return sdf.format(new Date());
    }

    public static String getYesterday(String curDate) throws Exception {
        return TimeUtil.addDay(curDate, -1);
    }

    public static String getTomorrow(String curDate) throws Exception {
        return TimeUtil.addDay(curDate, 1);
    }

    public static int getMonthEndDay(int year, int month) {
        int endDay = 0;
        switch (month) {
            case 1: {
                endDay = 31;
                break;
            }
            case 2: {
                endDay = 28;
                break;
            }
            case 3: {
                endDay = 31;
                break;
            }
            case 4: {
                endDay = 30;
                break;
            }
            case 5: {
                endDay = 31;
                break;
            }
            case 6: {
                endDay = 30;
                break;
            }
            case 7: {
                endDay = 31;
                break;
            }
            case 8: {
                endDay = 31;
                break;
            }
            case 9: {
                endDay = 30;
                break;
            }
            case 10: {
                endDay = 31;
                break;
            }
            case 11: {
                endDay = 30;
                break;
            }
            case 12: {
                endDay = 31;
            }
        }
        if (TimeUtil.leapYear(year) && month == 2) {
            endDay = 29;
        }
        return endDay;
    }

    public static int getEndMonthOfQuarter(int month) {
        int result = 0;
        switch (month) {
            case 1: 
            case 2: 
            case 3: {
                result = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                result = 6;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                result = 9;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                result = 12;
            }
        }
        return result;
    }

    public static String getEndDateOfMonth(String curDate) {
        String tmp = curDate.replaceAll("-", "");
        int year = Integer.parseInt(tmp.substring(0, 4));
        int month = Integer.parseInt(tmp.substring(4, 6));
        return TimeUtil.getEndDateOfMonth(year, month);
    }

    public static String getEndDateOfMonth(int year, int month) {
        int endOfMonth = TimeUtil.getMonthEndDay(year, month);
        return year + "-" + (month < 10 ? "0" + month : Integer.valueOf(month)) + "-" + endOfMonth;
    }

    public static String getEndDateOfQuarter(String curDate) {
        String tmp = curDate.replaceAll("-", "");
        int year = Integer.parseInt(tmp.substring(0, 4));
        int month = Integer.parseInt(tmp.substring(4, 6));
        return TimeUtil.getEndDateOfQuarter(year, month);
    }

    public static String getEndDateOfQuarter(int year, int month) {
        int m = TimeUtil.getEndMonthOfQuarter(month);
        int endOfMonth = TimeUtil.getMonthEndDay(year, m);
        return year + "-" + (m < 10 ? "0" + m : Integer.valueOf(m)) + "-" + endOfMonth;
    }

    public static String getCurrentDate() {
        return DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd", (Locale)Locale.CHINA);
    }

    public static String getCurrentDateTime() {
        return DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.CHINA);
    }

    public static String getTimeStampByPattern(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern, (Locale)Locale.CHINA);
    }

    public static String getBizDateTime(String bizDate) {
        return bizDate + " " + DateFormatUtils.format((Date)new Date(), (String)"HH:mm:ss", (Locale)Locale.CHINA);
    }
}

