/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.ssm.web.filter;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.irdstudio.sdk.beans.admin.service.vo.AuthInfoVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.ssm.session.SessionManager;
import com.irdstudio.sdk.beans.ssm.util.GsonUtils;
import com.irdstudio.sdk.beans.ssm.web.filter.E4ACasFilter;
import com.irdstudio.sdk.beans.ssm.web.http.impl.ModifyCookieHttpServletRequestWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class E4AJWTTokenFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(E4ACasFilter.class);
    private SessionManager sessionManager;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext applicationcontext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.sessionManager = (SessionManager)applicationcontext.getBean("sessionManager", SessionManager.class);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String token = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((CharSequence)token) && !StringUtils.startsWith((CharSequence)token, (CharSequence)"Bearer ")) {
            Map<String, Claim> tokenPayload = E4AJWTTokenFilter.verifyJwtToken(token);
            String sessionId = null;
            if (tokenPayload != null && tokenPayload.get("sessionId") != null) {
                sessionId = tokenPayload.get("sessionId").asString();
            }
            AuthInfoVO authInfo = null;
            try {
                authInfo = new AuthInfoVO();
                UserInfo userInfo = this.sessionManager.getLoginInfo(sessionId);
                if (userInfo == null || userInfo.getUserId() == null) {
                    throw new Exception("session\u4fe1\u606f\u8fc7\u671f\uff0c\u65e0\u6cd5\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f\u6821\u9a8c\u51fa\u9519:" + sessionId);
                }
                authInfo.setCheckToken(true);
                authInfo.setUserInfo(userInfo);
                String ssoClient = tokenPayload.get("ssoclient").asString();
                String timestamp = tokenPayload.get("ssottp").asString();
                String md5 = tokenPayload.get("ssomd5").asString();
                ModifyCookieHttpServletRequestWrapper cookieModifyReq = new ModifyCookieHttpServletRequestWrapper((HttpServletRequest)request);
                cookieModifyReq.putCookie("ssoclient", ssoClient);
                cookieModifyReq.putCookie("ssottp", timestamp);
                cookieModifyReq.putCookie("ssomd5", md5);
                request = cookieModifyReq;
            }
            catch (Exception e) {
                logger.error("sso client request token check fail: " + e.getMessage(), (Throwable)e);
                response.setStatus(401);
                ResponseData data = new ResponseData();
                data.createData((Object)false, "-1", "valify token \u9519\u8bef", false);
                String outputmessage = GsonUtils.toJson(data);
                try (PrintWriter rsp = response.getWriter();){
                    rsp.write(outputmessage);
                }
                return;
            }
            if (authInfo == null || !authInfo.isCheckToken() || authInfo.getUserInfo() == null || authInfo.getUserInfo().getUserId() == null) {
                logger.info("\u767b\u5f55\u6821\u9a8c\u5931\u8d25\uff1a" + authInfo);
                response.setStatus(401);
                ResponseData data = new ResponseData();
                data.createData((Object)false, "-1", "\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25", false);
                String outputmessage = GsonUtils.toJson(data);
                try (PrintWriter rsp = response.getWriter();){
                    rsp.write(outputmessage);
                }
                return;
            }
            logger.info("\u6821\u9a8c\u901a\u8fc7");
            request.getSession().setAttribute("userInfo", (Object)authInfo.getUserInfo());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    public static String genJwtToken(Map<String, Object> payload) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)"MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAMBjBDzWtzUpby1NinGstLcCtXEHjSi2ZtbJfCANBGQuwK5AqKropmAAz/ywm4jXZLUlU5ecy7l3jbS8oUVL/4hvPhPGqOEuaCjCdqC4xNsAYHMg+983mUvnaYOab8K8q7Zg8IW9lXxi6U1MJ7G+6Ps6JZFRekBtpCq7m086MbK1AgMBAAECgYBFux3sFz8sa6o6V2KYtSqDMt4k68HEQeigbUMqMs2mqjN4dUMtP0oefezk//Y/8SI1biQQTeqhfK3GFqC1h0hEwHf5DmPnK/M5O2VjuT9VRDaLTe8IGja8Ntu0Z222cGp6VWMDpmGyjIz/dq8Qfvrd10GxRIq8haAeXLWQ6X22eQJBAOFXljyVqtBg2ZHz1DaE2w0coB5ocQgtfmBbXRS75Uui3hke6TSW1n5EPd8T/GiHxEdrmJbPWrK03o/Ur0AfulcCQQDaj6G/IZ2HEEjjk7p7iQUmVDt09fReYPpdZEoNlFUhiFSK1olFqo4Hp13NAmM3Fv6VGYmdSf/fI5acSjfAJavTAkBvPS2M+tU3yJee1R8NSshX0Km6WRRzVQHtzyxD7/1hOSUqgXfd3hhEfKuOU+9mKp9aImNRD0tWrLKxjex1WzRBAkBByOW4b9fIZYBq73Y75LwmE0hqJfXNyobRQXSArdsJ4sz/lR9wVqu1Zgz3vfY7CLLMEgm3zCQ197JHjJdHQI99AkEAioozD+L7kzE/BTs6f7m23ID8roBLBzHHOll2N3RTbuVEmicCdXLj8FUlvl9Q6AhpxjdSNgcYuFEy4MCJRz0Ldg==");
            Date nowTime = new Date();
            Date after12Hours = DateUtils.addHours((Date)nowTime, (int)12);
            String token = JWT.create().withIssuer("irdstudio").withPayload(payload).withIssuedAt(nowTime).withExpiresAt(after12Hours).sign(algorithm);
            return token;
        }
        catch (JWTCreationException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Map<String, Claim> verifyJwtToken(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)"MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAMBjBDzWtzUpby1NinGstLcCtXEHjSi2ZtbJfCANBGQuwK5AqKropmAAz/ywm4jXZLUlU5ecy7l3jbS8oUVL/4hvPhPGqOEuaCjCdqC4xNsAYHMg+983mUvnaYOab8K8q7Zg8IW9lXxi6U1MJ7G+6Ps6JZFRekBtpCq7m086MbK1AgMBAAECgYBFux3sFz8sa6o6V2KYtSqDMt4k68HEQeigbUMqMs2mqjN4dUMtP0oefezk//Y/8SI1biQQTeqhfK3GFqC1h0hEwHf5DmPnK/M5O2VjuT9VRDaLTe8IGja8Ntu0Z222cGp6VWMDpmGyjIz/dq8Qfvrd10GxRIq8haAeXLWQ6X22eQJBAOFXljyVqtBg2ZHz1DaE2w0coB5ocQgtfmBbXRS75Uui3hke6TSW1n5EPd8T/GiHxEdrmJbPWrK03o/Ur0AfulcCQQDaj6G/IZ2HEEjjk7p7iQUmVDt09fReYPpdZEoNlFUhiFSK1olFqo4Hp13NAmM3Fv6VGYmdSf/fI5acSjfAJavTAkBvPS2M+tU3yJee1R8NSshX0Km6WRRzVQHtzyxD7/1hOSUqgXfd3hhEfKuOU+9mKp9aImNRD0tWrLKxjex1WzRBAkBByOW4b9fIZYBq73Y75LwmE0hqJfXNyobRQXSArdsJ4sz/lR9wVqu1Zgz3vfY7CLLMEgm3zCQ197JHjJdHQI99AkEAioozD+L7kzE/BTs6f7m23ID8roBLBzHHOll2N3RTbuVEmicCdXLj8FUlvl9Q6AhpxjdSNgcYuFEy4MCJRz0Ldg==");
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer("irdstudio").build();
            DecodedJWT jwt = verifier.verify(token);
            return jwt.getClaims();
        }
        catch (JWTVerificationException exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

