/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.facenter.api.rest;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinpaas.console.dmcenter.service.bo.CodeProduceInfoBo;
import com.irdstudio.allinpaas.console.dmcenter.service.bo.CodeTemplateFileBo;
import com.irdstudio.allinpaas.console.dmcenter.service.bo.CodeTemplateInfoBo;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableFieldService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableFieldVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmInfoVO;
import com.irdstudio.allinpaas.console.facenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.facenter.common.util.DirectoryTreeUtil;
import com.irdstudio.allinpaas.console.facenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.facenter.common.util.SpringPropertyUtils;
import com.irdstudio.allinpaas.console.facenter.common.util.TmModelUtil;
import com.irdstudio.allinpaas.console.facenter.service.facade.CodeProduceInfoService;
import com.irdstudio.allinpaas.console.facenter.service.facade.CodeProduceService;
import com.irdstudio.allinpaas.console.facenter.service.facade.CodeTemplateFileService;
import com.irdstudio.allinpaas.console.facenter.service.facade.CodeTemplateInfoService;
import com.irdstudio.allinpaas.console.facenter.service.vo.CodeProduceInfoVO;
import com.irdstudio.allinpaas.console.facenter.service.vo.CodeTemplateFileVO;
import com.irdstudio.allinpaas.console.facenter.service.vo.CodeTemplateInfoVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableFieldBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ApiForCodeProduceController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(ApiForCodeProduceController.class);
    @Autowired
    @Qualifier(value="projectTmInfoService")
    private ProjectTmInfoService projectTmInfoService;
    @Autowired
    @Qualifier(value="codeProduceInfoService")
    private CodeProduceInfoService codeProduceInfoService;
    @Autowired
    @Qualifier(value="codeProduceService")
    private CodeProduceService codeProduceService;
    @Autowired
    @Qualifier(value="codeTemplateFileService")
    private CodeTemplateFileService codeTemplateFileService;
    @Autowired
    @Qualifier(value="codeTemplateInfoService")
    private CodeTemplateInfoService codeTemplateInfoService;
    @Autowired
    @Qualifier(value="modelTableInfoService")
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    @Qualifier(value="modelTableFieldService")
    private ModelTableFieldService modelTableFieldService;

    @GetMapping(value={"/code/produce/{modelTableId}/{codeTemplateId}/{produceId}"})
    @ResponseBody
    public ResponseData<CodeProduceInfoVO> codeProduce(@PathVariable(value="modelTableId") String modelTableId, @PathVariable(value="codeTemplateId") String codeTemplateId, @PathVariable(value="produceId") String produceId) {
        CodeProduceInfoVO cpiv;
        logger.info("\u4ee3\u7801\u751f\u6210\u5f00\u59cb...");
        String author = this.getUserInfo().getUserId();
        boolean isReProduce = false;
        CodeProduceInfoBo cpib = null;
        if (StringUtils.isEmpty((CharSequence)produceId) || "NONE".equals(produceId)) {
            produceId = KeyUtil.createUUIDKey();
            cpib = new CodeProduceInfoBo();
            cpib.setProduceId(produceId);
            cpib.setProduceType("");
            cpib.setModelTableId(modelTableId);
            cpib.setCodeTemplateId(codeTemplateId);
        } else {
            isReProduce = true;
            CodeProduceInfoVO inVo = new CodeProduceInfoVO();
            inVo.setProduceId(produceId);
            CodeProduceInfoVO cpiv2 = this.codeProduceInfoService.queryByPk(inVo);
            cpib = new CodeProduceInfoBo();
            BeanUtils.copyProperties((Object)((Object)cpiv2), (Object)cpib);
        }
        ModelTableInfoVO mtInVo = new ModelTableInfoVO();
        mtInVo.setObjectId(cpib.getModelTableId());
        ModelTableInfoVO mti = this.modelTableInfoService.queryByPk(mtInVo);
        ModelTableInfoBo mtib = new ModelTableInfoBo();
        mtib.setTableId(mti.getObjectId());
        mtib.setTableCode(mti.getObjectCode());
        mtib.setTableName(mti.getObjectName());
        mtib.setModelClassName(TmModelUtil.tableCodeToClassName(mti.getObjectCode()));
        mtib.setJavaPropertyName(TmModelUtil.fieldToProperty(mti.getObjectCode()));
        ModelTableFieldVO mtfv = new ModelTableFieldVO();
        mtfv.setObjectId(cpib.getModelTableId());
        List mtfvList = this.modelTableFieldService.queryModelTableField(mtfv);
        ArrayList<ModelTableFieldBo> mtfbList = new ArrayList<ModelTableFieldBo>();
        for (ModelTableFieldVO mtf : mtfvList) {
            ModelTableFieldBo mtfb = new ModelTableFieldBo();
            BeanUtils.copyProperties((Object)mtf, (Object)mtfb);
            String javaPropertyName = TmModelUtil.fieldToProperty(mtf.getFieldCode());
            mtfb.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
            mtfb.setJavaPropertyName(javaPropertyName);
            mtfb.setJavaType(TmModelUtil.fieldTypeToJavaType(mtf.getFieldType()));
            mtfbList.add(mtfb);
        }
        mtib.setFieldList(mtfbList);
        logger.info("\u8868\u540d\uff1a" + mtib.getTableCode());
        ProjectTmInfoVO ptiv = new ProjectTmInfoVO();
        ptiv.setProjectId(cpib.getModelTableId());
        ProjectTmInfoVO outPtiv = this.projectTmInfoService.queryByModelId(ptiv);
        TmProjectInfoBo mpib = new TmProjectInfoBo();
        mpib.setProjectId(outPtiv.getProjectId());
        mpib.setProjectCode(outPtiv.getProjectCode());
        mpib.setProjectName(outPtiv.getProjectName());
        mpib.setProjectType(outPtiv.getProjectType());
        logger.info("\u6570\u636e\u5bf9\u8c61\u5de5\u7a0b\uff1a" + mpib.getProjectCode());
        CodeTemplateInfoVO ctiv = new CodeTemplateInfoVO();
        ctiv.setTemplateId(cpib.getCodeTemplateId());
        CodeTemplateInfoVO outputCtiv = this.codeTemplateInfoService.queryByPk(ctiv);
        CodeTemplateInfoBo ctib = new CodeTemplateInfoBo();
        ctib.setTemplateId(outputCtiv.getTemplateId());
        ctib.setTemplateName(outputCtiv.getTemplateName());
        String codeTemplateName = ctib.getTemplateName();
        logger.info("\u6a21\u677f\u540d\u79f0\uff1a" + codeTemplateName);
        List<CodeTemplateFileVO> outputCtfvList = this.codeTemplateFileService.getCodeTemplateFile(cpib.getCodeTemplateId());
        ArrayList<CodeTemplateFileBo> ctfbList = new ArrayList<CodeTemplateFileBo>();
        for (CodeTemplateFileVO ctf : outputCtfvList) {
            CodeTemplateFileBo ctfb = new CodeTemplateFileBo();
            BeanUtils.copyProperties((Object)((Object)ctf), (Object)ctfb);
            ctfbList.add(ctfb);
        }
        this.codeProduceService.produceModelBeanCode(author, cpib, mpib, mtib, ctfbList);
        if (!isReProduce) {
            cpib.setProduceDesc("\u751f\u6210" + mtib.getTableCode() + ctib.getTemplateName());
            cpib.setModelTableCode(mtib.getTableCode());
            cpib.setModelTableName(mtib.getTableName());
            cpib.setCodeTemplateName(ctib.getTemplateName());
            cpib.setCreateUser(author);
            cpib.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            cpib.setProduceTime(cpib.getCreateTime());
            cpiv = new CodeProduceInfoVO();
            BeanUtils.copyProperties((Object)cpib, (Object)((Object)cpiv));
            this.codeProduceInfoService.insertCodeProduceInfo(cpiv);
        } else {
            cpib.setProduceTime(CurrentDateUtil.getTodayDateEx2());
            cpiv = new CodeProduceInfoVO();
            BeanUtils.copyProperties((Object)cpib, (Object)((Object)cpiv));
            this.codeProduceInfoService.updateByPk(cpiv);
        }
        logger.info("\u4ee3\u7801\u751f\u6210\u5b8c\u6210!");
        cpiv = new CodeProduceInfoVO();
        BeanUtils.copyProperties((Object)cpib, (Object)((Object)cpiv));
        return this.getResponseData((Object)cpiv);
    }

    @GetMapping(value={"/code/view/{produceId}"})
    @ResponseBody
    public ResponseData<String> codeProduce(@PathVariable(value="produceId") String produceId) {
        if (StringUtils.isEmpty((CharSequence)produceId)) {
            logger.info("\u9700\u8981\u4f20\u5165\u4ee3\u7801\u751f\u6210\u6807\u8bc6!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u4ee3\u7801\u751f\u6210\u6807\u8bc6!");
            return data;
        }
        String codePath = SpringPropertyUtils.getProperty("facenter.code.path") + produceId;
        logger.info("\u4ee3\u7801\u76ee\u5f55\uff1a" + codePath);
        return this.getResponseData(DirectoryTreeUtil.getTreeJson(codePath));
    }

    @GetMapping(value={"/code/template/preview/{templateId}"})
    @ResponseBody
    public ResponseData<String> codeTemplate(@PathVariable(value="templateId") String templateId) {
        if (StringUtils.isEmpty((CharSequence)templateId)) {
            logger.info("\u9700\u8981\u4f20\u5165\u6a21\u677f\u6807\u8bc6!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u6a21\u677f\u6807\u8bc6!");
            return data;
        }
        String templatePath = this.getTemplatePath(templateId);
        logger.info("\u6a21\u677f\u76ee\u5f55\uff1a" + templatePath);
        return this.getResponseData(DirectoryTreeUtil.getTreeJson(templatePath));
    }

    private String getTemplatePath(String templateId) {
        CodeTemplateInfoVO templateParam = new CodeTemplateInfoVO();
        templateParam.setTemplateId(templateId);
        CodeTemplateInfoVO codeTemplateInfoVO = this.codeTemplateInfoService.queryByPk(templateParam);
        if (StringUtils.isNotBlank((CharSequence)codeTemplateInfoVO.getAppTemplateId())) {
            String basePath = SpringPropertyUtils.getProperty("facenter.template.path");
            File baseFile = new File(basePath);
            File ParentFile = baseFile.getParentFile();
            String templatePath = ParentFile.getAbsolutePath() + File.separator + codeTemplateInfoVO.getTemplateId();
            return templatePath;
        }
        String templatePath = SpringPropertyUtils.getProperty("facenter.template.path") + File.separator + codeTemplateInfoVO.getTemplateId();
        return templatePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/code/template/file/open"})
    @ResponseBody
    public ResponseData<String> codeTemplateFileOpen(@RequestParam(name="templateId") String templateId, @RequestParam(name="file") String file) {
        if (StringUtils.isEmpty((CharSequence)file)) {
            logger.info("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u7684\u6587\u4ef6!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u7684\u6587\u4ef6!");
            return data;
        }
        String codePath = this.getTemplatePath(templateId);
        File basePath = new File(codePath);
        File parentFile = basePath.getParentFile();
        StringBuffer content = new StringBuffer("");
        if (!StringUtils.isEmpty((CharSequence)file)) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(parentFile.getAbsoluteFile() + File.separator + file), "UTF-8"));
                String data = br.readLine();
                while (data != null) {
                    content.append(data + "\n");
                    data = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("content", content.toString());
        String jsonResult = JSON.toJSONString(map);
        return this.getResponseData(jsonResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/code/file/open"})
    @ResponseBody
    public ResponseData<String> codeFileOpen(@RequestParam(name="file") String file) {
        if (StringUtils.isEmpty((CharSequence)file)) {
            logger.info("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u7684\u6587\u4ef6!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u7684\u6587\u4ef6!");
            return data;
        }
        String codePath = SpringPropertyUtils.getProperty("facenter.code.path");
        StringBuffer content = new StringBuffer("");
        if (!StringUtils.isEmpty((CharSequence)file)) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(codePath + File.separator + file), "UTF-8"));
                String data = br.readLine();
                while (data != null) {
                    content.append(data + "\n");
                    data = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("content", content.toString());
        String jsonResult = JSON.toJSONString(map);
        return this.getResponseData(jsonResult);
    }

    @GetMapping(value={"/code/download/{produceId}"})
    public void codeDownload(@PathVariable(value="produceId") String produceId, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isEmpty((CharSequence)produceId)) {
            logger.info("\u9700\u8981\u4f20\u5165\u4ee3\u7801\u751f\u6210\u6807\u8bc6!");
            return;
        }
        String codeZipFilePath = SpringPropertyUtils.getProperty("facenter.code.path") + produceId + ".zip";
        logger.info(codeZipFilePath);
        logger.info("\u4e0b\u8f7d\u7684\u6587\u4ef6\u540d\u4e3a\uff1a" + codeZipFilePath);
        try {
            int j;
            File file = new File(codeZipFilePath);
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + codeZipFilePath);
            response.setContentLength((int)file.length());
            response.setContentType("application/zip");
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream buff = new BufferedInputStream(fis);
            byte[] b = new byte[1024];
            ServletOutputStream myout = response.getOutputStream();
            for (long k = 0L; k < file.length(); k += (long)j) {
                j = buff.read(b, 0, 1024);
                myout.write(b, 0, j);
            }
            myout.flush();
            buff.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

