/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.facenter.common.util;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DirectoryTreeUtil {
    public static String getTreeJson(String absolutePath) {
        ArrayList<Map<String, Object>> fileList = new ArrayList<Map<String, Object>>();
        boolean layer = true;
        File file = new File(absolutePath);
        String rootPath = file.getParentFile().getAbsolutePath() + File.separator;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", file.getAbsolutePath().replace(rootPath, ""));
        map.put("pId", 0);
        map.put("name", file.getName());
        map.put("open", true);
        fileList.add(map);
        DirectoryTreeUtil.iteratorFile(file, rootPath, fileList);
        String jsonStr = JSON.toJSONString(fileList);
        return jsonStr;
    }

    private static void iteratorFile(File file, String rootPath, List<Map<String, Object>> fileList) {
        String pid = file.getAbsolutePath().replace(rootPath, "");
        File[] files = file.listFiles();
        files = DirectoryTreeUtil.sortFile(files);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.getName().startsWith(".")) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String id = f.getAbsolutePath().replace(rootPath, "");
            map.put("id", id);
            map.put("pId", pid);
            map.put("name", f.getName());
            if (f.isDirectory() && f.list().length > 0) {
                map.put("open", false);
                fileList.add(map);
                DirectoryTreeUtil.iteratorFile(f, rootPath, fileList);
                continue;
            }
            map.put("file", id);
            fileList.add(map);
        }
    }

    private static File[] sortFile(File[] files) {
        ArrayList<File> list = new ArrayList<File>();
        for (File f : files) {
            if (!f.isDirectory()) continue;
            list.add(f);
        }
        for (File f : files) {
            if (!f.isFile()) continue;
            list.add(f);
        }
        return list.toArray(new File[files.length]);
    }

    public static void main(String[] args) {
        System.out.println(DirectoryTreeUtil.getTreeJson("E:/macms_ws/appprj/ecr.product/"));
    }
}

