/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.facenter.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpringPropertyUtils {
    private static Logger logger = LogManager.getLogger(SpringPropertyUtils.class);
    private static Properties props;

    private static synchronized void loadProps() {
        logger.info("\u5f00\u59cb\u52a0\u8f7dproperties\u6587\u4ef6\u5185\u5bb9.......");
        props = new Properties();
        InputStream in = null;
        try {
            in = SpringPropertyUtils.class.getClassLoader().getResourceAsStream("application.properties");
            props.load(in);
        }
        catch (FileNotFoundException e) {
            logger.error("jdbc.properties\u6587\u4ef6\u672a\u627e\u5230");
        }
        catch (IOException e) {
            logger.error("\u51fa\u73b0IOException");
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error("jdbc.properties\u6587\u4ef6\u6d41\u5173\u95ed\u51fa\u73b0\u5f02\u5e38");
            }
        }
        logger.info("\u52a0\u8f7dproperties\u6587\u4ef6\u5185\u5bb9\u5b8c\u6210...........");
        logger.info("properties\u6587\u4ef6\u5185\u5bb9\uff1a" + props);
    }

    public static String getProperty(String key) {
        if (null == props) {
            SpringPropertyUtils.loadProps();
        }
        return props.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        if (null == props) {
            SpringPropertyUtils.loadProps();
        }
        return props.getProperty(key, defaultValue);
    }

    static {
        SpringPropertyUtils.loadProps();
    }
}

