/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.solution.api.rest;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinpaas.common.enums.AdjustType;
import com.irdstudio.allinpaas.common.enums.AppCategory;
import com.irdstudio.allinpaas.common.enums.AppCreateWay;
import com.irdstudio.allinpaas.common.enums.AppType;
import com.irdstudio.allinpaas.common.enums.SolutionType;
import com.irdstudio.allinpaas.console.dmcenter.common.annotations.DevLog;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.LogAction;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableFieldService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmInfoVO;
import com.irdstudio.allinpaas.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinpaas.feignclient.FadpaasService;
import com.irdstudio.allinpaas.feignclient.NcdPaasService;
import com.irdstudio.allinpaas.portal.core.service.facade.OsrvArrangeTableService;
import com.irdstudio.allinpaas.portal.core.service.facade.OsrvEvalIsrvService;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasAppsAdjustService;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasAppsInfoService;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasAppsParamService;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasAppsPropertiesService;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasAppsSqlService;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasEnvParamService;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasSysRightService;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasTemplateInfoService;
import com.irdstudio.allinpaas.portal.core.service.facade.SSubsInfoService;
import com.irdstudio.allinpaas.portal.core.service.facade.SrvModelInfoService;
import com.irdstudio.allinpaas.portal.core.service.facade.SrvModelInoutService;
import com.irdstudio.allinpaas.portal.core.service.facade.SrvModelPackageService;
import com.irdstudio.allinpaas.portal.core.service.vo.PaasAppsAdjustVO;
import com.irdstudio.allinpaas.portal.core.service.vo.PaasAppsInfoVO;
import com.irdstudio.allinpaas.portal.core.service.vo.PaasAppsParamVO;
import com.irdstudio.allinpaas.portal.core.service.vo.PaasAppsPropertiesVO;
import com.irdstudio.allinpaas.portal.core.service.vo.PaasAppsSqlVO;
import com.irdstudio.allinpaas.portal.core.service.vo.PaasEnvParamVO;
import com.irdstudio.allinpaas.portal.core.service.vo.PaasTemplateInfoVO;
import com.irdstudio.allinpaas.portal.core.service.vo.SSubsInfoVO;
import com.irdstudio.allinpaas.portal.core.utils.DrawOsrvArrangeTable;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class PaasAppsInfoController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(PaasAppsInfoController.class);
    @Autowired
    @Qualifier(value="paasAppsInfoServiceImpl")
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    @Qualifier(value="srvModelInfoServiceImpl")
    private SrvModelInfoService srvModelInfoService;
    @Autowired
    @Qualifier(value="srvModelInoutServiceImpl")
    private SrvModelInoutService srvModelInoutService;
    @Autowired
    @Qualifier(value="modelTableFieldService")
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    @Qualifier(value="srvModelPackageServiceImpl")
    private SrvModelPackageService srvModelPackageService;
    @Autowired
    @Qualifier(value="osrvArrangeTableServiceImpl")
    private OsrvArrangeTableService osrvArrangeTableService;
    @Autowired
    @Qualifier(value="osrvEvalIsrvServiceImpl")
    private OsrvEvalIsrvService osrvEvalIsrvService;
    @Autowired
    @Qualifier(value="paasTemplateInfoService")
    private PaasTemplateInfoService paasTemplateInfoService;
    @Autowired
    @Qualifier(value="sSubsInfoService")
    private SSubsInfoService sSubsInfoService;
    @Autowired
    @Qualifier(value="paasAppsParamServiceImpl")
    private PaasAppsParamService paasAppsParamService;
    @Autowired
    @Qualifier(value="paasAppsPropertiesServiceImpl")
    private PaasAppsPropertiesService paasAppsPropertiesService;
    @Autowired
    @Qualifier(value="paasAppsSqlService")
    private PaasAppsSqlService paasAppsSqlService;
    @Autowired
    @Qualifier(value="modelTableInfoService")
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    @Qualifier(value="projectTmInfoService")
    private ProjectTmInfoService projectTmInfoService;
    @Autowired
    @Qualifier(value="paasAppsAdjustServiceImpl")
    private PaasAppsAdjustService paasAppsAdjustService;
    @Autowired
    @Qualifier(value="paasEnvParamServiceImpl")
    private PaasEnvParamService paasEnvParamService;
    @Autowired
    @Qualifier(value="paasSysRightServiceImpl")
    private PaasSysRightService paasSysRightService;
    @Value(value="${project.tmp.path}")
    private String projectTmpPath;
    @Value(value="${facenter.code.path:}")
    private String facenterCodePath;
    private DrawOsrvArrangeTable drawOsrvArrangeTable = new DrawOsrvArrangeTable();

    @RequestMapping(value={"/paas/apps/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoVO>> queryPaasAppsInfoAll(PaasAppsInfoVO vo) {
        List outputVo = this.paasAppsInfoService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/infos/pop/comps"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoVO>> queryMarketPopPageData(PaasAppsInfoVO vo) {
        List outputVo = this.paasAppsInfoService.queryMarketPopPageData(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/infos/refs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoVO>> queryAppReferenceComponentsByPage(PaasAppsInfoVO vo) {
        List outputVo = this.paasAppsInfoService.queryAppReferenceComponentsByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/infos/by/refeds"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoVO>> queryAppByReferencedByPage(PaasAppsInfoVO vo) {
        List outputVo = this.paasAppsInfoService.queryAppByReferencedByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info/filtrate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoVO>> queryPaasAppsInfos(PaasAppsInfoVO vo) {
        List outputVo = this.paasAppsInfoService.queryAllByFiltrate(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info/merag/{origin}/{target}/{originProjectId}/{targetProjectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> mergeApp(@PathVariable(value="origin") String origin, @PathVariable(value="originProjectId") String originProjectId, @PathVariable(value="target") String target, @PathVariable(value="targetProjectId") String targetProjectId, @RequestParam(value="subsCode") String subsCode) {
        ArrayList adjustContentList = new ArrayList();
        this.srvModelInfoService.mergeAppByAppId(origin, target, adjustContentList);
        int num = this.modelTableInfoService.mergeAppByProjectId(originProjectId, targetProjectId, adjustContentList);
        PaasAppsAdjustVO adjustLog = new PaasAppsAdjustVO();
        adjustLog.setRecordKeyid(UUIDUtil.getUUID());
        adjustLog.setSubsCode(subsCode);
        SSubsInfoVO sys = new SSubsInfoVO();
        sys.setSubsCode(subsCode);
        sys = this.sSubsInfoService.queryByPk(sys);
        if (sys != null) {
            adjustLog.setSubsName(sys.getSubsName());
        }
        adjustLog.setAppId(origin);
        PaasAppsInfoVO originApp = new PaasAppsInfoVO();
        originApp.setAppId(origin);
        originApp = this.paasAppsInfoService.queryByPk(originApp);
        if (originApp != null) {
            adjustLog.setAppCode(originApp.getAppCode());
            adjustLog.setAppName(originApp.getAppName());
        }
        adjustLog.setAdjustContent(JSON.toJSONString(adjustContentList));
        PaasAppsInfoVO targetApp = new PaasAppsInfoVO();
        targetApp.setAppId(target);
        targetApp = this.paasAppsInfoService.queryByPk(targetApp);
        if (targetApp != null && originApp != null) {
            adjustLog.setAdjustDesc(String.format("%s[%s]\u5408\u5e76\u5230%s[%s]", originApp.getAppName(), originApp.getAppCode(), targetApp.getAppName(), targetApp.getAppCode()));
        } else {
            adjustLog.setAdjustDesc(AdjustType.Combine.getName());
        }
        adjustLog.setAdjustType(AdjustType.Combine.getCode());
        adjustLog.setAdjustUser(this.getUserInfo().getUserId());
        adjustLog.setAdjustTime(CurrentDateUtil.getTodayDateEx2());
        this.paasAppsAdjustService.insertPaasAppsAdjust(adjustLog);
        return this.getResponseData(num);
    }

    @RequestMapping(value={"/paas/apps/info/move"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> moveApp(@RequestBody Map<String, Object> param) {
        ArrayList<Map<String, Object>> adjustContentList = new ArrayList<Map<String, Object>>();
        String appId = MapUtils.getString(param, (Object)"appId");
        String targetSubsId = MapUtils.getString(param, (Object)"targetSubsId");
        SSubsInfoVO targetSys = new SSubsInfoVO();
        targetSys.setSubsId(targetSubsId);
        targetSys = this.sSubsInfoService.queryByPk(targetSys);
        PaasAppsInfoVO appInfo = new PaasAppsInfoVO();
        appInfo.setAppId(appId);
        appInfo = this.paasAppsInfoService.queryByPk(appInfo);
        SSubsInfoVO originSys = new SSubsInfoVO();
        originSys.setSubsId(appInfo.getSubsId());
        originSys = this.sSubsInfoService.queryByPk(originSys);
        appInfo.setSubsId(targetSys.getSubsId());
        appInfo.setSubsCode(targetSys.getSubsCode());
        appInfo.setSubsName(targetSys.getSubsName());
        adjustContentList.add(this.createAdjustMap("\u5e94\u7528\u7cfb\u7edf", String.format("%s %s", originSys.getSubsName(), originSys.getSubsCode()), String.format("%s %s", targetSys.getSubsName(), targetSys.getSubsCode())));
        adjustContentList.add(this.createAdjustMap("\u67b6\u6784\u7c7b\u578b", appInfo.getArchType(), targetSys.getArchType()));
        appInfo.setArchType(targetSys.getArchType());
        String appTemplateId = targetSys.getArchType() + appInfo.getAppType();
        PaasTemplateInfoVO templateInfo = new PaasTemplateInfoVO();
        templateInfo.setAppTemplateId(appTemplateId);
        templateInfo = this.paasTemplateInfoService.queryByPk(templateInfo);
        if (templateInfo != null) {
            adjustContentList.add(this.createAdjustMap("\u5e94\u7528\u6a21\u677f", String.format("%s %s", appInfo.getAppTemplateId(), appInfo.getAppTemplateName()), String.format("%s %s", templateInfo.getAppTemplateId(), templateInfo.getAppTemplateName())));
            appInfo.setAppTemplateId(templateInfo.getAppTemplateId());
            appInfo.setAppTemplateName(templateInfo.getAppTemplateName());
        } else if (appInfo.getAppType().equals(AppType.A03.getCode())) {
            templateInfo = new PaasTemplateInfoVO();
            templateInfo.setAppType(appInfo.getAppType());
            templateInfo.setAppTemplateId(null);
            List templates = this.paasTemplateInfoService.queryAllByLevelOne(templateInfo);
            if (CollectionUtils.isNotEmpty((Collection)templates)) {
                adjustContentList.add(this.createAdjustMap("\u5e94\u7528\u6a21\u677f", String.format("%s %s", appInfo.getAppTemplateId(), appInfo.getAppTemplateName()), String.format("%s %s", templateInfo.getAppTemplateId(), templateInfo.getAppTemplateName())));
                templateInfo = (PaasTemplateInfoVO)templates.get(0);
                appInfo.setAppTemplateId(templateInfo.getAppTemplateId());
                appInfo.setAppTemplateName(templateInfo.getAppTemplateName());
            }
        }
        this.paasAppsInfoService.updateByPk(appInfo);
        PaasAppsAdjustVO adjustLog = new PaasAppsAdjustVO();
        adjustLog.setRecordKeyid(UUIDUtil.getUUID());
        adjustLog.setSubsId(originSys.getSubsId());
        adjustLog.setSubsCode(originSys.getSubsCode());
        adjustLog.setSubsName(originSys.getSubsName());
        adjustLog.setAppId(appInfo.getAppId());
        adjustLog.setAppCode(appInfo.getAppCode());
        adjustLog.setAppName(appInfo.getAppName());
        adjustLog.setAdjustContent(JSON.toJSONString(adjustContentList));
        if (appInfo != null) {
            adjustLog.setAdjustDesc(String.format("%s[%s]\u79fb\u52a8\u5230%s[%s]", appInfo.getAppName(), appInfo.getAppCode(), targetSys.getSubsName(), targetSys.getSubsCode()));
        } else {
            adjustLog.setAdjustDesc(AdjustType.Move.getName());
        }
        adjustLog.setAdjustType(AdjustType.Move.getCode());
        adjustLog.setAdjustUser(this.getUserInfo().getUserId());
        adjustLog.setAdjustTime(CurrentDateUtil.getTodayDateEx2());
        this.paasAppsAdjustService.insertPaasAppsAdjust(adjustLog);
        return this.getResponseData(1);
    }

    private Map<String, Object> createAdjustMap(String desc, String before, String after) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("desc", desc);
        map.put("beforeContent", before);
        map.put("afterContent", after);
        return map;
    }

    @RequestMapping(value={"/paas/apps/info/{appId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasAppsInfoVO> queryByPk(@PathVariable(value="appId") String appId) {
        PaasAppsInfoVO inVo = new PaasAppsInfoVO();
        inVo.setAppId(appId);
        PaasAppsInfoVO outputVo = this.paasAppsInfoService.queryByPk(inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasAppsInfoVO inPaasAppsInfoVo) {
        int outputVo = this.paasAppsInfoService.deleteByPk(inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @DevLog(action=LogAction.Delete, desc="\u5220\u9664\u5e94\u7528 ${args[0].subsId} ${args[0].appId}", appId="${args[0].appId}")
    @RequestMapping(value={"/paas/apps/info/project"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteFromProject(@RequestBody PaasAppsInfoVO inPaasAppsInfoVo) {
        PaasAppsInfoVO appInfo = new PaasAppsInfoVO();
        appInfo.setAppId(inPaasAppsInfoVo.getAppId());
        appInfo.setProjectId(inPaasAppsInfoVo.getProjectId());
        appInfo.setSubsId(inPaasAppsInfoVo.getSubsId());
        int outputVo = this.paasAppsInfoService.deleteByCond(appInfo);
        PaasAppsParamVO paasAppsParamVO = new PaasAppsParamVO();
        paasAppsParamVO.setAppId(inPaasAppsInfoVo.getAppId());
        this.paasAppsParamService.deleteByAppId(paasAppsParamVO);
        PaasAppsPropertiesVO propParam = new PaasAppsPropertiesVO();
        propParam.setAppId(inPaasAppsInfoVo.getAppId());
        this.paasAppsPropertiesService.deleteByAppId(propParam);
        PaasAppsSqlVO sqlParam = new PaasAppsSqlVO();
        sqlParam.setAppId(inPaasAppsInfoVo.getAppId());
        this.paasAppsSqlService.deleteByAppId(sqlParam);
        this.srvModelInfoService.deleteSpareData();
        this.srvModelInfoService.deleteSrvCompileData();
        ProjectTmInfoVO prjParam = new ProjectTmInfoVO();
        prjParam.setProjectId(inPaasAppsInfoVo.getProjectId());
        this.projectTmInfoService.deleteByPkWithTb(prjParam);
        this.projectTmInfoService.deleteByPk(prjParam);
        try {
            if (StringUtils.equals((CharSequence)AppCategory.FrontApp.getCode(), (CharSequence)inPaasAppsInfoVo.getAppCategory())) {
                FadpaasService fadpaasService = (FadpaasService)SpringContextUtils.getBean(FadpaasService.class);
                fadpaasService.deleteAppByAppId(inPaasAppsInfoVo.getAppId());
            }
            if (StringUtils.equals((CharSequence)AppCategory.LowCodeApp.getCode(), (CharSequence)inPaasAppsInfoVo.getAppCategory())) {
                NcdPaasService ncdPaasService = (NcdPaasService)SpringContextUtils.getBean(NcdPaasService.class);
                ncdPaasService.deleteAppByAppId(inPaasAppsInfoVo.getAppId());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasAppsInfoVO inPaasAppsInfoVo) {
        int outputVo = this.paasAppsInfoService.updateByPk(inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info/projectId"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByProjectId(@RequestBody PaasAppsInfoVO inPaasAppsInfoVo) {
        int outputVo = this.paasAppsInfoService.updateByProjectId(inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info/replace/template"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateAppTemplateIdByPk(@RequestBody PaasAppsInfoVO inPaasAppsInfoVo) {
        int outputVo = this.paasAppsInfoService.updateAppTemplateIdByPk(inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info/subsId"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateBySysCode(@RequestBody PaasAppsInfoVO inPaasAppsInfoVo) {
        int outputVo = this.paasAppsInfoService.updateBySubsCode(inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasAppsInfo(@RequestBody PaasAppsInfoVO inPaasAppsInfoVo) {
        try {
            String now = CurrentDateUtil.getTodayDateEx2();
            String userId = this.getUserInfo().getUserId();
            inPaasAppsInfoVo.setCreateUser(userId);
            inPaasAppsInfoVo.setCreateTime(now);
            inPaasAppsInfoVo.setLastUpdateUser(userId);
            inPaasAppsInfoVo.setLastUpdateTime(now);
            inPaasAppsInfoVo.setAppId(UUIDUtil.getUUID());
            int outputVo = this.paasAppsInfoService.insertPaasAppsInfo(inPaasAppsInfoVo);
            return this.getResponseData(inPaasAppsInfoVo.getAppId());
        }
        catch (Exception e) {
            ResponseData resp = this.getResponseData(null);
            resp.setMessage(e.getMessage());
            return resp;
        }
    }

    @RequestMapping(value={"/paas/apps/info/project"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasAppsInfoFromProject(@RequestParam(name="cpAppId", required=false) String cpAppId, @RequestParam(name="flag", required=false) Boolean flag, @RequestParam(name="createBaseServe", required=false) Boolean createBaseServe, final @RequestBody PaasAppsInfoVO inPaasAppsInfoVo) {
        PaasTemplateInfoVO templateInfo;
        String now = CurrentDateUtil.getTodayDateEx2();
        String userId = this.getUserInfo().getUserId();
        String appType = inPaasAppsInfoVo.getAppType();
        String archType = inPaasAppsInfoVo.getArchType();
        String subsId = inPaasAppsInfoVo.getSubsId();
        if (StringUtils.isBlank((CharSequence)inPaasAppsInfoVo.getAppId())) {
            String appId = this.paasAppsInfoService.queryAppIdSeqWithPrefix(subsId, subsId);
            inPaasAppsInfoVo.setAppId(appId);
        }
        inPaasAppsInfoVo.setSubsId(subsId);
        inPaasAppsInfoVo.setCreateUser(userId);
        inPaasAppsInfoVo.setCreateTime(now);
        inPaasAppsInfoVo.setLastUpdateUser(userId);
        inPaasAppsInfoVo.setLastUpdateTime(now);
        if (StringUtils.isNotBlank((CharSequence)inPaasAppsInfoVo.getAppTemplateId())) {
            templateInfo = new PaasTemplateInfoVO();
            templateInfo.setAppTemplateId(inPaasAppsInfoVo.getAppTemplateId());
            templateInfo = this.paasTemplateInfoService.queryByPk(templateInfo);
            if (templateInfo != null) {
                inPaasAppsInfoVo.setAppTemplateId(templateInfo.getAppTemplateId());
                inPaasAppsInfoVo.setAppTemplateName(templateInfo.getAppTemplateName());
                inPaasAppsInfoVo.setAppStartShell(templateInfo.getAppStartShell());
                inPaasAppsInfoVo.setAppRestartShell(templateInfo.getAppRestartShell());
                inPaasAppsInfoVo.setAppStopShell(templateInfo.getAppStopShell());
                inPaasAppsInfoVo.setAppPlGenerate(templateInfo.getAppPlGenerate());
                inPaasAppsInfoVo.setAppPlCompile(templateInfo.getAppPlCompile());
                inPaasAppsInfoVo.setAppPlDeploy(templateInfo.getAppPlDeploy());
                inPaasAppsInfoVo.setArchType(templateInfo.getArchType());
                if (StringUtils.isBlank((CharSequence)inPaasAppsInfoVo.getAppGitUrl())) {
                    inPaasAppsInfoVo.setAppGitUrl(templateInfo.getAppTemplateGitUrl());
                }
                inPaasAppsInfoVo.setAppCreateWay(AppCreateWay.TemplateCreate.getCode());
            }
        } else {
            templateInfo = new PaasTemplateInfoVO();
            templateInfo.setAppTemplateId(appType + archType);
            templateInfo = this.paasTemplateInfoService.queryByPk(templateInfo);
            if (templateInfo != null) {
                inPaasAppsInfoVo.setAppTemplateId(appType + archType);
                inPaasAppsInfoVo.setAppTemplateName(templateInfo.getAppTemplateName());
                inPaasAppsInfoVo.setAppStartShell(templateInfo.getAppStartShell());
                inPaasAppsInfoVo.setAppRestartShell(templateInfo.getAppRestartShell());
                inPaasAppsInfoVo.setAppStopShell(templateInfo.getAppStopShell());
                inPaasAppsInfoVo.setAppPlGenerate(templateInfo.getAppPlGenerate());
                inPaasAppsInfoVo.setAppPlCompile(templateInfo.getAppPlCompile());
                inPaasAppsInfoVo.setAppPlDeploy(templateInfo.getAppPlDeploy());
            } else if (appType.equals(AppType.A03.getCode())) {
                templateInfo = new PaasTemplateInfoVO();
                templateInfo.setAppType(appType);
                templateInfo.setAppTemplateId(null);
                List templates = this.paasTemplateInfoService.queryAllByLevelOne(templateInfo);
                if (CollectionUtils.isNotEmpty((Collection)templates)) {
                    templateInfo = (PaasTemplateInfoVO)templates.get(0);
                    inPaasAppsInfoVo.setAppTemplateId(templateInfo.getAppTemplateId());
                    inPaasAppsInfoVo.setAppTemplateName(templateInfo.getAppTemplateName());
                }
            }
        }
        if (inPaasAppsInfoVo.getAppOrder() == null) {
            PaasAppsInfoVO appParam = new PaasAppsInfoVO();
            appParam.setSubsId(subsId);
            appParam = this.paasAppsInfoService.querySysCodeAppOrder(appParam);
            if (appParam != null) {
                Integer order = appParam.getAppOrder();
                if (order == null) {
                    order = 0;
                }
                inPaasAppsInfoVo.setAppOrder(Integer.valueOf(order + 1));
            } else {
                inPaasAppsInfoVo.setAppOrder(Integer.valueOf(1));
            }
        }
        if (AppType.A80.getCode().equals(appType)) {
            PaasAppsInfoVO cpAppInfo = new PaasAppsInfoVO();
            cpAppInfo.setAppId(cpAppId);
            cpAppInfo = this.paasAppsInfoService.queryByPk(cpAppInfo);
            if (cpAppInfo != null) {
                PaasAppsInfoVO appInfo = inPaasAppsInfoVo;
                appInfo.setAppCode(cpAppInfo.getAppCode());
                appInfo.setAppName(cpAppInfo.getAppName());
                appInfo.setArchType(cpAppInfo.getArchType());
                appInfo.setAppType(appType);
                appInfo.setSubsId(subsId);
                appInfo.setProjectId(cpAppInfo.getProjectId());
                appInfo.setProjectCode(cpAppInfo.getProjectCode());
                appInfo.setProjectName(cpAppInfo.getProjectName());
                appInfo.setAppTemplateId(cpAppInfo.getAppTemplateId());
                appInfo.setAppTemplateName(cpAppInfo.getAppTemplateName());
                appInfo.setRefAppId(cpAppInfo.getAppId());
                appInfo.setRefSysCode(cpAppInfo.getSubsCode());
                appInfo.setAppDesc(cpAppInfo.getAppDesc());
                appInfo.setAppMavenPom(cpAppInfo.getAppMavenPom());
                if (StringUtils.isBlank((CharSequence)cpAppInfo.getSubsName())) {
                    SSubsInfoVO sSubsInfoVO = new SSubsInfoVO();
                    sSubsInfoVO.setSubsCode(cpAppInfo.getSubsCode());
                    sSubsInfoVO = this.sSubsInfoService.queryByPk(sSubsInfoVO);
                    if (sSubsInfoVO != null) {
                        cpAppInfo.setSubsCode(sSubsInfoVO.getSubsCode());
                        cpAppInfo.setSubsName(sSubsInfoVO.getSubsName());
                        this.paasAppsInfoService.updateByPk(cpAppInfo);
                    }
                }
                appInfo.setRefSysName(cpAppInfo.getSubsName());
            }
        } else {
            inPaasAppsInfoVo.setAppMavenPom(this.genAppMavenPom(inPaasAppsInfoVo.getAppCode(), inPaasAppsInfoVo.getAppType()));
        }
        if (StringUtils.isNotBlank((CharSequence)inPaasAppsInfoVo.getAppCreateWay())) {
            inPaasAppsInfoVo.setAppCreateWay(AppCreateWay.DirectCreate.getCode());
        }
        try {
            int cpAppInfo = this.paasAppsInfoService.insertPaasAppsInfo(inPaasAppsInfoVo);
        }
        catch (Exception e) {
            ResponseData resp = this.getResponseData(null);
            resp.setMessage(e.getMessage());
            return resp;
        }
        if (StringUtils.equalsAny((CharSequence)inPaasAppsInfoVo.getAppCategory(), (CharSequence[])new CharSequence[]{AppCategory.ServiceApp.getCode()}) || StringUtils.equalsAny((CharSequence)inPaasAppsInfoVo.getAppCategory(), (CharSequence[])new CharSequence[]{AppCategory.LowCodeApp.getCode()}) && StringUtils.equalsAny((CharSequence)appType, (CharSequence[])new CharSequence[]{AppType.A91.getCode()})) {
            String archTypeInitials;
            String string = archTypeInitials = StringUtils.isNotBlank((CharSequence)archType) ? archType.substring(0, 1) : archType;
            if (Objects.nonNull(flag) && flag.booleanValue() || "D".equals(archTypeInitials)) {
                this.paasAppsInfoService.generateIsrvRspInfo(inPaasAppsInfoVo.getAppId());
                this.paasAppsInfoService.generateUserTokenInfo(inPaasAppsInfoVo.getAppId());
                this.paasAppsInfoService.generatePageInfo(inPaasAppsInfoVo.getAppId());
                this.paasAppsInfoService.generateDateData(inPaasAppsInfoVo.getAppId());
                this.paasAppsInfoService.generateGivenData(inPaasAppsInfoVo.getAppId());
                this.paasAppsInfoService.generateRandomData(inPaasAppsInfoVo.getAppId());
                if (createBaseServe.booleanValue()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            PaasAppsInfoController.this.srvModelInfoService.generateBaseServer(inPaasAppsInfoVo.getAppId());
                        }
                    }).start();
                }
            }
        }
        SSubsInfoVO subsInfo = new SSubsInfoVO();
        subsInfo.setSubsId(inPaasAppsInfoVo.getSubsId());
        subsInfo = this.sSubsInfoService.queryByPk(subsInfo);
        if (subsInfo != null && StringUtils.equals((CharSequence)SolutionType.SDK.getCode(), (CharSequence)subsInfo.getSolutionType()) && StringUtils.isNotBlank((CharSequence)inPaasAppsInfoVo.getAppGitUrl())) {
            try {
                PaasEnvParamVO envParam = new PaasEnvParamVO();
                envParam.setEnvId("paas");
                envParam.setParamGroup("git.user");
                List gitParamList = this.paasEnvParamService.queryAllOwner(envParam);
                if (CollectionUtils.isNotEmpty((Collection)gitParamList)) {
                    String gitUrl;
                    String gitType = this.getEnvParamByCode("git.type", gitParamList);
                    String gitHostUrl = this.getEnvParamByCode("git.host.url", gitParamList);
                    String accessToken = this.getEnvParamByCode("git.open.api.access_token", gitParamList);
                    if (gitHostUrl.endsWith("/")) {
                        gitHostUrl = gitHostUrl.substring(0, gitHostUrl.length() - 1);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(gitUrl = inPaasAppsInfoVo.getAppGitUrl()))) {
                        logger.info(String.format("\u5f53\u524d\u4ed3\u5e93\u5bf9\u63a5\u662f %s", gitType));
                        boolean result = true;
                        if (StringUtils.equals((CharSequence)"gitee", (CharSequence)gitType)) {
                            result = this.sSubsInfoService.giteeRepoHandler(gitUrl, userId, gitHostUrl, accessToken, Collections.emptyList());
                        } else if (StringUtils.equals((CharSequence)"gitlab", (CharSequence)gitType)) {
                            result = this.sSubsInfoService.gitlabRepoHandler(gitUrl, userId, gitHostUrl, accessToken, Collections.emptyList());
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u521b\u5efaSDK\u4ed3\u5e93\u5f02\u5e38 " + inPaasAppsInfoVo.getAppGitUrl() + " " + e.getMessage(), (Throwable)e);
            }
        }
        return this.getResponseData(inPaasAppsInfoVo.getAppId());
    }

    private String genAppMavenPom(String appCode, String appType) {
        try {
            appCode = appCode.replaceAll("\\_", "-");
            String[] ary = appCode.split("-");
            String groupId = ary[0];
            for (int i = 1; i < ary.length; ++i) {
                groupId = groupId + "." + ary[i];
            }
            if (Arrays.asList(AppType.A01.getCode(), AppType.A02.getCode(), AppType.A03.getCode(), AppType.A05.getCode(), AppType.A09.getCode()).indexOf(appType) >= 0) {
                String appMavenPom = "<dependency>\n\t<groupId>allinpaas.component</groupId>\n\t<artifactId>" + appCode + "</artifactId>\n\t<version>1.0-SNAPSHOT</version>\n</dependency>\n";
                return appMavenPom;
            }
            String appMavenPom = "<dependency>\n\t<groupId>com.irdstudio." + groupId + "</groupId>\n\t<artifactId>" + appCode + "-facade</artifactId>\n\t<version>1.0-SNAPSHOT</version>\n</dependency>\n";
            return appMavenPom;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @RequestMapping(value={"/paas/apps/info/project/{projectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> checkProjectIdHasApp(@PathVariable(value="projectId") String projectId) {
        PaasAppsInfoVO inVo = new PaasAppsInfoVO();
        inVo.setProjectId(projectId);
        List exists = this.paasAppsInfoService.queryAllOwner(inVo);
        return this.getResponseData(CollectionUtils.isNotEmpty((Collection)exists));
    }

    @RequestMapping(value={"/paas/apps/infos/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoVO>> queryAppsInfoData(@RequestBody PaasAppsInfoVO param) {
        List outputVo = this.paasAppsInfoService.queryAppsInfoData(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/infos/page/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoVO>> queryAppsInfoDataByPage(PaasAppsInfoVO param) {
        List outputVo = this.paasAppsInfoService.queryAppsInfoDataByPage(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info/summarys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, Object>> queryAppsIndexSummary(@RequestBody PaasAppsInfoVO param) {
        Map outputVo = this.srvModelInfoService.queryAppsIndexSummary(param.getAppId());
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info/group/summarys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, Object>> queryAppsIndexGroupSummary(@RequestBody PaasAppsInfoVO param) {
        Map outputVo = this.srvModelInfoService.queryAppsIndexGroupSummary(param.getSubsId(), param.getBizDbName());
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/infos/component"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoVO>> queryComponentApp(@RequestBody PaasAppsInfoVO param) {
        List outputVo = this.paasAppsInfoService.queryComponentApp(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/infos/platform/component"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoVO>> queryPlatformComponentAppByPage(PaasAppsInfoVO param) {
        List outputVo = this.paasAppsInfoService.queryPlatformComponentAppByPage(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/info/pull/repo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> pullComponentRepo(@RequestParam(value="check", required=false) boolean check, @RequestBody PaasAppsInfoVO vo) {
        ResponseData outputVo = this.getResponseData("\u62c9\u53d6\u6210\u529f");
        logger.info("\u4ee3\u7801\u76ee\u5f55\uff1a" + this.facenterCodePath + File.separator + vo.getAppId());
        PaasAppsInfoVO appInfo = this.paasAppsInfoService.queryByPk(vo);
        if (appInfo == null) {
            outputVo.setRows((Object)"\u5e94\u7528\u4e0d\u5b58\u5728");
        } else {
            File repoPath;
            if (check && (repoPath = new File(this.facenterCodePath + File.separator + appInfo.getAppId())).exists() && repoPath.listFiles().length > 0) {
                outputVo.setRows((Object)"\u4ed3\u5e93\u5df2\u5b58\u5728");
                return outputVo;
            }
            PaasEnvParamVO tdpaasProduct = new PaasEnvParamVO();
            tdpaasProduct.setParamGroup("git.allinpaas.product");
            tdpaasProduct.setEnvId("paas");
            List productList = this.paasEnvParamService.queryAllOwner(tdpaasProduct);
            tdpaasProduct.setParamGroup("git.user");
            List gitList = this.paasEnvParamService.queryAllOwner(tdpaasProduct);
            productList.addAll(gitList);
            HashMap<String, PaasEnvParamVO> map = new HashMap<String, PaasEnvParamVO>();
            for (PaasEnvParamVO param : productList) {
                map.put(param.getParamCode(), param);
            }
            String productRemote = ((PaasEnvParamVO)map.get("git.allinpaas.product.remote.path")).getParamValue();
            String branchName = ((PaasEnvParamVO)map.get("git.allinpaas.product.branch.name")).getParamValue();
            String userName = ((PaasEnvParamVO)map.get("git.username")).getParamValue();
            String password = ((PaasEnvParamVO)map.get("git.password")).getParamValue();
            String url = String.format("%s/%s.git", productRemote, appInfo.getAppCode());
            if (this.repositoryPush(this.facenterCodePath + File.separator + appInfo.getAppId(), url, userName, password, branchName)) {
                outputVo.setRows((Object)"\u62c9\u53d6\u6210\u529f");
            } else {
                outputVo.setRows((Object)"\u62c9\u53d6\u5931\u8d25");
            }
        }
        return outputVo;
    }

    public boolean repositoryPush(String localPath, String remotePath, String username, String password, String branchName) {
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    @RequestMapping(value={"/paas/apps/infos/groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoVO>> queryAllGroupByPage(PaasAppsInfoVO vo) {
        List outputVo = this.paasAppsInfoService.queryAllGroupByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/paas/apps/infos/init/common/table"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> initCommonTable(@RequestParam(value="appId") String appId) {
        this.paasAppsInfoService.generateIsrvRspInfo(appId);
        this.paasAppsInfoService.generateUserTokenInfo(appId);
        this.paasAppsInfoService.generatePageInfo(appId);
        this.paasAppsInfoService.generateDateData(appId);
        this.paasAppsInfoService.generateGivenData(appId);
        this.paasAppsInfoService.generateRandomData(appId);
        return this.getResponseData("\u521d\u59cb\u5316\u6210\u529f");
    }

    private String getEnvParamByCode(String paramCode, List<PaasEnvParamVO> paramList) {
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasEnvParamVO param : paramList) {
                if (!param.getParamCode().equals(paramCode)) continue;
                return param.getParamValue();
            }
        }
        return null;
    }

    @RequestMapping(value={"/paas/apps/info/seq"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryAppIdSeqWithPrefix(@RequestParam(value="subsId") String subsId) {
        String seq = this.paasAppsInfoService.queryAppIdSeqWithPrefix(subsId, subsId);
        return this.getResponseData(seq);
    }

    @RequestMapping(value={"/paas/apps/info/idreset"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> appIdReset(@RequestBody Map<String, Object> param) {
        String subsId = MapUtils.getString(param, (Object)"subsId");
        String appId = MapUtils.getString(param, (Object)"appId");
        String newAppId = MapUtils.getString(param, (Object)"newAppId");
        SSubsInfoVO targetSys = new SSubsInfoVO();
        targetSys.setSubsId(subsId);
        targetSys = this.sSubsInfoService.queryByPk(targetSys);
        PaasAppsInfoVO appInfo = new PaasAppsInfoVO();
        appInfo.setAppId(appId);
        appInfo = this.paasAppsInfoService.queryByPk(appInfo);
        this.paasAppsInfoService.appIdReset(appId, newAppId);
        this.paasAppsInfoService.projectIdReset(appInfo.getProjectId(), newAppId);
        try {
            FadpaasService fadpaasService = (FadpaasService)SpringContextUtils.getBean(FadpaasService.class);
            fadpaasService.appIdReset(appId, newAppId);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u524d\u7aef\u5f00\u53d1\u5e73\u53f0\u6a21\u5757\u63a5\u53e3\u8c03\u6574\u5e94\u7528\u7f16\u53f7\u5f02\u5e38  " + e.getMessage(), (Throwable)e);
        }
        try {
            NcdPaasService ncdPaasService = (NcdPaasService)SpringContextUtils.getBean(NcdPaasService.class);
            ncdPaasService.appIdReset(appId, newAppId);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4f4e\u4ee3\u7801\u5e73\u53f0\u6a21\u5757\u63a5\u53e3\u8c03\u6574\u5e94\u7528\u7f16\u53f7\u5f02\u5e38  " + e.getMessage(), (Throwable)e);
        }
        PaasAppsAdjustVO adjustLog = new PaasAppsAdjustVO();
        adjustLog.setRecordKeyid(UUIDUtil.getUUID());
        adjustLog.setSubsId(targetSys.getSubsId());
        adjustLog.setSubsCode(targetSys.getSubsCode());
        adjustLog.setSubsName(targetSys.getSubsName());
        adjustLog.setAppId(appInfo.getAppId());
        adjustLog.setAppCode(appInfo.getAppCode());
        adjustLog.setAppName(appInfo.getAppName());
        adjustLog.setAdjustContent(JSON.toJSONString((Object)appInfo));
        adjustLog.setAdjustDesc(String.format("\u5e94\u7528\u7f16\u53f7\u7531 %s \u8c03\u6574\u4e3a %s, \u6570\u636e\u6a21\u578b\u5e93\u7f16\u53f7\u7531 %s \u8c03\u6574\u4e3a %s", appId, newAppId, appInfo.getProjectId(), newAppId));
        adjustLog.setAdjustType(AdjustType.ChangeAppId.getCode());
        adjustLog.setAdjustUser(this.getUserInfo().getUserId());
        adjustLog.setAdjustTime(CurrentDateUtil.getTodayDateEx2());
        this.paasAppsAdjustService.insertPaasAppsAdjust(adjustLog);
        return this.getResponseData(1);
    }
}

