/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.solution.api.rest;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSON;
import com.irdstudio.allinpaas.common.enums.YesOrNO;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableFieldService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.AnalysisIndexExcelData;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmInfoVO;
import com.irdstudio.allinpaas.executor.core.plugin.datarefactor.AnalysisTableMatchItemTask;
import com.irdstudio.allinpaas.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinpaas.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinpaas.executor.core.tinycore.jdbc.dbcp.impl.ConnPoolForDruid;
import com.irdstudio.allinpaas.feignclient.WikiService;
import com.irdstudio.allinpaas.feignclient.vo.WikiSubsDirectoryVO;
import com.irdstudio.allinpaas.portal.core.api.rest.ModuleSyncController;
import com.irdstudio.allinpaas.portal.core.api.rest.OutsideRmpPanelInfoController;
import com.irdstudio.allinpaas.portal.core.dao.domain.SSubsInfo;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasAppsInfoService;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasDocDirectoryService;
import com.irdstudio.allinpaas.portal.core.service.facade.PaasEcsInfoService;
import com.irdstudio.allinpaas.portal.core.service.facade.SSubsInfoService;
import com.irdstudio.allinpaas.portal.core.service.vo.PaasAppsInfoVO;
import com.irdstudio.allinpaas.portal.core.service.vo.PaasDocDirectoryVO;
import com.irdstudio.allinpaas.portal.core.service.vo.SSubsInfoVO;
import com.irdstudio.sdk.admin.service.facade.SDicService;
import com.irdstudio.sdk.admin.service.vo.SDicVO;
import com.irdstudio.sdk.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.EasyUITreeData;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.vo.UserInfo;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class SSubsInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="sSubsInfoService")
    private SSubsInfoService sSubsInfoService;
    @Autowired
    @Qualifier(value="paasAppsInfoServiceImpl")
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    @Qualifier(value="paasDocDirectoryServiceImpl")
    private PaasDocDirectoryService paasDocDirectoryService;
    @Autowired
    @Qualifier(value="paasEcsInfoService")
    private PaasEcsInfoService paasEcsInfoService;
    @Autowired
    @Qualifier(value="sDicService")
    private SDicService sDicService;
    @Autowired
    @Qualifier(value="modelTableInfoService")
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    @Qualifier(value="modelTableFieldService")
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    @Qualifier(value="projectTmInfoService")
    private ProjectTmInfoService projectTmInfoService;
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;

    @RequestMapping(value={"/s/subs/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SSubsInfoVO>> querySSubsInfoAll(SSubsInfoVO vo) {
        List outputVo = this.sSubsInfoService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/subs/info/max"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> querySSubsInfoMaxOrder() {
        Integer outputVo = this.sSubsInfoService.querySSubsInfoMaxOrder();
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/subs/infos/ddspaas"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryDdspaasSummaryByPage(SSubsInfoVO vo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getSolutionType()) && org.apache.commons.lang3.StringUtils.contains((CharSequence)vo.getSolutionType(), (CharSequence)",")) {
            vo.setSolutionTypes(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)vo.getSolutionType(), (String)",")));
            vo.setSolutionType(null);
        }
        List outputVo = this.sSubsInfoService.queryDdspaasSummaryByPage(vo);
        ResponseData resp = this.getResponseData(outputVo);
        resp.setTotal(vo.getTotal().intValue());
        return resp;
    }

    @RequestMapping(value={"/s/subs/infos/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySubsSummary(SSubsInfoVO vo) {
        List outputVo = this.sSubsInfoService.querySubsSummary(vo);
        ResponseData resp = this.getResponseData(outputVo);
        resp.setTotal(vo.getTotal().intValue());
        return resp;
    }

    @RequestMapping(value={"/s/subs/info/{subsId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SSubsInfoVO> queryByPk(@PathVariable(value="subsId") String subsId) {
        SSubsInfoVO inVo = new SSubsInfoVO();
        inVo.setSubsId(subsId);
        SSubsInfoVO outputVo = this.sSubsInfoService.queryByPk(inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/subs/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SSubsInfoVO inSSubsInfoVo) {
        int outputVo = this.sSubsInfoService.deleteByPk(inSSubsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/subs/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SSubsInfoVO inSSubsInfoVo) {
        SSubsInfoVO oldSubsInfo = this.sSubsInfoService.queryByPk(inSSubsInfoVo);
        int outputVo = this.sSubsInfoService.updateByPk(inSSubsInfoVo);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inSSubsInfoVo.getDocLibraryId())) {
            this.initWikiDirectory(inSSubsInfoVo, !org.apache.commons.lang3.StringUtils.equals((CharSequence)oldSubsInfo.getDocLibraryId(), (CharSequence)inSSubsInfoVo.getDocLibraryId()));
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/subs/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSSubsInfo(@RequestBody SSubsInfoVO inSSubsInfoVo) {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        inSSubsInfoVo.setSubsDataDate(formatter.format(date));
        this.setUserInfoToVO(inSSubsInfoVo);
        int outputVo = this.sSubsInfoService.insertSSubsInfo(inSSubsInfoVo);
        OutsideRmpPanelInfoController rmpController = (OutsideRmpPanelInfoController)SpringContextUtils.getBean(OutsideRmpPanelInfoController.class);
        HashMap<String, String> inRmpPanelInfoVo = new HashMap<String, String>();
        inRmpPanelInfoVo.put("loginUserId", inSSubsInfoVo.getLoginUserId());
        inRmpPanelInfoVo.put("panelDataCycle", "R");
        inRmpPanelInfoVo.put("panelDataInterval", "10");
        inRmpPanelInfoVo.put("panelLayout", "2");
        inRmpPanelInfoVo.put("subsId", inSSubsInfoVo.getSubsId());
        inRmpPanelInfoVo.put("panelId", inSSubsInfoVo.getSubsId() + "-default");
        inRmpPanelInfoVo.put("panelName", inSSubsInfoVo.getSubsName() + "\u9762\u677f");
        rmpController.insertRmpPanelInfo(inRmpPanelInfoVo);
        final ModuleSyncController moduleSyncController = (ModuleSyncController)SpringContextUtils.getBean(ModuleSyncController.class);
        if (moduleSyncController != null) {
            final HashMap<String, String> syncParam = new HashMap<String, String>();
            syncParam.put("syncData", "SSubsInfo");
            syncParam.put("subsId", inSSubsInfoVo.getSubsId());
            new Thread(){

                @Override
                public void run() {
                    moduleSyncController.queryAppsCheckLogAll(syncParam);
                }
            }.start();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inSSubsInfoVo.getDocLibraryId())) {
            this.initWikiDirectory(inSSubsInfoVo, true);
        }
        return this.getResponseData(outputVo);
    }

    private void initWikiDirectory(final SSubsInfoVO subsInfo, final Boolean recovery) {
        final ArrayList<WikiSubsDirectoryVO> wikiDirList = new ArrayList<WikiSubsDirectoryVO>();
        PaasDocDirectoryVO param = new PaasDocDirectoryVO();
        param.setLibId(subsInfo.getDocLibraryId());
        param.setSize(Integer.valueOf(1000));
        List docDirList = this.paasDocDirectoryService.queryAllOwner(param);
        if (CollectionUtils.isNotEmpty((Collection)docDirList)) {
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            HashMap<String, String> keyMap = new HashMap<String, String>();
            for (PaasDocDirectoryVO dir : docDirList) {
                String abvId;
                String key = (String)keyMap.get(dir.getDirId());
                if (key == null) {
                    key = UUIDUtil.getUUID();
                    keyMap.put(dir.getDirId(), key);
                }
                if ((abvId = (String)keyMap.get(dir.getDirAbvId())) == null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dir.getDirAbvId())) {
                    abvId = UUIDUtil.getUUID();
                    keyMap.put(dir.getDirAbvId(), abvId);
                }
                WikiSubsDirectoryVO wikiDir = new WikiSubsDirectoryVO();
                wikiDir.setDirId(key);
                wikiDir.setDirPid(abvId);
                wikiDir.setDirName(dir.getDirName());
                wikiDir.setDirOrder(dir.getDirOrder());
                wikiDir.setSubsId(subsInfo.getSubsId());
                wikiDir.setCreateUser(subsInfo.getLoginUserId());
                wikiDir.setCreateTime(nowTime);
                wikiDirList.add(wikiDir);
            }
        }
        new Thread(){

            @Override
            public void run() {
                WikiService wikiService = (WikiService)SpringContextUtils.getBean(WikiService.class);
                try {
                    ResponseData resp = wikiService.saveSubsDirectors(recovery, wikiDirList);
                    logger.info(subsInfo.getSubsCode() + " wiki\u76ee\u5f55\u521d\u59cb\u5316\u7ed3\u679c {}", (Object)JSON.toJSONString((Object)resp));
                }
                catch (Exception e) {
                    logger.error(subsInfo.getSubsCode() + e.getMessage(), (Throwable)e);
                }
            }
        }.start();
    }

    @RequestMapping(value={"/s/subs/info/all"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SSubsInfoVO>> queryAllSSubsInfo(SSubsInfoVO vo) {
        List outputVo = this.sSubsInfoService.queryAllByCondition(vo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/s/subs/info/app/nav/{subsId}"})
    @ResponseBody
    public List<Object> queryTree(@PathVariable(value="subsId") String subsId, @RequestParam(name="projectId", required=true) String projectId, @RequestParam(name="appId", required=false) String appId, @RequestParam(name="onlyTable", required=false) boolean onlyTable, @RequestParam(name="appType", required=false) String appType) {
        List treeData = this.sSubsInfoService.queryAppsTreeNav(subsId, projectId, appId, Boolean.valueOf(onlyTable), appType);
        return treeData;
    }

    @PostMapping(value={"/s/subs/info/app/nav/pop/{subsId}"})
    @ResponseBody
    public List<Object> queryAppsTreeForPop(@PathVariable(value="subsId") String subsId, @RequestParam(name="projectId", required=true) String projectId, @RequestParam(name="appId", required=false) String appId, @RequestParam(name="onlyTable", required=false) boolean onlyTable, @RequestParam(name="appType", required=false) String appType) {
        List treeData = this.sSubsInfoService.queryAppsTreeForPop(subsId, projectId, appId, Boolean.valueOf(onlyTable), appType);
        return treeData;
    }

    @PostMapping(value={"/s/subs/info/nav/group/{subsId}"})
    @ResponseBody
    public List<Object> queryBizDbTree(@PathVariable(value="subsId") String subsId, @RequestParam(name="bizDbName", required=true) String bizDbName) {
        List treeData = this.sSubsInfoService.queryBizDbTreeNav(subsId, bizDbName);
        return treeData;
    }

    @RequestMapping(value={"s/subs/info/tc/nav"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<EasyUITreeData>> queryTComponentIndex(@RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="appType", required=false) String appType) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)subsId)) {
            subsId = null;
        }
        List treeList = this.sSubsInfoService.queryTComponentIndex(subsId, appType);
        return this.getResponseData(treeList);
    }

    @RequestMapping(value={"s/subs/info/third/tree"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<EasyUITreeData>> querySubsTreeExcludeSelf(@RequestParam(value="subsId", required=false) String subsId) {
        List treeList = this.sSubsInfoService.querySubsTreeExcludeSelf(subsId);
        return this.getResponseData(treeList);
    }

    @RequestMapping(value={"s/subs/info/third/tree/market"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<EasyUITreeData>> querySubsTreeForMarketWithAppType(@RequestParam(value="appType", required=false) String appType) {
        List treeList = this.sSubsInfoService.querySubsTreeForMarket(appType);
        return this.getResponseData(treeList);
    }

    @RequestMapping(value={"s/subs/info/apps/tree"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<EasyUITreeData>> querySubsTreeForMarket(@RequestParam(value="subsId", required=true) String subsId) {
        List treeList = this.sSubsInfoService.querySubsAppsTree(subsId);
        return this.getResponseData(treeList);
    }

    @RequestMapping(value={"/s/subs/infos/apps"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, Object>> querySubsApps() {
        SSubsInfoVO vo = new SSubsInfoVO();
        vo.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List subsList = this.sSubsInfoService.queryAllByCondition(vo);
        PaasAppsInfoVO appParam = new PaasAppsInfoVO();
        appParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List appList = this.paasAppsInfoService.queryAllOwner(appParam);
        HashMap<String, List> outputVo = new HashMap<String, List>();
        outputVo.put("subs", subsList);
        outputVo.put("apps", appList);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/wiki/subs/page/upload"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertWikiDocumentWithFile(HttpServletRequest request, @RequestPart(value="file", required=false) MultipartFile file) {
        boolean flag = this.sSubsInfoService.insertWikiDocumentWithFile(request, file);
        return this.getResponseData(flag ? "\u4fdd\u5b58\u6210\u529f" : "\u5904\u7406\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"wiki/subs/page/preview"}, method={RequestMethod.GET})
    public void loadWikiDocumentFile(@RequestParam(value="subsId") String subsId, @RequestParam(value="dirId") String dirId, @RequestParam(value="docTitle") String docTitle, @RequestParam(value="docType") String docType, @RequestParam(value="previewType", required=false) String previewType, @RequestParam(value="loginUserId") String loginUserId, HttpServletResponse response) throws IOException {
        block19: {
            File targetFile;
            block20: {
                targetFile = this.sSubsInfoService.loadWikiFileForView(subsId, dirId, docTitle, docType, loginUserId);
                if (targetFile == null) break block20;
                BufferedInputStream bis = null;
                BufferedOutputStream bos = null;
                try {
                    int bytesRead;
                    response.setContentType("application/" + docType);
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)previewType, (CharSequence)"preview")) {
                        response.setHeader("Content-Disposition", "attachment;filename=" + new String(targetFile.getName().getBytes(), "iso-8859-1"));
                    }
                    ServletOutputStream out = response.getOutputStream();
                    bis = new BufferedInputStream(new FileInputStream(targetFile));
                    bos = new BufferedOutputStream((OutputStream)out);
                    byte[] buff = new byte[2048];
                    while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                        bos.write(buff, 0, bytesRead);
                    }
                    ResourceCloseUtil.closeInputStream((InputStream)bis);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    break block19;
                }
                finally {
                    ResourceCloseUtil.closeInputStream(bis);
                    ResourceCloseUtil.closeOutputStream(bos);
                }
                ResourceCloseUtil.closeOutputStream((OutputStream)bos);
                break block19;
            }
            response.setContentType("application/" + docType + ";charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(targetFile.getName().getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            try (PrintWriter rsp = response.getWriter();){
                rsp.write("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"wiki/subs/page/preview/docx/{fileName}"}, method={RequestMethod.GET})
    public void loaddDocxWithFileName(@RequestParam(value="subsId") String subsId, @RequestParam(value="dirId") String dirId, @RequestParam(value="docTitle") String docTitle, @RequestParam(value="docType") String docType, @RequestParam(value="previewType", required=false) String previewType, @RequestParam(value="loginUserId") String loginUserId, HttpServletResponse response) throws IOException {
        block19: {
            File targetFile;
            block20: {
                targetFile = this.sSubsInfoService.loadWikiFileForView(subsId, dirId, docTitle, docType, loginUserId);
                if (targetFile == null) break block20;
                BufferedInputStream bis = null;
                BufferedOutputStream bos = null;
                try {
                    int bytesRead;
                    response.setContentType("application/" + docType);
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)previewType, (CharSequence)"preview")) {
                        response.setHeader("Content-Disposition", "attachment;filename=" + new String(targetFile.getName().getBytes(), "iso-8859-1"));
                    }
                    ServletOutputStream out = response.getOutputStream();
                    bis = new BufferedInputStream(new FileInputStream(targetFile));
                    bos = new BufferedOutputStream((OutputStream)out);
                    byte[] buff = new byte[2048];
                    while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                        bos.write(buff, 0, bytesRead);
                    }
                    ResourceCloseUtil.closeInputStream((InputStream)bis);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    break block19;
                }
                finally {
                    ResourceCloseUtil.closeInputStream(bis);
                    ResourceCloseUtil.closeOutputStream(bos);
                }
                ResourceCloseUtil.closeOutputStream((OutputStream)bos);
                break block19;
            }
            response.setContentType("application/" + docType + ";charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(targetFile.getName().getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            try (PrintWriter rsp = response.getWriter();){
                rsp.write("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/s/subs/info/import/template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelTemplateDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = new File(templateRootPath + File.separator + "xlsx" + File.separator + "\u5e94\u7528\u7cfb\u7edf\u6a21\u677f.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u5e94\u7528\u7cfb\u7edf\u6a21\u677f.xlsx".getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u578b\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    @PostMapping(value={"/s/subs/info/import/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestPart(value="file") MultipartFile file) {
        try {
            UserInfo userInfo = this.getUserInfo();
            String userId = userInfo.getUserId();
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            String createTime = CurrentDateUtil.getTodayDateEx2();
            List<String> HEAD = Arrays.asList("\u5e94\u7528\u7f16\u53f7", "\u5e94\u7528\u7b80\u79f0", "\u5e94\u7528\u540d\u79f0", "\u5e94\u7528\u7c7b\u578b", "\u5e94\u7528\u67b6\u6784\u5206\u5c42", "\u5e94\u7528\u7cfb\u7edf\u7f16\u53f7", "\u5e94\u7528\u7cfb\u7edf\u7b80\u79f0", "\u5e94\u7528\u7cfb\u7edf\u540d\u79f0", "\u5e94\u7528\u7cfb\u7edf\u82f1\u6587\u5168\u79f0", "\u5e94\u7528\u7cfb\u7edf\u7b80\u4ecb", "\u5e94\u7528\u7cfb\u7edf\u4f7f\u7528\u8303\u56f4", "\u5e94\u7528\u7cfb\u7edf\u670d\u52a1\u5bf9\u8c61", "\u5e94\u7528\u7cfb\u7edf\u72b6\u6001");
            ArrayList headCellList = new ArrayList();
            ExcelReader excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            SubsInfoExcelReadListener subsListener = new SubsInfoExcelReadListener();
            ReadSheet subsSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)subsListener)).headRowNumber(Integer.valueOf(1))).build();
            excelReader.read(new ReadSheet[]{subsSheet});
            if (subsListener.getList().size() > 0) {
                SDicVO dicParam = new SDicVO();
                dicParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
                dicParam.setOpttypes(Arrays.asList("ARCH_LEVEL_TYPE", "SUBS_STATE", "SCOPE_USE", "SERVICE_USED"));
                List dictList = this.sDicService.queryAllOwner(dicParam);
                HashMap<String, SDicVO> dictMap = new HashMap<String, SDicVO>();
                if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                    for (SDicVO d : dictList) {
                        String key = String.format("%s-%s", d.getOpttype(), d.getCnname());
                        dictMap.put(key, d);
                    }
                }
                List<SSubsInfo> subsList = subsListener.getList();
                for (SSubsInfo s : subsList) {
                    SDicVO code;
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getArchLevelType())) {
                        String archLevel = s.getArchLevelType();
                        code = (SDicVO)dictMap.get("ARCH_LEVEL_TYPE-" + archLevel);
                        if (code != null) {
                            s.setArchLevelType(code.getEnname());
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getScopeUse())) {
                        String scopeUse = s.getScopeUse();
                        code = (SDicVO)dictMap.get("SCOPE_USE-" + scopeUse);
                        if (code != null) {
                            s.setScopeUse(code.getEnname());
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getServiceUsed())) {
                        String serviceUsed = s.getServiceUsed();
                        code = (SDicVO)dictMap.get("SERVICE_USED-" + serviceUsed);
                        if (code != null) {
                            s.setServiceUsed(code.getEnname());
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getSubsState())) {
                        String state = s.getSubsState();
                        code = (SDicVO)dictMap.get("SUBS_STATE-" + state);
                        if (code != null) {
                            s.setSubsState(code.getEnname());
                        }
                    }
                    s.setSolutionType("S");
                }
                this.sSubsInfoService.saveSubsInfoImportList(subsList);
            }
            return this.getResponseData("S");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u6570\u636e\u6807\u51c6\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            return this.getResponseData("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/s/subs/info/matchItem"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> appRefactorStd(@RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="objectId", required=false) String objectId) {
        if (AnalysisTableMatchItemTask.taskDebounce.get(appId) == null) {
            String userId = this.getUserInfo().getUserId();
            ConnPoolForDruid connTool = new ConnPoolForDruid();
            AnalysisTableMatchItemTask.taskDebounce.put(appId, "R");
            AnalysisTableMatchItemTask task = new AnalysisTableMatchItemTask(subsId, appId, null, objectId, null, userId, (IConnPool)connTool);
            this.applicationThreadPool.add((Callable)task);
            return this.getResponseData("\u6267\u884c\u6210\u529f");
        }
        return this.getResponseData("\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u5019\uff01");
    }

    @RequestMapping(value={"/s/subs/info/matchItem/stat"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> appRefactorStdStat(@RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId) {
        if (AnalysisTableMatchItemTask.taskDebounce.get(appId) == null) {
            return this.getResponseData("done");
        }
        return this.getResponseData("running");
    }

    @RequestMapping(value={"/s/subs/info/implstd"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> appsImplStd(@RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="objectId", required=false) String objectId, @RequestParam(value="dataMarkFlag") String dataMarkFlag) {
        PaasAppsInfoVO appParam = new PaasAppsInfoVO();
        appParam.setSubsId(subsId);
        appParam.setAppId(appId);
        appParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List appList = this.paasAppsInfoService.queryAllOwner(appParam);
        if (CollectionUtils.isEmpty((Collection)appList)) {
            return this.getResponseData(0);
        }
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        String userId = this.getUserInfo().getUserId();
        ArrayList<ProjectTmInfoVO> implStds = new ArrayList<ProjectTmInfoVO>();
        for (PaasAppsInfoVO paasAppsInfoVO : appList) {
            ProjectTmInfoVO param = new ProjectTmInfoVO();
            param.setProjectId(paasAppsInfoVO.getProjectId());
            ProjectTmInfoVO projectTmInfoVO = this.projectTmInfoService.queryByPk(param);
            implStds.add(projectTmInfoVO);
        }
        long count = implStds.stream().filter(item -> "N".equals(item.getValidateState()) || "U".equals(item.getValidateState()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)item.getValidateState())).count();
        if (count > 0L) {
            logger.info("\u5b58\u5728\u8868\u6a21\u578b\u672a\u6821\u9a8c\u6216\u8005\u6821\u9a8c\u5931\u8d25\u7684\u60c5\u51b5\uff0c\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u843d\u6807");
            return this.getResponseData(0);
        }
        int num = 0;
        for (PaasAppsInfoVO app : appList) {
            ProjectTmInfoVO implStd = new ProjectTmInfoVO();
            implStd.setProjectId(app.getProjectId());
            implStd = this.projectTmInfoService.queryByPk(implStd);
            if (implStd == null) {
                implStd = new ProjectTmInfoVO();
                implStd.setAppId(app.getAppId());
                implStd.setAppCode(app.getAppCode());
                implStd.setAppName(app.getAppName());
                implStd.setBizDbCnname(app.getBizDbCnname());
                implStd.setBizDbDbms(app.getBizDbDbms());
                implStd.setBizDbName(app.getBizDbName());
                implStd.setSubsId(subsId);
                implStd.setCreateTime(nowTime);
                implStd.setCreateUser(userId);
                this.projectTmInfoService.insertProjectTmInfo(implStd);
            }
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)implStd.getDataMarkStat(), (CharSequence)"R")) continue;
            implStd.setDataMarkFlag(dataMarkFlag);
            implStd.setDataMarkTime(nowTime);
            implStd.setDataMarkStat("R");
            this.projectTmInfoService.updateByPk(implStd);
            try {
                ModelTableInfoVO tbParam = new ModelTableInfoVO();
                tbParam.setProjectId(app.getProjectId());
                tbParam.setObjectId(objectId);
                List tableList = this.modelTableInfoService.queryAllNotPage(tbParam);
                if (CollectionUtils.isNotEmpty((Collection)tableList)) {
                    for (ModelTableInfoVO tb : tableList) {
                        this.modelTableFieldService.fieldRefactorByObjectId(tb.getObjectId(), dataMarkFlag, userId);
                    }
                }
                ++num;
                AnalysisIndexExcelData analysisData = this.modelTableInfoService.querySysAnalysisIndexData(app.getSubsId(), app.getAppId());
                implStd.setFieldCnRate(new BigDecimal(analysisData.getFieldCNRate()));
                implStd.setFieldMarkFlagRate(new BigDecimal(analysisData.getFieldMarkFlagRate()));
                implStd.setFieldStdFlagRate(new BigDecimal(analysisData.getFieldStdFlagRate()));
                implStd.setDataMarkStat(YesOrNO.YES.getCode());
            }
            catch (Exception e) {
                logger.error("\u6267\u884c\u843d\u6807\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                implStd.setDataMarkStat(YesOrNO.NO.getCode());
            }
            this.projectTmInfoService.updateByPk(implStd);
        }
        return this.getResponseData(num);
    }

    @RequestMapping(value={"/s/subs/info/seq"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryAllSSubsInfo(@RequestParam(value="solutionType") String solutionType) {
        String result = this.sSubsInfoService.querySSubsInfoMaxOrderWithPrefix(solutionType);
        return this.getResponseData(result);
    }

    public static class SubsInfoExcelReadListener
    extends AnalysisEventListener {
        private List<SSubsInfo> list = new ArrayList<SSubsInfo>();
        private List<String> HEAD = Arrays.asList("\u5e94\u7528\u7f16\u53f7", "\u5e94\u7528\u7b80\u79f0", "\u5e94\u7528\u540d\u79f0", "\u5e94\u7528\u7c7b\u578b", "\u5e94\u7528\u67b6\u6784\u5206\u5c42", "\u5e94\u7528\u7cfb\u7edf\u7f16\u53f7", "\u5e94\u7528\u7cfb\u7edf\u7b80\u79f0", "\u5e94\u7528\u7cfb\u7edf\u540d\u79f0", "\u5e94\u7528\u7cfb\u7edf\u82f1\u6587\u5168\u79f0", "\u5e94\u7528\u7cfb\u7edf\u7b80\u4ecb", "\u5e94\u7528\u7cfb\u7edf\u4f7f\u7528\u8303\u56f4", "\u5e94\u7528\u7cfb\u7edf\u670d\u52a1\u5bf9\u8c61", "\u5e94\u7528\u7cfb\u7edf\u72b6\u6001");
        private List<String> headCellList = new ArrayList<String>();

        public List<SSubsInfo> getList() {
            return this.list;
        }

        public void setList(List<SSubsInfo> list) {
            this.list = list;
        }

        public void invokeHeadMap(Map headMap, AnalysisContext context) {
            super.invokeHeadMap(headMap, context);
            int size = headMap.size();
            for (int i = 0; i < size; ++i) {
                this.headCellList.add((String)headMap.get(i));
            }
        }

        public void invoke(Object data, AnalysisContext context) {
            Map map = (Map)data;
            SSubsInfo subsInfo = new SSubsInfo();
            String id = (String)map.get(5);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            subsInfo.setArchLevelType((String)map.get(4));
            subsInfo.setSubsId((String)map.get(5));
            subsInfo.setSubsCode((String)map.get(6));
            subsInfo.setSubsName((String)map.get(7));
            subsInfo.setSubsEnname((String)map.get(8));
            subsInfo.setSubsIntro((String)map.get(9));
            subsInfo.setScopeUse((String)map.get(10));
            subsInfo.setServiceUsed((String)map.get(11));
            subsInfo.setSubsState((String)map.get(12));
            this.list.add(subsInfo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        public String checkExcelFormat() {
            if (this.headCellList.size() != this.HEAD.size()) {
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            for (int i = 0; i < this.HEAD.size(); ++i) {
                if (StringUtils.equals((String)this.headCellList.get(i), (String)this.HEAD.get(i))) continue;
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            return null;
        }
    }
}

