/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle;

import com.ecc.shuffle.Agenda;
import com.ecc.shuffle.FactHandle;
import com.ecc.shuffle.SLog;
import com.ecc.shuffle.rule.Rule;
import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.rule.RuleSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jci.readers.MemoryResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.ResourceStoreClassLoader;

public class WorkingMemory {
    private RuleBase ruleBase;
    private Agenda agenda;
    private Map objects = new HashMap();
    private Map handles = new HashMap();
    private List objs = new ArrayList();
    private int handleid;
    private String targetRuleSetName = null;
    private String targetRuleName = null;

    public WorkingMemory(RuleBase ruleBase) {
        if (ruleBase == null) {
            ruleBase = RuleBase.getInstance();
        } else if (ruleBase.classLoader == null) {
            ClassLoader parentClassLoader;
            if (ruleBase.src == null) {
                ruleBase.src = new MemoryResourceReader();
            }
            if (ruleBase.dst == null) {
                ruleBase.dst = new MemoryResourceStore();
            }
            if ((parentClassLoader = Thread.currentThread().getContextClassLoader()) == null) {
                parentClassLoader = this.getClass().getClassLoader();
            }
            ruleBase.classLoader = new ResourceStoreClassLoader(parentClassLoader, new ResourceStore[]{ruleBase.dst});
        }
        this.ruleBase = ruleBase;
        this.agenda = new Agenda(this);
        this.handleid = 0;
    }

    public FactHandle assertObject(Object object) {
        FactHandle handle = (FactHandle)this.handles.get(object);
        if (handle != null) {
            return handle;
        }
        handle = new FactHandle(++this.handleid);
        this.objects.put(handle, object);
        this.handles.put(object, handle);
        this.objs.add(object);
        return handle;
    }

    public Object removeObject(FactHandle handle) {
        Object object = this.objects.remove(handle);
        this.handles.remove(object);
        this.objs.remove(object);
        return object;
    }

    public void fireAllRules() throws Exception {
        String methodname;
        Method method;
        if (this.objs.size() == 0) {
            return;
        }
        if (this.targetRuleName != null && this.targetRuleSetName != null) {
            this.fireSpecialRule();
            return;
        }
        if (this.targetRuleSetName != null) {
            this.fireSpecialRules();
            return;
        }
        int k = 0;
        while (k < this.objs.size()) {
            Object obj = this.objs.get(k);
            int i = 0;
            while (i < this.ruleBase.listRuleMethod.size()) {
                method = (Method)this.ruleBase.listRuleMethod.get(i);
                if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == obj.getClass()) {
                    try {
                        boolean b = (Boolean)method.invoke(null, obj);
                        if (b) {
                            methodname = method.getName();
                            method = method.getDeclaringClass().getMethod(String.valueOf(methodname) + "_Invoke", method.getParameterTypes());
                            method.invoke(null, obj);
                            String str = method.getDeclaringClass().getName();
                            str = str.substring(16);
                            Rule rule = ((RuleSet)this.ruleBase.ruleSets.get(str)).getRule(methodname);
                            if (rule.isolation == '1') {
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            ++k;
        }
        if (this.objs.size() > 1) {
            int i = 0;
            while (i < this.ruleBase.listRuleMethod.size()) {
                method = (Method)this.ruleBase.listRuleMethod.get(i);
                if (method.getParameterTypes().length == this.objs.size()) {
                    boolean b = true;
                    int k2 = 0;
                    while (k2 < this.objs.size()) {
                        if (method.getParameterTypes()[k2] != this.objs.get(k2).getClass()) {
                            b = false;
                            break;
                        }
                        ++k2;
                    }
                    if (b) {
                        try {
                            b = (Boolean)method.invoke(null, this.objs.toArray());
                            if (b) {
                                methodname = method.getName();
                                method = method.getDeclaringClass().getMethod(String.valueOf(methodname) + "_Invoke", method.getParameterTypes());
                                method.invoke(null, this.objs.toArray());
                                String str = method.getDeclaringClass().getName();
                                str = str.substring(16);
                                Rule rule = ((RuleSet)this.ruleBase.ruleSets.get(str)).getRule(methodname);
                                if (rule.isolation == '1') {
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void fireAllRulesM() throws Exception {
        if (this.objs.size() == 0) {
            return;
        }
        if (this.targetRuleName != null && this.targetRuleSetName != null) {
            this.fireSpecialRuleM();
            return;
        }
        if (this.targetRuleSetName != null) {
            this.fireSpecialRulesM();
            return;
        }
        int i = 0;
        while (i < this.ruleBase.listRuleMethod.size()) {
            Method method = (Method)this.ruleBase.listRuleMethod.get(i);
            if (method.getParameterTypes().length == this.objs.size()) {
                boolean b = true;
                int k = 0;
                while (k < this.objs.size()) {
                    if (method.getParameterTypes()[k] != Map.class) {
                        b = false;
                        break;
                    }
                    ++k;
                }
                if (b) {
                    try {
                        b = (Boolean)method.invoke(null, this.objs.toArray());
                        if (b) {
                            String methodname = method.getName();
                            method = method.getDeclaringClass().getMethod(String.valueOf(methodname) + "_Invoke", method.getParameterTypes());
                            method.invoke(null, this.objs.toArray());
                            String str = method.getDeclaringClass().getName();
                            str = str.substring(16);
                            Rule rule = ((RuleSet)this.ruleBase.ruleSets.get(str)).getRule(methodname);
                            if (rule.isolation == '1') {
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    private void fireSpecialRule() throws Exception {
        Method method;
        if (this.targetRuleSetName == null || this.targetRuleSetName.equals("") || this.targetRuleName == null || this.targetRuleName.equals("")) {
            return;
        }
        Class<?> cls = this.ruleBase.classLoader.loadClass(this.targetRuleSetName);
        SLog.debug("\u5f00\u59cb\u6267\u884c\u7684\u76ee\u6807\u89c4\u5219\u96c6\u4e3a\uff1a" + this.targetRuleSetName + ";\u76ee\u6807\u89c4\u5219\u540d\u79f0\u4e3a\uff1a" + this.targetRuleName);
        int k = 0;
        while (k < this.objs.size()) {
            boolean b;
            Object obj = this.objs.get(k);
            try {
                method = cls.getMethod(this.targetRuleName, obj.getClass());
            }
            catch (Exception e) {
                method = null;
            }
            if (method != null && (b = ((Boolean)method.invoke(null, obj)).booleanValue())) {
                method = cls.getMethod(String.valueOf(this.targetRuleName) + "_Invoke", obj.getClass());
                method.invoke(null, obj);
            }
            ++k;
        }
        if (this.objs.size() > 1) {
            boolean b;
            Class[] clss = new Class[this.objs.size()];
            Object[] objss = this.objs.toArray();
            int k2 = 0;
            while (k2 < this.objs.size()) {
                clss[k2] = this.objs.get(k2).getClass();
                ++k2;
            }
            try {
                method = cls.getMethod(this.targetRuleName, clss);
            }
            catch (Exception e) {
                method = null;
            }
            if (method != null && (b = ((Boolean)method.invoke(null, objss)).booleanValue())) {
                method = cls.getMethod(String.valueOf(this.targetRuleName) + "_Invoke", clss);
                method.invoke(null, objss);
            }
        }
    }

    private void fireSpecialRuleM() throws Exception {
        boolean b;
        Method method;
        if (this.targetRuleSetName == null || this.targetRuleSetName.equals("") || this.targetRuleName == null || this.targetRuleName.equals("")) {
            return;
        }
        Class<?> cls = this.ruleBase.classLoader.loadClass(this.targetRuleSetName);
        SLog.debug("\u5f00\u59cb\u6267\u884c\u7684\u76ee\u6807\u89c4\u5219\u96c6\u4e3a\uff1a" + this.targetRuleSetName + ";\u76ee\u6807\u89c4\u5219\u540d\u79f0\u4e3a\uff1a" + this.targetRuleName);
        Class[] clss = new Class[this.objs.size()];
        Object[] objss = this.objs.toArray();
        int k = 0;
        while (k < this.objs.size()) {
            clss[k] = Map.class;
            ++k;
        }
        try {
            method = cls.getMethod(this.targetRuleName, clss);
        }
        catch (Exception e) {
            method = null;
        }
        if (method != null && (b = ((Boolean)method.invoke(null, objss)).booleanValue())) {
            method = cls.getMethod(String.valueOf(this.targetRuleName) + "_Invoke", clss);
            method.invoke(null, objss);
        }
    }

    private void fireSpecialRules() throws Exception {
        String methodname;
        Method method;
        if (this.targetRuleSetName == null || this.targetRuleSetName.equals("")) {
            return;
        }
        Class<?> cls = this.ruleBase.classLoader.loadClass(this.targetRuleSetName);
        SLog.debug("\u5f00\u59cb\u6267\u884c\u7684\u76ee\u6807\u89c4\u5219\u96c6\u4e3a\uff1a" + this.targetRuleSetName);
        Method[] methods = cls.getMethods();
        int k = 0;
        while (k < this.objs.size()) {
            Object obj = this.objs.get(k);
            int i = 0;
            while (i < methods.length) {
                boolean b;
                method = methods[i];
                if (method.getReturnType().getName().equals("boolean") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == obj.getClass() && (b = ((Boolean)method.invoke(null, obj)).booleanValue())) {
                    methodname = method.getName();
                    method = method.getDeclaringClass().getMethod(String.valueOf(methodname) + "_Invoke", method.getParameterTypes());
                    method.invoke(null, obj);
                    String str = method.getDeclaringClass().getName();
                    str = str.substring(16);
                    Rule rule = ((RuleSet)this.ruleBase.ruleSets.get(str)).getRule(methodname);
                    if (rule.isolation == '1') break;
                }
                ++i;
            }
            ++k;
        }
        if (this.objs.size() > 1) {
            int i = 0;
            while (i < methods.length) {
                method = methods[i];
                if (method.getReturnType().getName().equals("boolean") && method.getParameterTypes().length == this.objs.size()) {
                    boolean b = true;
                    int k2 = 0;
                    while (k2 < this.objs.size()) {
                        if (method.getParameterTypes()[k2] != this.objs.get(k2).getClass()) {
                            b = false;
                            break;
                        }
                        ++k2;
                    }
                    if (b && (b = ((Boolean)method.invoke(null, this.objs.toArray())).booleanValue())) {
                        methodname = method.getName();
                        method = method.getDeclaringClass().getMethod(String.valueOf(methodname) + "_Invoke", method.getParameterTypes());
                        method.invoke(null, this.objs.toArray());
                        String str = method.getDeclaringClass().getName();
                        str = str.substring(16);
                        Rule rule = ((RuleSet)this.ruleBase.ruleSets.get(str)).getRule(methodname);
                        if (rule.isolation == '1') break;
                    }
                }
                ++i;
            }
        }
    }

    private void fireSpecialRulesM() throws Exception {
        if (this.targetRuleSetName == null || this.targetRuleSetName.equals("")) {
            return;
        }
        Class<?> cls = this.ruleBase.classLoader.loadClass(this.targetRuleSetName);
        SLog.debug("\u5f00\u59cb\u6267\u884c\u7684\u76ee\u6807\u89c4\u5219\u96c6\u4e3a\uff1a" + this.targetRuleSetName);
        Method[] methods = cls.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getReturnType().getName().equals("boolean") && method.getParameterTypes().length == this.objs.size()) {
                boolean b = true;
                int k = 0;
                while (k < this.objs.size()) {
                    if (method.getParameterTypes()[k] != Map.class) {
                        b = false;
                        break;
                    }
                    ++k;
                }
                if (b && (b = ((Boolean)method.invoke(null, this.objs.toArray())).booleanValue())) {
                    String methodname = method.getName();
                    method = method.getDeclaringClass().getMethod(String.valueOf(methodname) + "_Invoke", method.getParameterTypes());
                    method.invoke(null, this.objs.toArray());
                    String str = method.getDeclaringClass().getName();
                    str = str.substring(16);
                    Rule rule = ((RuleSet)this.ruleBase.ruleSets.get(str)).getRule(methodname);
                    if (rule.isolation == '1') break;
                }
            }
            ++i;
        }
    }

    public void setTargetRuleSetName(String targetRuleSetName) {
        this.targetRuleSetName = "com.ecc.shuffle." + targetRuleSetName.toUpperCase();
    }

    public void setTargetRuleName(String targetRuleName) {
        this.targetRuleName = targetRuleName;
    }

    public boolean isTargetRuleSetNameExist(String targetRuleSetName) {
        return this.ruleBase.ruleSets.get(targetRuleSetName.toUpperCase()) != null;
    }

    public List getDBColumns() {
        ArrayList al = new ArrayList();
        if (this.targetRuleSetName == null || this.targetRuleSetName.equals("")) {
            return al;
        }
        String rulesetname = this.targetRuleSetName.substring(16);
        return ((RuleSet)this.ruleBase.ruleSets.get((Object)rulesetname)).dbcolumns;
    }

    public List getDBColumns(String rulename) {
        ArrayList al = new ArrayList();
        if (this.targetRuleSetName == null || this.targetRuleSetName.equals("")) {
            return al;
        }
        String rulesetname = this.targetRuleSetName.substring(16);
        Rule rule = ((RuleSet)this.ruleBase.ruleSets.get(rulesetname)).getRule(rulename);
        if (rule == null) {
            return al;
        }
        return rule.dbcolumns;
    }

    public Map getParamMap() {
        HashMap newParamMap = new HashMap();
        if (this.targetRuleSetName == null || this.targetRuleSetName.equals("")) {
            return newParamMap;
        }
        String rulesetname = this.targetRuleSetName.substring(16);
        RuleSet ruleSet = (RuleSet)this.ruleBase.ruleSets.get(rulesetname);
        if (ruleSet == null) {
            return newParamMap;
        }
        return ruleSet.paramMap;
    }

    public Map getParamAliasMap() {
        HashMap newParamMap = new HashMap();
        if (this.targetRuleSetName == null || this.targetRuleSetName.equals("")) {
            return newParamMap;
        }
        String rulesetname = this.targetRuleSetName.substring(16);
        RuleSet ruleSet = (RuleSet)this.ruleBase.ruleSets.get(rulesetname);
        if (ruleSet == null) {
            return newParamMap;
        }
        return ruleSet.paramAliasMap;
    }
}

