/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.common;

import com.ecc.echain.jci.JCIFactory;
import com.ecc.shuffle.rule.Declaration;
import com.ecc.shuffle.rule.Rule;
import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.rule.RuleSet;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.jci.readers.MemoryResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.ResourceStoreClassLoader;

public class JavaClassGenerator {
    private static final JavaClassGenerator INSTANCE = new JavaClassGenerator();
    private static final String newline = System.getProperty("line.separator");

    public static JavaClassGenerator getInstance() {
        return INSTANCE;
    }

    private JavaClassGenerator() {
    }

    public void generateClass(RuleBase rulebase) {
        for (String rsName : rulebase.ruleSets.keySet()) {
            RuleSet rs = (RuleSet)rulebase.ruleSets.get(rsName);
            this.generateRuleSetClass(rulebase, rs);
        }
    }

    public void generateRuleSetClass(RuleBase rulebase, RuleSet rs) {
        try {
            int k;
            StringBuffer buffer = new StringBuffer();
            buffer.append("package com.ecc.shuffle;");
            buffer.append(newline);
            buffer.append("import java.io.Serializable;");
            buffer.append(newline);
            Iterator it = rs.imports.iterator();
            while (it.hasNext()) {
                buffer.append("import " + it.next() + ";");
                buffer.append(newline);
            }
            buffer.append("public class " + rs.id + " implements Serializable{");
            buffer.append(newline);
            buffer.append(rs.functions);
            buffer.append(newline);
            HashMap ruleNameMap = new HashMap();
            int j = 0;
            while (j < rs.rules.size()) {
                String s;
                Rule rule = (Rule)rs.rules.get(j);
                ruleNameMap.put(rule.id, null);
                buffer.append("public static boolean " + rule.id + "(");
                String paramStr = "";
                k = 0;
                while (k < rule.parameterDeclarations.size()) {
                    Declaration dl = (Declaration)rule.parameterDeclarations.get(k);
                    paramStr = String.valueOf(paramStr) + "," + dl.objectType.getType().getName() + " " + dl.identifier;
                    ++k;
                }
                if (paramStr.length() > 1) {
                    paramStr = paramStr.substring(1);
                }
                buffer.append(String.valueOf(paramStr) + ") throws Exception{");
                buffer.append(newline);
                if (rule.pretreatments.size() > 0) {
                    k = 0;
                    while (k < rule.pretreatments.size()) {
                        s = (String)rule.pretreatments.get(k);
                        buffer.append(s);
                        buffer.append(newline);
                        ++k;
                    }
                    buffer.append(newline);
                }
                k = 0;
                while (k < rule.conditions.size()) {
                    s = (String)rule.conditions.get(k);
                    buffer.append("if(" + s + "){}");
                    buffer.append(newline);
                    buffer.append("else{return false;}");
                    buffer.append(newline);
                    ++k;
                }
                buffer.append("return true;");
                buffer.append(newline);
                buffer.append("}");
                buffer.append(newline);
                if (rule.consequence != null && rule.consequence.length() > 1) {
                    buffer.append("public static void " + rule.id + "_Invoke(");
                    buffer.append(String.valueOf(paramStr) + ") throws Exception{");
                    buffer.append(newline);
                    buffer.append(rule.consequence);
                    buffer.append(newline);
                    buffer.append("}");
                }
                buffer.append(newline);
                ++j;
            }
            buffer.append("}");
            if (rulebase.classLoader == null) {
                ClassLoader parentClassLoader;
                if (rulebase.src == null) {
                    rulebase.src = new MemoryResourceReader();
                }
                if (rulebase.dst == null) {
                    rulebase.dst = new MemoryResourceStore();
                }
                if ((parentClassLoader = Thread.currentThread().getContextClassLoader()) == null) {
                    parentClassLoader = INSTANCE.getClass().getClassLoader();
                }
                rulebase.classLoader = new ResourceStoreClassLoader(parentClassLoader, new ResourceStore[]{rulebase.dst});
            }
            JCIFactory.getInstance().getJciClass().compile(rs.classname, buffer, rulebase.src, rulebase.dst, rulebase.classLoader, (Object)rulebase);
            Class<?> javaclass = rulebase.classLoader.loadClass(rs.classname);
            Method[] methods = javaclass.getMethods();
            k = 0;
            while (k < methods.length) {
                if (ruleNameMap.containsKey(methods[k].getName())) {
                    rulebase.listRuleMethod.add(methods[k]);
                }
                ++k;
            }
        }
        catch (Exception e) {
            System.out.println("com.ecc.shuffle.common.JavaClassGenerator\u52a8\u6001\u7f16\u8bd1\u811a\u672c\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
        }
    }
}

