/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.db;

import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DbControl {
    DataSource dataSource = null;
    private Map dsMap = new HashMap();
    private static DbControl dbInstance = new DbControl();

    public static DbControl getInstance() {
        return dbInstance;
    }

    private DbControl() {
        this.dsMap.clear();
        if (this.dataSource != null) {
            return;
        }
        try {
            this.getDataSource();
        }
        catch (Exception e) {
            System.err.println("\u521d\u59cb\u5316\u6570\u636e\u5e93\u5904\u7406\u7c7bDbControl\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
        }
    }

    public DataSource getDataSource() throws NamingException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        InitialContext initCtx = new InitialContext();
        String JNDIName = null;
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = new FileInputStream("shuffle.properties");
        }
        catch (Exception e) {
            is = this.getClass().getResourceAsStream("/shuffle.properties");
        }
        if (is == null) {
            throw new NamingException("\u6307\u5b9a\u76ee\u5f55\u4e0b\u65e0\u6cd5\u8bfb\u53d6shuffle.properties\u6587\u4ef6");
        }
        try {
            props.load(is);
            JNDIName = props.getProperty("JNDIName");
            if (JNDIName == null || JNDIName.equals("")) {
                throw new NamingException("shuffle.properties\u6587\u4ef6\u4e2d\u65e0\u6cd5\u83b7\u53d6JNDIName\u914d\u7f6e\u4fe1\u606f");
            }
            this.dataSource = (DataSource)initCtx.lookup(JNDIName);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.dataSource;
    }

    public Connection getConnection() {
        Connection conn = null;
        if (this.dataSource != null) {
            try {
                conn = this.dataSource.getConnection();
            }
            catch (SQLException e) {
                System.out.println("\u672a\u83b7\u5f97\u6570\u636e\u5e93\u8fde\u63a5");
                e.printStackTrace();
            }
        }
        return conn;
    }

    public Connection getConnection(String dsName) {
        if (this.dsMap.containsKey(dsName)) {
            try {
                return ((DataSource)this.dsMap.get(dsName)).getConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Connection conn = null;
        try {
            InitialContext initCtx = new InitialContext();
            DataSource ds = (DataSource)initCtx.lookup(dsName);
            this.dsMap.put(dsName, ds);
            conn = ds.getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    public void releaseConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                System.out.println("\u6570\u636e\u5e93\u5173\u95ed\u5931\u8d25");
            }
        }
    }

    public boolean singleExecute(String sql) throws SQLException {
        boolean flag = false;
        Statement st = null;
        Connection conn = this.getConnection();
        if (conn != null) {
            st = conn.createStatement();
            int count = st.executeUpdate(sql);
            if (count != 0) {
                flag = true;
            } else {
                System.out.println("\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            if (st != null) {
                st.close();
            }
            this.releaseConnection(conn);
        } else {
            System.out.println("\u672a\u83b7\u5f97\u6570\u636e\u5e93\u8fde\u63a5");
        }
        return flag;
    }

    public Map querySingle(String sql) throws SQLException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Statement stmt = null;
        Connection conn = this.getConnection();
        ResultSet rs = null;
        if (conn != null) {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                ResultSetMetaData meta = rs.getMetaData();
                int i = 1;
                while (i <= meta.getColumnCount()) {
                    String name = meta.getColumnName(i).toLowerCase();
                    Object value = null;
                    value = rs.getObject(name);
                    resultMap.put(name, value);
                    ++i;
                }
            }
            rs.close();
            if (stmt != null) {
                stmt.close();
            }
            this.releaseConnection(conn);
        } else {
            System.out.println("\u672a\u83b7\u5f97\u6570\u636e\u5e93\u8fde\u63a5");
        }
        return resultMap;
    }

    public List queryAllInfos(String sql) throws SQLException {
        ArrayList resultList = new ArrayList();
        Connection conn = this.getConnection();
        PreparedStatement state = null;
        state = conn.prepareStatement(sql);
        ResultSet rs = state.executeQuery();
        while (rs.next()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            ResultSetMetaData meta = rs.getMetaData();
            int i = 1;
            while (i <= meta.getColumnCount()) {
                String name = meta.getColumnName(i).toLowerCase();
                Object value = rs.getObject(name);
                resultMap.put(name, value);
                ++i;
            }
            resultList.add(resultMap);
        }
        rs.close();
        if (state != null) {
            state.close();
        }
        this.releaseConnection(conn);
        return resultList;
    }
}

