/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;

public class DbPool {
    private static DbPool _instance = new DbPool();
    private static BasicDataSource ds;

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("=======ShutdownHook=======");
                try {
                    if (ds != null) {
                        ds.close();
                    }
                    ds = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private DbPool() {
    }

    public static synchronized DbPool getInstance() {
        return _instance;
    }

    public Connection getConnection() throws SQLException {
        if (ds == null) {
            this.createDataSource();
        }
        return ds.getConnection();
    }

    protected void createDataSource() {
        ds = new BasicDataSource();
        ds.setLogAbandoned(true);
        ds.setRemoveAbandoned(true);
        ds.setRemoveAbandonedTimeout(150);
        ds.setMaxActive(30);
        ds.setMaxIdle(10);
        ds.setMaxWait(-1L);
        ds.setDriverClassName("oracle.jdbc.driver.OracleDriver");
        ds.setUrl("jdbc:oracle:thin:@127.0.0.1:1521:ebank");
        ds.setUsername("emptrain");
        ds.setPassword("emptrain");
    }
}

