/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.rule;

import com.ecc.echain.jci.JCIFactory;
import com.ecc.shuffle.WorkingMemory;
import com.ecc.shuffle.db.DbControl;
import com.ecc.shuffle.rule.RuleBaseLoader;
import com.ecc.shuffle.rule.RuleFileListener;
import com.ecc.shuffle.rule.RuleSet;
import com.ecc.shuffle.upgrade.common.UpgradeClassGenerator;
import com.ecc.shuffle.upgrade.ext.Trans;
import com.ecc.shuffle.upgrade.function.FunctionManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.ResourceStore;

public class RuleBase {
    private static RuleBase instance;
    public boolean debug = false;
    public static String jciclass;
    public Map ruleSets;
    public List listRuleMethod;
    public int rulesetnum;
    public int rulenum;
    public ClassLoader classLoader;
    public ResourceReader src = null;
    public ResourceStore dst = null;
    public String shufflepath = null;
    private String ruleFilePath = null;
    private boolean setupFileListener = false;
    private String functionFilePath = null;
    public String JNDIName = null;
    public Map transMap = new HashMap();
    public Map variableMap = new HashMap();
    public Map variableMapType = new HashMap();

    static {
        jciclass = "com.ecc.echain.jci.JCIClass";
    }

    public WorkingMemory newWorkingMemory() {
        if (instance == null) {
            RuleBase.getInstance();
        }
        return new WorkingMemory(instance);
    }

    private RuleBase() {
    }

    public static synchronized RuleBase getInstance() {
        if (instance == null) {
            instance = new RuleBase();
            RuleBase.instance.ruleSets = new HashMap();
            RuleBase.instance.listRuleMethod = new ArrayList();
            RuleBase.instance.rulesetnum = 0;
            RuleBase.instance.rulenum = 0;
            instance.readShufflePropertes();
            instance.initVariable();
            instance.initTrans();
            FunctionManager.initialize(RuleBase.instance.functionFilePath);
            RuleBaseLoader rbl = new RuleBaseLoader(instance);
            rbl.loadRules(RuleBase.instance.ruleFilePath);
            UpgradeClassGenerator.getInstance().generateClass(instance);
            if (RuleBase.instance.setupFileListener) {
                RuleFileListener.getInstance().beginListening();
            }
        }
        return instance;
    }

    public void removeRuleSet(String filepath) {
        for (String rsName : this.ruleSets.keySet()) {
            RuleSet rs = (RuleSet)this.ruleSets.get(rsName);
            if (!rs.filepath.equals(filepath)) continue;
            String targetRuleSetName = rs.classname;
            this.ruleSets.remove(rsName);
            int j = 0;
            while (j < this.listRuleMethod.size()) {
                Method method = (Method)this.listRuleMethod.get(j);
                if (method.getDeclaringClass().getName().equals(targetRuleSetName)) {
                    this.listRuleMethod.remove(j);
                }
                ++j;
            }
            break block0;
        }
    }

    public void reLoadRuleBase() {
        RuleBase.instance.ruleSets.clear();
        RuleBase.instance.listRuleMethod.clear();
        RuleBase.instance.rulesetnum = 0;
        RuleBase.instance.rulenum = 0;
        instance.readShufflePropertes();
        instance.initVariable();
        instance.initTrans();
        FunctionManager.initialize(RuleBase.instance.functionFilePath);
        RuleBaseLoader rbl = new RuleBaseLoader(instance);
        rbl.loadRules(RuleBase.instance.ruleFilePath);
        UpgradeClassGenerator.getInstance().generateClass(instance);
        if (RuleBase.instance.setupFileListener) {
            RuleFileListener.getInstance().beginListening();
        }
    }

    private void readShufflePropertes() {
        System.out.println("===========\u52a0\u8f7d\u89c4\u5219\u96c6\u4fe1\u606f===========");
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = new FileInputStream("shuffle.properties");
        }
        catch (Exception e) {
            is = this.getClass().getResourceAsStream("/shuffle.properties");
        }
        if (is != null) {
            try {
                props.load(is);
                this.shufflepath = props.getProperty("shufflepath");
                System.out.println("shufflepath:" + this.shufflepath);
                this.JNDIName = props.getProperty("JNDIName");
                System.out.println("JNDI\u6570\u636e\u6e90\u540d\u79f0:" + this.JNDIName);
                this.ruleFilePath = String.valueOf(this.shufflepath) + "\\rules";
                if (System.getProperty("file.separator") != null && System.getProperty("file.separator").equals("/")) {
                    this.ruleFilePath = this.ruleFilePath.replaceAll("\\\\", "/");
                }
                System.out.println("\u89c4\u5219\u6587\u4ef6\u5b58\u653e\u76ee\u5f55\u8def\u5f84:" + this.ruleFilePath);
                this.setupFileListener = Boolean.valueOf(props.getProperty("setupFileListener"));
                System.out.println("\u662f\u5426\u5b89\u88c5\u89c4\u5219\u6587\u4ef6\u4fa6\u542c\u5668:" + this.setupFileListener);
                this.functionFilePath = String.valueOf(this.shufflepath) + "\\function.xml";
                if (System.getProperty("file.separator") != null && System.getProperty("file.separator").equals("/")) {
                    this.functionFilePath = this.functionFilePath.replaceAll("\\\\", "/");
                }
                System.out.println("\u81ea\u5b9a\u4e49\u51fd\u6570\u914d\u7f6e\u6587\u4ef6\u8def\u5f84:" + this.functionFilePath);
                if (props.getProperty("jciclass") != null && props.getProperty("jciclass").length() > 0) {
                    jciclass = props.getProperty("jciclass");
                }
                System.out.println("\u52a8\u6001\u811a\u672c\u7f16\u8bd1\u5b9e\u73b0\u7c7b:" + jciclass);
                JCIFactory.getInstance().setJciClassname(jciclass);
                String dbg = props.getProperty("debug");
                if (dbg != null && dbg.equals("true")) {
                    this.debug = true;
                }
                System.out.println("debug:" + this.debug);
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\u672a\u627e\u5230shuffle.properties\u6587\u4ef6\uff0c\u8be5\u6587\u4ef6\u5e94\u8be5\u4f4d\u4e8ebin\u76ee\u5f55\uff08\u6216classes\u76ee\u5f55\uff09\u3001\u6216\u8005shuffle.jar\u5305\u4e2d\uff01");
            System.out.println("\u89c4\u5219\u5f15\u64ce\u76ee\u524d\u5904\u4e8e\u88ab\u52a8\u52a0\u8f7d\u72b6\u6001.");
        }
    }

    public void initVariable() {
        DbControl db = DbControl.getInstance();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                conn = db.getConnection();
                ps = conn.prepareStatement("select var_name,var_value,var_type from sf_var");
                rs = ps.executeQuery();
                this.variableMap = new HashMap();
                this.variableMapType = new HashMap();
                while (rs.next()) {
                    String var_name = rs.getString(1);
                    this.variableMap.put(var_name, rs.getString(2));
                    this.variableMapType.put(var_name, rs.getString(3));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (conn != null) {
                        db.releaseConnection(conn);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    db.releaseConnection(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initTrans() {
        DbControl db = DbControl.getInstance();
        Connection conn = null;
        Statement smt = null;
        Statement smt2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        try {
            try {
                conn = db.getConnection();
                smt = conn.createStatement();
                smt2 = conn.createStatement();
                rs = smt.executeQuery("select trans_id,trans_name,trans_permission,trans_ext,trans_desc from sf_trans");
                this.transMap.clear();
                while (rs.next()) {
                    String transid = rs.getString(1);
                    Trans trans = new Trans(transid);
                    trans.name = rs.getString(2);
                    trans.permission = rs.getString(3);
                    trans.ext = rs.getString(4);
                    trans.desc = rs.getString(5);
                    rs2 = smt2.executeQuery("select rulesetid,ruleid from sf_transrule where trans_id='" + transid + "'");
                    while (rs2.next()) {
                        String rulesetid = rs2.getString(1);
                        String ruleid = rs2.getString(2);
                        ArrayList<String> ruleList = new ArrayList<String>();
                        if (ruleid != null && ruleid.length() > 0) {
                            StringTokenizer st = new StringTokenizer(ruleid, ";");
                            while (st.hasMoreElements()) {
                                ruleList.add((String)st.nextElement());
                            }
                        }
                        trans.ruleMap.put(rulesetid.toUpperCase(), ruleList);
                    }
                    this.transMap.put(transid, trans);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (rs2 != null) {
                        rs2.close();
                    }
                    if (smt != null) {
                        smt.close();
                    }
                    if (smt2 != null) {
                        smt2.close();
                    }
                    if (conn != null) {
                        db.releaseConnection(conn);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (rs2 != null) {
                    rs2.close();
                }
                if (smt != null) {
                    smt.close();
                }
                if (smt2 != null) {
                    smt2.close();
                }
                if (conn != null) {
                    db.releaseConnection(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

