/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.rule;

import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.rule.RuleFileListener;
import com.ecc.shuffle.rule.RuleSet;
import com.ecc.shuffle.rule.RuleSetLoader;
import com.ecc.shuffle.upgrade.function.FunctionManager;
import com.ecc.shuffle.upgrade.rule.UpgradeRuleSetLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RuleBaseLoader {
    private RuleBase rulebase;
    private String rulefilepath = null;

    public RuleBaseLoader(RuleBase rulebase) {
        this.rulebase = rulebase;
    }

    public void loadRules(String rulefilepath) {
        this.rulefilepath = rulefilepath;
        FunctionManager.class.getClass();
        if (rulefilepath == null || rulefilepath.length() < 2) {
            System.out.println("\u3010warning\u3011\u65e0\u6cd5\u5b9a\u4f4d\u89c4\u5219\u6587\u4ef6\u5b58\u653e\u76ee\u5f55\u8def\u5f84\uff0c\u521d\u59cb\u89c4\u5219\u6587\u4ef6\u672a\u52a0\u8f7d\uff01");
            return;
        }
        RuleSetLoader rsl = new RuleSetLoader();
        UpgradeRuleSetLoader ursl = new UpgradeRuleSetLoader();
        try {
            RuleFileListener rfl = RuleFileListener.getInstance();
            rfl.setRuleFilePath(rulefilepath);
            File d = new File(rulefilepath);
            if (!d.exists() || !d.isDirectory()) {
                System.out.println(String.valueOf(rulefilepath) + "\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u76ee\u5f55\u8def\u5f84\uff0c\u8bf7\u68c0\u67e5shuffle.properties\u914d\u7f6e\u6587\u4ef6");
                return;
            }
            File[] list = RuleBaseLoader.listAllFiles(d).toArray(new File[0]);
            int i = 0;
            while (i < list.length) {
                RuleSet rs;
                if (list[i].isFile() && list[i].getCanonicalPath().endsWith(".xml")) {
                    rfl.addRuleFile(list[i]);
                    rs = rsl.addFromURL(list[i].getCanonicalPath());
                    if (rs != null) {
                        this.rulebase.ruleSets.put(rs.id, rs);
                        ++this.rulebase.rulesetnum;
                        System.out.println("===>Add RuleSet: " + rs.id + " from " + rs.filepath + " ok!");
                    }
                } else if (list[i].isFile() && list[i].getCanonicalPath().endsWith(".rule")) {
                    rfl.addRuleFile(list[i]);
                    rs = ursl.addFromURL(list[i].getCanonicalPath());
                    if (rs != null) {
                        this.rulebase.ruleSets.put(rs.id, rs);
                        ++this.rulebase.rulesetnum;
                        System.out.println("===>Add RuleSet: " + rs.id + " from " + rs.filepath + " ok!");
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("=====\u5171\u52a0\u8f7d\u89c4\u5219\u96c6: " + this.rulebase.rulesetnum + " \u4e2a\uff0c\u89c4\u5219: " + this.rulebase.rulenum + " \u6761=====");
    }

    public static List listAllFiles(File dir) throws IOException {
        ArrayList<File> allFileList = new ArrayList<File>();
        if (!dir.exists() || !dir.isDirectory()) {
            return allFileList;
        }
        File[] list = dir.listFiles();
        int i = 0;
        while (i < list.length) {
            File aFile = list[i];
            if (aFile.isFile()) {
                allFileList.add(aFile);
            } else if (aFile.isDirectory()) {
                List newList = RuleBaseLoader.listAllFiles(aFile);
                allFileList.addAll(newList);
            }
            ++i;
        }
        return allFileList;
    }
}

