/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.rule;

import com.ecc.shuffle.common.JavaClassGenerator;
import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.rule.RuleBaseLoader;
import com.ecc.shuffle.rule.RuleSet;
import com.ecc.shuffle.rule.RuleSetLoader;
import com.ecc.shuffle.upgrade.common.UpgradeClassGenerator;
import com.ecc.shuffle.upgrade.rule.UpgradeRuleSetLoader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class RuleFileListener {
    private static RuleFileListener instance;
    private String rulefilepath = null;
    private boolean isRunning = false;
    private final Map fileMap = new HashMap();
    private RuleBase rb = RuleBase.getInstance();

    private RuleFileListener() {
    }

    public static RuleFileListener getInstance() {
        if (instance == null) {
            instance = new RuleFileListener();
        }
        return instance;
    }

    public void setRuleFilePath(String rulefilepath) {
        this.rulefilepath = rulefilepath;
    }

    public void addRuleFile(File file) throws Exception {
        this.fileMap.put(file.getCanonicalPath(), new Long(file.lastModified()));
    }

    public void beginListening() {
        if (this.rulefilepath != null && !this.isRunning) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                public void run() {
                    RuleFileListener.this.refreshAllRules();
                }
            }, 15000L, 15000L);
            this.isRunning = true;
        }
    }

    private void refreshAllRules() {
        try {
            File d = new File(this.rulefilepath);
            File[] list = RuleBaseLoader.listAllFiles(d).toArray(new File[0]);
            this.refresh(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshSingleRule(String rulePath) {
        try {
            File f = new File(rulePath);
            if (f.exists() && f.isFile()) {
                File[] list = new File[]{f};
                this.refresh(list);
            } else {
                System.out.println("===>Update RuleSet: Rule File " + rulePath + " does not exists!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refresh(File[] list) {
        long l = 0L;
        File d = null;
        int i = 0;
        while (i < list.length) {
            try {
                RuleSet rs;
                Object rsl;
                d = list[i];
                if (d.isFile() && d.getCanonicalPath().endsWith(".xml")) {
                    if (!this.fileMap.containsKey(d.getCanonicalPath())) {
                        rsl = new RuleSetLoader();
                        rs = ((RuleSetLoader)rsl).addFromURL(d.getCanonicalPath());
                        if (rs != null) {
                            this.rb.ruleSets.put(rs.id, rs);
                            JavaClassGenerator.getInstance().generateRuleSetClass(this.rb, rs);
                            this.fileMap.put(d.getCanonicalPath(), new Long(d.lastModified()));
                            System.out.println("===>Add RuleSet: " + rs.id + " from " + rs.filepath + " ok!");
                        }
                    } else {
                        l = (Long)this.fileMap.get(d.getCanonicalPath());
                        if (d.lastModified() != l) {
                            this.rb.removeRuleSet(d.getCanonicalPath());
                            rsl = new RuleSetLoader();
                            rs = ((RuleSetLoader)rsl).addFromURL(d.getCanonicalPath());
                            if (rs != null) {
                                this.rb.ruleSets.put(rs.id, rs);
                                this.rb.classLoader = null;
                                JavaClassGenerator.getInstance().generateRuleSetClass(this.rb, rs);
                                this.fileMap.put(d.getCanonicalPath(), new Long(d.lastModified()));
                                System.out.println("===>Update RuleSet: " + rs.id + " from " + rs.filepath + " ok!");
                            }
                        }
                    }
                } else if (d.isFile() && d.getCanonicalPath().endsWith(".rule")) {
                    if (!this.fileMap.containsKey(d.getCanonicalPath())) {
                        rsl = new UpgradeRuleSetLoader();
                        rs = ((UpgradeRuleSetLoader)rsl).addFromURL(d.getCanonicalPath());
                        if (rs != null) {
                            this.rb.ruleSets.put(rs.id, rs);
                            UpgradeClassGenerator.getInstance().generateRuleSetClass(this.rb, rs);
                            this.fileMap.put(d.getCanonicalPath(), new Long(d.lastModified()));
                            System.out.println("===>Add RuleSet: " + rs.id + " from " + rs.filepath + " ok!");
                        }
                    } else {
                        l = (Long)this.fileMap.get(d.getCanonicalPath());
                        if (d.lastModified() != l) {
                            this.rb.removeRuleSet(d.getCanonicalPath());
                            rsl = new UpgradeRuleSetLoader();
                            rs = ((UpgradeRuleSetLoader)rsl).addFromURL(d.getCanonicalPath());
                            if (rs != null) {
                                this.rb.ruleSets.put(rs.id, rs);
                                this.rb.classLoader = null;
                                UpgradeClassGenerator.getInstance().generateRuleSetClass(this.rb, rs);
                                this.fileMap.put(d.getCanonicalPath(), new Long(d.lastModified()));
                                System.out.println("===>Update RuleSet: " + rs.id + " from " + rs.filepath + " ok!");
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

