/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.rule;

import com.ecc.shuffle.rule.Mycomparator;
import com.ecc.shuffle.rule.Rule;
import com.ecc.shuffle.upgrade.rule.RulesParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class RuleSet
implements Serializable {
    public String id;
    public String ids;
    public String name;
    public String desc;
    public String levels;
    public String type;
    public String appsign;
    public String version;
    public Set ruleIds;
    public Set imports;
    public List rules;
    public List dbcolumns;
    public Map paramMap;
    public Map paramAliasMap;
    public String functions = "";
    public String classname;
    public String filepath;

    public RuleSet(String id) {
        this.id = id;
        this.ruleIds = new HashSet();
        this.imports = new HashSet();
        this.rules = new ArrayList();
        this.dbcolumns = new ArrayList();
        this.paramMap = new HashMap();
        this.paramAliasMap = new HashMap();
    }

    public void addImport(String strImport) {
        if (!this.imports.contains(strImport)) {
            this.imports.add(strImport);
        }
    }

    public void addDBColumns(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(str, ";");
        while (st.hasMoreElements()) {
            this.dbcolumns.add((String)st.nextElement());
        }
    }

    public void addParameter(String name, RulesParameter aParam) {
        if (name == null || name.length() == 0 || aParam == null) {
            return;
        }
        this.paramMap.put(name, aParam);
        if (aParam.alias != null) {
            this.paramAliasMap.put(aParam.alias, name);
        }
    }

    public void addRule(Rule rule) {
        if (!this.containsRule(rule.id)) {
            this.ruleIds.add(rule.id);
            this.rules.add(rule);
        }
    }

    public boolean containsRule(String id) {
        return this.ruleIds.contains(id);
    }

    public Rule[] getRules() {
        return this.rules.toArray(new Rule[this.rules.size()]);
    }

    public Rule getRule(String ruleid) {
        Rule[] rules = this.getRules();
        int i = 0;
        while (i < rules.length) {
            if (rules[i].id.equals(ruleid)) {
                return rules[i];
            }
            ++i;
        }
        return null;
    }

    public void sortOrder() {
        if (this.rules.size() > 1) {
            Collections.sort(this.rules, new Mycomparator());
        }
    }
}

