/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.rule;

import com.ecc.shuffle.rule.Rule;
import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.rule.RuleSet;
import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RuleSetLoader {
    private DocumentBuilder db;

    public RuleSetLoader() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            this.db = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RuleSet addFromURL(String urlpath) {
        String rulesetname;
        Element root;
        RuleSet ruleset;
        block18: {
            ruleset = null;
            Document doc = this.db.parse(new File(urlpath));
            root = doc.getDocumentElement();
            rulesetname = root.getAttribute("name").toUpperCase();
            if (!RuleBase.getInstance().ruleSets.containsKey(rulesetname)) break block18;
            System.out.println("\u3010\u8b66\u544a\u3011\u91cd\u590d\u7684\u89c4\u5219\u96c6\u540d\u79f0\uff1a" + rulesetname + ";\u4f4d\u4e8e\u89c4\u5219\u6587\u4ef6\uff1a" + urlpath + "\u4e2d.");
            return null;
        }
        try {
            ruleset = new RuleSet(rulesetname);
            ruleset.filepath = urlpath;
            ruleset.classname = "com.ecc.shuffle." + rulesetname;
            NodeList nl = root.getElementsByTagName("java:import");
            int i = 0;
            while (i < nl.getLength()) {
                ruleset.addImport(nl.item(i).getFirstChild().getNodeValue());
                ++i;
            }
            nl = root.getElementsByTagName("db:columns");
            if (nl.getLength() > 0) {
                ruleset.addDBColumns(nl.item(0).getFirstChild().getNodeValue());
            }
            if ((nl = root.getElementsByTagName("java:functions")).getLength() > 0) {
                ruleset.functions = nl.item(0).getFirstChild().getNodeValue();
            }
            nl = root.getElementsByTagName("rule");
            HashMap rulenameMap = new HashMap();
            int i2 = 0;
            while (i2 < nl.getLength()) {
                Element ruleElement = (Element)nl.item(i2);
                String rulename = ruleElement.getAttribute("name");
                if (rulenameMap.containsKey(rulename)) {
                    System.out.println("\u3010\u8b66\u544a\u3011\u91cd\u590d\u7684\u89c4\u5219\u540d\u79f0\uff1a" + rulename + ";\u4f4d\u4e8e\u89c4\u5219\u6587\u4ef6\uff1a" + urlpath + "\u4e2d.");
                } else {
                    NodeList rulenl;
                    String isolation;
                    rulenameMap.put(rulename, null);
                    Rule rule = new Rule(rulename, ruleset);
                    String salience = ruleElement.getAttribute("salience");
                    if (salience != null && !salience.equals("")) {
                        rule.salience = Integer.parseInt(salience);
                    }
                    if ((isolation = ruleElement.getAttribute("isolation")) != null && isolation.equals("yes")) {
                        rule.isolation = (char)49;
                    }
                    if ((rulenl = ruleElement.getElementsByTagName("db:columns")).getLength() > 0) {
                        rule.addDBColumns(rulenl.item(0).getFirstChild().getNodeValue());
                    }
                    if ((rulenl = ruleElement.getElementsByTagName("parameter")).getLength() < 1) {
                        System.out.println("\u3010\u8b66\u544a\u3011\u89c4\u5219\u96c6 " + rulesetname + " \u4e2d\u7684\u89c4\u5219 " + rulename + " \u7f3a\u5c11\u53c2\u6570,\u8bf7\u4fee\u6539\u3002");
                    } else {
                        int j = 0;
                        while (j < rulenl.getLength()) {
                            Element paramElement = (Element)rulenl.item(j);
                            String identifier = paramElement.getAttribute("identifier");
                            String strobjecttype = paramElement.getElementsByTagName("class").item(0).getFirstChild().getNodeValue();
                            rule.addParameterDeclaration(identifier, strobjecttype);
                            ++j;
                        }
                        rulenl = ruleElement.getElementsByTagName("java:pretreatment");
                        j = 0;
                        while (j < rulenl.getLength()) {
                            rule.pretreatments.add(rulenl.item(j).getFirstChild().getNodeValue());
                            ++j;
                        }
                        rulenl = ruleElement.getElementsByTagName("java:condition");
                        j = 0;
                        while (j < rulenl.getLength()) {
                            rule.conditions.add(rulenl.item(j).getFirstChild().getNodeValue());
                            ++j;
                        }
                        rulenl = ruleElement.getElementsByTagName("java:consequence");
                        if (rulenl.getLength() > 0) {
                            rule.consequence = rulenl.item(0).getFirstChild().getNodeValue();
                        }
                        ruleset.addRule(rule);
                        ++RuleBase.getInstance().rulenum;
                    }
                }
                ++i2;
            }
            ruleset.sortOrder();
        }
        catch (Exception e) {
            System.out.println("\u8bfb\u53d6\u6587\u4ef6\uff1a" + urlpath + " \u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6539\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002");
            e.printStackTrace();
        }
        return ruleset;
    }
}

