/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade;

import com.ecc.shuffle.rule.Rule;
import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.rule.RuleConstant;
import com.ecc.shuffle.rule.RuleSet;
import com.ecc.shuffle.upgrade.function.ExtendedFunction;
import com.ecc.shuffle.upgrade.function.FunctionManager;
import com.ecc.shuffle.upgrade.rule.RulesParameter;
import com.ecc.util.formula.CFormula;
import com.ecc.util.formula.FormulaException;
import com.ecc.util.formula.FormulaValue;
import com.ecc.util.formula.FunctionController;
import com.ecc.util.formula.LexicalAnalyser;
import com.ecc.util.formula.VariableController;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Map;
import java.util.Vector;

public class FormulaProcesser {
    public static void assign4ValueMap(String outputParam, String formula, Map paramMap, Map resourceMap, Map valueMap) throws Exception {
        if (!paramMap.containsKey(outputParam)) {
            System.out.println("\u3010Error\u3011\u8d4b\u503c\u8bed\u53e5\u89e3\u6790\u9519\u8bef\uff1a" + outputParam + " := " + formula);
            throw new FormulaException("\u8d4b\u503c\u53c2\u6570\u672a\u5b9a\u4e49\uff1a" + outputParam);
        }
        String value = FormulaProcesser.retStringValue(formula, paramMap, resourceMap, valueMap);
        if (valueMap.containsKey(outputParam)) {
            valueMap.remove(outputParam);
        }
        valueMap.put(outputParam, value);
    }

    public static String retStringValue(String formula, Map paramMap, Map resourceMap, Map inputValueMap) throws Exception {
        try {
            FormulaValue value = FormulaProcesser.processFormula(formula, paramMap, resourceMap, inputValueMap);
            return value.sStringValue();
        }
        catch (Exception e) {
            System.out.println("\u3010Error\u3011\u8868\u8fbe\u5f0f\u89e3\u6790\u9519\u8bef\uff1a" + formula);
            throw e;
        }
    }

    public static boolean retBooleanValue(String formula, Map paramMap, Map resourceMap, Map inputValueMap) throws Exception {
        try {
            FormulaValue value = FormulaProcesser.processFormula(formula, paramMap, resourceMap, inputValueMap);
            return value.bBooleanValue();
        }
        catch (Exception e) {
            System.out.println("\u3010Error\u3011\u8868\u8fbe\u5f0f\u89e3\u6790\u9519\u8bef\uff1a" + formula);
            throw e;
        }
    }

    private static FormulaValue processFormula(String formula, final Map paramMap, final Map resourceMap, final Map inputValueMap) throws Exception {
        LexicalAnalyser lexical = new LexicalAnalyser();
        CFormula valueFormula = new CFormula();
        lexical.parseTheFormula(formula);
        valueFormula.setVariableController(new VariableController(){

            public FormulaValue getVariableValue(String variableName) throws Exception {
                String var = variableName;
                char flag = var.charAt(0);
                var = var.trim().substring(1);
                if (flag != '$') {
                    throw new FormulaException("\u5f15\u7528\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff1a" + var);
                }
                if (variableName.trim().startsWith("$$")) {
                    var = var.substring(1);
                    String rulesetid = (String)resourceMap.get("_ruleSetId");
                    String ruleid = resourceMap.containsKey("_iruleId") ? (String)resourceMap.get("_iruleId") : (String)resourceMap.get("_ruleId");
                    String value = null;
                    RuleSet ruleset = (RuleSet)RuleBase.getInstance().ruleSets.get(rulesetid.toUpperCase());
                    Rule rule = ruleset.getRule(ruleid);
                    String vType = "";
                    for (RuleConstant rc : rule.ruleConstants) {
                        if (!rc.name.equals(var)) continue;
                        value = rc.value;
                        vType = rc.type;
                        break;
                    }
                    if (value == null) {
                        throw new FormulaException("\u5f15\u7528\u5e38\u91cf\u672a\u5b9a\u4e49\uff1a" + var);
                    }
                    FormulaValue formulaValue = new FormulaValue();
                    if (vType.equalsIgnoreCase("int") || vType.equalsIgnoreCase("integer")) {
                        formulaValue.setValue((Object)new Integer(value));
                    } else if (vType.equalsIgnoreCase("string")) {
                        formulaValue.setValue((Object)value);
                    } else if (vType.equalsIgnoreCase("float")) {
                        formulaValue.setValue((Object)new Float(value));
                    } else if (vType.equalsIgnoreCase("decimal")) {
                        formulaValue.setValue((Object)new BigDecimal(value));
                    } else if (vType.equalsIgnoreCase("boolean")) {
                        formulaValue.setValue((Object)new Boolean(value));
                    } else {
                        formulaValue.setValue((Object)value);
                    }
                    return formulaValue;
                }
                if (!paramMap.containsKey(var)) {
                    throw new FormulaException("\u5f15\u7528\u53c2\u6570\u672a\u5b9a\u4e49\uff1a" + var);
                }
                if (!inputValueMap.containsKey(var)) {
                    throw new FormulaException("\u5f15\u7528\u53c2\u6570\u672a\u8d4b\u503c\uff1a" + var);
                }
                RulesParameter parameter = (RulesParameter)paramMap.get(var);
                String value = inputValueMap.get(var).toString();
                return FormulaProcesser.defineFormula(parameter, value);
            }
        });
        valueFormula.setFunctionController(new FunctionController(){

            public FormulaValue getFunctionValue(String functionName, Vector args) {
                String var = functionName;
                if (var.charAt(0) != '@') {
                    var = "@" + functionName;
                }
                ExtendedFunction func = null;
                try {
                    func = (ExtendedFunction)((Object)Class.forName(FunctionManager.getFunctionClassName(var)).newInstance());
                    func.setDsName(FunctionManager.getDsName(var));
                }
                catch (Exception e) {
                    System.err.println("\u5f15\u7528\u51fd\u6570\u5b9e\u4f8b\u5316\u5f02\u5e38\uff1a" + var);
                    e.printStackTrace();
                }
                if (func == null) {
                    System.err.println("\u5f15\u7528\u51fd\u6570\u672a\u5b9a\u4e49\uff1a" + var);
                    return null;
                }
                try {
                    if (func instanceof ExtendedFunction) {
                        ExtendedFunction extendedFunc = func;
                        extendedFunc.setResourceMap(resourceMap);
                    }
                    return func.getValue(args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        valueFormula.setContent(lexical);
        FormulaValue value = valueFormula.getValue();
        return value;
    }

    private static FormulaValue defineFormula(RulesParameter parameter, String value) throws FormulaException {
        FormulaValue formulaValue = new FormulaValue();
        formulaValue.nDataType = 6;
        try {
            Object objectValue = null;
            switch (parameter.valueType) {
                case 0: {
                    objectValue = new Integer(value);
                    break;
                }
                case 8: {
                    objectValue = new BigInteger(value);
                    break;
                }
                case 1: {
                    objectValue = new Float(value);
                    break;
                }
                case 7: {
                    objectValue = new BigDecimal(value);
                    break;
                }
                case 3: {
                    objectValue = new Boolean(value);
                    break;
                }
                case 2: {
                    objectValue = value;
                    break;
                }
                case 4: {
                    try {
                        if (value.length() == 8) {
                            objectValue = DateFormat.getDateInstance().parse(String.valueOf(value.substring(0, 4)) + "-" + value.substring(4, 6) + "-" + value.substring(6, 8));
                            break;
                        }
                        if (value.length() == 10) {
                            objectValue = DateFormat.getDateInstance().parse(value);
                            break;
                        }
                        objectValue = DateFormat.getDateInstance().parse(value);
                    }
                    catch (Exception e) {
                        objectValue = value;
                    }
                    break;
                }
                default: {
                    objectValue = value;
                }
            }
            formulaValue.setValue(objectValue);
        }
        catch (NumberFormatException e) {
            throw new FormulaException("\u53c2\u6570[" + parameter.name + "]\u7684\u53d6\u503c[" + value + "]\u4e0e\u7c7b\u578b[" + parameter.valueType + "]\u4e0d\u7b26");
        }
        return formulaValue;
    }
}

