/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade;

import com.ecc.util.formula.CFormula;
import com.ecc.util.formula.FormulaException;
import com.ecc.util.formula.FormulaValue;
import com.ecc.util.formula.FunctionController;
import com.ecc.util.formula.LexicalAnalyser;
import com.ecc.util.formula.VariableController;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class FormulaTest {
    public static void main(String[] args) throws Exception {
        FormulaTest ft = new FormulaTest();
        System.out.println("===begin=====");
        String formula = "(($IN_\u5e01\u79cd='CNY') or ($IN_\u5e01\u79cd='USD')) and ($IN_\u4ea7\u54c1\u7c7b\u578b = '\u4ee3\u53d1\u5de5\u8d44') and ($IN_\u4ea4\u6613\u91d1\u989d-10000 >= 50000.00)";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("IN_\u4ea7\u54c1\u7c7b\u578b", String.valueOf(2));
        paramMap.put("IN_\u4ea4\u6613\u91d1\u989d", String.valueOf(1));
        paramMap.put("IN_\u5e10\u53f7", String.valueOf(2));
        paramMap.put("IN_\u53d7\u76ca\u5e10\u53f7", String.valueOf(2));
        paramMap.put("IN_\u5e01\u79cd", String.valueOf(2));
        HashMap<String, String> inputValueMap = new HashMap<String, String>();
        inputValueMap.put("IN_\u4ea7\u54c1\u7c7b\u578b", "\u4ee3\u53d1\u5de5\u8d44");
        inputValueMap.put("IN_\u4ea4\u6613\u91d1\u989d", "60010.00");
        inputValueMap.put("IN_\u5e01\u79cd", "CNY");
        FormulaValue value = ft.processFormula(formula, paramMap, inputValueMap);
        System.out.println(value.bBooleanValue());
    }

    private FormulaValue processFormula(String formula, final Map paramMap, final Map inputValueMap) throws Exception {
        LexicalAnalyser lexical = new LexicalAnalyser();
        CFormula valueFormula = new CFormula();
        lexical.parseTheFormula(formula);
        valueFormula.setVariableController(new VariableController(){

            public FormulaValue getVariableValue(String variableName) throws Exception {
                String var = variableName;
                char flag = var.charAt(0);
                var = var.trim().substring(1);
                if (flag != '$') {
                    throw new FormulaException("\u5f15\u7528\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff1a" + var);
                }
                if (!paramMap.containsKey(var)) {
                    throw new FormulaException("\u5f15\u7528\u53c2\u6570\u672a\u5b9a\u4e49\uff1a" + var);
                }
                if (!inputValueMap.containsKey(var)) {
                    throw new FormulaException("\u5f15\u7528\u53c2\u6570\u672a\u8d4b\u503c\uff1a" + var);
                }
                String value = (String)inputValueMap.get(var);
                return FormulaTest.this.defineFormula((String)paramMap.get(var), value);
            }
        });
        valueFormula.setFunctionController(new FunctionController(){

            public FormulaValue getFunctionValue(String functionName, Vector args) {
                return new FormulaValue();
            }
        });
        valueFormula.setContent(lexical);
        FormulaValue value = valueFormula.getValue();
        return value;
    }

    private FormulaValue defineFormula(String valueType, String value) throws FormulaException {
        FormulaValue formulaValue = new FormulaValue();
        formulaValue.nDataType = 6;
        try {
            Object objectValue = null;
            switch (Integer.parseInt(valueType)) {
                case 0: {
                    objectValue = new Integer(value);
                    break;
                }
                case 8: {
                    objectValue = new BigInteger(value);
                    break;
                }
                case 1: {
                    objectValue = new Float(value);
                    break;
                }
                case 7: {
                    objectValue = new BigDecimal(value);
                    break;
                }
                case 3: {
                    objectValue = new Boolean(value);
                    break;
                }
                case 2: {
                    objectValue = value;
                    break;
                }
                default: {
                    objectValue = value;
                }
            }
            formulaValue.setValue(objectValue);
        }
        catch (NumberFormatException e) {
            throw new FormulaException("\u53c2\u6570\u53d6\u503c\u4e0e\u7c7b\u578b\u4e0d\u7b26");
        }
        return formulaValue;
    }
}

