/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade;

import com.ecc.shuffle.FactHandle;
import com.ecc.shuffle.SLog;
import com.ecc.shuffle.WorkingMemory;
import com.ecc.shuffle.db.DbControl;
import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.upgrade.ext.ShuffleExtFactory;
import com.ecc.shuffle.upgrade.ext.Trans;
import com.ecc.shuffle.upgrade.rule.RulesParameter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleSetInstance {
    private WorkingMemory workingmemory;
    private String ruleSetId = null;
    private Map resourceMap = new HashMap();

    public RuleSetInstance() {
    }

    public RuleSetInstance(String ruleSetId) {
        this.ruleSetId = ruleSetId;
        this.resourceMap.put("_ruleSetId", ruleSetId);
        this.workingmemory = RuleBase.getInstance().newWorkingMemory();
        this.workingmemory.setTargetRuleSetName(ruleSetId);
        Map paramMap = this.workingmemory.getParamMap();
        this.resourceMap.put("_paramMap", paramMap);
        this.workingmemory.assertObject(paramMap);
        this.workingmemory.assertObject(this.resourceMap);
    }

    public RuleSetInstance(String ruleSetId, String ruleId) {
        this.ruleSetId = ruleSetId;
        this.resourceMap.put("_ruleSetId", ruleSetId);
        this.resourceMap.put("_ruleId", ruleId);
        this.workingmemory = RuleBase.getInstance().newWorkingMemory();
        this.workingmemory.setTargetRuleSetName(ruleSetId);
        this.workingmemory.setTargetRuleName(ruleId);
        Map paramMap = this.workingmemory.getParamMap();
        this.resourceMap.put("_paramMap", paramMap);
        this.workingmemory.assertObject(paramMap);
        this.workingmemory.assertObject(this.resourceMap);
    }

    public Map fireTargetRules(String ruleId, Map inputValueMap) throws Exception {
        this.resourceMap.put("_ruleId", ruleId);
        SLog.debug("fireTargetRules,ruleSetId=" + this.resourceMap.get("_ruleSetId") + ";ruleId=" + this.resourceMap.get("_ruleId"));
        RuleSetInstance.paramAliasMapping(this.workingmemory.getParamAliasMap(), inputValueMap);
        FactHandle handle = this.workingmemory.assertObject(inputValueMap);
        this.resourceMap.put("_valueMap", inputValueMap);
        this.workingmemory.setTargetRuleName(ruleId);
        SLog.debug("=====\u89c4\u5219\u6267\u884c\u5f00\u59cb\uff1a" + this.ruleSetId + "." + ruleId + "=====");
        this.workingmemory.fireAllRulesM();
        SLog.debug("=====\u89c4\u5219\u6267\u884c\u7ed3\u675f\uff1a" + this.ruleSetId + "." + ruleId + "=====");
        this.resourceMap.remove("_valueMap");
        this.workingmemory.removeObject(handle);
        return inputValueMap;
    }

    public Map fireTargetRules(Map inputValueMap) throws Exception {
        SLog.debug("fireTargetRules,ruleSetId=" + this.resourceMap.get("_ruleSetId") + ";ruleId=" + this.resourceMap.get("_ruleId"));
        RuleSetInstance.paramAliasMapping(this.workingmemory.getParamAliasMap(), inputValueMap);
        FactHandle handle = this.workingmemory.assertObject(inputValueMap);
        this.resourceMap.put("_valueMap", inputValueMap);
        SLog.debug("=====\u89c4\u5219\u6267\u884c\u5f00\u59cb\uff1a" + this.resourceMap.get("_ruleSetId") + "." + this.resourceMap.get("_ruleId") + "=====");
        this.workingmemory.fireAllRulesM();
        this.resourceMap.remove("_valueMap");
        this.workingmemory.removeObject(handle);
        return inputValueMap;
    }

    public Map fireTargetRulesWithConnection(String ruleId, Map inputValueMap, Connection conn) throws Exception {
        this.resourceMap.put("_ruleId", ruleId);
        SLog.debug("fireTargetRulesWithConnection,ruleSetId=" + this.resourceMap.get("_ruleSetId") + ";ruleId=" + this.resourceMap.get("_ruleId"));
        RuleSetInstance.paramAliasMapping(this.workingmemory.getParamAliasMap(), inputValueMap);
        FactHandle handle = this.workingmemory.assertObject(inputValueMap);
        this.resourceMap.put("_valueMap", inputValueMap);
        this.workingmemory.setTargetRuleName(ruleId);
        SLog.debug("=====\u89c4\u5219\u6267\u884c\u5f00\u59cb\uff1a" + this.ruleSetId + "." + ruleId + "=====");
        Connection myconn = null;
        try {
            if (conn == null) {
                myconn = DbControl.getInstance().getConnection();
                myconn.setAutoCommit(true);
                this.resourceMap.put("_connection", myconn);
            } else {
                this.resourceMap.put("_connection", conn);
            }
            this.workingmemory.fireAllRulesM();
        }
        finally {
            if (myconn != null) {
                try {
                    myconn.close();
                }
                catch (Exception e) {
                    System.err.println("[error]\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                    e.printStackTrace();
                }
            }
        }
        SLog.debug("=====\u89c4\u5219\u6267\u884c\u7ed3\u675f\uff1a" + this.ruleSetId + "." + ruleId + "=====");
        this.resourceMap.remove("_valueMap");
        this.workingmemory.removeObject(handle);
        return inputValueMap;
    }

    public Map fireTargetRulesWithConnection(Map inputValueMap, Connection conn) throws Exception {
        SLog.debug("fireTargetRulesWithConnection,ruleSetId=" + this.resourceMap.get("_ruleSetId") + ";ruleId=" + this.resourceMap.get("_ruleId"));
        RuleSetInstance.paramAliasMapping(this.workingmemory.getParamAliasMap(), inputValueMap);
        FactHandle handle = this.workingmemory.assertObject(inputValueMap);
        this.resourceMap.put("_valueMap", inputValueMap);
        SLog.debug("=====\u89c4\u5219\u6267\u884c\u5f00\u59cb\uff1a" + this.resourceMap.get("_ruleSetId") + "." + this.resourceMap.get("_ruleId") + "=====");
        Connection myconn = null;
        try {
            if (conn == null) {
                myconn = DbControl.getInstance().getConnection();
                myconn.setAutoCommit(true);
                this.resourceMap.put("_connection", myconn);
            } else {
                this.resourceMap.put("_connection", conn);
            }
            this.workingmemory.fireAllRulesM();
        }
        finally {
            if (myconn != null) {
                try {
                    myconn.close();
                }
                catch (Exception e) {
                    System.err.println("[error]\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                    e.printStackTrace();
                }
            }
        }
        SLog.debug("=====\u89c4\u5219\u6267\u884c\u7ed3\u675f\uff1a" + this.resourceMap.get("_ruleSetId") + "." + this.resourceMap.get("_ruleId") + "=====");
        this.resourceMap.remove("_valueMap");
        this.workingmemory.removeObject(handle);
        return inputValueMap;
    }

    public Map fireTargetTrans(String transid, Map inputValueMap) throws Exception {
        SLog.debug("fireTargetTrans,transid=" + transid);
        Trans trans = (Trans)RuleBase.getInstance().transMap.get(transid);
        if (trans == null) {
            throw new Exception("\u672a\u627e\u5230\u76f8\u5e94\u7684\u4ea4\u6613\u8bbe\u7f6e,transid=" + transid);
        }
        this.resourceMap.put("_transid", transid);
        if (trans.ext != null && trans.ext.length() > 0 && ShuffleExtFactory.getInstance().invokeExt(trans.ext, null, this.resourceMap, inputValueMap) == null) {
            return inputValueMap;
        }
        for (String rulesetid : trans.ruleMap.keySet()) {
            List ruleList = (List)trans.ruleMap.get(rulesetid);
            this.ruleSetId = rulesetid;
            this.resourceMap.put("_ruleSetId", rulesetid);
            this.workingmemory = RuleBase.getInstance().newWorkingMemory();
            this.workingmemory.setTargetRuleSetName(rulesetid);
            Map paramMap = this.workingmemory.getParamMap();
            this.resourceMap.put("_paramMap", paramMap);
            this.workingmemory.assertObject(paramMap);
            this.workingmemory.assertObject(this.resourceMap);
            RuleSetInstance.paramAliasMapping(this.workingmemory.getParamAliasMap(), inputValueMap);
            this.workingmemory.assertObject(inputValueMap);
            int i = 0;
            while (i < ruleList.size()) {
                String ruleid = (String)ruleList.get(i);
                this.resourceMap.put("_ruleId", ruleid);
                this.resourceMap.put("_valueMap", inputValueMap);
                this.workingmemory.setTargetRuleName(ruleid);
                this.workingmemory.fireAllRulesM();
                ++i;
            }
        }
        return inputValueMap;
    }

    public Map fireTargetTransWithConnection(String transid, Map inputValueMap, Connection conn) throws Exception {
        SLog.debug("fireTargetTransWithConnection,transid=" + transid);
        Trans trans = (Trans)RuleBase.getInstance().transMap.get(transid);
        if (trans == null) {
            throw new Exception("\u672a\u627e\u5230\u76f8\u5e94\u7684\u4ea4\u6613\u8bbe\u7f6e,transid=" + transid);
        }
        this.resourceMap.put("_transid", transid);
        if (trans.ext != null && trans.ext.length() > 0) {
            this.resourceMap.put("_connection", conn);
            if (ShuffleExtFactory.getInstance().invokeExt(trans.ext, null, this.resourceMap, inputValueMap) == null) {
                return inputValueMap;
            }
        }
        for (String rulesetid : trans.ruleMap.keySet()) {
            List ruleList = (List)trans.ruleMap.get(rulesetid);
            this.ruleSetId = rulesetid;
            this.resourceMap.put("_ruleSetId", rulesetid);
            this.workingmemory = RuleBase.getInstance().newWorkingMemory();
            this.workingmemory.setTargetRuleSetName(rulesetid);
            Map paramMap = this.workingmemory.getParamMap();
            this.resourceMap.put("_paramMap", paramMap);
            this.workingmemory.assertObject(paramMap);
            this.workingmemory.assertObject(this.resourceMap);
            RuleSetInstance.paramAliasMapping(this.workingmemory.getParamAliasMap(), inputValueMap);
            this.workingmemory.assertObject(inputValueMap);
            int i = 0;
            while (i < ruleList.size()) {
                String ruleid = (String)ruleList.get(i);
                this.resourceMap.put("_ruleId", ruleid);
                this.resourceMap.put("_valueMap", inputValueMap);
                this.workingmemory.setTargetRuleName(ruleid);
                Connection myconn = null;
                try {
                    if (conn == null) {
                        myconn = DbControl.getInstance().getConnection();
                        myconn.setAutoCommit(true);
                        this.resourceMap.put("_connection", myconn);
                    } else {
                        this.resourceMap.put("_connection", conn);
                    }
                    this.workingmemory.fireAllRulesM();
                }
                finally {
                    if (myconn != null) {
                        try {
                            myconn.close();
                        }
                        catch (Exception e) {
                            System.err.println("[error]\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        }
        return inputValueMap;
    }

    public void addResourceObject(String id, Object obj) {
        if (id != null && id.trim().length() > 0 && obj != null) {
            this.resourceMap.put(id, obj);
        }
    }

    public void removeResourceObject(String id) {
        if (id != null && id.trim().length() > 0) {
            this.resourceMap.remove(id);
        }
    }

    public List getParamList() {
        Map paramMap = this.workingmemory.getParamMap();
        ArrayList<RulesParameter> paramList = new ArrayList<RulesParameter>();
        for (RulesParameter aParam : paramMap.values()) {
            paramList.add(aParam);
        }
        return paramList;
    }

    public Map getParamMap() {
        return this.workingmemory.getParamMap();
    }

    private static void paramAliasMapping(Map paramAliasMap, Map inputValueMap) {
        ArrayList<String> replaceList = new ArrayList<String>();
        for (String key : inputValueMap.keySet()) {
            if (!paramAliasMap.containsKey(key)) continue;
            replaceList.add(key);
        }
        int i = 0;
        while (i < replaceList.size()) {
            String key = (String)replaceList.get(i);
            Object obj = inputValueMap.get(key);
            inputValueMap.remove(key);
            inputValueMap.put(paramAliasMap.get(key), obj);
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

