/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade.common;

import com.ecc.echain.jci.JCIFactory;
import com.ecc.shuffle.common.JavaClassGenerator;
import com.ecc.shuffle.rule.Rule;
import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.rule.RuleSet;
import com.ecc.shuffle.upgrade.complier.PseudoCodeComplier;
import com.ecc.shuffle.upgrade.rule.RuleFlow;
import com.ecc.shuffle.upgrade.rule.RuleTable;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.jci.readers.MemoryResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.ResourceStoreClassLoader;

public class UpgradeClassGenerator {
    private static final UpgradeClassGenerator INSTANCE = new UpgradeClassGenerator();
    private static final String newline = System.getProperty("line.separator");

    public static UpgradeClassGenerator getInstance() {
        return INSTANCE;
    }

    private UpgradeClassGenerator() {
    }

    public void generateClass(RuleBase rulebase) {
        for (String rsName : rulebase.ruleSets.keySet()) {
            RuleSet rs = (RuleSet)rulebase.ruleSets.get(rsName);
            if (rs.filepath.endsWith(".xml")) {
                JavaClassGenerator.getInstance().generateRuleSetClass(rulebase, rs);
                continue;
            }
            if (!rs.filepath.endsWith(".rule")) continue;
            this.generateRuleSetClass(rulebase, rs);
        }
    }

    public void generateRuleSetClass(RuleBase rulebase, RuleSet rs) {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("package com.ecc.shuffle;");
            buffer.append(newline);
            buffer.append("import java.io.Serializable;");
            buffer.append("import java.util.*;");
            buffer.append(newline);
            buffer.append("public class " + rs.id.toUpperCase() + " implements Serializable{");
            buffer.append(newline);
            HashMap ruleNameMap = new HashMap();
            PseudoCodeComplier codeComplier = new PseudoCodeComplier();
            int j = 0;
            while (j < rs.rules.size()) {
                Rule rule = (Rule)rs.rules.get(j);
                ruleNameMap.put(rule.id, null);
                StringBuffer javaBuffer = new StringBuffer();
                try {
                    if (rule instanceof RuleFlow) {
                        javaBuffer = ((RuleFlow)rule).parseRuleFlow();
                    } else if (rule instanceof RuleTable) {
                        javaBuffer.append("public static boolean " + rule.id + "(java.util.Map paramMap, java.util.Map resourceMap, java.util.Map valueMap) throws Exception{");
                        javaBuffer.append(newline);
                        if (rule.runStatus == 2) {
                            javaBuffer.append("if(true){");
                            javaBuffer.append(newline);
                            javaBuffer.append("System.out.println(\"\u89c4\u5219[" + rule.id + "]\u5904\u4e8e\u505c\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u8c03\u7528!\");");
                            javaBuffer.append(newline);
                            javaBuffer.append("return false;");
                            javaBuffer.append(newline);
                            javaBuffer.append("}");
                            javaBuffer.append(newline);
                        }
                        if (rule.extClassName != null && rule.extClassName.length() > 0) {
                            String[] exts = rule.extClassName.split(";");
                            int k = 0;
                            while (k < exts.length) {
                                javaBuffer.append("if(com.ecc.shuffle.upgrade.ext.ShuffleExtFactory.getInstance().invokeExt(\"" + exts[k] + "\",paramMap, resourceMap, valueMap)==null)return false;");
                                javaBuffer.append(newline);
                                ++k;
                            }
                        }
                        if (rule.extScript != null && rule.extScript.trim().length() > 0) {
                            javaBuffer.append(new PseudoCodeComplier().parsePseudoCode(rule.extScript));
                            javaBuffer.append(newline);
                        }
                        javaBuffer.append(rule.consequence);
                        javaBuffer.append(newline);
                        javaBuffer.append("}");
                    } else {
                        javaBuffer = codeComplier.parsePseudoCode(rule);
                    }
                }
                catch (Exception e) {
                    System.out.println("\u3010Loader Error\u3011:\u52a0\u8f7d\u89c4\u5219\u96c6[" + rs.id + "]\u4e2d\u7684\u89c4\u5219[" + rule.id + "]\u65f6\u51fa\u9519\uff01");
                    e.printStackTrace();
                }
                buffer.append(javaBuffer);
                buffer.append("public static boolean " + rule.id + "_Invoke(java.util.Map paramMap, java.util.Map resourceMap, java.util.Map valueMap) throws Exception{");
                buffer.append(newline);
                buffer.append("return true;");
                buffer.append(newline);
                buffer.append("}");
                buffer.append(newline);
                ++j;
            }
            buffer.append("}");
            if (rulebase.classLoader == null) {
                ClassLoader parentClassLoader;
                if (rulebase.src == null) {
                    rulebase.src = new MemoryResourceReader();
                }
                if (rulebase.dst == null) {
                    rulebase.dst = new MemoryResourceStore();
                }
                if ((parentClassLoader = Thread.currentThread().getContextClassLoader()) == null) {
                    parentClassLoader = INSTANCE.getClass().getClassLoader();
                }
                rulebase.classLoader = new ResourceStoreClassLoader(parentClassLoader, new ResourceStore[]{rulebase.dst});
            }
            JCIFactory.getInstance().getJciClass().compile(rs.classname, buffer, rulebase.src, rulebase.dst, rulebase.classLoader, (Object)rulebase);
            Class<?> javaclass = rulebase.classLoader.loadClass(rs.classname);
            Method[] methods = javaclass.getMethods();
            int k = 0;
            while (k < methods.length) {
                if (ruleNameMap.containsKey(methods[k].getName())) {
                    rulebase.listRuleMethod.add(methods[k]);
                }
                ++k;
            }
        }
        catch (Exception e) {
            System.out.println("com.ecc.shuffle.upgrade.common.UpgradeClassGenerator\u52a8\u6001\u7f16\u8bd1\u811a\u672c\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
        }
    }
}

