/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade.complier;

import java.util.HashMap;
import java.util.Map;

public class SymbolToken {
    private String srcStr = null;
    private int curIdx = 0;
    private int srcLength = 0;
    private String[] symbolStrs = new String[]{"\u5982\u679c", "\u90a3\u4e48", "\u5426\u5219", "{", "}", ":=", ";", "#", "$", "@", "%"};
    Map symbolMap = new HashMap();
    public static final int ERROR = -1;
    public static final int IF = 0;
    public static final int THEN = 1;
    public static final int ELSE = 2;
    public static final int LF = 3;
    public static final int RT = 4;
    public static final int ASSIGN = 5;
    public static final int END = 6;
    public static final int NOTE = 7;
    private int tempSymbolType = -1;

    public SymbolToken(String srcStr) {
        this.srcStr = srcStr;
        this.srcLength = srcStr.length();
        this.curIdx = 0;
        int i = 0;
        while (i < this.symbolStrs.length) {
            this.symbolMap.put(this.symbolStrs[i], new Integer(i));
            ++i;
        }
    }

    public int nextSymbol() {
        while (this.curIdx < this.srcLength) {
            char chr = this.srcStr.charAt(this.curIdx);
            while (chr == ' ' || chr == '\r' || chr == '\n' || chr == '\t') {
                ++this.curIdx;
                if (this.curIdx >= this.srcLength) break;
                chr = this.srcStr.charAt(this.curIdx);
            }
            if (this.curIdx >= this.srcLength) break;
            switch (chr) {
                case '{': {
                    this.tempSymbolType = 3;
                    ++this.curIdx;
                    return 3;
                }
                case '}': {
                    this.tempSymbolType = 4;
                    ++this.curIdx;
                    return 4;
                }
                case ';': {
                    this.tempSymbolType = 6;
                    ++this.curIdx;
                    return 6;
                }
                case '#': {
                    this.tempSymbolType = 7;
                    ++this.curIdx;
                    return 7;
                }
            }
            String str = this.srcStr.substring(this.curIdx, this.curIdx + 2);
            ++this.curIdx;
            if ("\u5982\u679c".equals(str)) {
                this.tempSymbolType = 0;
                ++this.curIdx;
                return 0;
            }
            if ("\u90a3\u4e48".equals(str)) {
                this.tempSymbolType = 1;
                ++this.curIdx;
                return 1;
            }
            if ("\u5426\u5219".equals(str)) {
                this.tempSymbolType = 2;
                ++this.curIdx;
                return 2;
            }
            if (!":=".equals(str)) continue;
            this.tempSymbolType = 5;
            ++this.curIdx;
            return 5;
        }
        this.tempSymbolType = -1;
        return this.tempSymbolType;
    }

    public int getCurIdx() {
        return this.curIdx;
    }

    public int getIdxBeforeSymbol() {
        return this.curIdx - this.symbolStrs[this.tempSymbolType].length();
    }

    public void reset() {
        this.curIdx = 0;
    }

    public void resetByIdx(int idx) {
        if (idx < this.srcLength) {
            this.curIdx = idx;
        }
    }
}

