/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade.complier;

import com.ecc.shuffle.upgrade.complier.SymbolToken;
import com.ecc.shuffle.upgrade.complier.SyntaxException;
import com.ecc.shuffle.upgrade.complier.unit.AssignmentUnit;
import com.ecc.shuffle.upgrade.complier.unit.ExpressionUnit;
import com.ecc.shuffle.upgrade.complier.unit.LogicJudgementUnit;
import com.ecc.shuffle.upgrade.complier.unit.NoteUnit;
import com.ecc.shuffle.upgrade.complier.unit.SyntaxUnit;

public class SyntaxAnalyser {
    private String sourceCode = null;

    public SyntaxUnit parseSrcCode(String srcCode) throws SyntaxException {
        this.sourceCode = srcCode;
        SymbolToken token = new SymbolToken(srcCode);
        int symbolType = token.nextSymbol();
        if (symbolType != 0) {
            throw new SyntaxException("\u3010Syntax Error\u3011:\u4f2a\u7801\u5fc5\u987b\u4ee5\u5173\u952e\u5b57'\u5982\u679c'\u5f00\u59cb");
        }
        LogicJudgementUnit rootUnit = new LogicJudgementUnit();
        this.analyseIFSyntax(rootUnit, token);
        return rootUnit;
    }

    private void analyseIFSyntax(LogicJudgementUnit logicUnit, SymbolToken token) throws SyntaxException {
        int beginIdx = token.getCurIdx();
        int endIdx = -1;
        StringBuffer buffer = new StringBuffer();
        int symbolType = token.nextSymbol();
        if (symbolType == 7) {
            endIdx = token.getIdxBeforeSymbol();
            buffer.append(this.sourceCode.substring(beginIdx, endIdx).trim());
            beginIdx = token.getCurIdx();
            while ((symbolType = token.nextSymbol()) != 7) {
            }
            endIdx = token.getIdxBeforeSymbol();
            String desc = this.sourceCode.substring(beginIdx, endIdx).trim();
            logicUnit.setDesc(desc);
            beginIdx = token.getCurIdx();
            symbolType = token.nextSymbol();
        }
        if (symbolType != 1) {
            throw new SyntaxException("\u3010Syntax Error\u3011:'\u5982\u679c'\u540e\u9762\u7f3a\u5c11\u5173\u952e\u5b57'\u90a3\u4e48'");
        }
        endIdx = token.getIdxBeforeSymbol();
        buffer.append(this.sourceCode.substring(beginIdx, endIdx).trim());
        String condition = buffer.toString();
        ExpressionUnit conditionUnit = new ExpressionUnit(condition);
        logicUnit.setCondition(conditionUnit);
        this.analyseTHENSyntax(logicUnit, token, symbolType);
        int lastIdx = token.getCurIdx();
        symbolType = token.nextSymbol();
        if (symbolType == 2) {
            this.analyseTHENSyntax(logicUnit, token, symbolType);
        } else {
            token.resetByIdx(lastIdx);
        }
    }

    private void analyseTHENSyntax(LogicJudgementUnit logicUnit, SymbolToken token, int type) throws SyntaxException {
        int symbolType = token.nextSymbol();
        if (symbolType != 3) {
            throw new SyntaxException("\u3010Syntax Error\u3011:'\u90a3\u4e48'\u540e\u9762\u7f3a\u5c11\u5173\u952e\u5b57'{'");
        }
        int lastIdx = token.getCurIdx();
        symbolType = token.nextSymbol();
        while (symbolType != 4) {
            int endIdx;
            if (symbolType == 7) {
                lastIdx = token.getCurIdx();
                while ((symbolType = token.nextSymbol()) != 7) {
                }
                endIdx = token.getIdxBeforeSymbol();
                String desc = this.sourceCode.substring(lastIdx, endIdx).trim();
                NoteUnit noteUnit = new NoteUnit(desc);
                logicUnit.addUnit(noteUnit, type);
            } else if (symbolType == 0) {
                LogicJudgementUnit subLogicUnit = new LogicJudgementUnit();
                this.analyseIFSyntax(subLogicUnit, token);
                logicUnit.addUnit(subLogicUnit, type);
            } else if (symbolType == 5) {
                endIdx = token.getIdxBeforeSymbol();
                String out_var = this.sourceCode.substring(lastIdx, endIdx).trim();
                if (!out_var.startsWith("$")) {
                    throw new SyntaxException("\u3010Syntax Error\u3011:\u8d4b\u503c\u8bed\u53e5\u4e2d\u7f3a\u5c11\u4ee5'$'\u5f00\u59cb\u7684\u8d4b\u503c\u53d8\u91cf");
                }
                out_var = out_var.substring(1);
                lastIdx = token.getCurIdx();
                symbolType = token.nextSymbol();
                if (symbolType != 6) {
                    throw new SyntaxException("\u3010Syntax Error\u3011:\u8d4b\u503c\u8bed\u53e5\u672a\u7ed3\u675f");
                }
                endIdx = token.getIdxBeforeSymbol();
                String expression = this.sourceCode.substring(lastIdx, endIdx).trim();
                ExpressionUnit expUnit = new ExpressionUnit(expression);
                AssignmentUnit assignUnit = new AssignmentUnit(out_var, expUnit);
                logicUnit.addUnit(assignUnit, type);
            } else if (symbolType == 6) {
                endIdx = token.getIdxBeforeSymbol();
                String function = this.sourceCode.substring(lastIdx, endIdx).trim();
                if (!function.startsWith("@")) {
                    throw new SyntaxException("\u3010Syntax Error\u3011:\u51fd\u6570\u8c03\u7528\u8bed\u53e5\u5fc5\u987b\u4ee5\u5173\u952e\u5b57'@'\u5f00\u59cb");
                }
                ExpressionUnit funcUnit = new ExpressionUnit(function);
                logicUnit.addUnit(funcUnit, type);
            } else {
                throw new SyntaxException("\u3010Syntax Error\u3011:\u8bed\u6cd5\u7ed3\u6784\u9519\u8bef\uff0c\u65e0\u6cd5\u8bc6\u522b\u7684\u8bed\u6cd5\u683c\u5f0f");
            }
            lastIdx = token.getCurIdx();
            symbolType = token.nextSymbol();
        }
    }
}

