/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade.complier.unit;

import com.ecc.shuffle.upgrade.FormulaProcesser;
import com.ecc.shuffle.upgrade.complier.TargetCodeBuilder;
import com.ecc.shuffle.upgrade.complier.unit.ExpressionUnit;
import com.ecc.shuffle.upgrade.complier.unit.SyntaxUnit;
import java.util.ArrayList;
import java.util.List;

public class LogicJudgementUnit
extends SyntaxUnit {
    ExpressionUnit condition = null;
    String desc = "";
    List thenSytaxList = new ArrayList();
    List elseSytaxList = new ArrayList();

    public void setCondition(ExpressionUnit condition) {
        this.condition = condition;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void addUnit(SyntaxUnit unit, int type) {
        if (type == 1) {
            this.thenSytaxList.add(unit);
        } else if (type == 2) {
            this.elseSytaxList.add(unit);
        }
    }

    public StringBuffer translate() {
        SyntaxUnit subUnit;
        StringBuffer buffer = new StringBuffer();
        buffer.append("if (");
        buffer.append(this.translateCondition());
        buffer.append(")");
        buffer.append(TargetCodeBuilder.newline);
        buffer.append("/*" + this.desc + "*/");
        buffer.append(TargetCodeBuilder.newline);
        buffer.append("{");
        buffer.append(TargetCodeBuilder.newline);
        int i = 0;
        while (i < this.thenSytaxList.size()) {
            subUnit = (SyntaxUnit)this.thenSytaxList.get(i);
            buffer.append(subUnit.translate());
            buffer.append(TargetCodeBuilder.newline);
            ++i;
        }
        buffer.append("}");
        if (!this.elseSytaxList.isEmpty()) {
            buffer.append(" else {");
            buffer.append(TargetCodeBuilder.newline);
            i = 0;
            while (i < this.elseSytaxList.size()) {
                subUnit = (SyntaxUnit)this.elseSytaxList.get(i);
                buffer.append(subUnit.translate());
                buffer.append(TargetCodeBuilder.newline);
                ++i;
            }
            buffer.append("}");
        }
        return buffer;
    }

    private String translateCondition() {
        String s = String.valueOf(FormulaProcesser.class.getName()) + ".retBooleanValue(\"" + this.condition.toString() + "\", paramMap, resourceMap, valueMap)";
        return s;
    }

    public String getConditionStr() {
        return this.condition.toString();
    }

    public String getDesc() {
        return this.desc;
    }

    public List getElseSytaxList() {
        return this.elseSytaxList;
    }

    public List getThenSytaxList() {
        return this.thenSytaxList;
    }
}

