/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade.ext;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class IdcardUtil {
    static final Map<Integer, String> zoneNum = new HashMap<Integer, String>();
    static final int[] PARITYBIT;
    static final int[] POWER_LIST;

    static {
        zoneNum.put(11, "\u5317\u4eac");
        zoneNum.put(12, "\u5929\u6d25");
        zoneNum.put(13, "\u6cb3\u5317");
        zoneNum.put(14, "\u5c71\u897f");
        zoneNum.put(15, "\u5185\u8499\u53e4");
        zoneNum.put(21, "\u8fbd\u5b81");
        zoneNum.put(22, "\u5409\u6797");
        zoneNum.put(23, "\u9ed1\u9f99\u6c5f");
        zoneNum.put(31, "\u4e0a\u6d77");
        zoneNum.put(32, "\u6c5f\u82cf");
        zoneNum.put(33, "\u6d59\u6c5f");
        zoneNum.put(34, "\u5b89\u5fbd");
        zoneNum.put(35, "\u798f\u5efa");
        zoneNum.put(36, "\u6c5f\u897f");
        zoneNum.put(37, "\u5c71\u4e1c");
        zoneNum.put(41, "\u6cb3\u5357");
        zoneNum.put(42, "\u6e56\u5317");
        zoneNum.put(43, "\u6e56\u5357");
        zoneNum.put(44, "\u5e7f\u4e1c");
        zoneNum.put(45, "\u5e7f\u897f");
        zoneNum.put(46, "\u6d77\u5357");
        zoneNum.put(50, "\u91cd\u5e86");
        zoneNum.put(51, "\u56db\u5ddd");
        zoneNum.put(52, "\u8d35\u5dde");
        zoneNum.put(53, "\u4e91\u5357");
        zoneNum.put(54, "\u897f\u85cf");
        zoneNum.put(61, "\u9655\u897f");
        zoneNum.put(62, "\u7518\u8083");
        zoneNum.put(63, "\u9752\u6d77");
        zoneNum.put(64, "\u5b81\u590f");
        zoneNum.put(65, "\u65b0\u7586");
        zoneNum.put(71, "\u53f0\u6e7e");
        zoneNum.put(81, "\u9999\u6e2f");
        zoneNum.put(82, "\u6fb3\u95e8");
        zoneNum.put(91, "\u56fd\u5916");
        PARITYBIT = new int[]{49, 48, 88, 57, 56, 55, 54, 53, 52, 51, 50};
        POWER_LIST = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    }

    public static boolean isIdcard(String s) {
        if (s == null || s.length() != 15 && s.length() != 18) {
            return false;
        }
        char[] cs = s.toUpperCase().toCharArray();
        int power = 0;
        int i = 0;
        while (i < cs.length) {
            if (i == cs.length - 1 && cs[i] == 'X') break;
            if (cs[i] < '0' || cs[i] > '9') {
                return false;
            }
            if (i < cs.length - 1) {
                power += (cs[i] - 48) * POWER_LIST[i];
            }
            ++i;
        }
        if (!zoneNum.containsKey(Integer.valueOf(s.substring(0, 2)))) {
            return false;
        }
        String year = s.length() == 15 ? "19" + s.substring(6, 8) : s.substring(6, 10);
        int iyear = Integer.parseInt(year);
        if (iyear < 1900 || iyear > Calendar.getInstance().get(1)) {
            return false;
        }
        String month = s.length() == 15 ? s.substring(8, 10) : s.substring(10, 12);
        int imonth = Integer.parseInt(month);
        if (imonth < 1 || imonth > 12) {
            return false;
        }
        String day = s.length() == 15 ? s.substring(10, 12) : s.substring(12, 14);
        int iday = Integer.parseInt(day);
        if (iday < 1 || iday > 31) {
            return false;
        }
        if (!IdcardUtil.validate(iyear, imonth, iday)) {
            return false;
        }
        if (s.length() == 15) {
            return true;
        }
        return cs[cs.length - 1] == PARITYBIT[power % 11];
    }

    static boolean validate(int year, int month, int day) {
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
            return false;
        }
        if (month == 2) {
            boolean leap;
            boolean bl = leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
            if (day > 29 || day == 29 && !leap) {
                return false;
            }
        }
        return true;
    }

    public static int getAgeByIdcard(String s) {
        if (s == null || s.length() != 15 && s.length() != 18) {
            return -1;
        }
        String year = s.length() == 15 ? "19" + s.substring(6, 8) : s.substring(6, 10);
        return Calendar.getInstance().get(1) - Integer.parseInt(year);
    }

    public static String fixIdcardTo18(String personIDCode) {
        String retIDCode = "";
        if (personIDCode == null || personIDCode.trim().length() != 15) {
            return "";
        }
        String id17 = String.valueOf(personIDCode.substring(0, 6)) + "19" + personIDCode.substring(6, 15);
        char[] code = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int[] nArray = new int[18];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 8;
        nArray[4] = 5;
        nArray[5] = 10;
        nArray[6] = 9;
        nArray[7] = 7;
        nArray[8] = 3;
        nArray[9] = 6;
        nArray[10] = 1;
        nArray[11] = 2;
        nArray[12] = 4;
        nArray[13] = 8;
        nArray[14] = 5;
        nArray[15] = 10;
        nArray[16] = 9;
        nArray[17] = 7;
        int[] factor = nArray;
        int[] idcd = new int[18];
        int i = 1;
        while (i < 18) {
            int j = 17 - i;
            idcd[i] = Integer.parseInt(id17.substring(j, j + 1));
            ++i;
        }
        int sum = 0;
        i = 1;
        while (i < 18) {
            sum += idcd[i] * factor[i];
            ++i;
        }
        int remainder = sum % 11;
        String lastCheckBit = String.valueOf(code[remainder]);
        return String.valueOf(id17) + lastCheckBit;
    }

    public static String fixIdcardTo15(String personIDCode) {
        String retIDCode = "";
        if (personIDCode == null || personIDCode.trim().length() != 18) {
            return "";
        }
        retIDCode = String.valueOf(personIDCode.substring(0, 6)) + personIDCode.substring(8, 17);
        return retIDCode;
    }

    public static void main(String[] args) {
        String s = "331025197712190619";
        System.out.println(String.valueOf(s) + " --> " + IdcardUtil.isIdcard(s));
        System.out.println(String.valueOf(s) + " --> " + IdcardUtil.getAgeByIdcard(s));
        s = "340821197511130380";
        System.out.println(String.valueOf(s) + " --> " + IdcardUtil.isIdcard(s));
        System.out.println(String.valueOf(s) + " --> " + IdcardUtil.getAgeByIdcard(s));
        s = "350124770630497";
        System.out.println(String.valueOf(s) + " --> " + IdcardUtil.fixIdcardTo18(s));
        s = "35012419770630497X";
        System.out.println(String.valueOf(s) + " --> " + IdcardUtil.fixIdcardTo15(s));
    }
}

